/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public final class CreditMemoStatuses {
    public static final String APPDOC_INITIATE = "Initiated";
    public static final String APPDOC_IN_PROCESS = "In Process";
    public static final String APPDOC_CANCELLED_IN_PROCESS = "Cancelled In Process";
    public static final String APPDOC_CANCELLED_PRIOR_TO_AP_APPROVAL = "Void";
    public static final String APPDOC_CANCELLED_POST_AP_APPROVE = "Cancelled";
    public static final String APPDOC_COMPLETE = "Complete";
    public static final String APPDOC_AWAITING_ACCOUNTS_PAYABLE_REVIEW = "Awaiting AP Review";
    public static final String NODE_ADHOC_REVIEW = "AdHoc";
    public static final String NODE_ACCOUNT_REVIEW = "Account";
    public static final String[] STATUSES_ALLOWED_FOR_EXTRACTION = new String[]{"Awaiting AP Review", "Complete"};
    public static final String[] STATUSES_POTENTIALLY_ACTIVE = new String[]{"In Process", "Awaiting AP Review"};
    public static final Set<String> CANCELLED_STATUSES = new HashSet<String>();
    public static final Set<String> STATUSES_DISALLOWING_HOLD = new HashSet<String>();
    public static final Set<String> STATUSES_NOT_REQUIRING_ENTRY_REVERSAL = new HashSet<String>();

    private CreditMemoStatuses() {
    }

    public static HashMap<String, String> getAllAppDocStatuses() {
        HashMap<String, String> appDocStatusMap = new HashMap<String, String>();
        appDocStatusMap.put(APPDOC_INITIATE, APPDOC_INITIATE);
        appDocStatusMap.put(APPDOC_IN_PROCESS, APPDOC_IN_PROCESS);
        appDocStatusMap.put(APPDOC_CANCELLED_IN_PROCESS, APPDOC_CANCELLED_IN_PROCESS);
        appDocStatusMap.put(APPDOC_CANCELLED_PRIOR_TO_AP_APPROVAL, APPDOC_CANCELLED_PRIOR_TO_AP_APPROVAL);
        appDocStatusMap.put(APPDOC_CANCELLED_POST_AP_APPROVE, APPDOC_CANCELLED_POST_AP_APPROVE);
        appDocStatusMap.put(APPDOC_COMPLETE, APPDOC_COMPLETE);
        appDocStatusMap.put(APPDOC_AWAITING_ACCOUNTS_PAYABLE_REVIEW, APPDOC_AWAITING_ACCOUNTS_PAYABLE_REVIEW);
        return appDocStatusMap;
    }

    public static HashMap<String, String> getCreditMemoAppDocDisapproveStatuses() {
        HashMap<String, String> appDocStatusMap = new HashMap<String, String>();
        appDocStatusMap.put(NODE_ADHOC_REVIEW, APPDOC_CANCELLED_IN_PROCESS);
        appDocStatusMap.put("ImageAttachment", APPDOC_CANCELLED_PRIOR_TO_AP_APPROVAL);
        appDocStatusMap.put(NODE_ACCOUNT_REVIEW, APPDOC_CANCELLED_POST_AP_APPROVE);
        return appDocStatusMap;
    }

    static {
        CANCELLED_STATUSES.add(APPDOC_CANCELLED_IN_PROCESS);
        CANCELLED_STATUSES.add(APPDOC_CANCELLED_PRIOR_TO_AP_APPROVAL);
        CANCELLED_STATUSES.add(APPDOC_CANCELLED_POST_AP_APPROVE);
        STATUSES_DISALLOWING_HOLD.add(APPDOC_INITIATE);
        STATUSES_DISALLOWING_HOLD.add(APPDOC_IN_PROCESS);
        STATUSES_DISALLOWING_HOLD.addAll(Arrays.asList(CANCELLED_STATUSES.toArray(new String[CANCELLED_STATUSES.size()])));
        STATUSES_NOT_REQUIRING_ENTRY_REVERSAL.add(APPDOC_INITIATE);
        STATUSES_NOT_REQUIRING_ENTRY_REVERSAL.add(APPDOC_IN_PROCESS);
        STATUSES_NOT_REQUIRING_ENTRY_REVERSAL.addAll(Arrays.asList(CANCELLED_STATUSES.toArray(new String[CANCELLED_STATUSES.size()])));
    }

    public static enum STATUS_ORDER {
        CANCELLED_IN_PROCESS("Cancelled In Process", false),
        CANCELLED_PRIOR_TO_AP_APPROVAL("Void", false),
        CANCELLED_POST_AP_APPROVE("Cancelled", false),
        INITIATE("Initiated", true),
        IN_PROCESS("In Process", true),
        AWAITING_ACCOUNTS_PAYABLE_REVIEW("Awaiting AP Review", false),
        COMPLETE("Complete", false);

        private String statusCode;
        private boolean fullEntryAllowed;

        private STATUS_ORDER(String statusCode, boolean fullEntry) {
            this.statusCode = statusCode;
            this.fullEntryAllowed = fullEntry;
        }

        public static STATUS_ORDER getByStatusCode(String statusCode) {
            for (STATUS_ORDER status : STATUS_ORDER.values()) {
                if (!StringUtils.equals((CharSequence)status.statusCode, (CharSequence)statusCode)) continue;
                return status;
            }
            return null;
        }

        public static boolean isFullDocumentEntryCompleted(String status) {
            return !STATUS_ORDER.getByStatusCode((String)status).fullEntryAllowed;
        }

        public static STATUS_ORDER getPreviousStatus(String statusCode) {
            STATUS_ORDER statusOrder = STATUS_ORDER.getByStatusCode(statusCode);
            if (statusOrder.ordinal() > 0) {
                return STATUS_ORDER.values()[statusOrder.ordinal() - 1];
            }
            return null;
        }

        public static boolean isFirstFullEntryStatus(String statusCode) {
            return STATUS_ORDER.getByStatusCode((String)statusCode).fullEntryAllowed && !STATUS_ORDER.getPreviousStatus((String)statusCode).fullEntryAllowed;
        }
    }
}

