/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.service.impl;

import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.core.api.config.property.ConfigurationService;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderVendorQuote;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.service.FaxService;
import org.kuali.kfs.module.purap.exception.FaxServerUnavailableError;
import org.kuali.kfs.module.purap.exception.FaxSubmissionError;
import org.kuali.kfs.module.purap.exception.PurError;
import org.kuali.kfs.module.purap.pdf.PurchaseOrderParameters;
import org.kuali.kfs.module.purap.pdf.PurchaseOrderPdf;
import org.kuali.kfs.module.purap.pdf.PurchaseOrderQuotePdf;
import org.kuali.kfs.module.purap.pdf.PurchaseOrderTransmitParameters;
import org.kuali.kfs.sys.businessobject.Country;
import org.kuali.kfs.sys.service.LocationService;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;
import org.kuali.kfs.vnd.document.service.VendorService;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class FaxServiceImpl
implements FaxService {
    private static final Logger LOG = LogManager.getLogger();
    protected ConfigurationService kualiConfigurationService;
    protected ParameterService parameterService;
    protected VendorService vendorService;
    protected BusinessObjectService businessObjectService;
    private LocationService locationService;
    private PurchaseOrderParameters purchaseOrderParameters;

    @Override
    public void faxPurchaseOrderPdf(PurchaseOrderDocument po, boolean isRetransmit) {
        LOG.debug("faxPurchaseOrderPdf(po,reTransmit) started");
        String pdfFileLocation = this.getPdfFileLocation();
        if (pdfFileLocation == null) {
            throw new RuntimeException("Application Setting PDF_DIRECTORY is missing.");
        }
        String imageTempLocation = this.kualiConfigurationService.getPropertyValueAsString("temp.directory") + "/";
        if (imageTempLocation == null) {
            throw new RuntimeException("Application Setting TEMP_DIRECTORY_KEY is missing.");
        }
        LOG.debug("faxPurchaseOrderPdf() ended");
        this.faxPurchaseOrderPdf(po, pdfFileLocation, imageTempLocation, isRetransmit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void faxPurchaseOrderPdf(PurchaseOrderDocument po, String pdfFileLocation, String imageTempLocation, boolean isRetransmit) {
        block25: {
            LOG.debug("faxPurchaseOrderPdf() started with locations");
            if (StringUtils.isNotBlank((CharSequence)po.getVendorCountryCode())) {
                Country vendorCountry = this.locationService.getCountry(po.getVendorCountryCode());
                if (vendorCountry != null) {
                    po.setVendorCountryCode(vendorCountry.getCode());
                } else {
                    po.setVendorCountryCode("NA");
                }
            } else {
                po.setVendorCountryCode("NA");
            }
            this.purchaseOrderParameters.setPurchaseOrderPdfAndFaxParameters(po);
            PurchaseOrderPdf poPdf = null;
            try {
                String environment = this.kualiConfigurationService.getPropertyValueAsString("environment");
                poPdf = new PurchaseOrderPdf();
                poPdf.savePdf(po, this.purchaseOrderParameters, isRetransmit, environment);
            }
            catch (PurError e) {
                GlobalVariables.getMessageMap().putError("errors", "error.blank", new String[0]);
                LOG.debug("faxPurchaseOrderPdf() ended");
            }
            catch (Throwable e) {
                LOG.error("faxPurchaseOrderPdf() Faxing Failed on PDF creation - Exception was " + e.getMessage(), e);
                GlobalVariables.getMessageMap().putError("errors", "error.blank", new String[]{"Faxing Error.  Unable to save pdf file. Please Contact Purchasing"});
                LOG.debug("faxPurchaseOrderPdf() ended");
            }
            PurchaseOrderTransmitParameters transmitParameters = (PurchaseOrderTransmitParameters)this.purchaseOrderParameters;
            String[] files = new String[]{transmitParameters.getPdfFileName()};
            this.faxPDF(files, this.purchaseOrderParameters);
            try {
                if (poPdf != null) {
                    poPdf.deletePdf(pdfFileLocation, transmitParameters.getPdfFileName());
                }
                break block25;
            }
            catch (Throwable e) {
                LOG.error("faxPurchaseOrderPdf() Error deleting PDF - Exception was " + e.getMessage(), e);
                GlobalVariables.getMessageMap().putError("errors", "error.blank", new String[]{"Your fax was sent successfully but an error occurred that is unrelated to faxing. Please report this problem to Purchasing"});
            }
            break block25;
            catch (FaxServerUnavailableError | FaxSubmissionError | PurError e) {
                GlobalVariables.getMessageMap().putError("errors", "error.blank", new String[0]);
                try {
                    if (poPdf != null) {
                        poPdf.deletePdf(pdfFileLocation, transmitParameters.getPdfFileName());
                    }
                }
                catch (Throwable e2) {
                    LOG.error("faxPurchaseOrderPdf() Error deleting PDF - Exception was " + e2.getMessage(), e2);
                    GlobalVariables.getMessageMap().putError("errors", "error.blank", new String[]{"Your fax was sent successfully but an error occurred that is unrelated to faxing. Please report this problem to Purchasing"});
                }
            }
            catch (Throwable e2) {
                LOG.error("faxPurchaseOrderPdf() Faxing Failed Exception was " + e2.getMessage(), e2);
                GlobalVariables.getMessageMap().putError("errors", "error.blank", new String[]{"Faxing Error.  Please Contact Purchasing"});
                {
                    catch (Throwable throwable) {
                        try {
                            if (poPdf != null) {
                                poPdf.deletePdf(pdfFileLocation, transmitParameters.getPdfFileName());
                            }
                        }
                        catch (Throwable e3) {
                            LOG.error("faxPurchaseOrderPdf() Error deleting PDF - Exception was " + e3.getMessage(), e3);
                            GlobalVariables.getMessageMap().putError("errors", "error.blank", new String[]{"Your fax was sent successfully but an error occurred that is unrelated to faxing. Please report this problem to Purchasing"});
                        }
                        throw throwable;
                    }
                }
                try {
                    if (poPdf != null) {
                        poPdf.deletePdf(pdfFileLocation, transmitParameters.getPdfFileName());
                    }
                }
                catch (Throwable e4) {
                    LOG.error("faxPurchaseOrderPdf() Error deleting PDF - Exception was " + e4.getMessage(), e4);
                    GlobalVariables.getMessageMap().putError("errors", "error.blank", new String[]{"Your fax was sent successfully but an error occurred that is unrelated to faxing. Please report this problem to Purchasing"});
                }
            }
        }
        LOG.debug("faxPurchaseOrderPdf() ended");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void faxPurchaseOrderQuotePdf(PurchaseOrderDocument po, PurchaseOrderVendorQuote povq) {
        block22: {
            LOG.debug("faxPurchaseOrderQuotePdf() started");
            this.purchaseOrderParameters.setPurchaseOrderPdfAndFaxParameters(po, povq);
            String environmentCode = this.kualiConfigurationService.getPropertyValueAsString("environment");
            PurchaseOrderQuotePdf poQuotePdf = new PurchaseOrderQuotePdf();
            try {
                if (StringUtils.isNotBlank((CharSequence)povq.getVendorCountryCode())) {
                    Country vendorCountry = this.locationService.getCountry(po.getVendorCountryCode());
                    if (vendorCountry != null) {
                        povq.setVendorCountryCode(vendorCountry.getCode());
                    } else {
                        povq.setVendorCountryCode("NA");
                    }
                } else {
                    povq.setVendorCountryCode("NA");
                }
                poQuotePdf.savePOQuotePDF(po, povq, this.purchaseOrderParameters, environmentCode);
            }
            catch (PurError e) {
                GlobalVariables.getMessageMap().putError("errors", "error.blank", new String[0]);
                LOG.debug("faxPurchaseOrderQuotePdf() ended");
            }
            catch (Throwable e) {
                LOG.error("faxPurchaseOrderQuotePdf() Faxing Failed on PDF creation - Exception was " + e.getMessage(), e);
                LOG.error("faxPurchaseOrderQuotePdf() Faxing Failed on PDF creation - Exception was " + e.getMessage(), e);
                GlobalVariables.getMessageMap().putError("errors", "error.blank", new String[]{"Faxing Error.  Unable to save pdf file. Please Contact Purchasing"});
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("faxPurchaseOrderQuotePdf() Quote PDF saved successfully for PO " + po.getPurapDocumentIdentifier() + " and Quote ID " + povq.getPurchaseOrderVendorQuoteIdentifier());
            }
            PurchaseOrderTransmitParameters transmitParameters = (PurchaseOrderTransmitParameters)this.purchaseOrderParameters;
            String pdfFileLocation = transmitParameters.getPdfFileLocation();
            String pdfFileName = transmitParameters.getPdfFileName();
            String[] files = new String[]{pdfFileName};
            this.faxPDF(files, transmitParameters);
            try {
                poQuotePdf.deletePdf(pdfFileLocation, pdfFileName);
            }
            catch (Throwable e) {
                LOG.error("faxPurchaseOrderQuotePdf() Error deleting Quote PDF" + pdfFileName + " - Exception was " + e.getMessage(), e);
                GlobalVariables.getMessageMap().putError("errors", "error.blank", new String[]{"Your fax was sent successfully but an error occurred that is unrelated to faxing. Please report this problem to Purchasing"});
            }
            break block22;
            catch (FaxSubmissionError e) {
                LOG.error("faxPurchaseOrderQuotePdf() Error faxing Quote PDF" + pdfFileName + " - Exception was " + e.getMessage(), (Throwable)e);
                GlobalVariables.getMessageMap().putError("errors", "error.blank", new String[0]);
                try {
                    poQuotePdf.deletePdf(pdfFileLocation, pdfFileName);
                }
                catch (Throwable e2) {
                    LOG.error("faxPurchaseOrderQuotePdf() Error deleting Quote PDF" + pdfFileName + " - Exception was " + e2.getMessage(), e2);
                    GlobalVariables.getMessageMap().putError("errors", "error.blank", new String[]{"Your fax was sent successfully but an error occurred that is unrelated to faxing. Please report this problem to Purchasing"});
                }
            }
            catch (Throwable e2) {
                LOG.error("faxPurchaseOrderQuotePdf() Error faxing Quote PDF" + pdfFileName + " - Exception was " + e2.getMessage(), e2);
                GlobalVariables.getMessageMap().putError("errors", "error.blank", new String[]{"The document did not successfully transmit to the fax server. Report this to the Procurement Services Technology group, make note of the document you attempted to transmit and try again when the issue has been resolved"});
                {
                    catch (Throwable throwable) {
                        try {
                            poQuotePdf.deletePdf(pdfFileLocation, pdfFileName);
                        }
                        catch (Throwable e3) {
                            LOG.error("faxPurchaseOrderQuotePdf() Error deleting Quote PDF" + pdfFileName + " - Exception was " + e3.getMessage(), e3);
                            GlobalVariables.getMessageMap().putError("errors", "error.blank", new String[]{"Your fax was sent successfully but an error occurred that is unrelated to faxing. Please report this problem to Purchasing"});
                        }
                        throw throwable;
                    }
                }
                try {
                    poQuotePdf.deletePdf(pdfFileLocation, pdfFileName);
                }
                catch (Throwable e4) {
                    LOG.error("faxPurchaseOrderQuotePdf() Error deleting Quote PDF" + pdfFileName + " - Exception was " + e4.getMessage(), e4);
                    GlobalVariables.getMessageMap().putError("errors", "error.blank", new String[]{"Your fax was sent successfully but an error occurred that is unrelated to faxing. Please report this problem to Purchasing"});
                }
            }
        }
        LOG.debug("faxPurchaseOrderQuotePdf() ended");
    }

    protected void faxPDF(String[] files, PurchaseOrderParameters transmitParameters) {
        LOG.info("faxPDF() NEEDS TO BE IMPLEMENTED!");
        throw new RuntimeException("faxPDF() NEEDS TO BE IMPLEMENTED!");
    }

    public String getPdfFileLocation() {
        return this.parameterService.getParameterValueAsString(KfsParameterConstants.PURCHASING_DOCUMENT.class, "PDF_DIRECTORY");
    }

    public void setConfigurationService(ConfigurationService kualiConfigurationService) {
        this.kualiConfigurationService = kualiConfigurationService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setVendorService(VendorService vendorService) {
        this.vendorService = vendorService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setLocationService(LocationService locationService) {
        this.locationService = locationService;
    }

    public void setPurchaseOrderParameters(PurchaseOrderParameters purchaseOrderParameters) {
        this.purchaseOrderParameters = purchaseOrderParameters;
    }
}

