/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.service.impl;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.core.api.config.property.ConfigurationService;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderVendorQuote;
import org.kuali.kfs.module.purap.document.BulkReceivingDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.service.PrintService;
import org.kuali.kfs.module.purap.exception.PurError;
import org.kuali.kfs.module.purap.exception.PurapConfigurationException;
import org.kuali.kfs.module.purap.pdf.BulkReceivingPdf;
import org.kuali.kfs.module.purap.pdf.PurchaseOrderParameters;
import org.kuali.kfs.module.purap.pdf.PurchaseOrderPdf;
import org.kuali.kfs.module.purap.pdf.PurchaseOrderQuotePdf;
import org.kuali.kfs.module.purap.pdf.PurchaseOrderQuoteRequestsPdf;
import org.kuali.kfs.module.purap.pdf.PurchaseOrderTransmitParameters;
import org.kuali.kfs.module.purap.service.ImageService;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class PrintServiceImpl
implements PrintService {
    private static final Logger LOG = LogManager.getLogger();
    protected static final boolean TRANSMISSION_IS_RETRANSMIT = true;
    protected static final boolean TRANSMISSION_IS_NOT_RETRANSMIT = false;
    private ImageService imageService;
    private ParameterService parameterService;
    private ConfigurationService kualiConfigurationService;
    private PurchaseOrderParameters purchaseOrderParameters;

    @Override
    public Collection generatePurchaseOrderQuoteRequestsListPdf(PurchaseOrderDocument po, ByteArrayOutputStream byteArrayOutputStream) {
        LOG.debug("generatePurchaseOrderQuoteRequestsListPdf() started");
        ArrayList<String> errors = new ArrayList<String>();
        PurchaseOrderQuoteRequestsPdf poQuoteRequestsPdf = new PurchaseOrderQuoteRequestsPdf();
        try {
            PurchaseOrderTransmitParameters pdfParameters = this.getPurchaseOrderQuoteRequestsListPdfParameters(po);
            poQuoteRequestsPdf.generatePOQuoteRequestsListPdf(po, byteArrayOutputStream, pdfParameters.getCampusParameter().getPurchasingInstitutionName());
        }
        catch (Exception | PurError pe) {
            LOG.error("Caught exception ", pe);
            errors.add(pe.getMessage());
        }
        LOG.debug("generatePurchaseOrderQuoteRequestsListPdf() ended");
        return errors;
    }

    @Override
    public Collection savePurchaseOrderQuoteRequestsListPdf(PurchaseOrderDocument po) {
        return null;
    }

    protected PurchaseOrderTransmitParameters getPurchaseOrderQuoteRequestsListPdfParameters(PurchaseOrderDocument po) {
        this.purchaseOrderParameters.setPurchaseOrderPdfParameters(po);
        return (PurchaseOrderTransmitParameters)this.purchaseOrderParameters;
    }

    @Override
    public Collection generatePurchaseOrderQuotePdf(PurchaseOrderDocument po, PurchaseOrderVendorQuote povq, ByteArrayOutputStream byteArrayOutputStream, String environment) {
        LOG.debug("generatePurchaseOrderQuotePdf() started");
        PurchaseOrderQuotePdf poQuotePdf = new PurchaseOrderQuotePdf();
        ArrayList<String> errors = new ArrayList<String>();
        try {
            this.purchaseOrderParameters.setPurchaseOrderPdfParameters(po, povq);
            PurchaseOrderTransmitParameters pdfParameters = (PurchaseOrderTransmitParameters)this.purchaseOrderParameters;
            String deliveryCampusName = pdfParameters.getCampusParameter().getCampus().getName();
            poQuotePdf.generatePOQuotePDF(po, povq, deliveryCampusName, pdfParameters.getContractManagerCampusCode(), pdfParameters.getLogoImage(), byteArrayOutputStream, environment);
        }
        catch (PurError | PurapConfigurationException pe) {
            LOG.error("Caught exception ", pe);
            errors.add(pe.getMessage());
        }
        LOG.debug("generatePurchaseOrderQuotePdf() ended");
        return errors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection savePurchaseOrderQuotePdf(PurchaseOrderDocument po, PurchaseOrderVendorQuote povq, String environment) {
        LOG.debug("savePurchaseOrderQuotePdf() started");
        String pdfQuoteFilename = "PURAP_PO_" + po.getPurapDocumentIdentifier().toString() + "_Quote_" + povq.getPurchaseOrderVendorQuoteIdentifier().toString() + "_" + System.currentTimeMillis() + ".pdf";
        PurchaseOrderQuotePdf poQuotePdf = new PurchaseOrderQuotePdf();
        ArrayList<String> errors = new ArrayList<String>();
        PurchaseOrderTransmitParameters pdfParameters = null;
        try {
            this.purchaseOrderParameters.setPurchaseOrderPdfParameters(po, povq);
            pdfParameters = (PurchaseOrderTransmitParameters)this.purchaseOrderParameters;
            poQuotePdf.savePOQuotePDF(po, povq, pdfParameters, environment);
        }
        catch (PurError | PurapConfigurationException e) {
            LOG.error("Caught exception ", e);
            errors.add(e.getMessage());
        }
        finally {
            try {
                poQuotePdf.deletePdf(pdfParameters.getPdfFileLocation(), pdfQuoteFilename);
            }
            catch (Throwable e) {
                LOG.error("savePurchaseOrderQuotePdf() Error deleting Quote PDF" + pdfQuoteFilename + " - Exception was " + e.getMessage(), e);
                errors.add(e.getMessage());
            }
        }
        LOG.debug("savePurchaseOrderQuotePdf() ended");
        return errors;
    }

    protected Collection generatePurchaseOrderPdf(PurchaseOrderDocument po, ByteArrayOutputStream byteArrayOutputStream, boolean isRetransmit, String environment, List<PurchaseOrderItem> retransmitItems) {
        LOG.debug("generatePurchaseOrderPdf() started");
        PurchaseOrderPdf poPdf = new PurchaseOrderPdf();
        ArrayList<String> errors = new ArrayList<String>();
        try {
            this.purchaseOrderParameters.setPurchaseOrderPdfParameters(po);
            PurchaseOrderTransmitParameters pdfParameters = (PurchaseOrderTransmitParameters)this.purchaseOrderParameters;
            poPdf.generatePdf(po, pdfParameters, byteArrayOutputStream, isRetransmit, environment, retransmitItems);
        }
        catch (PurError | PurapConfigurationException e) {
            LOG.error("Caught exception ", e);
            errors.add(e.getMessage());
        }
        LOG.debug("generatePurchaseOrderPdf() ended");
        return errors;
    }

    @Override
    public Collection generatePurchaseOrderPdf(PurchaseOrderDocument po, ByteArrayOutputStream byteArrayOutputStream, String environment, List<PurchaseOrderItem> retransmitItems) {
        return this.generatePurchaseOrderPdf(po, byteArrayOutputStream, false, environment, retransmitItems);
    }

    @Override
    public Collection generatePurchaseOrderPdfForRetransmission(PurchaseOrderDocument po, ByteArrayOutputStream byteArrayOutputStream, String environment, List<PurchaseOrderItem> retransmitItems) {
        return this.generatePurchaseOrderPdf(po, byteArrayOutputStream, true, environment, retransmitItems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection savePurchaseOrderPdf(PurchaseOrderDocument po, boolean isRetransmit, String environment) {
        LOG.debug("savePurchaseOrderPdf() started");
        PurchaseOrderPdf poPdf = new PurchaseOrderPdf();
        ArrayList<Object> errors = new ArrayList<Object>();
        PurchaseOrderTransmitParameters pdfParameters = null;
        try {
            this.purchaseOrderParameters.setPurchaseOrderPdfParameters(po);
            pdfParameters = (PurchaseOrderTransmitParameters)this.purchaseOrderParameters;
            poPdf.savePdf(po, pdfParameters, isRetransmit, environment);
        }
        catch (PurError | PurapConfigurationException e) {
            LOG.error("Caught exception ", e);
            errors.add(e.getMessage());
        }
        finally {
            try {
                poPdf.deletePdf(pdfParameters.getPdfFileLocation(), pdfParameters.getPdfFileName());
            }
            catch (Throwable e) {
                LOG.error("savePurchaseOrderPdf() Error deleting PDF" + pdfParameters.getPdfFileName() + " - Exception was " + e.getMessage(), e);
                errors.add("Error while deleting the pdf after savePurchaseOrderPdf" + e.getMessage());
            }
        }
        LOG.debug("savePurchaseOrderPdf() ended");
        return errors;
    }

    @Override
    public Collection savePurchaseOrderPdf(PurchaseOrderDocument po, String environment) {
        return this.savePurchaseOrderPdf(po, false, environment);
    }

    @Override
    public Collection savePurchaseOrderPdfForRetransmission(PurchaseOrderDocument po, String environment) {
        return this.savePurchaseOrderPdf(po, true, environment);
    }

    @Override
    public Collection generateBulkReceivingPDF(BulkReceivingDocument blkRecDoc, ByteArrayOutputStream baosPDF) {
        LOG.debug("generateBulkReceivingPDF() started");
        BulkReceivingPdf recBlkTicketPDF = new BulkReceivingPdf();
        ArrayList<String> errors = new ArrayList<String>();
        String logoImage = "";
        String key = blkRecDoc.getDocumentNumber();
        String campusCode = blkRecDoc.getDeliveryCampusCode().toLowerCase(Locale.US);
        String environment = this.kualiConfigurationService.getPropertyValueAsString("environment");
        boolean useImage = true;
        if (this.parameterService.parameterExists(KfsParameterConstants.PURCHASING_DOCUMENT.class, "PDF_IMAGES_AVAILABLE_IND").booleanValue()) {
            useImage = this.parameterService.getParameterValueAsBoolean(KfsParameterConstants.PURCHASING_DOCUMENT.class, "PDF_IMAGES_AVAILABLE_IND");
        }
        if (useImage) {
            String imageTempLocation = this.kualiConfigurationService.getPropertyValueAsString("temp.directory") + "/";
            if (imageTempLocation == null) {
                throw new PurapConfigurationException("IMAGE_TEMP_PATH is missing");
            }
            logoImage = this.imageService.getLogo(key, campusCode, imageTempLocation);
            if (StringUtils.isEmpty((CharSequence)logoImage)) {
                throw new PurapConfigurationException("logoImage is null.");
            }
        }
        try {
            recBlkTicketPDF.generatePdf(blkRecDoc, baosPDF, logoImage, environment);
        }
        catch (PurapConfigurationException pce) {
            LOG.error("Caught exception ", (Throwable)pce);
            errors.add(pce.getMessage());
        }
        LOG.debug("generateBulkReceivingPDF() ended");
        return errors;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setImageService(ImageService imageService) {
        this.imageService = imageService;
    }

    public void setConfigurationService(ConfigurationService kualiConfigurationService) {
        this.kualiConfigurationService = kualiConfigurationService;
    }

    public void setPurchaseOrderParameters(PurchaseOrderParameters purchaseOrderParameters) {
        this.purchaseOrderParameters = purchaseOrderParameters;
    }
}

