/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.kns.rules.DocumentRuleBase;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.document.TransactionalDocument;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.document.BulkReceivingDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.service.BulkReceivingService;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.module.purap.document.validation.ContinuePurapRule;
import org.kuali.kfs.sys.context.SpringContext;

public class BulkReceivingDocumentRule
extends DocumentRuleBase
implements ContinuePurapRule {
    protected boolean processCustomRouteDocumentBusinessRules(Document document) {
        BulkReceivingDocument bulkReceivingDocument = (BulkReceivingDocument)document;
        GlobalVariables.getMessageMap().clearErrorPath();
        GlobalVariables.getMessageMap().addToErrorPath("document");
        boolean valid = super.processCustomRouteDocumentBusinessRules(document);
        return valid &= this.canCreateBulkReceivingDocument(bulkReceivingDocument);
    }

    @Override
    public boolean processContinuePurapBusinessRules(TransactionalDocument document) {
        BulkReceivingDocument bulkReceivingDocument = (BulkReceivingDocument)document;
        GlobalVariables.getMessageMap().clearErrorPath();
        GlobalVariables.getMessageMap().addToErrorPath("document");
        return this.hasRequiredFieldsForContinue(bulkReceivingDocument) && this.canCreateBulkReceivingDocument(bulkReceivingDocument);
    }

    protected boolean hasRequiredFieldsForContinue(BulkReceivingDocument bulkReceivingDocument) {
        boolean valid = true;
        if (ObjectUtils.isNull((Object)bulkReceivingDocument.getShipmentReceivedDate())) {
            GlobalVariables.getMessageMap().putError("shipmentReceivedDate", "error.required", new String[]{"Vendor Date"});
            valid = false;
        }
        return valid;
    }

    protected boolean canCreateBulkReceivingDocument(BulkReceivingDocument bulkReceivingDocument) {
        boolean valid = true;
        if (bulkReceivingDocument.getPurchaseOrderIdentifier() != null) {
            PurchaseOrderDocument po = ((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).getCurrentPurchaseOrder(bulkReceivingDocument.getPurchaseOrderIdentifier());
            if (ObjectUtils.isNull((Object)po)) {
                GlobalVariables.getMessageMap().putError("purchaseOrderIdentifier", "errors.bulkReceiving.invalidPo", new String[]{bulkReceivingDocument.getDocumentNumber(), bulkReceivingDocument.getPurchaseOrderIdentifier().toString()});
                valid = false;
            } else if (!po.getApplicationDocumentStatus().equals("Open") && !po.getApplicationDocumentStatus().equals("Closed")) {
                valid = false;
                GlobalVariables.getMessageMap().putError("purchaseOrderIdentifier", "errors.bulkReceiving.purchaseOrder.notOpen", new String[]{bulkReceivingDocument.getDocumentNumber(), bulkReceivingDocument.getPurchaseOrderIdentifier().toString()});
            } else {
                String docNumberInProcess = ((BulkReceivingService)SpringContext.getBean(BulkReceivingService.class)).getBulkReceivingDocumentNumberInProcessForPurchaseOrder(po.getPurapDocumentIdentifier(), bulkReceivingDocument.getDocumentNumber());
                if (StringUtils.isNotEmpty((CharSequence)docNumberInProcess)) {
                    valid = false;
                    GlobalVariables.getMessageMap().putError("purchaseOrderIdentifier", "errors.bulkReceiving.documentActiveForPo", new String[]{docNumberInProcess, bulkReceivingDocument.getPurchaseOrderIdentifier().toString()});
                }
            }
        }
        return valid;
    }
}

