/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.core.api.parameter.ParameterEvaluatorService;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.document.AccountingDocument;
import org.kuali.kfs.sys.document.validation.BranchingValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class PurchasingAccountsPayableObjectCodeOverrideBranchingValidation
extends BranchingValidation {
    protected String propertyPath;
    protected String parameterToCheckAgainst;
    protected ParameterService parameterService;
    protected String responsibleProperty;
    protected AccountingDocument accountingDocumentForValidation;
    protected AccountingLine accountingLineForValidation;
    private ParameterEvaluatorService parameterEvaluatorService;
    protected static final String OBJECT_CODE_OVERRIDEN = "ObjectCodeOverriden";
    protected static final String OBJECT_CODE_NOT_OVERRIDEN = "ObjectCodeNotOverriden";

    protected String determineBranch(AttributedDocumentEvent event) {
        if (StringUtils.isNotBlank((CharSequence)this.propertyPath)) {
            this.refreshByPath(this.accountingLineForValidation);
        }
        boolean isTaxApproval = false;
        if (this.accountingDocumentForValidation instanceof PaymentRequestDocument) {
            PaymentRequestDocument preq = (PaymentRequestDocument)this.accountingDocumentForValidation;
            PurApAccountingLine purapAccountingLine = (PurApAccountingLine)this.accountingLineForValidation;
            Object item = purapAccountingLine.getPurapItem();
            if (StringUtils.equals((CharSequence)"Awaiting Tax Approval", (CharSequence)preq.getApplicationDocumentStatus())) {
                isTaxApproval = true;
            } else if (StringUtils.equals((CharSequence)"Department-Approved", (CharSequence)preq.getApplicationDocumentStatus()) && ObjectUtils.isNotNull(item) && item.getItemType().getIsTaxCharge()) {
                isTaxApproval = true;
            }
        }
        if (isTaxApproval) {
            return null;
        }
        if (this.isAccountingLineValueAllowed(this.accountingDocumentForValidation.getClass(), this.accountingLineForValidation, this.parameterToCheckAgainst, this.propertyPath, this.responsibleProperty != null ? this.responsibleProperty : this.propertyPath)) {
            return OBJECT_CODE_OVERRIDEN;
        }
        return OBJECT_CODE_NOT_OVERRIDEN;
    }

    protected boolean isAccountingLineValueAllowed(Class documentClass, AccountingLine accountingLine, String parameterName, String propertyName, String userEnteredPropertyName) {
        boolean isAllowed = false;
        String exceptionMessage = "Invalid property name provided to PurchasingAccountsPayableObjectCodeOverrideBranchingValidation isAccountingLineValueAllowed method: " + propertyName;
        try {
            String propertyValue = (String)PropertyUtils.getProperty((Object)accountingLine, (String)propertyName);
            if (this.getParameterService().parameterExists(documentClass, parameterName).booleanValue()) {
                isAllowed = this.parameterEvaluatorService.getParameterEvaluator(documentClass, parameterName, propertyValue).evaluationSucceeds();
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(exceptionMessage, e);
        }
        return isAllowed;
    }

    public void refreshByPath(AccountingLine line) {
        this.refreshByQueue((PersistableBusinessObject)line, this.convertPathToQueue(this.propertyPath));
    }

    protected Queue<String> convertPathToQueue(String path) {
        LinkedList<String> pathQueue = new LinkedList<String>();
        Collections.addAll(pathQueue, path.split("\\."));
        return pathQueue;
    }

    protected void refreshByQueue(PersistableBusinessObject bo, Queue<String> path) {
        if (path.size() > 1) {
            String currentProperty = path.remove();
            bo.refreshReferenceObject(currentProperty);
            PersistableBusinessObject childBO = (PersistableBusinessObject)ObjectUtils.getPropertyValue((Object)bo, (String)currentProperty);
            if (!ObjectUtils.isNull((Object)childBO)) {
                this.refreshByQueue(childBO, path);
            }
        }
    }

    public String getPropertyPath() {
        return this.propertyPath;
    }

    public void setPropertyPath(String refreshPath) {
        this.propertyPath = refreshPath;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public String getParameterToCheckAgainst() {
        return this.parameterToCheckAgainst;
    }

    public void setParameterToCheckAgainst(String parameterToCheckAgainst) {
        this.parameterToCheckAgainst = parameterToCheckAgainst;
    }

    public String getResponsibleProperty() {
        return this.responsibleProperty;
    }

    public void setResponsibleProperty(String responsibleProperty) {
        this.responsibleProperty = responsibleProperty;
    }

    public AccountingDocument getAccountingDocumentForValidation() {
        return this.accountingDocumentForValidation;
    }

    public void setAccountingDocumentForValidation(AccountingDocument accountingDocumentForValidation) {
        this.accountingDocumentForValidation = accountingDocumentForValidation;
    }

    public AccountingLine getAccountingLineForValidation() {
        return this.accountingLineForValidation;
    }

    public void setAccountingLineForValidation(AccountingLine accountingLineForValidation) {
        this.accountingLineForValidation = accountingLineForValidation;
    }

    public void setParameterEvaluatorService(ParameterEvaluatorService parameterEvaluatorService) {
        this.parameterEvaluatorService = parameterEvaluatorService;
    }
}

