/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.service.impl;

import java.math.BigDecimal;
import java.sql.Date;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.batch.ElectronicInvoiceStep;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoice;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceDetailRequestSummary;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceRejectReason;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceRejectReasonType;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.service.ElectronicInvoiceMatchingService;
import org.kuali.kfs.module.purap.service.impl.ElectronicInvoiceItemHolder;
import org.kuali.kfs.module.purap.service.impl.ElectronicInvoiceOrderHolder;
import org.kuali.kfs.module.purap.util.ElectronicInvoiceUtils;
import org.kuali.kfs.module.purap.util.PurApItemUtils;
import org.kuali.kfs.sys.service.TaxService;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;
import org.kuali.kfs.vnd.businessobject.PurchaseOrderCostSource;
import org.kuali.kfs.vnd.businessobject.VendorDetail;
import org.kuali.kfs.vnd.document.service.VendorService;

public class ElectronicInvoiceMatchingServiceImpl
implements ElectronicInvoiceMatchingService {
    private static final Logger LOG = LogManager.getLogger();
    private Map<String, ElectronicInvoiceRejectReasonType> rejectReasonTypes;
    private VendorService vendorService;
    private TaxService taxService;
    private DateTimeService dateTimeService;
    private ParameterService parameterService;
    private BusinessObjectService businessObjectService;
    String upperVariancePercentString;
    String lowerVariancePercentString;

    @Override
    public void doMatchingProcess(ElectronicInvoiceOrderHolder orderHolder) {
        if (LOG.isInfoEnabled()) {
            LOG.info("Matching process started");
        }
        this.upperVariancePercentString = this.parameterService.getParameterValueAsString(ElectronicInvoiceStep.class, "SALES_TAX_UPPER_VARIANCE_PERCENT");
        this.lowerVariancePercentString = this.parameterService.getParameterValueAsString(ElectronicInvoiceStep.class, "SALES_TAX_LOWER_VARIANCE_PERCENT");
        try {
            if (orderHolder.isValidateHeaderInformation()) {
                this.validateHeaderInformation(orderHolder);
                if (orderHolder.isInvoiceRejected()) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info("Matching process failed at header validation");
                    }
                    return;
                }
            }
            this.validateInvoiceDetails(orderHolder);
            if (orderHolder.isInvoiceRejected()) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("Matching process failed at order detail validation");
                }
                return;
            }
        }
        catch (NumberFormatException e) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Matching process matching failed due to number format exception " + e.getMessage());
            }
            ElectronicInvoiceRejectReason rejectReason = this.createRejectReason("NFEX", e.getMessage(), orderHolder.getFileName());
            orderHolder.addInvoiceHeaderRejectReason(rejectReason);
            return;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Matching process ended successfully");
        }
    }

    protected void validateHeaderInformation(ElectronicInvoiceOrderHolder orderHolder) {
        String dunsField = "vendorDunsNumber";
        String applnResourceKeyName = "errors.reject.invalidDuns";
        if (StringUtils.isEmpty((CharSequence)orderHolder.getDunsNumber())) {
            ElectronicInvoiceRejectReason rejectReason = this.createRejectReason("NODU", null, orderHolder.getFileName());
            orderHolder.addInvoiceHeaderRejectReason(rejectReason, dunsField, applnResourceKeyName);
            return;
        }
        if (orderHolder.isRejectDocumentHolder()) {
            VendorDetail vendorDetail = this.vendorService.getVendorByDunsNumber(orderHolder.getDunsNumber());
            if (vendorDetail == null) {
                ElectronicInvoiceRejectReason rejectReason = this.createRejectReason("INDU", null, orderHolder.getFileName());
                orderHolder.addInvoiceHeaderRejectReason(rejectReason, dunsField, applnResourceKeyName);
                return;
            }
        } else if (orderHolder.getVendorHeaderId() == null && orderHolder.getVendorDetailId() == null) {
            ElectronicInvoiceRejectReason rejectReason = this.createRejectReason("INDU", null, orderHolder.getFileName());
            orderHolder.addInvoiceHeaderRejectReason(rejectReason, dunsField, applnResourceKeyName);
            return;
        }
        String invoiceNumberField = "invoiceFileNumber";
        if (!orderHolder.isInvoiceNumberAcceptIndicatorEnabled() && StringUtils.isEmpty((CharSequence)orderHolder.getInvoiceNumber())) {
            ElectronicInvoiceRejectReason rejectReason = this.createRejectReason("IIDE", null, orderHolder.getFileName());
            orderHolder.addInvoiceHeaderRejectReason(rejectReason, invoiceNumberField, "errors.reject.invoicenumber.empty");
            return;
        }
        String invoiceDateField = "invoiceFileDate";
        if (StringUtils.isEmpty((CharSequence)orderHolder.getInvoiceDateString()) || orderHolder.getInvoiceDate() == null) {
            ElectronicInvoiceRejectReason rejectReason = this.createRejectReason("IDIV", null, orderHolder.getFileName());
            orderHolder.addInvoiceHeaderRejectReason(rejectReason, invoiceDateField, "errors.reject.invoicedate.invalid");
            return;
        }
        if (orderHolder.getInvoiceDate().after(this.dateTimeService.getCurrentDate())) {
            ElectronicInvoiceRejectReason rejectReason = this.createRejectReason("IDAG", null, orderHolder.getFileName());
            orderHolder.addInvoiceOrderRejectReason(rejectReason, invoiceDateField, "errors.reject.invoicedate.greater");
            return;
        }
        if (orderHolder.isInformationOnly()) {
            ElectronicInvoiceRejectReason rejectReason = this.createRejectReason("INFO", null, orderHolder.getFileName());
            orderHolder.addInvoiceHeaderRejectReason(rejectReason);
            return;
        }
        this.validateSummaryAmounts(orderHolder);
        if (orderHolder.isInvoiceRejected()) {
            return;
        }
        this.validateItemTypes(orderHolder);
    }

    protected void validateSummaryAmounts(ElectronicInvoiceOrderHolder orderHolder) {
        if (orderHolder.isRejectDocumentHolder()) {
            return;
        }
        ElectronicInvoiceDetailRequestSummary summary = orderHolder.getElectronicInvoice().getInvoiceDetailRequestSummary();
        boolean enableSalesTaxInd = this.parameterService.getParameterValueAsBoolean(KfsParameterConstants.PURCHASING_DOCUMENT.class, "ENABLE_SALES_TAX_IND");
        boolean salesTaxUsed = false;
        PurchaseOrderDocument poDoc = orderHolder.getPurchaseOrderDocument();
        if (poDoc != null) {
            List<PurApItem> items = PurApItemUtils.getAboveTheLineOnly(poDoc.getItems());
            for (PurApItem item : items) {
                if (!item.getItemType().isTaxableIndicator()) continue;
                salesTaxUsed = true;
                break;
            }
            boolean useTaxUsed = poDoc.isUseTaxIndicator();
            boolean bl = salesTaxUsed || useTaxUsed;
            BigDecimal summaryTaxAmount = summary.getInvoiceTaxAmount();
            if (!(enableSalesTaxInd &= bl)) {
                if (summaryTaxAmount.compareTo(new BigDecimal(0)) != 0) {
                    String extraDescription = "Summary Tax Amount:" + summaryTaxAmount;
                    ElectronicInvoiceRejectReason rejectReason = this.createRejectReason("STNV", extraDescription, orderHolder.getFileName());
                    orderHolder.addInvoiceHeaderRejectReason(rejectReason);
                }
            } else if (orderHolder.isTaxInLine()) {
                this.validateSummaryAmount(orderHolder, summaryTaxAmount, ElectronicInvoice.INVOICE_AMOUNT_TYPE_CODE_TAX, "TSAM");
            }
        }
        if (orderHolder.isShippingInLine()) {
            this.validateSummaryAmount(orderHolder, summary.getInvoiceShippingAmount(), ElectronicInvoice.INVOICE_AMOUNT_TYPE_CODE_SHIPPING, "SHSA");
        }
        if (orderHolder.isSpecialHandlingInLine()) {
            this.validateSummaryAmount(orderHolder, summary.getInvoiceSpecialHandlingAmount(), ElectronicInvoice.INVOICE_AMOUNT_TYPE_CODE_SPECIAL_HANDLING, "SSAM");
        }
        if (orderHolder.isDiscountInLine()) {
            this.validateSummaryAmount(orderHolder, summary.getInvoiceDiscountAmount(), ElectronicInvoice.INVOICE_AMOUNT_TYPE_CODE_DISCOUNT, "DSAM");
        }
    }

    protected void validateSummaryAmount(ElectronicInvoiceOrderHolder orderHolder, BigDecimal summaryAmount, String invoiceLineItemTypeCode, String rejectDescriptionCode) {
        BigDecimal lineItemTotalAmount = orderHolder.getElectronicInvoice().getFileTotalAmountForInLineItems(invoiceLineItemTypeCode);
        if (lineItemTotalAmount.compareTo(summaryAmount) != 0) {
            String extraDescription = "Line Total Amount:" + lineItemTotalAmount + ",Summary Total Amount:" + summaryAmount;
            ElectronicInvoiceRejectReason rejectReason = this.createRejectReason(rejectDescriptionCode, extraDescription, orderHolder.getFileName());
            orderHolder.addInvoiceHeaderRejectReason(rejectReason);
        }
    }

    protected void validateItemTypes(ElectronicInvoiceOrderHolder orderHolder) {
        this.validateItemMapping(orderHolder, ElectronicInvoice.INVOICE_AMOUNT_TYPE_CODE_ITEM);
        this.validateItemMapping(orderHolder, ElectronicInvoice.INVOICE_AMOUNT_TYPE_CODE_TAX);
        this.validateItemMapping(orderHolder, ElectronicInvoice.INVOICE_AMOUNT_TYPE_CODE_SHIPPING);
        this.validateItemMapping(orderHolder, ElectronicInvoice.INVOICE_AMOUNT_TYPE_CODE_SPECIAL_HANDLING);
        this.validateItemMapping(orderHolder, ElectronicInvoice.INVOICE_AMOUNT_TYPE_CODE_DISCOUNT);
        this.validateItemMapping(orderHolder, ElectronicInvoice.INVOICE_AMOUNT_TYPE_CODE_EXMT);
    }

    protected void validateItemMapping(ElectronicInvoiceOrderHolder orderHolder, String kualiItemTypeCode) {
        if (!orderHolder.isItemTypeAvailableInItemMapping(kualiItemTypeCode)) {
            ElectronicInvoiceRejectReason rejectReason = this.createRejectReason("IMNA", kualiItemTypeCode, orderHolder.getFileName());
            orderHolder.addInvoiceHeaderRejectReason(rejectReason);
        }
    }

    protected void validateInvoiceDetails(ElectronicInvoiceOrderHolder orderHolder) {
        this.validatePurchaseOrderMatch(orderHolder);
        if (orderHolder.isInvoiceRejected()) {
            return;
        }
        this.validateInvoiceItems(orderHolder);
        if (LOG.isInfoEnabled() && !orderHolder.isInvoiceRejected()) {
            LOG.info("Purchase order document match done successfully");
        }
    }

    protected void validatePurchaseOrderMatch(ElectronicInvoiceOrderHolder orderHolder) {
        String poIDFieldName = "invoiceOrderPurchaseOrderIdentifier";
        String poID = orderHolder.getInvoicePurchaseOrderID();
        if (StringUtils.isEmpty((CharSequence)poID)) {
            ElectronicInvoiceRejectReason rejectReason = this.createRejectReason("POIE", null, orderHolder.getFileName());
            orderHolder.addInvoiceOrderRejectReason(rejectReason, poIDFieldName, "errors.reject.poid.empty");
            return;
        }
        String extraDesc = "Invoice Order ID:" + poID;
        if (!NumberUtils.isDigits((String)poID)) {
            ElectronicInvoiceRejectReason rejectReason = this.createRejectReason("POII", extraDesc, orderHolder.getFileName());
            orderHolder.addInvoiceOrderRejectReason(rejectReason, poIDFieldName, "errors.reject.poid.invalid");
            return;
        }
        PurchaseOrderDocument poDoc = orderHolder.getPurchaseOrderDocument();
        if (poDoc == null) {
            ElectronicInvoiceRejectReason rejectReason = this.createRejectReason("PONE", extraDesc, orderHolder.getFileName());
            orderHolder.addInvoiceOrderRejectReason(rejectReason, poIDFieldName, "errors.reject.po.notexists");
            return;
        }
        if (!poDoc.getApplicationDocumentStatus().equals("Open")) {
            ElectronicInvoiceRejectReason rejectReason = this.createRejectReason("PONO", null, orderHolder.getFileName());
            orderHolder.addInvoiceOrderRejectReason(rejectReason, poIDFieldName, "errors.reject.po.closed");
            return;
        }
        if (poDoc.getVendorHeaderGeneratedIdentifier() == null || poDoc.getVendorDetailAssignedIdentifier() == null || !poDoc.getVendorHeaderGeneratedIdentifier().equals(orderHolder.getVendorHeaderId()) || !poDoc.getVendorDetailAssignedIdentifier().equals(orderHolder.getVendorDetailId())) {
            ElectronicInvoiceRejectReason rejectReason = this.createRejectReason("PVNM", null, orderHolder.getFileName());
            orderHolder.addInvoiceOrderRejectReason(rejectReason);
        }
    }

    protected void validateInvoiceItems(ElectronicInvoiceOrderHolder orderHolder) {
        HashSet poLineNumbers = new HashSet();
        ElectronicInvoiceItemHolder[] itemHolders = orderHolder.getItems();
        if (itemHolders != null) {
            for (ElectronicInvoiceItemHolder itemHolder : itemHolders) {
                this.validateInvoiceItem(itemHolder, poLineNumbers);
            }
        }
    }

    protected void validateInvoiceItem(ElectronicInvoiceItemHolder itemHolder, Set poLineNumbers) {
        PurchaseOrderItem poItem = itemHolder.getPurchaseOrderItem();
        ElectronicInvoiceOrderHolder orderHolder = itemHolder.getInvoiceOrderHolder();
        if (poItem == null) {
            String extraDescription = "Invoice Item Line Number:" + itemHolder.getInvoiceItemLineNumber();
            ElectronicInvoiceRejectReason rejectReason = this.createRejectReason("IMLI", extraDescription, orderHolder.getFileName());
            orderHolder.addInvoiceOrderRejectReason(rejectReason, "invoiceItemLineNumber", "errors.reject.invoice.item.nomatch");
            return;
        }
        if (poLineNumbers.contains(itemHolder.getInvoiceItemLineNumber())) {
            String extraDescription = "Invoice Item Line Number:" + itemHolder.getInvoiceItemLineNumber();
            ElectronicInvoiceRejectReason rejectReason = this.createRejectReason("ICSL", extraDescription, orderHolder.getFileName());
            orderHolder.addInvoiceOrderRejectReason(rejectReason, "invoiceItemLineNumber", "errors.reject.po.item.dupliate");
            return;
        }
        poLineNumbers.add(itemHolder.getInvoiceItemLineNumber());
        if (!poItem.isItemActiveIndicator()) {
            String extraDescription = "PO Item Line Number:" + poItem.getItemLineNumber();
            ElectronicInvoiceRejectReason rejectReason = this.createRejectReason("ILIA", extraDescription, orderHolder.getFileName());
            orderHolder.addInvoiceOrderRejectReason(rejectReason, "invoiceItemLineNumber", "errors.reject.po.item.inactive");
            return;
        }
        if (!itemHolder.isCatalogNumberAcceptIndicatorEnabled()) {
            this.validateCatalogNumber(itemHolder);
            if (orderHolder.isInvoiceRejected()) {
                return;
            }
        }
        if (!itemHolder.isUnitOfMeasureAcceptIndicatorEnabled() && !StringUtils.equals((CharSequence)poItem.getItemUnitOfMeasureCode(), (CharSequence)itemHolder.getInvoiceItemUnitOfMeasureCode())) {
            String extraDescription = "Invoice UOM:" + itemHolder.getInvoiceItemUnitOfMeasureCode() + ", PO UOM:" + poItem.getItemUnitOfMeasureCode();
            ElectronicInvoiceRejectReason rejectReason = this.createRejectReason("IUOM", extraDescription, orderHolder.getFileName());
            orderHolder.addInvoiceOrderRejectReason(rejectReason, "invoiceItemUnitOfMeasureCode", "errors.reject.uom.mismatch");
            return;
        }
        this.validateUnitPrice(itemHolder);
        if (orderHolder.isInvoiceRejected()) {
            return;
        }
        this.validateSalesTax(itemHolder);
        if (orderHolder.isInvoiceRejected()) {
            return;
        }
        if (poItem.getItemQuantity() != null) {
            this.validateQtyBasedItem(itemHolder);
        } else {
            this.validateNonQtyBasedItem(itemHolder);
        }
    }

    protected void validateCatalogNumber(ElectronicInvoiceItemHolder itemHolder) {
        PurchaseOrderItem poItem = itemHolder.getPurchaseOrderItem();
        ElectronicInvoiceOrderHolder orderHolder = itemHolder.getInvoiceOrderHolder();
        String invoiceCatalogNumberStripped = itemHolder.getCatalogNumberStripped();
        String poCatalogNumberStripped = ElectronicInvoiceUtils.stripSplChars(poItem.getItemCatalogNumber());
        if (StringUtils.isNotBlank((CharSequence)invoiceCatalogNumberStripped) && StringUtils.isNotBlank((CharSequence)poCatalogNumberStripped)) {
            if (!StringUtils.equals((CharSequence)poCatalogNumberStripped, (CharSequence)invoiceCatalogNumberStripped)) {
                String extraDescription = "Invoice Catalog No:" + invoiceCatalogNumberStripped + ", PO Catalog No:" + poCatalogNumberStripped;
                ElectronicInvoiceRejectReason rejectReason = this.createRejectReason("IICN", extraDescription, orderHolder.getFileName());
                orderHolder.addInvoiceOrderRejectReason(rejectReason, "invoiceItemCatalogNumber", "errors.reject.catalog.mismatch");
            }
        } else {
            Object[] requisitionSourcesFromParam;
            String reqSourceRequiringCatalogMatch = this.parameterService.getParameterValueAsString(ElectronicInvoiceStep.class, "REQUISITION_SOURCES_REQUIRING_CATALOG_MATCHING");
            String requisitionSourceCodeInPO = orderHolder.getPurchaseOrderDocument().getRequisitionSourceCode();
            if (StringUtils.isNotEmpty((CharSequence)reqSourceRequiringCatalogMatch) && ArrayUtils.contains((Object[])(requisitionSourcesFromParam = StringUtils.split((String)reqSourceRequiringCatalogMatch, (char)';')), (Object)requisitionSourceCodeInPO)) {
                String extraDescription = "Invoice Catalog No:" + invoiceCatalogNumberStripped + ", PO Catalog No:" + poItem.getItemCatalogNumber();
                ElectronicInvoiceRejectReason rejectReason = this.createRejectReason("IICN", extraDescription, orderHolder.getFileName());
                orderHolder.addInvoiceOrderRejectReason(rejectReason, "invoiceItemCatalogNumber", "errors.reject.catalog.mismatch");
            }
        }
    }

    protected void validateQtyBasedItem(ElectronicInvoiceItemHolder itemHolder) {
        PurchaseOrderItem poItem = itemHolder.getPurchaseOrderItem();
        ElectronicInvoiceOrderHolder orderHolder = itemHolder.getInvoiceOrderHolder();
        if (KualiDecimal.ZERO.compareTo((AbstractKualiDecimal)poItem.getItemOutstandingEncumberedQuantity()) >= 0) {
            String extraDescription = "Invoice Item Line Number:" + itemHolder.getInvoiceItemLineNumber();
            ElectronicInvoiceRejectReason rejectReason = this.createRejectReason("UEOQ", extraDescription, orderHolder.getFileName());
            orderHolder.addInvoiceOrderRejectReason(rejectReason, "invoiceItemQuantity", "errors.reject.poitem.outstanding.qty");
            return;
        }
        if (itemHolder.getInvoiceItemQuantity() == null) {
            String extraDescription = "Invoice Item Line Number:" + itemHolder.getInvoiceItemLineNumber();
            ElectronicInvoiceRejectReason rejectReason = this.createRejectReason("IIQE", extraDescription, orderHolder.getFileName());
            orderHolder.addInvoiceOrderRejectReason(rejectReason, "invoiceItemQuantity", "errors.reject.poitem.invoice.qty.empty");
        } else if (!itemHolder.getInvoiceOrderHolder().getPurchaseOrderDocument().isReceivingDocumentRequiredIndicator() && itemHolder.getInvoiceItemQuantity().compareTo(poItem.getItemOutstandingEncumberedQuantity().bigDecimalValue()) > 0) {
            String extraDescription = "Invoice Item Line Number:" + itemHolder.getInvoiceItemLineNumber();
            ElectronicInvoiceRejectReason rejectReason = this.createRejectReason("PILI", extraDescription, orderHolder.getFileName());
            orderHolder.addInvoiceOrderRejectReason(rejectReason, "invoiceItemQuantity", "errors.reject.poitem.less.outstanding.qty");
        }
    }

    protected void validateNonQtyBasedItem(ElectronicInvoiceItemHolder itemHolder) {
        PurchaseOrderItem poItem = itemHolder.getPurchaseOrderItem();
        ElectronicInvoiceOrderHolder orderHolder = itemHolder.getInvoiceOrderHolder();
        if (KualiDecimal.ZERO.compareTo((AbstractKualiDecimal)poItem.getItemOutstandingEncumberedAmount()) >= 0) {
            String extraDescription = "Invoice Item Line Number:" + itemHolder.getInvoiceItemLineNumber();
            ElectronicInvoiceRejectReason rejectReason = this.createRejectReason("UEAA", extraDescription, orderHolder.getFileName());
            orderHolder.addInvoiceOrderRejectReason(rejectReason, "invoiceItemLineNumber", "errors.reject.poitem.outstanding.amt");
        } else if (itemHolder.getInvoiceItemSubTotalAmount().setScale(2, KualiDecimal.ROUND_BEHAVIOR).compareTo(poItem.getItemOutstandingEncumberedAmount().bigDecimalValue()) > 0) {
            String extraDescription = "Invoice Item Line Number:" + itemHolder.getInvoiceItemLineNumber();
            ElectronicInvoiceRejectReason rejectReason = this.createRejectReason("PAIA", extraDescription, orderHolder.getFileName());
            orderHolder.addInvoiceOrderRejectReason(rejectReason, "invoiceItemLineNumber", "errors.reject.poitem.less.outstanding.amt");
        }
    }

    protected void validateUnitPrice(ElectronicInvoiceItemHolder itemHolder) {
        BigDecimal upperPercentage;
        BigDecimal upperAcceptableVariance;
        PurchaseOrderCostSource costSource = itemHolder.getInvoiceOrderHolder().getPurchaseOrderDocument().getPurchaseOrderCostSource();
        PurchaseOrderItem poItem = itemHolder.getPurchaseOrderItem();
        ElectronicInvoiceOrderHolder orderHolder = itemHolder.getInvoiceOrderHolder();
        String extraDescription = "Invoice Item Line Number:" + itemHolder.getInvoiceItemLineNumber();
        BigDecimal actualVariance = itemHolder.getInvoiceItemUnitPrice().subtract(poItem.getItemUnitPrice());
        BigDecimal lowerPercentage = costSource.getItemUnitPriceLowerVariancePercent() != null ? costSource.getItemUnitPriceLowerVariancePercent() : new BigDecimal(100);
        BigDecimal lowerAcceptableVariance = lowerPercentage.divide(new BigDecimal(100)).multiply(poItem.getItemUnitPrice()).negate();
        if (lowerAcceptableVariance.compareTo(actualVariance) > 0) {
            ElectronicInvoiceRejectReason rejectReason = this.createRejectReason("ALLV", extraDescription, orderHolder.getFileName());
            orderHolder.addInvoiceOrderRejectReason(rejectReason, "invoiceItemUnitPrice", "errors.reject.unitprice.lowervariance");
        }
        if ((upperAcceptableVariance = (upperPercentage = costSource.getItemUnitPriceUpperVariancePercent() != null ? costSource.getItemUnitPriceUpperVariancePercent() : new BigDecimal(100)).divide(new BigDecimal(100)).multiply(poItem.getItemUnitPrice())).compareTo(actualVariance) < 0) {
            ElectronicInvoiceRejectReason rejectReason = this.createRejectReason("AGUV", extraDescription, orderHolder.getFileName());
            orderHolder.addInvoiceOrderRejectReason(rejectReason, "invoiceItemUnitPrice", "errors.reject.unitprice.uppervariance");
        }
    }

    protected void validateSalesTax(ElectronicInvoiceItemHolder itemHolder) {
        KualiDecimal upperVariancePercent;
        BigDecimal upperAcceptableVariance;
        if (LOG.isInfoEnabled()) {
            LOG.info("Validating sales tax");
        }
        ElectronicInvoiceOrderHolder orderHolder = itemHolder.getInvoiceOrderHolder();
        PurchaseOrderItem poItem = itemHolder.getPurchaseOrderItem();
        KualiDecimal invoiceSalesTaxAmount = new KualiDecimal(itemHolder.getTaxAmount());
        boolean enableSalesTaxInd = this.parameterService.getParameterValueAsBoolean(KfsParameterConstants.PURCHASING_DOCUMENT.class, "ENABLE_SALES_TAX_IND");
        boolean salesTaxUsed = false;
        PurchaseOrderDocument poDoc = orderHolder.getPurchaseOrderDocument();
        List<PurApItem> items = PurApItemUtils.getAboveTheLineOnly(poDoc.getItems());
        for (PurApItem item : items) {
            if (!item.getItemType().isTaxableIndicator()) continue;
            salesTaxUsed = true;
            break;
        }
        boolean useTaxUsed = poDoc.isUseTaxIndicator();
        enableSalesTaxInd &= poItem.getItemType().isTaxableIndicator() && (salesTaxUsed || useTaxUsed);
        if (LOG.isInfoEnabled()) {
            LOG.info("Sales Tax Enable Indicator - " + enableSalesTaxInd);
            LOG.info("Invoice item tax amount - " + invoiceSalesTaxAmount);
        }
        if (!enableSalesTaxInd) {
            if (invoiceSalesTaxAmount.compareTo((AbstractKualiDecimal)KualiDecimal.ZERO) != 0) {
                String extraDescription = "Item Tax Amount:" + invoiceSalesTaxAmount;
                ElectronicInvoiceRejectReason rejectReason = this.createRejectReason("STNV", extraDescription, orderHolder.getFileName());
                orderHolder.addInvoiceHeaderRejectReason(rejectReason);
            }
            return;
        }
        Date transTaxDate = itemHolder.getInvoiceOrderHolder().getInvoiceProcessedDate();
        String deliveryPostalCode = poItem.getPurchaseOrder().getDeliveryPostalCode();
        KualiDecimal extendedPrice = new KualiDecimal(this.getExtendedPrice(itemHolder).setScale(2, KualiDecimal.ROUND_BEHAVIOR));
        KualiDecimal salesTaxAmountCalculated = this.taxService.getTotalSalesTaxAmount(transTaxDate, deliveryPostalCode, extendedPrice);
        KualiDecimal actualVariance = (KualiDecimal)invoiceSalesTaxAmount.subtract((AbstractKualiDecimal)salesTaxAmountCalculated);
        if (LOG.isInfoEnabled()) {
            LOG.info("Sales Tax Upper Variance param - " + this.upperVariancePercentString);
            LOG.info("Sales Tax Lower Variance param - " + this.lowerVariancePercentString);
            LOG.info("Trans date (from invoice/rejectdoc) - " + transTaxDate);
            LOG.info("Delivery Postal Code - " + deliveryPostalCode);
            LOG.info("Extended price - " + extendedPrice);
            LOG.info("Sales Tax amount (from sales tax service) - " + salesTaxAmountCalculated);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.upperVariancePercentString) && (upperAcceptableVariance = ((KualiDecimal)((KualiDecimal)(upperVariancePercent = new KualiDecimal(this.upperVariancePercentString)).divide((AbstractKualiDecimal)new KualiDecimal(100))).multiply((AbstractKualiDecimal)salesTaxAmountCalculated)).bigDecimalValue()).compareTo(actualVariance.bigDecimalValue()) < 0) {
            ElectronicInvoiceRejectReason rejectReason = this.createRejectReason("STUV", null, orderHolder.getFileName());
            orderHolder.addInvoiceOrderRejectReason(rejectReason, "invoiceItemTaxAmount", "errors.reject.taxamount.uppervariance");
            return;
        }
        if (StringUtils.isNotEmpty((CharSequence)this.lowerVariancePercentString)) {
            KualiDecimal lowerVariancePercent = new KualiDecimal(this.lowerVariancePercentString);
            BigDecimal lowerAcceptableVariance = ((KualiDecimal)((KualiDecimal)lowerVariancePercent.divide((AbstractKualiDecimal)new KualiDecimal(100))).multiply((AbstractKualiDecimal)salesTaxAmountCalculated)).bigDecimalValue().negate();
            if (lowerAcceptableVariance.compareTo(BigDecimal.ZERO) >= 0 && actualVariance.compareTo((AbstractKualiDecimal)KualiDecimal.ZERO) >= 0) {
                if (actualVariance.bigDecimalValue().compareTo(lowerAcceptableVariance) > 0) {
                    ElectronicInvoiceRejectReason rejectReason = this.createRejectReason("STLV", null, orderHolder.getFileName());
                    orderHolder.addInvoiceOrderRejectReason(rejectReason, "invoiceItemTaxAmount", "errors.reject.taxamount.lowervariance");
                }
            } else if (actualVariance.bigDecimalValue().compareTo(lowerAcceptableVariance) < 0) {
                ElectronicInvoiceRejectReason rejectReason = this.createRejectReason("STLV", null, orderHolder.getFileName());
                orderHolder.addInvoiceOrderRejectReason(rejectReason, "invoiceItemTaxAmount", "errors.reject.taxamount.lowervariance");
            }
        }
    }

    protected BigDecimal getExtendedPrice(ElectronicInvoiceItemHolder itemHolder) {
        if (itemHolder.getPurchaseOrderItem().getItemType().isAmountBasedGeneralLedgerIndicator()) {
            return itemHolder.getUnitPrice();
        }
        if (ObjectUtils.isNotNull((Object)itemHolder.getQuantity())) {
            return itemHolder.getUnitPrice().multiply(itemHolder.getQuantity());
        }
        return BigDecimal.ZERO;
    }

    @Override
    public ElectronicInvoiceRejectReason createRejectReason(String rejectReasonTypeCode, String extraDescription, String fileName) {
        ElectronicInvoiceRejectReasonType rejectReasonType = this.getElectronicInvoiceRejectReasonType(rejectReasonTypeCode);
        ElectronicInvoiceRejectReason eInvoiceRejectReason = new ElectronicInvoiceRejectReason();
        if (rejectReasonType == null) {
            throw new NullPointerException("Reject reason type for " + rejectReasonTypeCode + " not available in DB");
        }
        eInvoiceRejectReason.setInvoiceFileName(fileName);
        eInvoiceRejectReason.setInvoiceRejectReasonTypeCode(rejectReasonTypeCode);
        if (StringUtils.isNotEmpty((CharSequence)extraDescription)) {
            eInvoiceRejectReason.setInvoiceRejectReasonDescription(rejectReasonType.getInvoiceRejectReasonTypeDescription() + " (" + extraDescription + ")");
        } else {
            eInvoiceRejectReason.setInvoiceRejectReasonDescription(rejectReasonType.getInvoiceRejectReasonTypeDescription());
        }
        return eInvoiceRejectReason;
    }

    @Override
    public ElectronicInvoiceRejectReasonType getElectronicInvoiceRejectReasonType(String rejectReasonTypeCode) {
        if (this.rejectReasonTypes == null) {
            this.rejectReasonTypes = this.getElectronicInvoiceRejectReasonTypes();
        }
        return this.rejectReasonTypes.get(rejectReasonTypeCode);
    }

    protected Map<String, ElectronicInvoiceRejectReasonType> getElectronicInvoiceRejectReasonTypes() {
        Collection collection = this.businessObjectService.findAll(ElectronicInvoiceRejectReasonType.class);
        HashMap<String, ElectronicInvoiceRejectReasonType> rejectReasonTypesMap = new HashMap<String, ElectronicInvoiceRejectReasonType>();
        if (collection != null && collection.size() > 0) {
            ElectronicInvoiceRejectReasonType[] rejectReasonTypesArr = new ElectronicInvoiceRejectReasonType[collection.size()];
            collection.toArray(rejectReasonTypesArr);
            for (ElectronicInvoiceRejectReasonType aRejectReasonTypesArr : rejectReasonTypesArr) {
                rejectReasonTypesMap.put(aRejectReasonTypesArr.getInvoiceRejectReasonTypeCode(), aRejectReasonTypesArr);
            }
        }
        return rejectReasonTypesMap;
    }

    public void setVendorService(VendorService vendorService) {
        this.vendorService = vendorService;
    }

    public void setTaxService(TaxService taxService) {
        this.taxService = taxService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    protected ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

