/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public final class PaymentRequestStatuses {
    public static final String APPDOC_INITIATE = "Initiated";
    public static final String APPDOC_IN_PROCESS = "In Process";
    public static final String APPDOC_CANCELLED_IN_PROCESS = "Cancelled In Process";
    public static final String APPDOC_CANCELLED_POST_AP_APPROVE = "Cancelled";
    public static final String APPDOC_DEPARTMENT_APPROVED = "Department-Approved";
    public static final String APPDOC_AUTO_APPROVED = "Auto-Approved";
    public static final String APPDOC_AWAITING_ACCOUNTS_PAYABLE_REVIEW = "Awaiting AP Review";
    public static final String APPDOC_AWAITING_RECEIVING_REVIEW = "Awaiting Receiving";
    public static final String APPDOC_AWAITING_SUB_ACCT_MGR_REVIEW = "Awaiting Sub-Account Manager Approval";
    public static final String APPDOC_AWAITING_FISCAL_REVIEW = "Awaiting Fiscal Officer Approval";
    public static final String APPDOC_AWAITING_ORG_REVIEW = "Awaiting Chart Approval";
    public static final String APPDOC_AWAITING_TAX_REVIEW = "Awaiting Tax Approval";
    public static final String APPDOC_PENDING_E_INVOICE = "Pending Route Electronic Invoice";
    public static final String NODE_ADHOC_REVIEW = "AdHoc";
    public static final String NODE_AWAITING_RECEIVING = "Receiving";
    public static final String NODE_AWAITING_RECEIVING_REVIEW = "PurchaseWasReceived";
    public static final String NODE_SUB_ACCOUNT_REVIEW = "SubAccount";
    public static final String NODE_ACCOUNT_REVIEW = "Account";
    public static final String NODE_ORG_REVIEW = "AccountingOrganizationHierarchy";
    public static final String NODE_VENDOR_TAX_REVIEW = "Tax";
    public static final String[] PREQ_STATUSES_FOR_AUTO_APPROVE = new String[]{"Awaiting Sub-Account Manager Approval", "Awaiting Fiscal Officer Approval", "Awaiting Chart Approval"};
    public static final String[] STATUSES_ALLOWED_FOR_EXTRACTION = new String[]{"Auto-Approved", "Department-Approved"};
    public static final String[] STATUSES_POTENTIALLY_ACTIVE = new String[]{"In Process", "Department-Approved", "Auto-Approved", "Awaiting AP Review", "Awaiting Receiving", "Awaiting Sub-Account Manager Approval", "Awaiting Fiscal Officer Approval", "Awaiting Chart Approval", "Awaiting Tax Approval"};
    public static final Set<String> CANCELLED_STATUSES = new HashSet<String>();
    public static final Set<String> STATUSES_DISALLOWING_HOLD = new HashSet<String>();
    public static final Set<String> STATUSES_DISALLOWING_REMOVE_HOLD = new HashSet<String>();
    public static final Set<String> STATUSES_DISALLOWING_REQUEST_CANCEL = new HashSet<String>();
    public static final Set<String> STATUSES_DISALLOWING_REMOVE_REQUEST_CANCEL = new HashSet<String>();
    public static final Set<String> STATUSES_PREROUTE = new HashSet<String>();
    public static final Set<String> STATUSES_ENROUTE = new HashSet<String>();
    public static final Set<String> STATUSES_POSTROUTE = new HashSet<String>();

    private PaymentRequestStatuses() {
    }

    public static HashMap<String, String> getAllAppDocStatuses() {
        HashMap<String, String> appDocStatusMap = new HashMap<String, String>();
        appDocStatusMap.put(APPDOC_INITIATE, APPDOC_INITIATE);
        appDocStatusMap.put(APPDOC_IN_PROCESS, APPDOC_IN_PROCESS);
        appDocStatusMap.put(APPDOC_CANCELLED_IN_PROCESS, APPDOC_CANCELLED_IN_PROCESS);
        appDocStatusMap.put(APPDOC_CANCELLED_POST_AP_APPROVE, APPDOC_CANCELLED_POST_AP_APPROVE);
        appDocStatusMap.put(APPDOC_DEPARTMENT_APPROVED, APPDOC_DEPARTMENT_APPROVED);
        appDocStatusMap.put(APPDOC_AUTO_APPROVED, APPDOC_AUTO_APPROVED);
        appDocStatusMap.put(APPDOC_AWAITING_ACCOUNTS_PAYABLE_REVIEW, APPDOC_AWAITING_ACCOUNTS_PAYABLE_REVIEW);
        appDocStatusMap.put(APPDOC_AWAITING_RECEIVING_REVIEW, APPDOC_AWAITING_RECEIVING_REVIEW);
        appDocStatusMap.put(APPDOC_AWAITING_SUB_ACCT_MGR_REVIEW, APPDOC_AWAITING_SUB_ACCT_MGR_REVIEW);
        appDocStatusMap.put(APPDOC_AWAITING_FISCAL_REVIEW, APPDOC_AWAITING_FISCAL_REVIEW);
        appDocStatusMap.put(APPDOC_AWAITING_ORG_REVIEW, APPDOC_AWAITING_ORG_REVIEW);
        appDocStatusMap.put(APPDOC_AWAITING_TAX_REVIEW, APPDOC_AWAITING_TAX_REVIEW);
        appDocStatusMap.put(APPDOC_PENDING_E_INVOICE, APPDOC_PENDING_E_INVOICE);
        return appDocStatusMap;
    }

    public static HashMap<String, String> getPaymentRequestAppDocDisapproveStatuses() {
        HashMap<String, String> appDocStatusMap = new HashMap<String, String>();
        appDocStatusMap.put(NODE_ADHOC_REVIEW, APPDOC_CANCELLED_IN_PROCESS);
        appDocStatusMap.put("ImageAttachment", APPDOC_CANCELLED_IN_PROCESS);
        appDocStatusMap.put(NODE_AWAITING_RECEIVING, APPDOC_CANCELLED_POST_AP_APPROVE);
        appDocStatusMap.put(NODE_AWAITING_RECEIVING_REVIEW, APPDOC_CANCELLED_POST_AP_APPROVE);
        appDocStatusMap.put(NODE_SUB_ACCOUNT_REVIEW, APPDOC_CANCELLED_POST_AP_APPROVE);
        appDocStatusMap.put(NODE_ACCOUNT_REVIEW, APPDOC_CANCELLED_POST_AP_APPROVE);
        appDocStatusMap.put(NODE_ORG_REVIEW, APPDOC_CANCELLED_POST_AP_APPROVE);
        appDocStatusMap.put(NODE_VENDOR_TAX_REVIEW, APPDOC_CANCELLED_POST_AP_APPROVE);
        return appDocStatusMap;
    }

    public static List<String> getNodesRequiringCorrectingGeneralLedgerEntries() {
        ArrayList<String> returnList = new ArrayList<String>();
        returnList.add(NODE_ACCOUNT_REVIEW);
        returnList.add(NODE_VENDOR_TAX_REVIEW);
        return returnList;
    }

    static {
        CANCELLED_STATUSES.add(APPDOC_CANCELLED_IN_PROCESS);
        CANCELLED_STATUSES.add(APPDOC_CANCELLED_POST_AP_APPROVE);
        STATUSES_DISALLOWING_HOLD.add(APPDOC_INITIATE);
        STATUSES_DISALLOWING_HOLD.add(APPDOC_IN_PROCESS);
        STATUSES_DISALLOWING_HOLD.addAll(Arrays.asList(CANCELLED_STATUSES.toArray(new String[CANCELLED_STATUSES.size()])));
        STATUSES_DISALLOWING_REMOVE_HOLD.addAll(Arrays.asList(CANCELLED_STATUSES.toArray(new String[CANCELLED_STATUSES.size()])));
        STATUSES_DISALLOWING_REQUEST_CANCEL.add(APPDOC_INITIATE);
        STATUSES_DISALLOWING_REQUEST_CANCEL.add(APPDOC_IN_PROCESS);
        STATUSES_DISALLOWING_REQUEST_CANCEL.add(APPDOC_DEPARTMENT_APPROVED);
        STATUSES_DISALLOWING_REQUEST_CANCEL.add(APPDOC_AUTO_APPROVED);
        STATUSES_DISALLOWING_REQUEST_CANCEL.add(APPDOC_AWAITING_ACCOUNTS_PAYABLE_REVIEW);
        STATUSES_DISALLOWING_REQUEST_CANCEL.addAll(Arrays.asList(CANCELLED_STATUSES.toArray(new String[CANCELLED_STATUSES.size()])));
        STATUSES_DISALLOWING_REMOVE_REQUEST_CANCEL.addAll(Arrays.asList(CANCELLED_STATUSES.toArray(new String[CANCELLED_STATUSES.size()])));
        STATUSES_PREROUTE.add(APPDOC_IN_PROCESS);
        STATUSES_PREROUTE.add(APPDOC_AWAITING_ACCOUNTS_PAYABLE_REVIEW);
        STATUSES_ENROUTE.add(APPDOC_AWAITING_RECEIVING_REVIEW);
        STATUSES_ENROUTE.add(APPDOC_AWAITING_SUB_ACCT_MGR_REVIEW);
        STATUSES_ENROUTE.add(APPDOC_AWAITING_FISCAL_REVIEW);
        STATUSES_ENROUTE.add(APPDOC_AWAITING_ORG_REVIEW);
        STATUSES_ENROUTE.add(APPDOC_AWAITING_TAX_REVIEW);
        STATUSES_POSTROUTE.add(APPDOC_DEPARTMENT_APPROVED);
        STATUSES_POSTROUTE.add(APPDOC_AUTO_APPROVED);
    }

    public static enum STATUS_ORDER {
        CANCELLED_IN_PROCESS("Cancelled In Process", false),
        CANCELLED_POST_AP_APPROVE("Cancelled", false),
        INITIATE("Initiated", true),
        IN_PROCESS("In Process", true),
        AWAITING_ACCOUNTS_PAYABLE_REVIEW("Awaiting AP Review", false),
        AWAITING_RECEIVING_REVIEW("Awaiting Receiving", false),
        AWAITING_SUB_ACCT_MGR_REVIEW("Awaiting Sub-Account Manager Approval", false),
        AWAITING_FISCAL_REVIEW("Awaiting Fiscal Officer Approval", false),
        AWAITING_ORG_REVIEW("Awaiting Chart Approval", false),
        AWAITING_TAX_REVIEW("Awaiting Tax Approval", false),
        DEPARTMENT_APPROVED("Department-Approved", false),
        AUTO_APPROVED("Auto-Approved", false);

        private String statusCode;
        private boolean fullEntryAllowed;

        private STATUS_ORDER(String statusCode, boolean fullEntry) {
            this.statusCode = statusCode;
            this.fullEntryAllowed = fullEntry;
        }

        public static STATUS_ORDER getByStatusCode(String statusCode) {
            for (STATUS_ORDER status : STATUS_ORDER.values()) {
                if (!StringUtils.equals((CharSequence)status.statusCode, (CharSequence)statusCode)) continue;
                return status;
            }
            return null;
        }

        public static boolean isFullDocumentEntryCompleted(String status) {
            if (StringUtils.isNotBlank((CharSequence)status)) {
                return !STATUS_ORDER.getByStatusCode((String)status).fullEntryAllowed;
            }
            return false;
        }

        public static STATUS_ORDER getPreviousStatus(String statusCode) {
            STATUS_ORDER statusOrder = STATUS_ORDER.getByStatusCode(statusCode);
            if (statusOrder.ordinal() > 0) {
                return STATUS_ORDER.values()[statusOrder.ordinal() - 1];
            }
            return null;
        }

        public static boolean isFirstFullEntryStatus(String statusCode) {
            return STATUS_ORDER.getByStatusCode((String)statusCode).fullEntryAllowed && !STATUS_ORDER.getPreviousStatus((String)statusCode).fullEntryAllowed;
        }
    }
}

