/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.kew.api.document.WorkflowDocumentService;
import org.kuali.kfs.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.PurchaseOrderStatuses;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderAccount;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.service.PurapService;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.module.purap.document.service.ReceivingService;
import org.kuali.kfs.module.purap.service.PurapAccountingService;
import org.kuali.kfs.module.purap.service.PurapGeneralLedgerService;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySourceDetail;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.AccountingDocument;

public class PurchaseOrderAmendmentDocument
extends PurchaseOrderDocument {
    boolean newUnorderedItem;
    String receivingDeliveryCampusCode;

    @Override
    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        super.doRouteStatusChange(statusChangeEvent);
        if (this.getFinancialSystemDocumentHeader().getWorkflowDocument().isProcessed()) {
            ((PurapGeneralLedgerService)SpringContext.getBean(PurapGeneralLedgerService.class)).generateEntriesApproveAmendPurchaseOrder(this);
            if (this.getGlOnlySourceAccountingLines() != null && !this.getGlOnlySourceAccountingLines().isEmpty()) {
                ((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).sendFyiForGLEntries(this);
            }
            ((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).completePurchaseOrderAmendment(this);
            ((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).updateVendorCommodityCode(this);
            this.updateAndSaveAppDocStatus("Open");
        } else if (this.getFinancialSystemDocumentHeader().getWorkflowDocument().isDisapproved()) {
            ((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).setCurrentAndPendingIndicatorsForDisapprovedChangePODocuments(this);
            ((PurapService)SpringContext.getBean(PurapService.class)).saveDocumentNoValidation((Document)this);
            String nodeName = ((WorkflowDocumentService)SpringContext.getBean(WorkflowDocumentService.class)).getCurrentRouteLevelName(this.getFinancialSystemDocumentHeader().getWorkflowDocument());
            String reqStatus = PurchaseOrderStatuses.getPurchaseOrderAppDocDisapproveStatuses().get(nodeName);
            this.updateAndSaveAppDocStatus(PurchaseOrderStatuses.getPurchaseOrderAppDocDisapproveStatuses().get(reqStatus));
        } else if (this.getFinancialSystemDocumentHeader().getWorkflowDocument().isCanceled()) {
            ((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).setCurrentAndPendingIndicatorsForCancelledChangePODocuments(this);
            this.updateAndSaveAppDocStatus("Cancelled");
        }
    }

    @Override
    public void customizeExplicitGeneralLedgerPendingEntry(GeneralLedgerPendingEntrySourceDetail postable, GeneralLedgerPendingEntry explicitEntry) {
        super.customizeExplicitGeneralLedgerPendingEntry(postable, explicitEntry);
        ((PurapGeneralLedgerService)SpringContext.getBean(PurapGeneralLedgerService.class)).customizeGeneralLedgerPendingEntry(this, (AccountingLine)postable, explicitEntry, this.getPurapDocumentIdentifier(), "D", "PO", true);
        explicitEntry.setFinancialDocumentTypeCode("POA");
        explicitEntry.setFinancialDocumentApprovedCode("A");
    }

    public List<GeneralLedgerPendingEntrySourceDetail> getGeneralLedgerPendingEntrySourceDetails() {
        ArrayList<GeneralLedgerPendingEntrySourceDetail> accountingLines = new ArrayList<GeneralLedgerPendingEntrySourceDetail>();
        if (this.getGlOnlySourceAccountingLines() != null) {
            for (SourceAccountingLine line : this.getGlOnlySourceAccountingLines()) {
                accountingLines.add((GeneralLedgerPendingEntrySourceDetail)line);
            }
        }
        return accountingLines;
    }

    @Override
    public void populateDocumentForRouting() {
        this.newUnorderedItem = ((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).hasNewUnorderedItem(this);
        this.receivingDeliveryCampusCode = ((ReceivingService)SpringContext.getBean(ReceivingService.class)).getReceivingDeliveryCampusCode(this);
        super.populateDocumentForRouting();
    }

    public boolean isNewUnorderedItem() {
        return this.newUnorderedItem;
    }

    public void setNewUnorderedItem(boolean newUnorderedItem) {
        this.newUnorderedItem = newUnorderedItem;
    }

    public String getReceivingDeliveryCampusCode() {
        return this.receivingDeliveryCampusCode;
    }

    public void setReceivingDeliveryCampusCode(String receivingDeliveryCampusCode) {
        this.receivingDeliveryCampusCode = receivingDeliveryCampusCode;
    }

    @Override
    public boolean answerSplitNodeQuestion(String nodeName) throws UnsupportedOperationException {
        if (nodeName.equals("HasNewUnorderedItems")) {
            return this.isNewUnorderedItem();
        }
        throw new UnsupportedOperationException("Cannot answer split question for this node you call \"" + nodeName + "\"");
    }

    public Class<? extends AccountingDocument> getDocumentClassForAccountingLineValueAllowedValidation() {
        return PurchaseOrderDocument.class;
    }

    @Override
    public void customPrepareForSave(KualiDocumentEvent event) {
        super.customPrepareForSave(event);
        List poItems = this.getItems();
        for (PurchaseOrderItem item : poItems) {
            KualiDecimal outstandingEncumbrance;
            if (!item.isItemActiveIndicator()) continue;
            KualiDecimal invoicedTotalQuantity = item.getItemInvoicedTotalQuantity();
            if (item.getItemInvoicedTotalQuantity() == null) {
                invoicedTotalQuantity = KualiDecimal.ZERO;
                item.setItemInvoicedTotalQuantity(KualiDecimal.ZERO);
            }
            if (item.getItemInvoicedTotalAmount() == null) {
                item.setItemInvoicedTotalAmount(KualiDecimal.ZERO);
            }
            if (item.getItemType().isQuantityBasedGeneralLedgerIndicator()) {
                KualiDecimal itemQuantity = item.getItemQuantity() == null ? KualiDecimal.ZERO : item.getItemQuantity();
                KualiDecimal outstandingEncumberedQuantity = (KualiDecimal)itemQuantity.subtract((AbstractKualiDecimal)invoicedTotalQuantity);
                item.setItemOutstandingEncumberedQuantity(outstandingEncumberedQuantity);
            }
            if (item.getItemType().isAmountBasedGeneralLedgerIndicator()) {
                KualiDecimal totalAmount = item.getTotalAmount() == null ? KualiDecimal.ZERO : item.getTotalAmount();
                outstandingEncumbrance = (KualiDecimal)totalAmount.subtract((AbstractKualiDecimal)item.getItemInvoicedTotalAmount());
                item.setItemOutstandingEncumberedAmount(outstandingEncumbrance);
            } else {
                BigDecimal itemUnitPrice = ObjectUtils.isNull((Object)item.getItemUnitPrice()) ? BigDecimal.ZERO : item.getItemUnitPrice();
                outstandingEncumbrance = new KualiDecimal(item.getItemOutstandingEncumberedQuantity().bigDecimalValue().multiply(itemUnitPrice));
                item.setItemOutstandingEncumberedAmount(outstandingEncumbrance);
            }
            List<PurApAccountingLine> accountLines = item.getSourceAccountingLines();
            Collections.sort(accountLines);
            this.updateEncumbranceOnAccountingLines(outstandingEncumbrance, accountLines);
        }
        List<SourceAccountingLine> sourceLines = ((PurapAccountingService)SpringContext.getBean(PurapAccountingService.class)).generateSummaryWithNoZeroTotals(this.getItems());
        this.setSourceAccountingLines(sourceLines);
    }

    protected void updateEncumbranceOnAccountingLines(KualiDecimal outstandingEncumbrance, List accountLines) {
        for (Object accountLineObject : accountLines) {
            PurchaseOrderAccount accountLine = (PurchaseOrderAccount)accountLineObject;
            if (accountLine.isEmpty()) continue;
            BigDecimal linePercent = accountLine.getAccountLinePercent();
            KualiDecimal accountOutstandingEncumbrance = new KualiDecimal(outstandingEncumbrance.bigDecimalValue().multiply(linePercent).divide(KFSConstants.ONE_HUNDRED.bigDecimalValue()));
            accountLine.setItemAccountOutstandingEncumbranceAmount(accountOutstandingEncumbrance);
        }
    }

    @Override
    protected boolean shouldAdhocFyi() {
        Collection excludeList = new ArrayList();
        if (((ParameterService)SpringContext.getBean(ParameterService.class)).parameterExists(PurchaseOrderDocument.class, "NOTIFY_REQUISITION_SOURCES").booleanValue()) {
            excludeList = ((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValuesAsString(PurchaseOrderDocument.class, "NOTIFY_REQUISITION_SOURCES");
        }
        if (this.getDocumentHeader().getWorkflowDocument().isDisapproved()) {
            return true;
        }
        return this.getDocumentHeader().getWorkflowDocument().isFinal() && !excludeList.contains(this.getRequisitionSourceCode());
    }
}

