/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.authorization;

import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.kew.api.WorkflowDocument;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.PaymentRequestStatuses;
import org.kuali.kfs.module.purap.businessobject.PaymentRequestItem;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.authorization.PurchasingAccountsPayableDocumentPresentationController;
import org.kuali.kfs.module.purap.document.service.PurapService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.FinancialSystemWorkflowHelperService;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;

public class PaymentRequestDocumentPresentationController
extends PurchasingAccountsPayableDocumentPresentationController {
    Boolean canHold;
    Boolean canRequestCancel;
    Boolean canEditPreExtraction;

    public boolean canSave(Document document) {
        PaymentRequestDocument paymentRequestDocument = (PaymentRequestDocument)document;
        if (StringUtils.equals((CharSequence)paymentRequestDocument.getApplicationDocumentStatus(), (CharSequence)"Initiated")) {
            return false;
        }
        if (this.canEditPreExtraction(paymentRequestDocument)) {
            return true;
        }
        return super.canSave(document);
    }

    public boolean canReload(Document document) {
        PaymentRequestDocument paymentRequestDocument = (PaymentRequestDocument)document;
        if (StringUtils.equals((CharSequence)paymentRequestDocument.getApplicationDocumentStatus(), (CharSequence)"Initiated")) {
            return false;
        }
        if (this.canEditPreExtraction(paymentRequestDocument)) {
            return true;
        }
        return super.canReload(document);
    }

    public boolean canCancel(Document document) {
        return false;
    }

    public boolean canApprove(Document document) {
        PaymentRequestDocument paymentRequestDocument = (PaymentRequestDocument)document;
        if (paymentRequestDocument.isPaymentRequestedCancelIndicator() || paymentRequestDocument.isHoldIndicator()) {
            return false;
        }
        return super.canApprove(document);
    }

    public boolean canDisapprove(Document document) {
        return false;
    }

    @Override
    public boolean canEdit(Document document) {
        PaymentRequestDocument paymentRequestDocument = (PaymentRequestDocument)document;
        boolean fullDocEntryCompleted = ((PurapService)SpringContext.getBean(PurapService.class)).isFullDocumentEntryCompleted(paymentRequestDocument);
        if (((FinancialSystemWorkflowHelperService)SpringContext.getBean(FinancialSystemWorkflowHelperService.class)).isAdhocApprovalRequestedForPrincipal(document.getDocumentHeader().getWorkflowDocument(), GlobalVariables.getUserSession().getPrincipalId())) {
            return false;
        }
        if (paymentRequestDocument.isHoldIndicator() || paymentRequestDocument.isPaymentRequestedCancelIndicator()) {
            return false;
        }
        if (fullDocEntryCompleted) {
            return paymentRequestDocument.isDocumentStoppedInRouteNode("Account");
        }
        return true;
    }

    public Set<String> getEditModes(Document document) {
        boolean salesTaxInd;
        Set editModes = super.getEditModes(document);
        PaymentRequestDocument paymentRequestDocument = (PaymentRequestDocument)document;
        if (this.canProcessorCancel(paymentRequestDocument)) {
            editModes.add("processorCancel");
        }
        if (this.canManagerCancel(paymentRequestDocument)) {
            editModes.add("managerCancel");
        }
        if (this.canHold(paymentRequestDocument)) {
            editModes.add("requestPaymentRequestHold");
        }
        if (this.canRequestCancel(paymentRequestDocument)) {
            editModes.add("requestPaymentRequestCancel");
        }
        if (this.canRemoveHold(paymentRequestDocument)) {
            editModes.add("paymentRequestHoldCancelRemoval");
        }
        if (this.canRemoveRequestCancel(paymentRequestDocument)) {
            editModes.add("paymentRequestHoldCancelRemoval");
        }
        if (this.canProcessorInit(paymentRequestDocument)) {
            editModes.add("displayInitTab");
        }
        if (ObjectUtils.isNotNull((Object)paymentRequestDocument.getVendorHeaderGeneratedIdentifier())) {
            editModes.add("lockVendorEntry");
        }
        if (((PurapService)SpringContext.getBean(PurapService.class)).isFullDocumentEntryCompleted(paymentRequestDocument)) {
            editModes.add("fullDocumentEntryCompleted");
        } else if (ObjectUtils.isNotNull((Object)paymentRequestDocument.getPurchaseOrderDocument()) && "Open".equals(paymentRequestDocument.getPurchaseOrderDocument().getApplicationDocumentStatus())) {
            editModes.add("allowClosePurchaseOrder");
        }
        if (this.canEditPreExtraction(paymentRequestDocument)) {
            editModes.add("editPreExtract");
        }
        if (salesTaxInd = ((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsBoolean(KfsParameterConstants.PURCHASING_DOCUMENT.class, "ENABLE_SALES_TAX_IND").booleanValue()) {
            editModes.add("purapTaxEnabled");
            if (paymentRequestDocument.isUseTaxIndicator()) {
                editModes.add("lockTaxAmountEntry");
            } else {
                editModes.add("clearAllTaxes");
            }
        }
        if (paymentRequestDocument.isDocumentStoppedInRouteNode("Tax")) {
            editModes.add("taxAreaEditable");
        }
        if ("Department-Approved".equals(paymentRequestDocument.getApplicationDocumentStatus()) && StringUtils.isNotEmpty((CharSequence)paymentRequestDocument.getTaxClassificationCode())) {
            editModes.add("taxInfoViewable");
        }
        if (paymentRequestDocument.isDocumentStoppedInRouteNode("Account")) {
            editModes.add("restrictFullEntry");
            if (!paymentRequestDocument.isHoldIndicator() && !paymentRequestDocument.isPaymentRequestedCancelIndicator()) {
                for (Object prdItem : paymentRequestDocument.getItems()) {
                    PaymentRequestItem item = (PaymentRequestItem)prdItem;
                    if (!item.getItemType().isLineItemIndicator() || item.getSourceAccountingLines().size() != 0) continue;
                    editModes.add("expenseEntry");
                }
            }
        }
        if (paymentRequestDocument.isExtracted()) {
            editModes.remove("bankEntry");
        }
        this.addACHSignUpInfoMode(document, editModes);
        return editModes;
    }

    protected void addACHSignUpInfoMode(Document document, Set<String> editModes) {
        WorkflowDocument workflowDocument = document.getDocumentHeader().getWorkflowDocument();
        if (!(workflowDocument.isFinal() || workflowDocument.isProcessed() || workflowDocument.isDisapproved())) {
            editModes.add("achAccountInfoDisplayed");
        }
    }

    protected boolean canProcessorInit(PaymentRequestDocument paymentRequestDocument) {
        String status = paymentRequestDocument.getApplicationDocumentStatus();
        return StringUtils.equals((CharSequence)status, (CharSequence)"Initiated");
    }

    protected boolean canProcessorCancel(PaymentRequestDocument paymentRequestDocument) {
        if (this.canProcessorInit(paymentRequestDocument)) {
            return false;
        }
        String docStatus = paymentRequestDocument.getApplicationDocumentStatus();
        boolean requestCancelIndicator = paymentRequestDocument.getPaymentRequestedCancelIndicator();
        boolean holdIndicator = paymentRequestDocument.isHoldIndicator();
        boolean extracted = paymentRequestDocument.isExtracted();
        boolean can = false;
        if (PaymentRequestStatuses.STATUSES_PREROUTE.contains(docStatus)) {
            can = true;
        } else if (PaymentRequestStatuses.STATUSES_ENROUTE.contains(docStatus)) {
            can = requestCancelIndicator;
        } else if (PaymentRequestStatuses.STATUSES_POSTROUTE.contains(docStatus)) {
            can = !requestCancelIndicator && !holdIndicator && !extracted;
        }
        return can;
    }

    protected boolean canManagerCancel(PaymentRequestDocument paymentRequestDocument) {
        if (this.canProcessorInit(paymentRequestDocument)) {
            return false;
        }
        String docStatus = paymentRequestDocument.getApplicationDocumentStatus();
        boolean requestCancelIndicator = paymentRequestDocument.getPaymentRequestedCancelIndicator();
        boolean holdIndicator = paymentRequestDocument.isHoldIndicator();
        boolean extracted = paymentRequestDocument.isExtracted();
        boolean can = false;
        if (PaymentRequestStatuses.STATUSES_PREROUTE.contains(docStatus) || PaymentRequestStatuses.STATUSES_ENROUTE.contains(docStatus)) {
            can = true;
        } else if (PaymentRequestStatuses.STATUSES_POSTROUTE.contains(docStatus)) {
            can = !requestCancelIndicator && !holdIndicator && !extracted;
        }
        return can;
    }

    protected boolean canHold(PaymentRequestDocument paymentRequestDocument) {
        if (this.canHold == null) {
            boolean can;
            boolean bl = can = !paymentRequestDocument.isHoldIndicator() && !paymentRequestDocument.isPaymentRequestedCancelIndicator() && !paymentRequestDocument.isExtracted();
            if (can) {
                can = ((FinancialSystemWorkflowHelperService)SpringContext.getBean(FinancialSystemWorkflowHelperService.class)).isAdhocApprovalRequestedForPrincipal(paymentRequestDocument.getFinancialSystemDocumentHeader().getWorkflowDocument(), GlobalVariables.getUserSession().getPrincipalId());
                can = can || !PaymentRequestStatuses.STATUSES_DISALLOWING_HOLD.contains(paymentRequestDocument.getApplicationDocumentStatus());
            }
            this.canHold = can;
        }
        return this.canHold;
    }

    protected boolean canRequestCancel(PaymentRequestDocument paymentRequestDocument) {
        if (this.canRequestCancel == null) {
            boolean can;
            boolean bl = can = !paymentRequestDocument.isPaymentRequestedCancelIndicator() && !paymentRequestDocument.isHoldIndicator() && !paymentRequestDocument.isExtracted();
            if (can) {
                can = ((FinancialSystemWorkflowHelperService)SpringContext.getBean(FinancialSystemWorkflowHelperService.class)).isAdhocApprovalRequestedForPrincipal(paymentRequestDocument.getFinancialSystemDocumentHeader().getWorkflowDocument(), GlobalVariables.getUserSession().getPrincipalId());
                can = can || !PaymentRequestStatuses.STATUSES_DISALLOWING_REQUEST_CANCEL.contains(paymentRequestDocument.getApplicationDocumentStatus());
            }
            this.canRequestCancel = can;
        }
        return this.canRequestCancel;
    }

    protected boolean canRemoveHold(PaymentRequestDocument paymentRequestDocument) {
        return paymentRequestDocument.isHoldIndicator();
    }

    protected boolean canRemoveRequestCancel(PaymentRequestDocument paymentRequestDocument) {
        return paymentRequestDocument.isPaymentRequestedCancelIndicator();
    }

    protected boolean canEditPreExtraction(PaymentRequestDocument paymentRequestDocument) {
        if (this.canEditPreExtraction == null) {
            this.canEditPreExtraction = !paymentRequestDocument.isExtracted() && !((FinancialSystemWorkflowHelperService)SpringContext.getBean(FinancialSystemWorkflowHelperService.class)).isAdhocApprovalRequestedForPrincipal(paymentRequestDocument.getFinancialSystemDocumentHeader().getWorkflowDocument(), GlobalVariables.getUserSession().getPrincipalId()) && !PaymentRequestStatuses.CANCELLED_STATUSES.contains(paymentRequestDocument.getApplicationDocumentStatus());
        }
        return this.canEditPreExtraction;
    }
}

