/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.fp.businessobject.NonresidentTaxPercent;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.MessageMap;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class PaymentRequestTaxAreaValidation
extends GenericValidation {
    private BusinessObjectService businessObjectService;

    public boolean validate(AttributedDocumentEvent event) {
        PaymentRequestDocument preq = (PaymentRequestDocument)event.getDocument();
        if (!StringUtils.equals((CharSequence)preq.getApplicationDocumentStatus(), (CharSequence)"Awaiting Tax Approval")) {
            return true;
        }
        MessageMap errorMap = GlobalVariables.getMessageMap();
        errorMap.clearErrorPath();
        errorMap.addToErrorPath("document.tax*");
        boolean valid = this.validateTaxIncomeClass(preq);
        valid &= this.validateTaxRates(preq);
        errorMap.clearErrorPath();
        return valid &= this.validateTaxIndicators(preq);
    }

    protected boolean validateTaxIncomeClass(PaymentRequestDocument preq) {
        boolean valid = true;
        MessageMap errorMap = GlobalVariables.getMessageMap();
        if (StringUtils.isEmpty((CharSequence)preq.getTaxClassificationCode())) {
            valid = false;
            errorMap.putError("taxClassificationCode", "errors.paymentRequest.tax.field.required", new String[]{"taxClassificationCode"});
        } else if (StringUtils.equalsIgnoreCase((CharSequence)preq.getTaxClassificationCode(), (CharSequence)"N")) {
            if (preq.getTaxFederalPercent() != null && preq.getTaxFederalPercent().compareTo(new BigDecimal(0)) != 0) {
                valid = false;
                errorMap.putError("taxFederalPercent", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxClassificationCode", "taxFederalPercent"});
            }
            if (preq.getTaxStatePercent() != null && preq.getTaxStatePercent().compareTo(new BigDecimal(0)) != 0) {
                valid = false;
                errorMap.putError("taxStatePercent", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxClassificationCode", "taxStatePercent"});
            }
            if (StringUtils.isNotEmpty((CharSequence)preq.getTaxCountryCode())) {
                valid = false;
                errorMap.putError("taxCountryCode", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxClassificationCode", "taxCountryCode"});
            }
            if (StringUtils.isNotEmpty((CharSequence)preq.getTaxNQIId())) {
                valid = false;
                errorMap.putError("taxNQIId", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxClassificationCode", "taxNQIId"});
            }
            if (preq.getTaxSpecialW4Amount() != null && preq.getTaxSpecialW4Amount().compareTo((AbstractKualiDecimal)new KualiDecimal(0)) != 0) {
                valid = false;
                errorMap.putError("taxSpecialW4Amount", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxClassificationCode", "taxSpecialW4Amount"});
            }
            if (Objects.equals(preq.getTaxExemptTreatyIndicator(), true)) {
                valid = false;
                errorMap.putError("taxExemptTreatyIndicator", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxClassificationCode", "taxExemptTreatyIndicator"});
            }
            if (Objects.equals(preq.getTaxGrossUpIndicator(), true)) {
                valid = false;
                errorMap.putError("taxGrossUpIndicator", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxClassificationCode", "taxGrossUpIndicator"});
            }
            if (Objects.equals(preq.getTaxForeignSourceIndicator(), true)) {
                valid = false;
                errorMap.putError("taxForeignSourceIndicator", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxClassificationCode", "taxForeignSourceIndicator"});
            }
            if (Objects.equals(preq.getTaxUSAIDPerDiemIndicator(), true)) {
                valid = false;
                errorMap.putError("taxUSAIDPerDiemIndicator", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxClassificationCode", "taxUSAIDPerDiemIndicator"});
            }
            if (Objects.equals(preq.getTaxOtherExemptIndicator(), true)) {
                valid = false;
                errorMap.putError("taxOtherExemptIndicator", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxClassificationCode", "taxOtherExemptIndicator"});
            }
        } else {
            if (preq.getTaxFederalPercent() == null) {
                valid = false;
                errorMap.putError("taxFederalPercent", "errors.paymentRequest.tax.field.required.if", new String[]{"taxClassificationCode", "taxFederalPercent"});
            }
            if (preq.getTaxStatePercent() == null) {
                valid = false;
                errorMap.putError("taxStatePercent", "errors.paymentRequest.tax.field.required.if", new String[]{"taxClassificationCode", "taxStatePercent"});
            }
            if (StringUtils.isEmpty((CharSequence)preq.getTaxCountryCode())) {
                valid = false;
                errorMap.putError("taxCountryCode", "errors.paymentRequest.tax.field.required.if", new String[]{"taxClassificationCode", "taxCountryCode"});
            }
        }
        return valid;
    }

    protected boolean validateTaxRates(PaymentRequestDocument preq) {
        boolean hasStRate;
        ArrayList<BigDecimal> stRates;
        boolean valid = true;
        String code = preq.getTaxClassificationCode();
        BigDecimal fedRate = preq.getTaxFederalPercent();
        BigDecimal stRate = preq.getTaxStatePercent();
        MessageMap errorMap = GlobalVariables.getMessageMap();
        if (StringUtils.isEmpty((CharSequence)code) || StringUtils.equalsIgnoreCase((CharSequence)code, (CharSequence)"N") || fedRate == null || stRate == null) {
            return true;
        }
        ArrayList<BigDecimal> fedRates = this.retrieveTaxRates(code, "F");
        if (!this.listContainsValue(fedRates, fedRate)) {
            valid = false;
            errorMap.putError("taxFederalPercent", "errors.paymentRequest.tax.field.value.invalid.if", new String[]{"taxClassificationCode", "taxFederalPercent"});
        }
        if (!this.listContainsValue(stRates = this.retrieveTaxRates(code, "S"), stRate)) {
            valid = false;
            errorMap.putError("taxStatePercent", "errors.paymentRequest.tax.field.value.invalid.if", new String[]{"taxClassificationCode", "taxStatePercent"});
        }
        if (fedRate.compareTo(new BigDecimal(0)) == 0 && stRate.compareTo(new BigDecimal(0)) != 0) {
            valid = false;
            errorMap.putError("taxStatePercent", "errors.paymentRequest.tax.rate.must.zero.if", new String[]{"taxFederalPercent", "taxStatePercent"});
        }
        boolean bl = hasStRate = "F".equalsIgnoreCase(code) || "A".equalsIgnoreCase(code) || "O".equalsIgnoreCase(code);
        if (fedRate.compareTo(new BigDecimal(0)) > 0 && stRate.compareTo(new BigDecimal(0)) <= 0 && hasStRate) {
            valid = false;
            errorMap.putError("taxStatePercent", "errors.paymentRequest.tax.rate.must.not.zero.if", new String[]{"taxFederalPercent", "taxStatePercent"});
        }
        return valid;
    }

    protected boolean validateTaxIndicators(PaymentRequestDocument preq) {
        boolean valid = true;
        MessageMap errorMap = GlobalVariables.getMessageMap();
        if (Objects.equals(preq.getTaxExemptTreatyIndicator(), true)) {
            if (Objects.equals(preq.getTaxGrossUpIndicator(), true)) {
                valid = false;
                errorMap.putError("taxGrossUpIndicator", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxExemptTreatyIndicator", "taxGrossUpIndicator"});
            }
            if (Objects.equals(preq.getTaxForeignSourceIndicator(), true)) {
                valid = false;
                errorMap.putError("taxForeignSourceIndicator", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxExemptTreatyIndicator", "taxForeignSourceIndicator"});
            }
            if (Objects.equals(preq.getTaxUSAIDPerDiemIndicator(), true)) {
                valid = false;
                errorMap.putError("taxUSAIDPerDiemIndicator", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxExemptTreatyIndicator", "taxUSAIDPerDiemIndicator"});
            }
            if (Objects.equals(preq.getTaxOtherExemptIndicator(), true)) {
                valid = false;
                errorMap.putError("taxOtherExemptIndicator", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxExemptTreatyIndicator", "taxOtherExemptIndicator"});
            }
            if (preq.getTaxSpecialW4Amount() != null && preq.getTaxSpecialW4Amount().compareTo((AbstractKualiDecimal)new KualiDecimal(0)) != 0) {
                valid = false;
                errorMap.putError("taxSpecialW4Amount", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxExemptTreatyIndicator", "taxSpecialW4Amount"});
            }
            if (preq.getTaxFederalPercent() != null && preq.getTaxFederalPercent().compareTo(new BigDecimal(0)) != 0) {
                valid = false;
                errorMap.putError("taxFederalPercent", "errors.paymentRequest.tax.rate.must.zero.if", new String[]{"taxExemptTreatyIndicator", "taxFederalPercent"});
            }
            if (preq.getTaxStatePercent() != null && preq.getTaxStatePercent().compareTo(new BigDecimal(0)) != 0) {
                valid = false;
                errorMap.putError("taxStatePercent", "errors.paymentRequest.tax.rate.must.zero.if", new String[]{"taxExemptTreatyIndicator", "taxStatePercent"});
            }
        }
        if (Objects.equals(preq.getTaxGrossUpIndicator(), true)) {
            if (Objects.equals(preq.getTaxExemptTreatyIndicator(), true)) {
                valid = false;
                errorMap.putError("taxExemptTreatyIndicator", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxGrossUpIndicator", "taxExemptTreatyIndicator"});
            }
            if (Objects.equals(preq.getTaxForeignSourceIndicator(), true)) {
                valid = false;
                errorMap.putError("taxForeignSourceIndicator", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxGrossUpIndicator", "taxForeignSourceIndicator"});
            }
            if (Objects.equals(preq.getTaxUSAIDPerDiemIndicator(), true)) {
                valid = false;
                errorMap.putError("taxUSAIDPerDiemIndicator", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxGrossUpIndicator", "taxUSAIDPerDiemIndicator"});
            }
            if (Objects.equals(preq.getTaxOtherExemptIndicator(), true)) {
                valid = false;
                errorMap.putError("taxOtherExemptIndicator", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxGrossUpIndicator", "taxOtherExemptIndicator"});
            }
            if (preq.getTaxSpecialW4Amount() != null && preq.getTaxSpecialW4Amount().compareTo((AbstractKualiDecimal)new KualiDecimal(0)) != 0) {
                valid = false;
                errorMap.putError("taxSpecialW4Amount", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxGrossUpIndicator", "taxSpecialW4Amount"});
            }
            if (preq.getTaxFederalPercent() == null || preq.getTaxFederalPercent().compareTo(new BigDecimal(0)) == 0) {
                valid = false;
                errorMap.putError("taxFederalPercent", "errors.paymentRequest.tax.rate.must.not.zero.if", new String[]{"taxGrossUpIndicator", "taxFederalPercent"});
            }
        }
        if (Objects.equals(preq.getTaxForeignSourceIndicator(), true)) {
            if (Objects.equals(preq.getTaxExemptTreatyIndicator(), true)) {
                valid = false;
                errorMap.putError("taxExemptTreatyIndicator", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxForeignSourceIndicator", "taxExemptTreatyIndicator"});
            }
            if (Objects.equals(preq.getTaxGrossUpIndicator(), true)) {
                valid = false;
                errorMap.putError("taxGrossUpIndicator", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxForeignSourceIndicator", "taxGrossUpIndicator"});
            }
            if (Objects.equals(preq.getTaxUSAIDPerDiemIndicator(), true)) {
                valid = false;
                errorMap.putError("taxUSAIDPerDiemIndicator", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxForeignSourceIndicator", "taxUSAIDPerDiemIndicator"});
            }
            if (Objects.equals(preq.getTaxOtherExemptIndicator(), true)) {
                valid = false;
                errorMap.putError("taxOtherExemptIndicator", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxForeignSourceIndicator", "taxOtherExemptIndicator"});
            }
            if (preq.getTaxSpecialW4Amount() != null && preq.getTaxSpecialW4Amount().compareTo((AbstractKualiDecimal)new KualiDecimal(0)) != 0) {
                valid = false;
                errorMap.putError("taxSpecialW4Amount", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxForeignSourceIndicator", "taxSpecialW4Amount"});
            }
            if (preq.getTaxFederalPercent() != null && preq.getTaxFederalPercent().compareTo(new BigDecimal(0)) != 0) {
                valid = false;
                errorMap.putError("taxFederalPercent", "errors.paymentRequest.tax.rate.must.zero.if", new String[]{"taxForeignSourceIndicator", "taxFederalPercent"});
            }
            if (preq.getTaxStatePercent() != null && preq.getTaxStatePercent().compareTo(new BigDecimal(0)) != 0) {
                valid = false;
                errorMap.putError("taxStatePercent", "errors.paymentRequest.tax.rate.must.zero.if", new String[]{"taxForeignSourceIndicator", "taxStatePercent"});
            }
        }
        if (Objects.equals(preq.getTaxUSAIDPerDiemIndicator(), true)) {
            if (Objects.equals(preq.getTaxExemptTreatyIndicator(), true)) {
                valid = false;
                errorMap.putError("taxExemptTreatyIndicator", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxUSAIDPerDiemIndicator", "taxExemptTreatyIndicator"});
            }
            if (Objects.equals(preq.getTaxGrossUpIndicator(), true)) {
                valid = false;
                errorMap.putError("taxGrossUpIndicator", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxUSAIDPerDiemIndicator", "taxGrossUpIndicator"});
            }
            if (Objects.equals(preq.getTaxForeignSourceIndicator(), true)) {
                valid = false;
                errorMap.putError("taxForeignSourceIndicator", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxUSAIDPerDiemIndicator", "taxForeignSourceIndicator"});
            }
            if (!Objects.equals(preq.getTaxOtherExemptIndicator(), true)) {
                valid = false;
                errorMap.putError("taxOtherExemptIndicator", "errors.paymentRequest.tax.field.required.if", new String[]{"taxUSAIDPerDiemIndicator", "taxOtherExemptIndicator"});
            }
            if (preq.getTaxSpecialW4Amount() != null && preq.getTaxSpecialW4Amount().compareTo((AbstractKualiDecimal)new KualiDecimal(0)) != 0) {
                valid = false;
                errorMap.putError("taxSpecialW4Amount", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxUSAIDPerDiemIndicator", "taxSpecialW4Amount"});
            }
            if (StringUtils.isEmpty((CharSequence)preq.getTaxClassificationCode()) || !StringUtils.equalsIgnoreCase((CharSequence)preq.getTaxClassificationCode(), (CharSequence)"F")) {
                valid = false;
                errorMap.putError("taxClassificationCode", "errors.paymentRequest.tax.field.value.invalid.if", new String[]{"taxUSAIDPerDiemIndicator", "taxClassificationCode"});
            }
            if (preq.getTaxFederalPercent() != null && preq.getTaxFederalPercent().compareTo(new BigDecimal(0)) != 0) {
                valid = false;
                errorMap.putError("taxFederalPercent", "errors.paymentRequest.tax.rate.must.zero.if", new String[]{"taxUSAIDPerDiemIndicator", "taxFederalPercent"});
            }
            if (preq.getTaxStatePercent() != null && preq.getTaxStatePercent().compareTo(new BigDecimal(0)) != 0) {
                valid = false;
                errorMap.putError("taxStatePercent", "errors.paymentRequest.tax.rate.must.zero.if", new String[]{"taxUSAIDPerDiemIndicator", "taxStatePercent"});
            }
        }
        if (Objects.equals(preq.getTaxOtherExemptIndicator(), true)) {
            if (Objects.equals(preq.getTaxExemptTreatyIndicator(), true)) {
                valid = false;
                errorMap.putError("taxExemptTreatyIndicator", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxOtherExemptIndicator", "taxExemptTreatyIndicator"});
            }
            if (Objects.equals(preq.getTaxGrossUpIndicator(), true)) {
                valid = false;
                errorMap.putError("taxGrossUpIndicator", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxOtherExemptIndicator", "taxGrossUpIndicator"});
            }
            if (Objects.equals(preq.getTaxForeignSourceIndicator(), true)) {
                valid = false;
                errorMap.putError("taxForeignSourceIndicator", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxOtherExemptIndicator", "taxForeignSourceIndicator"});
            }
            if (preq.getTaxFederalPercent() != null && preq.getTaxFederalPercent().compareTo(new BigDecimal(0)) != 0) {
                valid = false;
                errorMap.putError("taxFederalPercent", "errors.paymentRequest.tax.rate.must.zero.if", new String[]{"taxOtherExemptIndicator", "taxFederalPercent"});
            }
            if (preq.getTaxStatePercent() != null && preq.getTaxStatePercent().compareTo(new BigDecimal(0)) != 0) {
                valid = false;
                errorMap.putError("taxStatePercent", "errors.paymentRequest.tax.rate.must.zero.if", new String[]{"taxOtherExemptIndicator", "taxStatePercent"});
            }
        }
        if (preq.getTaxSpecialW4Amount() != null && preq.getTaxSpecialW4Amount().compareTo((AbstractKualiDecimal)new KualiDecimal(0)) != 0) {
            if (Objects.equals(preq.getTaxExemptTreatyIndicator(), true)) {
                valid = false;
                errorMap.putError("taxExemptTreatyIndicator", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxSpecialW4Amount", "taxExemptTreatyIndicator"});
            }
            if (Objects.equals(preq.getTaxGrossUpIndicator(), true)) {
                valid = false;
                errorMap.putError("taxGrossUpIndicator", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxSpecialW4Amount", "taxGrossUpIndicator"});
            }
            if (Objects.equals(preq.getTaxForeignSourceIndicator(), true)) {
                valid = false;
                errorMap.putError("taxForeignSourceIndicator", "errors.paymentRequest.tax.field.disallowed.if", new String[]{"taxSpecialW4Amount", "taxForeignSourceIndicator"});
            }
            if (Objects.equals(preq.getTaxOtherExemptIndicator(), false)) {
                valid = false;
                errorMap.putError("taxOtherExemptIndicator", "errors.paymentRequest.tax.exempt.under.other.code.must.be.checked", new String[]{"taxSpecialW4Amount", "taxOtherExemptIndicator"});
            }
            if (preq.getTaxSpecialW4Amount().compareTo((AbstractKualiDecimal)new KualiDecimal(0)) < 0) {
                valid = false;
                errorMap.putError("taxSpecialW4Amount", "errors.paymentRequest.tax.field.value.must.not.negative", new String[]{"taxSpecialW4Amount"});
            }
            if (StringUtils.isEmpty((CharSequence)preq.getTaxClassificationCode()) || !StringUtils.equalsIgnoreCase((CharSequence)preq.getTaxClassificationCode(), (CharSequence)"F")) {
                valid = false;
                errorMap.putError("taxClassificationCode", "errors.paymentRequest.tax.field.value.invalid.if", new String[]{"taxSpecialW4Amount", "taxClassificationCode"});
            }
            if (preq.getTaxFederalPercent() != null && preq.getTaxFederalPercent().compareTo(new BigDecimal(0)) != 0) {
                valid = false;
                errorMap.putError("taxFederalPercent", "errors.paymentRequest.tax.rate.must.zero.if", new String[]{"taxSpecialW4Amount", "taxFederalPercent"});
            }
            if (preq.getTaxStatePercent() != null && preq.getTaxStatePercent().compareTo(new BigDecimal(0)) != 0) {
                valid = false;
                errorMap.putError("taxStatePercent", "errors.paymentRequest.tax.rate.must.zero.if", new String[]{"taxSpecialW4Amount", "taxStatePercent"});
            }
        }
        return valid;
    }

    public ArrayList<BigDecimal> retrieveTaxRates(String incomeClassCode, String incomeTaxTypeCode) {
        ArrayList<BigDecimal> rates = new ArrayList<BigDecimal>();
        HashMap<String, String> criterion = new HashMap<String, String>();
        criterion.put("incomeClassCode", incomeClassCode);
        criterion.put("incomeTaxTypeCode", incomeTaxTypeCode);
        criterion.put("active", "Y");
        List percents = (List)this.businessObjectService.findMatching(NonresidentTaxPercent.class, criterion);
        for (NonresidentTaxPercent percent : percents) {
            rates.add(percent.getIncomeTaxPercent());
        }
        return rates;
    }

    protected boolean listContainsValue(ArrayList<BigDecimal> list, BigDecimal value) {
        if (list == null || value == null) {
            return false;
        }
        for (BigDecimal val : list) {
            if (val.compareTo(value) != 0) continue;
            return true;
        }
        return false;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

