/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2021 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/*
 * Created on Feb 28, 2006
 *
 */
package org.kuali.kfs.module.purap.businessobject;

import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.core.api.util.type.KualiDecimal;

import java.sql.Timestamp;

public class ElectronicInvoiceLoadSummary extends PersistableBusinessObjectBase {

    private Integer invoiceLoadSummaryIdentifier;
    // this is string constant if DUNS not found
    private String vendorDunsNumber;
    private Integer vendorHeaderGeneratedIdentifier;
    private Integer vendorDetailAssignedIdentifier;
    private String vendorName;
    private Integer invoiceLoadSuccessCount = 0;
    private KualiDecimal invoiceLoadSuccessAmount = new KualiDecimal(0.00);
    private Integer invoiceLoadFailCount = 0;
    private KualiDecimal invoiceLoadFailAmount = new KualiDecimal(0.00);
    private Boolean isEmpty = Boolean.TRUE;
    private Timestamp fileProcessTimestamp;

    public ElectronicInvoiceLoadSummary() {
        super();
    }

    public ElectronicInvoiceLoadSummary(String vendorDunsNumber) {
        super();
        this.vendorDunsNumber = vendorDunsNumber;
    }

    public void addSuccessfulInvoiceOrder(KualiDecimal amount, ElectronicInvoice eInvoice) {
        isEmpty = Boolean.FALSE;
        invoiceLoadSuccessCount = invoiceLoadSuccessCount + 1;
        fileProcessTimestamp = SpringContext.getBean(DateTimeService.class).getCurrentTimestamp();

        if (amount != null) {
            invoiceLoadSuccessAmount = invoiceLoadSuccessAmount.add(amount);
        }

        setupVendorInformation(eInvoice);
    }

    public void addFailedInvoiceOrder(KualiDecimal amount, ElectronicInvoice eInvoice) {
        isEmpty = Boolean.FALSE;
        invoiceLoadFailCount = invoiceLoadFailCount + 1;
        fileProcessTimestamp = SpringContext.getBean(DateTimeService.class).getCurrentTimestamp();

        if (amount != null) {
            invoiceLoadFailAmount = invoiceLoadFailAmount.add(amount);
        }

        setupVendorInformation(eInvoice);
    }

    public void addFailedInvoiceOrder(ElectronicInvoice ei) {
        this.addFailedInvoiceOrder(new KualiDecimal(0), ei);
    }

    public void addFailedInvoiceOrder() {
        this.addFailedInvoiceOrder(new KualiDecimal(0), null);
    }

    private void setupVendorInformation(ElectronicInvoice eInvoice) {
        if (eInvoice != null && getVendorHeaderGeneratedIdentifier() == null
                && getVendorDetailAssignedIdentifier() == null) {
            setVendorHeaderGeneratedIdentifier(eInvoice.getVendorHeaderID());
            setVendorDetailAssignedIdentifier(eInvoice.getVendorDetailID());
            setVendorName(eInvoice.getVendorName());
        }
    }

    public String getVendorDescriptor() {
        String kualiDescriptor = null;
        if (this.vendorName != null && this.vendorHeaderGeneratedIdentifier != null
                && this.vendorDetailAssignedIdentifier != null) {
            kualiDescriptor = "  (Kuali Match:  " + this.vendorName + "  ~  " + vendorHeaderGeneratedIdentifier +
                    "-" + vendorDetailAssignedIdentifier + ")";
        } else if (this.vendorHeaderGeneratedIdentifier != null && this.vendorDetailAssignedIdentifier != null) {
            kualiDescriptor = "  (Kuali Match:  " + vendorHeaderGeneratedIdentifier + "-" +
                    vendorDetailAssignedIdentifier + ")";
        } else if (this.vendorName != null) {
            kualiDescriptor = "  (Kuali Match:  " + this.vendorName + ")";
        }
        return this.getVendorDunsNumber() + (kualiDescriptor != null ? kualiDescriptor : "");
    }

    public Integer getVendorDetailAssignedIdentifier() {
        return vendorDetailAssignedIdentifier;
    }

    public void setVendorDetailAssignedIdentifier(Integer kualiVendorDetailId) {
        this.vendorDetailAssignedIdentifier = kualiVendorDetailId;
    }

    public Integer getVendorHeaderGeneratedIdentifier() {
        return vendorHeaderGeneratedIdentifier;
    }

    public void setVendorHeaderGeneratedIdentifier(Integer kualiVendorHeaderId) {
        this.vendorHeaderGeneratedIdentifier = kualiVendorHeaderId;
    }

    public String getVendorName() {
        return vendorName;
    }

    public void setVendorName(String kualiVendorName) {
        this.vendorName = kualiVendorName;
    }

    public KualiDecimal getInvoiceLoadFailAmount() {
        return invoiceLoadFailAmount;
    }

    public void setInvoiceLoadFailAmount(KualiDecimal failAmount) {
        this.invoiceLoadFailAmount = failAmount;
    }

    public Integer getInvoiceLoadFailCount() {
        return invoiceLoadFailCount;
    }

    public void setInvoiceLoadFailCount(Integer failCount) {
        this.invoiceLoadFailCount = failCount;
    }

    public Integer getInvoiceLoadSummaryIdentifier() {
        return invoiceLoadSummaryIdentifier;
    }

    public void setInvoiceLoadSummaryIdentifier(Integer id) {
        this.invoiceLoadSummaryIdentifier = id;
    }

    public Boolean isEmpty() {
        return isEmpty;
    }

    public void setIsEmpty(Boolean isEmpty) {
        this.isEmpty = isEmpty;
    }

    public KualiDecimal getInvoiceLoadSuccessAmount() {
        return invoiceLoadSuccessAmount;
    }

    public void setInvoiceLoadSuccessAmount(KualiDecimal successAmount) {
        this.invoiceLoadSuccessAmount = successAmount;
    }

    public Integer getInvoiceLoadSuccessCount() {
        return invoiceLoadSuccessCount;
    }

    public void setInvoiceLoadSuccessCount(Integer successCount) {
        this.invoiceLoadSuccessCount = successCount;
    }

    public String getVendorDunsNumber() {
        return vendorDunsNumber;
    }

    public void setVendorDunsNumber(String vendorDunsNumber) {
        this.vendorDunsNumber = vendorDunsNumber;
    }

    public Timestamp getFileProcessTimestamp() {
        return fileProcessTimestamp;
    }

    public void setFileProcessTimestamp(Timestamp fileProcessTimestamp) {
        this.fileProcessTimestamp = fileProcessTimestamp;
    }

}
