/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2021 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.purap.businessobject;

import org.kuali.kfs.sys.businessobject.UnitOfMeasure;
import org.kuali.kfs.core.api.util.type.KualiDecimal;

public interface ReceivingItem {

    Integer getReceivingItemIdentifier();

    void setReceivingItemIdentifier(Integer receivingItemIdentifier);

    String getDocumentNumber();

    void setDocumentNumber(String documentNumber);

    Integer getPurchaseOrderIdentifier();

    void setPurchaseOrderIdentifier(Integer purchaseOrderIdentifier);

    Integer getItemLineNumber();

    void setItemLineNumber(Integer itemLineNumber);

    String getItemTypeCode();

    void setItemTypeCode(String itemTypeCode);

    String getItemUnitOfMeasureCode();

    void setItemUnitOfMeasureCode(String itemUnitOfMeasureCode);

    String getItemCatalogNumber();

    void setItemCatalogNumber(String itemCatalogNumber);

    String getItemDescription();

    void setItemDescription(String itemDescription);

    KualiDecimal getItemReceivedTotalQuantity();

    void setItemReceivedTotalQuantity(KualiDecimal itemReceivedTotalQuantity);

    KualiDecimal getItemReturnedTotalQuantity();

    void setItemReturnedTotalQuantity(KualiDecimal itemReturnedTotalQuantity);

    KualiDecimal getItemDamagedTotalQuantity();

    void setItemDamagedTotalQuantity(KualiDecimal itemDamagedTotalQuantity);

    String getItemReasonAddedCode();

    void setItemReasonAddedCode(String itemReasonAddedCode);

    ItemType getItemType();

    /**
     * @deprecated
     */
    void setItemType(ItemType itemType);

    UnitOfMeasure getItemUnitOfMeasure();

    /**
     * @deprecated
     */
    void setItemUnitOfMeasure(UnitOfMeasure itemUnitOfMeasure);

    KualiDecimal getItemOriginalReceivedTotalQuantity();

    void setItemOriginalReceivedTotalQuantity(KualiDecimal itemOriginalReceivedTotalQuantity);

    KualiDecimal getItemOriginalReturnedTotalQuantity();

    void setItemOriginalReturnedTotalQuantity(KualiDecimal itemOriginalReturnedTotalQuantity);

    KualiDecimal getItemOriginalDamagedTotalQuantity();

    void setItemOriginalDamagedTotalQuantity(KualiDecimal itemOriginalDamagedTotalQuantity);

}
