/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2021 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.purap.businessobject;

import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.core.api.mo.common.active.MutableInactivatable;

public class VendorStipulation extends PersistableBusinessObjectBase implements MutableInactivatable {

    private Integer vendorStipulationIdentifier;
    private String vendorStipulationName;
    private String vendorStipulationDescription;
    private boolean active;

    public VendorStipulation() {

    }

    public Integer getVendorStipulationIdentifier() {
        return vendorStipulationIdentifier;
    }

    public void setVendorStipulationIdentifier(Integer vendorStipulationIdentifier) {
        this.vendorStipulationIdentifier = vendorStipulationIdentifier;
    }

    public String getVendorStipulationName() {
        return vendorStipulationName;
    }

    public void setVendorStipulationName(String vendorStipulationName) {
        this.vendorStipulationName = vendorStipulationName;
    }

    public String getVendorStipulationDescription() {
        return vendorStipulationDescription;
    }

    public void setVendorStipulationDescription(String vendorStipulationDescription) {
        this.vendorStipulationDescription = vendorStipulationDescription;
    }

    public boolean isActive() {
        return active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

}
