/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.batch.service.impl;

import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.coreservice.impl.parameter.Parameter;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.KualiRuleService;
import org.kuali.kfs.krad.service.NoteService;
import org.kuali.kfs.module.purap.PurapConstants;
import org.kuali.kfs.module.purap.batch.AutoCloseRecurringOrdersStep;
import org.kuali.kfs.module.purap.batch.service.AutoClosePurchaseOrderService;
import org.kuali.kfs.module.purap.businessobject.AutoClosePurchaseOrderView;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.dataaccess.PurchaseOrderDao;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.kuali.kfs.sys.document.service.FinancialSystemDocumentService;
import org.kuali.kfs.sys.document.validation.event.AttributedRouteDocumentEvent;
import org.kuali.kfs.sys.mail.BodyMailMessage;
import org.kuali.kfs.sys.mail.MailMessage;
import org.kuali.kfs.sys.service.EmailService;
import org.springframework.transaction.annotation.Transactional;

public class AutoClosePurchaseOrderServiceImpl
implements AutoClosePurchaseOrderService {
    private static final Logger LOG = LogManager.getLogger();
    protected PurchaseOrderService purchaseOrderService;
    protected ParameterService parameterService;
    protected DateTimeService dateTimeService;
    protected PurchaseOrderDao purchaseOrderDao;
    protected KualiRuleService kualiRuleService;
    protected FinancialSystemDocumentService financialSystemDocumentService;
    protected DocumentService documentService;
    protected NoteService noteService;
    protected EmailService emailService;

    @Override
    public boolean autoCloseFullyDisencumberedOrders() {
        LOG.debug("autoCloseFullyDisencumberedOrders() started");
        List<AutoClosePurchaseOrderView> autoCloseList = this.getAllOpenPurchaseOrdersForAutoClose();
        for (AutoClosePurchaseOrderView poAutoClose : autoCloseList) {
            this.autoClosePurchaseOrder(poAutoClose);
        }
        LOG.debug("autoCloseFullyDisencumberedOrders() ended");
        return true;
    }

    @Override
    @Transactional
    public void autoClosePurchaseOrder(AutoClosePurchaseOrderView poAutoClose) {
        if (poAutoClose.getTotalAmount() != null && KualiDecimal.ZERO.compareTo((AbstractKualiDecimal)poAutoClose.getTotalAmount()) != 0) {
            LOG.info("autoCloseFullyDisencumberedOrders() PO ID " + poAutoClose.getPurapDocumentIdentifier() + " with total " + poAutoClose.getTotalAmount().doubleValue() + " will be closed");
            String newStatus = "Pending Close";
            String annotation = "This PO was automatically closed in batch.";
            String documentType = "POC";
            PurchaseOrderDocument document = this.getPurchaseOrderService().getPurchaseOrderByDocumentNumber(poAutoClose.getDocumentNumber());
            this.createNoteForAutoCloseOrders(document, annotation);
            this.getPurchaseOrderService().createAndRoutePotentialChangeDocument(poAutoClose.getDocumentNumber(), documentType, annotation, null, newStatus);
        }
    }

    @Override
    @Transactional
    public boolean autoCloseRecurringOrders() {
        LOG.debug("autoCloseRecurringOrders() started");
        boolean shouldSendEmail = true;
        BodyMailMessage message = new BodyMailMessage();
        String parameterToEmail = this.parameterService.getParameterValueAsString(AutoCloseRecurringOrdersStep.class, "AUTO_CLOSE_RECURRING_PO_TO_EMAIL_ADDRESSES");
        String parameterFromEmail = this.parameterService.getParameterValueAsString(AutoCloseRecurringOrdersStep.class, "EMAIL_FROM");
        if (StringUtils.isEmpty((CharSequence)parameterToEmail)) {
            LOG.error("autoCloseRecurringOrders(): parameterToEmail is missing, we'll not send out any emails for this job.");
            shouldSendEmail = false;
        }
        if (StringUtils.isEmpty((CharSequence)parameterFromEmail)) {
            LOG.error("autoCloseRecurringOrders(): parameterFromEmail is missing, we'll not send out any emails for this job.");
            shouldSendEmail = false;
        }
        if (shouldSendEmail) {
            message = this.setMessageAddressesAndSubject(message, parameterToEmail, parameterFromEmail);
        }
        StringBuffer emailBody = new StringBuffer();
        String recurringOrderDateString = this.parameterService.getParameterValueAsString(AutoCloseRecurringOrdersStep.class, "AUTO_CLOSE_RECURRING_PO_DATE");
        boolean validDate = true;
        Date recurringOrderDate = null;
        try {
            recurringOrderDate = this.dateTimeService.convertToDate(recurringOrderDateString);
        }
        catch (ParseException pe) {
            validDate = false;
        }
        if (StringUtils.isEmpty((CharSequence)recurringOrderDateString) || "mm/dd/yyyy".equalsIgnoreCase(recurringOrderDateString) || !validDate) {
            if ("mm/dd/yyyy".equalsIgnoreCase(recurringOrderDateString)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("autoCloseRecurringOrders(): mm/dd/yyyy was found in the Application Settings table. No orders will be closed, method will end.");
                }
                if (shouldSendEmail) {
                    emailBody.append("The AUTO_CLOSE_RECURRING_ORDER_DT found in the Application Settings table was mm/dd/yyyy. No recurring PO's were closed.");
                }
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("autoCloseRecurringOrders(): An invalid autoCloseRecurringOrdersDate was found in the Application Settings table: " + recurringOrderDateString + ". Method will end.");
                }
                if (shouldSendEmail) {
                    emailBody.append("An invalid AUTO_CLOSE_RECURRING_ORDER_DT was found in the Application Settings table: ").append(recurringOrderDateString).append(". No recurring PO's were closed.");
                }
            }
            if (shouldSendEmail) {
                this.sendMessage(message, emailBody.toString());
            }
            LOG.info("autoCloseRecurringOrders() ended");
            return false;
        }
        LOG.info("autoCloseRecurringOrders() The autoCloseRecurringOrdersDate found in the Application Settings table was " + recurringOrderDateString);
        if (shouldSendEmail) {
            emailBody.append("The autoCloseRecurringOrdersDate found in the Application Settings table was ").append(recurringOrderDateString).append(".");
        }
        Calendar appSettingsDate = this.dateTimeService.getCalendar(recurringOrderDate);
        Timestamp appSettingsDay = new Timestamp(appSettingsDate.getTime().getTime());
        Calendar todayMinusThreeMonths = this.getTodayMinusThreeMonths();
        Timestamp threeMonthsAgo = new Timestamp(todayMinusThreeMonths.getTime().getTime());
        if (appSettingsDate.after(todayMinusThreeMonths)) {
            LOG.info("autoCloseRecurringOrders() The appSettingsDate: " + appSettingsDay + " is after todayMinusThreeMonths: " + threeMonthsAgo + ". The program will end.");
            if (shouldSendEmail) {
                emailBody.append("\n\nThe autoCloseRecurringOrdersDate: ").append(appSettingsDay).append(" is after todayMinusThreeMonths: ").append(threeMonthsAgo).append(". The program will end.");
                this.sendMessage(message, emailBody.toString());
            }
            LOG.info("autoCloseRecurringOrders() ended");
            return false;
        }
        List<AutoClosePurchaseOrderView> closeList = this.purchaseOrderDao.getAutoCloseRecurringPurchaseOrders(this.getExcludedVendorChoiceCodes());
        List<AutoClosePurchaseOrderView> purchaseOrderAutoCloseList = this.filterDocumentsForAppDocStatusOpen(closeList);
        LOG.info("autoCloseRecurringOrders(): " + purchaseOrderAutoCloseList.size() + " PO's were returned for processing.");
        int counter = 0;
        for (AutoClosePurchaseOrderView poAutoClose : purchaseOrderAutoCloseList) {
            LOG.info("autoCloseRecurringOrders(): Testing PO ID " + poAutoClose.getPurapDocumentIdentifier() + ". recurringPaymentEndDate: " + poAutoClose.getRecurringPaymentEndDate());
            if (!poAutoClose.getRecurringPaymentEndDate().before(threeMonthsAgo)) continue;
            String newStatus = "Pending Close";
            String annotation = "This recurring PO was automatically closed in batch.";
            String documentType = "POC";
            PurchaseOrderDocument document = this.purchaseOrderService.getPurchaseOrderByDocumentNumber(poAutoClose.getDocumentNumber());
            this.kualiRuleService.applyRules((KualiDocumentEvent)new AttributedRouteDocumentEvent("", (Document)document));
            if (++counter == 1) {
                emailBody.append("\n\nThe following recurring Purchase Orders will be closed by auto close recurring batch job \n");
            }
            LOG.info("autoCloseRecurringOrders() PO ID " + poAutoClose.getPurapDocumentIdentifier() + " will be closed.");
            this.createNoteForAutoCloseOrders(document, annotation);
            this.purchaseOrderService.createAndRoutePotentialChangeDocument(poAutoClose.getDocumentNumber(), documentType, annotation, null, newStatus);
            if (!shouldSendEmail) continue;
            emailBody.append("\n\n").append(counter).append(" PO ID: ").append(poAutoClose.getPurapDocumentIdentifier()).append(", End Date: ").append(poAutoClose.getRecurringPaymentEndDate()).append(", Status: ").append(poAutoClose.getApplicationDocumentStatus()).append(", VendorChoice: ").append(poAutoClose.getVendorChoiceCode()).append(", RecurringPaymentType: ").append(poAutoClose.getRecurringPaymentTypeCode());
        }
        if (counter == 0) {
            LOG.info("\n\nNo recurring PO's fit the conditions for closing.");
            if (shouldSendEmail) {
                emailBody.append("\n\nNo recurring PO's fit the conditions for closing.");
            }
        }
        if (shouldSendEmail) {
            this.sendMessage(message, emailBody.toString());
        }
        this.resetAutoCloseRecurringOrderDateParameter();
        LOG.debug("autoCloseRecurringOrders() ended");
        return true;
    }

    @Transactional
    protected List<AutoClosePurchaseOrderView> filterDocumentsForAppDocStatusOpen(List<AutoClosePurchaseOrderView> autoClosePurchaseOrderViews) {
        ArrayList<AutoClosePurchaseOrderView> filteredAutoClosePOView = new ArrayList<AutoClosePurchaseOrderView>();
        LOG.info("Start filtering " + autoClosePurchaseOrderViews.size() + " documents for app doc status open...");
        int count = 0;
        for (AutoClosePurchaseOrderView autoClosePurchaseOrderView : autoClosePurchaseOrderViews) {
            FinancialSystemDocumentHeader documentHeader = this.financialSystemDocumentService.findByDocumentNumber(autoClosePurchaseOrderView.getDocumentNumber());
            if (documentHeader != null && "Open".equalsIgnoreCase(documentHeader.getApplicationDocumentStatus())) {
                filteredAutoClosePOView.add(autoClosePurchaseOrderView);
            }
            if (++count % 10000 != 0) continue;
            LOG.debug("Filtered " + count + " documents.");
        }
        LOG.info("Filtering is Complete. Found " + filteredAutoClosePOView.size() + " documents to be closed.");
        return filteredAutoClosePOView;
    }

    @Override
    @Transactional
    public void createNoteForAutoCloseOrders(PurchaseOrderDocument purchaseOrderDocument, String annotation) {
        try {
            Note noteObj = this.documentService.createNoteFromDocument((Document)purchaseOrderDocument, annotation);
            this.noteService.save(noteObj);
        }
        catch (Exception e) {
            String errorMessage = "Error creating and saving close note for purchase order with document service";
            LOG.error("createNoteForAutoCloseRecurringOrders " + errorMessage, (Throwable)e);
            throw new RuntimeException(errorMessage, e);
        }
    }

    @Transactional
    protected BodyMailMessage setMessageAddressesAndSubject(BodyMailMessage message, String parameterToEmail, String parameterFromEmail) {
        String[] toAddressList = parameterToEmail.split(";");
        if (toAddressList.length > 0) {
            Arrays.stream(toAddressList).filter(Objects::nonNull).map(String::trim).forEach(arg_0 -> ((BodyMailMessage)message).addToAddress(arg_0));
        }
        message.setFromAddress(parameterFromEmail);
        message.setSubject("Auto Close Recurring Purchase Orders");
        return message;
    }

    @Transactional
    protected void sendMessage(BodyMailMessage message, String emailBody) {
        message.setMessage(emailBody);
        try {
            this.emailService.sendMessage((MailMessage)message, false);
        }
        catch (Exception e) {
            LOG.error("sendMessage(): email problem. Message not sent.", (Throwable)e);
        }
    }

    @Transactional
    protected Calendar getTodayMinusThreeMonths() {
        Calendar todayMinusThreeMonths = Calendar.getInstance();
        todayMinusThreeMonths.add(2, -3);
        todayMinusThreeMonths.set(10, 12);
        todayMinusThreeMonths.set(12, 0);
        todayMinusThreeMonths.set(13, 0);
        todayMinusThreeMonths.set(14, 0);
        todayMinusThreeMonths.set(9, 0);
        return todayMinusThreeMonths;
    }

    @Transactional
    protected List<String> getExcludedVendorChoiceCodes() {
        return new ArrayList<String>(Arrays.asList(PurapConstants.AUTO_CLOSE_EXCLUSION_VNDR_CHOICE_CODES));
    }

    @Transactional
    protected void resetAutoCloseRecurringOrderDateParameter() {
        Parameter autoCloseRecurringPODate = this.parameterService.getParameter(AutoCloseRecurringOrdersStep.class, "AUTO_CLOSE_RECURRING_PO_DATE");
        if (autoCloseRecurringPODate != null) {
            autoCloseRecurringPODate.setValue("mm/dd/yyyy");
            this.parameterService.updateParameter(autoCloseRecurringPODate);
        }
    }

    @Override
    @Transactional
    public List<AutoClosePurchaseOrderView> getAllOpenPurchaseOrdersForAutoClose() {
        return this.purchaseOrderDao.getAllOpenPurchaseOrders(this.getExcludedVendorChoiceCodes());
    }

    public PurchaseOrderService getPurchaseOrderService() {
        return this.purchaseOrderService;
    }

    public void setPurchaseOrderService(PurchaseOrderService purchaseOrderService) {
        this.purchaseOrderService = purchaseOrderService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public void setPurchaseOrderDao(PurchaseOrderDao purchaseOrderDao) {
        this.purchaseOrderDao = purchaseOrderDao;
    }

    public void setKualiRuleService(KualiRuleService kualiRuleService) {
        this.kualiRuleService = kualiRuleService;
    }

    public void setFinancialSystemDocumentService(FinancialSystemDocumentService financialSystemDocumentService) {
        this.financialSystemDocumentService = financialSystemDocumentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setNoteService(NoteService noteService) {
        this.noteService = noteService;
    }

    public void setEmailService(EmailService emailService) {
        this.emailService = emailService;
    }
}

