/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.sys.document.FinancialSystemMaintainable;
import org.kuali.kfs.vnd.VendorUtils;

public class PurchaseOrderQuoteListMaintainableImpl
extends FinancialSystemMaintainable {
    public Map<String, String> populateNewCollectionLines(Map<String, String> fieldValues, MaintenanceDocument maintenanceDocument, String methodToCall) {
        String collName = "quoteListVendors.vendorDetail.vendorNumber";
        String vendorNumber = fieldValues.get(collName);
        if (StringUtils.isNotBlank((CharSequence)vendorNumber)) {
            if (!VendorUtils.validVendorNumberFormat((String)vendorNumber)) {
                GlobalVariables.getMessageMap().putError("add." + collName, "error.purchaseOrder.quoteList.nonExistence.vendor", new String[0]);
                return fieldValues;
            }
            Integer headerId = VendorUtils.getVendorHeaderId((String)vendorNumber);
            Integer detailId = VendorUtils.getVendorDetailId((String)vendorNumber);
            this.resetPreviousVendorInformationOnAddLine(fieldValues, headerId, detailId);
        }
        return super.populateNewCollectionLines(fieldValues, maintenanceDocument, methodToCall);
    }

    private void resetPreviousVendorInformationOnAddLine(Map fieldValues, Integer headerId, Integer detailId) {
        if (fieldValues.get("quoteListVendors.vendorHeaderGeneratedIdentifier") != null) {
            fieldValues.put("quoteListVendors.vendorHeaderGeneratedIdentifier", headerId);
        }
        if (fieldValues.get("quoteListVendors.vendorDetailAssignedIdentifier") != null) {
            fieldValues.put("quoteListVendors.vendorDetailAssignedIdentifier", detailId);
        }
    }
}

