/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document;

import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.kew.api.document.WorkflowDocumentService;
import org.kuali.kfs.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.module.purap.PurchaseOrderStatuses;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.module.purap.service.PurapGeneralLedgerService;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySourceDetail;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.kfs.sys.context.SpringContext;

public class PurchaseOrderReopenDocument
extends PurchaseOrderDocument {
    private static final Logger LOG = LogManager.getLogger();

    @Override
    public void prepareForSave(KualiDocumentEvent event) {
        LOG.info("prepareForSave(KualiDocumentEvent) do not create gl entries");
        this.setSourceAccountingLines(new ArrayList());
        this.setGeneralLedgerPendingEntries(new ArrayList());
    }

    @Override
    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        super.doRouteStatusChange(statusChangeEvent);
        if (this.getFinancialSystemDocumentHeader().getWorkflowDocument().isProcessed()) {
            ((PurapGeneralLedgerService)SpringContext.getBean(PurapGeneralLedgerService.class)).generateEntriesReopenPurchaseOrder(this);
            ((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).setCurrentAndPendingIndicatorsForApprovedPODocuments(this);
            this.updateAndSaveAppDocStatus("Open");
        } else if (this.getFinancialSystemDocumentHeader().getWorkflowDocument().isDisapproved()) {
            ((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).setCurrentAndPendingIndicatorsForDisapprovedReopenPODocuments(this);
            String nodeName = ((WorkflowDocumentService)SpringContext.getBean(WorkflowDocumentService.class)).getCurrentRouteLevelName(this.getFinancialSystemDocumentHeader().getWorkflowDocument());
            String reqStatus = PurchaseOrderStatuses.getPurchaseOrderAppDocDisapproveStatuses().get(nodeName);
            this.updateAndSaveAppDocStatus(reqStatus);
        } else if (this.getFinancialSystemDocumentHeader().getWorkflowDocument().isCanceled()) {
            ((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).setCurrentAndPendingIndicatorsForCancelledReopenPODocuments(this);
            this.updateAndSaveAppDocStatus("Cancelled");
        }
    }

    @Override
    public void customizeExplicitGeneralLedgerPendingEntry(GeneralLedgerPendingEntrySourceDetail postable, GeneralLedgerPendingEntry explicitEntry) {
        super.customizeExplicitGeneralLedgerPendingEntry(postable, explicitEntry);
        ((PurapGeneralLedgerService)SpringContext.getBean(PurapGeneralLedgerService.class)).customizeGeneralLedgerPendingEntry(this, (AccountingLine)postable, explicitEntry, this.getPurapDocumentIdentifier(), "D", "PO", true);
        explicitEntry.setFinancialDocumentTypeCode("POR");
        explicitEntry.setFinancialDocumentApprovedCode("A");
    }

    public List<GeneralLedgerPendingEntrySourceDetail> getGeneralLedgerPendingEntrySourceDetails() {
        ArrayList<GeneralLedgerPendingEntrySourceDetail> accountingLines = new ArrayList<GeneralLedgerPendingEntrySourceDetail>();
        if (this.getGlOnlySourceAccountingLines() != null) {
            for (SourceAccountingLine line : this.getGlOnlySourceAccountingLines()) {
                accountingLines.add((GeneralLedgerPendingEntrySourceDetail)line);
            }
        }
        return accountingLines;
    }
}

