/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document;

import java.math.BigDecimal;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.kew.api.document.WorkflowDocumentService;
import org.kuali.kfs.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.module.purap.PurchaseOrderStatuses;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.sys.context.SpringContext;

public class PurchaseOrderRetransmitDocument
extends PurchaseOrderDocument {
    protected boolean shouldDisplayRetransmitTab;

    @Override
    public void customPrepareForSave(KualiDocumentEvent event) {
    }

    public KualiDecimal getTotalDollarAmountForRetransmit() {
        KualiDecimal total = new KualiDecimal(BigDecimal.ZERO);
        for (PurchaseOrderItem item : this.getItems()) {
            if (!item.isItemSelectedForRetransmitIndicator()) continue;
            KualiDecimal totalAmount = item.getTotalAmount();
            KualiDecimal itemTotal = totalAmount != null ? totalAmount : KualiDecimal.ZERO;
            total = (KualiDecimal)total.add((AbstractKualiDecimal)itemTotal);
        }
        return total;
    }

    public KualiDecimal getTotalPreTaxDollarAmountForRetransmit() {
        KualiDecimal total = new KualiDecimal(BigDecimal.ZERO);
        for (PurchaseOrderItem item : this.getItems()) {
            if (!item.isItemSelectedForRetransmitIndicator()) continue;
            KualiDecimal extendedPrice = item.getExtendedPrice();
            KualiDecimal itemTotal = extendedPrice != null ? extendedPrice : KualiDecimal.ZERO;
            total = (KualiDecimal)total.add((AbstractKualiDecimal)itemTotal);
        }
        return total;
    }

    public KualiDecimal getTotalTaxDollarAmountForRetransmit() {
        KualiDecimal total = new KualiDecimal(BigDecimal.ZERO);
        for (PurchaseOrderItem item : this.getItems()) {
            if (!item.isItemSelectedForRetransmitIndicator()) continue;
            KualiDecimal taxAmount = item.getItemTaxAmount();
            KualiDecimal itemTotal = taxAmount != null ? taxAmount : KualiDecimal.ZERO;
            total = (KualiDecimal)total.add((AbstractKualiDecimal)itemTotal);
        }
        return total;
    }

    @Override
    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        super.doRouteStatusChange(statusChangeEvent);
        if (this.getFinancialSystemDocumentHeader().getWorkflowDocument().isProcessed()) {
            ((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).setCurrentAndPendingIndicatorsForApprovedPODocuments(this);
            this.setPurchaseOrderLastTransmitTimestamp(((DateTimeService)SpringContext.getBean(DateTimeService.class)).getCurrentTimestamp());
            this.updateAndSaveAppDocStatus("Open");
        } else if (this.getFinancialSystemDocumentHeader().getWorkflowDocument().isDisapproved()) {
            ((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).setCurrentAndPendingIndicatorsForDisapprovedChangePODocuments(this);
            String nodeName = ((WorkflowDocumentService)SpringContext.getBean(WorkflowDocumentService.class)).getCurrentRouteLevelName(this.getFinancialSystemDocumentHeader().getWorkflowDocument());
            String reqStatus = PurchaseOrderStatuses.getPurchaseOrderAppDocDisapproveStatuses().get(nodeName);
            this.updateAndSaveAppDocStatus(PurchaseOrderStatuses.getPurchaseOrderAppDocDisapproveStatuses().get(reqStatus));
        } else if (this.getFinancialSystemDocumentHeader().getWorkflowDocument().isCanceled()) {
            ((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).setCurrentAndPendingIndicatorsForCancelledChangePODocuments(this);
            this.updateAndSaveAppDocStatus("Cancelled");
        }
    }

    public boolean isShouldDisplayRetransmitTab() {
        return this.shouldDisplayRetransmitTab;
    }

    public void setShouldDisplayRetransmitTab(boolean shouldDisplayRetransmitTab) {
        this.shouldDisplayRetransmitTab = shouldDisplayRetransmitTab;
    }

    @Override
    protected boolean shouldAdhocFyi() {
        return false;
    }
}

