/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.service.impl;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.core.api.parameter.ParameterEvaluator;
import org.kuali.kfs.core.api.parameter.ParameterEvaluatorService;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.datadictionary.legacy.DataDictionaryService;
import org.kuali.kfs.kew.api.KewApiServiceLocator;
import org.kuali.kfs.kew.api.WorkflowDocument;
import org.kuali.kfs.kew.api.document.attribute.DocumentAttributeIndexingQueue;
import org.kuali.kfs.kns.util.KNSGlobalVariables;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.NoteService;
import org.kuali.kfs.krad.service.PersistenceService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.CreditMemoStatuses;
import org.kuali.kfs.module.purap.PaymentRequestStatuses;
import org.kuali.kfs.module.purap.PurapConstants;
import org.kuali.kfs.module.purap.businessobject.AbstractRelatedView;
import org.kuali.kfs.module.purap.businessobject.AccountsPayableItem;
import org.kuali.kfs.module.purap.businessobject.BulkReceivingView;
import org.kuali.kfs.module.purap.businessobject.CorrectionReceivingView;
import org.kuali.kfs.module.purap.businessobject.CreditMemoView;
import org.kuali.kfs.module.purap.businessobject.ItemType;
import org.kuali.kfs.module.purap.businessobject.LineItemReceivingView;
import org.kuali.kfs.module.purap.businessobject.OrganizationParameter;
import org.kuali.kfs.module.purap.businessobject.PaymentRequestView;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurApItemUseTax;
import org.kuali.kfs.module.purap.businessobject.PurapEnterableItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderView;
import org.kuali.kfs.module.purap.businessobject.PurchasingItem;
import org.kuali.kfs.module.purap.businessobject.PurchasingItemBase;
import org.kuali.kfs.module.purap.businessobject.RequisitionView;
import org.kuali.kfs.module.purap.document.AccountsPayableDocument;
import org.kuali.kfs.module.purap.document.AccountsPayableDocumentBase;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.PurapItemOperations;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.purap.document.PurchasingDocument;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.document.VendorCreditMemoDocument;
import org.kuali.kfs.module.purap.document.service.LogicContainer;
import org.kuali.kfs.module.purap.document.service.PurapService;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.module.purap.service.PurapAccountingService;
import org.kuali.kfs.module.purap.util.PurApItemUtils;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.kfs.sys.businessobject.TaxDetail;
import org.kuali.kfs.sys.document.validation.event.DocumentSystemSaveEvent;
import org.kuali.kfs.sys.service.TaxService;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;
import org.kuali.kfs.vnd.businessobject.CommodityCode;
import org.kuali.kfs.vnd.document.service.VendorService;

public class PurapServiceImpl
implements PurapService {
    private static final Logger LOG = LogManager.getLogger();
    protected BusinessObjectService businessObjectService;
    protected DataDictionaryService dataDictionaryService;
    protected DateTimeService dateTimeService;
    protected DocumentService documentService;
    protected NoteService noteService;
    protected ParameterService parameterService;
    protected PersistenceService persistenceService;
    protected PurchaseOrderService purchaseOrderService;
    protected UniversityDateService universityDateService;
    protected VendorService vendorService;
    protected TaxService taxService;
    protected PurapAccountingService purapAccountingService;
    private ParameterEvaluatorService parameterEvaluatorService;

    public void setBusinessObjectService(BusinessObjectService boService) {
        this.businessObjectService = boService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    public void setVendorService(VendorService vendorService) {
        this.vendorService = vendorService;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public void setPurchaseOrderService(PurchaseOrderService purchaseOrderService) {
        this.purchaseOrderService = purchaseOrderService;
    }

    public void setNoteService(NoteService noteService) {
        this.noteService = noteService;
    }

    public void setUniversityDateService(UniversityDateService universityDateService) {
        this.universityDateService = universityDateService;
    }

    public void setTaxService(TaxService taxService) {
        this.taxService = taxService;
    }

    @Override
    public void saveRoutingDataForRelatedDocuments(Integer accountsPayablePurchasingDocumentLinkIdentifier) {
        List reqViews = this.getRelatedViews(RequisitionView.class, accountsPayablePurchasingDocumentLinkIdentifier);
        for (Object view : reqViews) {
            Document doc = this.documentService.getByDocumentHeaderId(((AbstractRelatedView)((Object)view)).getDocumentNumber());
            doc.getDocumentHeader().getWorkflowDocument().saveDocumentData();
        }
        List poViews = this.getRelatedViews(PurchaseOrderView.class, accountsPayablePurchasingDocumentLinkIdentifier);
        for (Object view : poViews) {
            Document doc = this.documentService.getByDocumentHeaderId(((PurchaseOrderView)((Object)view)).getDocumentNumber());
            doc.getDocumentHeader().getWorkflowDocument().saveDocumentData();
        }
        List preqViews = this.getRelatedViews(PaymentRequestView.class, accountsPayablePurchasingDocumentLinkIdentifier);
        for (Object view : preqViews) {
            Document doc = this.documentService.getByDocumentHeaderId(((AbstractRelatedView)((Object)view)).getDocumentNumber());
            doc.getDocumentHeader().getWorkflowDocument().saveDocumentData();
        }
        List cmViews = this.getRelatedViews(CreditMemoView.class, accountsPayablePurchasingDocumentLinkIdentifier);
        for (Object view : cmViews) {
            Document doc = this.documentService.getByDocumentHeaderId(((AbstractRelatedView)((Object)view)).getDocumentNumber());
            doc.getDocumentHeader().getWorkflowDocument().saveDocumentData();
        }
        List lineViews = this.getRelatedViews(LineItemReceivingView.class, accountsPayablePurchasingDocumentLinkIdentifier);
        for (Object view : lineViews) {
            Document doc = this.documentService.getByDocumentHeaderId(((AbstractRelatedView)((Object)view)).getDocumentNumber());
            doc.getDocumentHeader().getWorkflowDocument().saveDocumentData();
        }
        List corrViews = this.getRelatedViews(CorrectionReceivingView.class, accountsPayablePurchasingDocumentLinkIdentifier);
        for (CorrectionReceivingView view : corrViews) {
            Document doc = this.documentService.getByDocumentHeaderId(view.getDocumentNumber());
            doc.getDocumentHeader().getWorkflowDocument().saveDocumentData();
        }
        List bulkViews = this.getRelatedViews(BulkReceivingView.class, accountsPayablePurchasingDocumentLinkIdentifier);
        for (BulkReceivingView view : bulkViews) {
            Document doc = this.documentService.getByDocumentHeaderId(view.getDocumentNumber());
            doc.getDocumentHeader().getWorkflowDocument().saveDocumentData();
        }
    }

    @Override
    public List<String> getRelatedDocumentIds(Integer accountsPayablePurchasingDocumentLinkIdentifier) {
        LOG.debug("getRelatedDocumentIds() started");
        ArrayList<String> documentIdList = new ArrayList<String>();
        List reqViews = this.getRelatedViews(RequisitionView.class, accountsPayablePurchasingDocumentLinkIdentifier);
        for (Object view : reqViews) {
            documentIdList.add(((AbstractRelatedView)((Object)view)).getDocumentNumber());
        }
        List poViews = this.getRelatedViews(PurchaseOrderView.class, accountsPayablePurchasingDocumentLinkIdentifier);
        for (Object view : poViews) {
            documentIdList.add(((PurchaseOrderView)((Object)view)).getDocumentNumber());
        }
        List preqViews = this.getRelatedViews(PaymentRequestView.class, accountsPayablePurchasingDocumentLinkIdentifier);
        for (Object view : preqViews) {
            documentIdList.add(((AbstractRelatedView)((Object)view)).getDocumentNumber());
        }
        List cmViews = this.getRelatedViews(CreditMemoView.class, accountsPayablePurchasingDocumentLinkIdentifier);
        for (Object view : cmViews) {
            documentIdList.add(((AbstractRelatedView)((Object)view)).getDocumentNumber());
        }
        List lineViews = this.getRelatedViews(LineItemReceivingView.class, accountsPayablePurchasingDocumentLinkIdentifier);
        for (Object view : lineViews) {
            documentIdList.add(((AbstractRelatedView)((Object)view)).getDocumentNumber());
        }
        List corrViews = this.getRelatedViews(CorrectionReceivingView.class, accountsPayablePurchasingDocumentLinkIdentifier);
        for (CorrectionReceivingView view : corrViews) {
            documentIdList.add(view.getDocumentNumber());
        }
        List bulkViews = this.getRelatedViews(BulkReceivingView.class, accountsPayablePurchasingDocumentLinkIdentifier);
        for (BulkReceivingView view : bulkViews) {
            documentIdList.add(view.getDocumentNumber());
        }
        return documentIdList;
    }

    @Override
    public List getRelatedViews(Class clazz, Integer accountsPayablePurchasingDocumentLinkIdentifier) {
        LOG.debug("getRelatedViews() started");
        HashMap<String, Integer> criteria = new HashMap<String, Integer>();
        criteria.put("accountsPayablePurchasingDocumentLinkIdentifier", accountsPayablePurchasingDocumentLinkIdentifier);
        return (List)this.businessObjectService.findMatchingOrderBy(clazz, criteria, "documentNumber", false);
    }

    @Override
    public void addBelowLineItems(PurchasingAccountsPayableDocument document) {
        LOG.debug("addBelowLineItems() started");
        String[] itemTypes = this.getBelowTheLineForDocument(document);
        List<PurApItem> existingItems = document.getItems();
        ArrayList<PurApItem> belowTheLine = new ArrayList<PurApItem>();
        this.sortBelowTheLine(itemTypes, existingItems, belowTheLine);
        ArrayList<String> existingItemTypes = new ArrayList<String>();
        for (PurApItem existingItem : existingItems) {
            existingItemTypes.add(existingItem.getItemTypeCode());
        }
        Class itemClass = document.getItemClass();
        for (int i = 0; i < itemTypes.length; ++i) {
            if (existingItemTypes.contains(itemTypes[i])) continue;
            try {
                int lastFound = i > 0 ? existingItemTypes.lastIndexOf(itemTypes[i - 1]) + 1 : existingItemTypes.size();
                PurApItem newItem = (PurApItem)itemClass.newInstance();
                newItem.setItemTypeCode(itemTypes[i]);
                newItem.setPurapDocument(document);
                existingItems.add(lastFound, newItem);
                existingItemTypes.add(itemTypes[i]);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        document.fixItemReferences();
    }

    protected void sortBelowTheLine(String[] itemTypes, List<PurApItem> existingItems, List<PurApItem> belowTheLine) {
        LOG.debug("sortBelowTheLine() started");
        for (PurApItem purApItem : existingItems) {
            if (!purApItem.getItemType().isAdditionalChargeIndicator()) continue;
            belowTheLine.add(purApItem);
        }
        existingItems.removeAll(belowTheLine);
        block1: for (String itemType : itemTypes) {
            for (PurApItem purApItem : belowTheLine) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)purApItem.getItemTypeCode(), (CharSequence)itemType)) continue;
                existingItems.add(purApItem);
                continue block1;
            }
        }
        belowTheLine.removeAll(existingItems);
        if (belowTheLine.size() != 0) {
            throw new RuntimeException("below the line item sort didn't work: trying to remove an item without adding it back");
        }
    }

    @Override
    public void sortBelowTheLine(PurchasingAccountsPayableDocument document) {
        LOG.debug("sortBelowTheLine() started");
        String[] itemTypes = this.getBelowTheLineForDocument(document);
        List<PurApItem> existingItems = document.getItems();
        ArrayList<PurApItem> belowTheLine = new ArrayList<PurApItem>();
        this.sortBelowTheLine(itemTypes, existingItems, belowTheLine);
    }

    @Override
    public String[] getBelowTheLineForDocument(PurchasingAccountsPayableDocument document) {
        LOG.debug("getBelowTheLineForDocument() started");
        String documentType = this.dataDictionaryService.getDocumentTypeNameByClass(document.getClass());
        try {
            return this.parameterService.getParameterValuesAsString(Class.forName(PurapConstants.PURAP_DETAIL_TYPE_CODE_MAP.get(documentType)), "ADDITIONAL_CHARGES_ITEM_TYPES").toArray(new String[0]);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("The getBelowTheLineForDocument method of PurapServiceImpl was unable to resolve the document class for type: " + PurapConstants.PURAP_DETAIL_TYPE_CODE_MAP.get(documentType), e);
        }
    }

    @Override
    public PurApItem getBelowTheLineByType(PurchasingAccountsPayableDocument document, ItemType iT) {
        LOG.debug("getBelowTheLineByType() started");
        String[] itemTypes = this.getBelowTheLineForDocument(document);
        boolean foundItemType = false;
        for (String itemType : itemTypes) {
            if (!StringUtils.equals((CharSequence)iT.getItemTypeCode(), (CharSequence)itemType)) continue;
            foundItemType = true;
            break;
        }
        if (!foundItemType) {
            return null;
        }
        PurApItem belowTheLineItem = null;
        for (PurApItem item : document.getItems()) {
            if (!item.getItemType().isAdditionalChargeIndicator() || !StringUtils.equals((CharSequence)iT.getItemTypeCode(), (CharSequence)item.getItemType().getItemTypeCode())) continue;
            belowTheLineItem = item;
            break;
        }
        return belowTheLineItem;
    }

    @Override
    public Date getDateFromOffsetFromToday(int offsetDays) {
        Calendar calendar = this.dateTimeService.getCurrentCalendar();
        calendar.add(5, offsetDays);
        return new Date(calendar.getTimeInMillis());
    }

    @Override
    public boolean isDateInPast(Date compareDate) {
        LOG.debug("isDateInPast() started");
        Date today = this.dateTimeService.getCurrentSqlDate();
        int diffFromToday = this.dateTimeService.dateDiff((java.util.Date)today, (java.util.Date)compareDate, false);
        return diffFromToday < 0;
    }

    @Override
    public boolean isDateMoreThanANumberOfDaysAway(Date compareDate, int daysAway) {
        LOG.debug("isDateMoreThanANumberOfDaysAway() started");
        Date todayAtMidnight = this.dateTimeService.getCurrentSqlDateMidnight();
        Calendar daysAwayCalendar = this.dateTimeService.getCalendar((java.util.Date)todayAtMidnight);
        daysAwayCalendar.add(5, daysAway);
        Timestamp daysAwayTime = new Timestamp(daysAwayCalendar.getTime().getTime());
        Calendar compareCalendar = this.dateTimeService.getCalendar((java.util.Date)compareDate);
        compareCalendar.set(10, 0);
        compareCalendar.set(12, 0);
        compareCalendar.set(13, 0);
        compareCalendar.set(14, 0);
        compareCalendar.set(9, 0);
        Timestamp compareTime = new Timestamp(compareCalendar.getTime().getTime());
        return compareTime.compareTo(daysAwayTime) > 0;
    }

    @Override
    public boolean isDateAYearBeforeToday(Date compareDate) {
        LOG.debug("isDateAYearBeforeToday() started");
        Calendar calendar = this.dateTimeService.getCurrentCalendar();
        calendar.add(1, -1);
        Date yearAgo = new Date(calendar.getTimeInMillis());
        int diffFromYearAgo = this.dateTimeService.dateDiff((java.util.Date)compareDate, (java.util.Date)yearAgo, false);
        return diffFromYearAgo > 0;
    }

    @Override
    public KualiDecimal getApoLimit(Integer vendorContractGeneratedIdentifier, String chart, String org) {
        LOG.debug("getApoLimit() started");
        KualiDecimal purchaseOrderTotalLimit = this.vendorService.getApoLimitFromContract(vendorContractGeneratedIdentifier, chart, org);
        if (ObjectUtils.isNull((Object)purchaseOrderTotalLimit) && !ObjectUtils.isNull((Object)chart) && !ObjectUtils.isNull((Object)org)) {
            OrganizationParameter organizationParameter = new OrganizationParameter();
            organizationParameter.setChartOfAccountsCode(chart);
            organizationParameter.setOrganizationCode(org);
            Map orgParamKeys = this.persistenceService.getPrimaryKeyFieldValues((Object)organizationParameter);
            orgParamKeys.put("activeIndicator", true);
            organizationParameter = (OrganizationParameter)this.businessObjectService.findByPrimaryKey(OrganizationParameter.class, orgParamKeys);
            KualiDecimal kualiDecimal = purchaseOrderTotalLimit = organizationParameter == null ? null : organizationParameter.getOrganizationAutomaticPurchaseOrderLimit();
        }
        if (ObjectUtils.isNull((Object)purchaseOrderTotalLimit)) {
            String defaultLimit = this.parameterService.getParameterValueAsString(RequisitionDocument.class, "AUTOMATIC_PURCHASE_ORDER_DEFAULT_LIMIT_AMOUNT");
            purchaseOrderTotalLimit = new KualiDecimal(defaultLimit);
        }
        return purchaseOrderTotalLimit;
    }

    @Override
    public boolean isFullDocumentEntryCompleted(PurchasingAccountsPayableDocument purapDocument) {
        LOG.debug("isFullDocumentEntryCompleted() started");
        boolean value = false;
        if (purapDocument instanceof PaymentRequestDocument) {
            value = PaymentRequestStatuses.STATUS_ORDER.isFullDocumentEntryCompleted(purapDocument.getApplicationDocumentStatus());
        } else if (purapDocument instanceof VendorCreditMemoDocument) {
            value = CreditMemoStatuses.STATUS_ORDER.isFullDocumentEntryCompleted(purapDocument.getApplicationDocumentStatus());
        }
        return value;
    }

    @Override
    public boolean isPaymentRequestFullDocumentEntryCompleted(String purapDocumentStatus) {
        LOG.debug("isPaymentRequestFullDocumentEntryCompleted() started");
        return PaymentRequestStatuses.STATUS_ORDER.isFullDocumentEntryCompleted(purapDocumentStatus);
    }

    @Override
    public boolean isVendorCreditMemoFullDocumentEntryCompleted(String purapDocumentStatus) {
        LOG.debug("isVendorCreditMemoFullDocumentEntryCompleted() started");
        return CreditMemoStatuses.STATUS_ORDER.isFullDocumentEntryCompleted(purapDocumentStatus);
    }

    @Override
    public void performLogicForCloseReopenPO(PurchasingAccountsPayableDocument purapDocument) {
        LOG.debug("performLogicForCloseReopenPO() started");
        if (purapDocument instanceof PaymentRequestDocument) {
            PaymentRequestDocument paymentRequest = (PaymentRequestDocument)purapDocument;
            if (paymentRequest.isClosePurchaseOrderIndicator() && "Open".equals(paymentRequest.getPurchaseOrderDocument().getApplicationDocumentStatus())) {
                this.processCloseReopenPo((AccountsPayableDocumentBase)purapDocument, "POC");
            }
        } else if (purapDocument instanceof VendorCreditMemoDocument) {
            VendorCreditMemoDocument creditMemo = (VendorCreditMemoDocument)purapDocument;
            if (creditMemo.isReopenPurchaseOrderIndicator() && "Closed".equals(creditMemo.getPurchaseOrderDocument().getApplicationDocumentStatus())) {
                this.processCloseReopenPo((AccountsPayableDocumentBase)purapDocument, "POR");
            }
        } else {
            throw new RuntimeException("Attempted to perform full entry logic for unhandled document type '" + purapDocument.getClass().getName() + "'");
        }
    }

    @Override
    public void deleteUnenteredItems(PurapItemOperations document) {
        LOG.debug("deleteUnenteredItems() started");
        ArrayList<PurapEnterableItem> deletionList = new ArrayList<PurapEnterableItem>();
        for (PurapEnterableItem item : document.getItems()) {
            if (item.isConsideredEntered()) continue;
            deletionList.add(item);
        }
        document.getItems().removeAll(deletionList);
    }

    public void processCloseReopenPo(AccountsPayableDocumentBase apDocument, String docType) {
        String newStatus;
        String action;
        LOG.debug("processCloseReopenPo() started");
        if ("POC".equals(docType)) {
            action = "closed";
            newStatus = "Pending Close";
        } else if ("POR".equals(docType)) {
            action = "reopened";
            newStatus = "Pending Reopen";
        } else {
            String errorMessage = "Method processCloseReopenPo called using ID + '" + apDocument.getPurapDocumentIdentifier() + "' and invalid doc type '" + docType + "'";
            LOG.error(errorMessage);
            throw new RuntimeException(errorMessage);
        }
        Integer poId = apDocument.getPurchaseOrderIdentifier();
        PurchaseOrderDocument purchaseOrderDocument = this.purchaseOrderService.getCurrentPurchaseOrder(poId);
        if (!StringUtils.equalsIgnoreCase((CharSequence)purchaseOrderDocument.getDocumentHeader().getWorkflowDocument().getDocumentTypeName(), (CharSequence)docType)) {
            this.purchaseOrderService.createAndRoutePotentialChangeDocument(purchaseOrderDocument.getDocumentNumber(), docType, this.assemblePurchaseOrderNote(apDocument, docType, action), new ArrayList(), newStatus);
        }
        if ("POC".equals(docType)) {
            apDocument.setClosePurchaseOrderIndicator(false);
            String userName = apDocument.getLastActionPerformedByPersonName();
            StringBuffer poNote = new StringBuffer();
            poNote.append("PO was closed manually by ");
            poNote.append(userName);
            poNote.append(" in approving PREQ with ID ");
            poNote.append(apDocument.getDocumentNumber());
            try {
                Note noteObj = this.documentService.createNoteFromDocument((Document)apDocument.getPurchaseOrderDocument(), poNote.toString());
                noteObj.setNoteTypeCode(apDocument.getPurchaseOrderDocument().getNoteType().getCode());
                apDocument.getPurchaseOrderDocument().addNote(noteObj);
                this.noteService.save(noteObj);
            }
            catch (Exception e) {
                String errorMessage = "Error creating and saving close note for purchase order with document service";
                LOG.error("processCloseReopenPo() " + errorMessage, (Throwable)e);
                throw new RuntimeException(errorMessage, e);
            }
        } else if ("POR".equals(docType)) {
            apDocument.setReopenPurchaseOrderIndicator(false);
        }
    }

    protected String assemblePurchaseOrderNote(AccountsPayableDocumentBase apDocument, String docType, String action) {
        LOG.debug("assemblePurchaseOrderNote() started");
        String documentLabel = this.dataDictionaryService.getDocumentLabelByClass(apDocument.getClass());
        StringBuffer closeReopenNote = new StringBuffer();
        String userName = GlobalVariables.getUserSession().getPerson().getName();
        closeReopenNote.append(this.dataDictionaryService.getDocumentLabelByTypeName("PO"));
        closeReopenNote.append(" will be manually ");
        closeReopenNote.append(action);
        closeReopenNote.append(" by ");
        closeReopenNote.append(userName);
        closeReopenNote.append(" when approving ");
        closeReopenNote.append(documentLabel);
        closeReopenNote.append(" with ");
        closeReopenNote.append(this.dataDictionaryService.getAttributeLabel(apDocument.getClass(), "purapDocumentIdentifier"));
        closeReopenNote.append(" ");
        closeReopenNote.append(apDocument.getPurapDocumentIdentifier());
        return closeReopenNote.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object performLogicWithFakedUserSession(String requiredPersonPersonUserId, LogicContainer logicToRun, Object ... objects) {
        LOG.debug("performLogicWithFakedUserSession() started");
        if (StringUtils.isBlank((CharSequence)requiredPersonPersonUserId)) {
            throw new RuntimeException("Attempted to perform logic with a fake user session with a blank user person id: '" + requiredPersonPersonUserId + "'");
        }
        if (ObjectUtils.isNull((Object)logicToRun)) {
            throw new RuntimeException("Attempted to perform logic with a fake user session with no logic to run");
        }
        UserSession actualUserSession = GlobalVariables.getUserSession();
        try {
            GlobalVariables.setUserSession((UserSession)new UserSession(requiredPersonPersonUserId));
            Object object = logicToRun.runLogic(objects);
            return object;
        }
        finally {
            GlobalVariables.setUserSession((UserSession)actualUserSession);
        }
    }

    @Override
    public void saveDocumentNoValidation(Document document) {
        try {
            if (document.getDocumentHeader() != null && document.getDocumentHeader().getDocumentNumber() == null) {
                WorkflowDocument workflowDocument = document.getDocumentHeader().getWorkflowDocument();
                document.refreshReferenceObject("documentHeader");
                document.getDocumentHeader().setWorkflowDocument(workflowDocument);
            }
            this.documentService.saveDocument(document, DocumentSystemSaveEvent.class);
            DocumentAttributeIndexingQueue documentAttributeIndexingQueue = KewApiServiceLocator.getDocumentAttributeIndexingQueue();
            documentAttributeIndexingQueue.indexDocument(document.getDocumentNumber());
        }
        catch (NumberFormatException ne) {
            String errorMsg = "Invalid document number format for document # " + document.getDocumentHeader().getDocumentNumber() + " " + ne.getMessage();
            LOG.error(errorMsg, (Throwable)ne);
            throw new RuntimeException(errorMsg, ne);
        }
    }

    @Override
    public boolean isDocumentStoppedInRouteNode(PurchasingAccountsPayableDocument document, String nodeName) {
        WorkflowDocument workflowDoc = document.getDocumentHeader().getWorkflowDocument();
        Set currentRouteLevels = workflowDoc.getCurrentNodeNames();
        return CollectionUtils.isNotEmpty((Collection)currentRouteLevels) && currentRouteLevels.contains(nodeName) && workflowDoc.isApprovalRequested();
    }

    @Override
    public boolean allowEncumberNextFiscalYear() {
        LOG.debug("allowEncumberNextFiscalYear() started");
        java.util.Date today = this.dateTimeService.getCurrentDate();
        java.util.Date closingDate = this.universityDateService.getLastDateOfFiscalYear(this.universityDateService.getCurrentFiscalYear());
        int allowEncumberNext = Integer.parseInt(this.parameterService.getParameterValueAsString(RequisitionDocument.class, "ALLOW_ENCUMBER_NEXT_YEAR_DAYS"));
        int diffTodayClosing = this.dateTimeService.dateDiff(today, closingDate, false);
        if (ObjectUtils.isNotNull((Object)closingDate) && ObjectUtils.isNotNull((Object)today) && ObjectUtils.isNotNull((Object)allowEncumberNext)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("allowEncumberNextFiscalYear() today = " + this.dateTimeService.toDateString(today) + "; encumber next FY range = " + allowEncumberNext + " - " + this.dateTimeService.toDateTimeString(today));
            }
            if (allowEncumberNext >= diffTodayClosing && diffTodayClosing >= KualiDecimal.ZERO.intValue()) {
                LOG.debug("allowEncumberNextFiscalYear() encumber next FY allowed; return true.");
                return true;
            }
        }
        LOG.debug("allowEncumberNextFiscalYear() encumber next FY not allowed; return false.");
        return false;
    }

    @Override
    public List<Integer> getAllowedFiscalYears() {
        ArrayList<Integer> allowedYears = new ArrayList<Integer>();
        Integer currentFY = this.universityDateService.getCurrentFiscalYear();
        allowedYears.add(currentFY);
        if (this.allowEncumberNextFiscalYear()) {
            allowedYears.add(currentFY + 1);
        }
        return allowedYears;
    }

    @Override
    public boolean isTodayWithinApoAllowedRange() {
        java.util.Date today = this.dateTimeService.getCurrentDate();
        Integer currentFY = this.universityDateService.getCurrentFiscalYear();
        java.util.Date closingDate = this.universityDateService.getLastDateOfFiscalYear(currentFY);
        int allowApoDate = Integer.parseInt(this.parameterService.getParameterValueAsString(RequisitionDocument.class, "ALLOW_APO_NEXT_FY_DAYS"));
        int diffTodayClosing = this.dateTimeService.dateDiff(today, closingDate, true);
        return diffTodayClosing <= allowApoDate;
    }

    @Override
    public void clearTax(PurchasingAccountsPayableDocument purapDocument, boolean useTax) {
        for (PurApItem item : purapDocument.getItems()) {
            if (useTax) {
                item.getUseTaxItems().clear();
                continue;
            }
            item.setItemTaxAmount(null);
        }
    }

    @Override
    public void updateUseTaxIndicator(PurchasingAccountsPayableDocument purapDocument, boolean newUseTaxIndicatorValue) {
        boolean currentUseTaxIndicator = purapDocument.isUseTaxIndicator();
        if (currentUseTaxIndicator != newUseTaxIndicatorValue) {
            this.clearTax(purapDocument, currentUseTaxIndicator);
        }
        purapDocument.setUseTaxIndicator(newUseTaxIndicatorValue);
    }

    @Override
    public void calculateTax(PurchasingAccountsPayableDocument purapDocument) {
        boolean salesTaxInd = this.parameterService.getParameterValueAsBoolean(KfsParameterConstants.PURCHASING_DOCUMENT.class, "ENABLE_SALES_TAX_IND");
        boolean useTaxIndicator = purapDocument.isUseTaxIndicator();
        String deliveryState = this.getDeliveryState(purapDocument);
        String deliveryPostalCode = this.getDeliveryPostalCode(purapDocument);
        Date transactionTaxDate = purapDocument.getTransactionTaxDate();
        if (salesTaxInd || useTaxIndicator) {
            for (PurApItem item : purapDocument.getItems()) {
                if (!this.isTaxable(useTaxIndicator, deliveryState, item)) continue;
                this.calculateItemTax(useTaxIndicator, deliveryPostalCode, transactionTaxDate, item, item.getUseTaxClass(), purapDocument);
            }
        }
    }

    @Override
    public String getDeliveryState(PurchasingAccountsPayableDocument purapDocument) {
        if (purapDocument instanceof PurchasingDocument) {
            PurchasingDocument document = (PurchasingDocument)purapDocument;
            return document.getDeliveryStateCode();
        }
        if (purapDocument instanceof AccountsPayableDocument) {
            AccountsPayableDocument document = (AccountsPayableDocument)purapDocument;
            if (document.getPurchaseOrderDocument() == null) {
                throw new RuntimeException("PurchaseOrder document does not exists");
            }
            return document.getPurchaseOrderDocument().getDeliveryStateCode();
        }
        return null;
    }

    protected String getDeliveryPostalCode(PurchasingAccountsPayableDocument purapDocument) {
        if (purapDocument instanceof PurchasingDocument) {
            PurchasingDocument document = (PurchasingDocument)purapDocument;
            return document.getDeliveryPostalCode();
        }
        if (purapDocument instanceof AccountsPayableDocument) {
            AccountsPayableDocument docBase = (AccountsPayableDocument)purapDocument;
            if (docBase.getPurchaseOrderDocument() == null) {
                throw new RuntimeException("PurchaseOrder document does not exists");
            }
            return docBase.getPurchaseOrderDocument().getDeliveryPostalCode();
        }
        return null;
    }

    @Override
    public boolean isTaxable(boolean useTaxIndicator, String deliveryState, PurApItem item) {
        boolean taxable = false;
        if (item.getItemType().isTaxableIndicator() && (ObjectUtils.isNull((Object)item.getItemTaxAmount()) || useTaxIndicator) && this.doesCommodityAllowCallToTaxService(item) && this.doesAccountAllowCallToTaxService(deliveryState, item)) {
            taxable = true;
        }
        return taxable;
    }

    @Override
    public boolean isTaxableForSummary(boolean useTaxIndicator, String deliveryState, PurApItem item) {
        return item.getItemType().isTaxableIndicator() && this.doesCommodityAllowCallToTaxService(item) && this.doesAccountAllowCallToTaxService(deliveryState, item);
    }

    protected boolean doesCommodityAllowCallToTaxService(PurApItem item) {
        boolean callService = true;
        if (item.getItemType().isLineItemIndicator()) {
            AccountsPayableItem apItem;
            PurchaseOrderItem poItem;
            if (item instanceof PurchasingItem) {
                PurchasingItemBase purItem = (PurchasingItemBase)item;
                if (purItem.getPurchasingCommodityCode() == null) {
                    return true;
                }
                callService = this.isCommodityCodeTaxable(purItem.getCommodityCode());
            } else if (item instanceof AccountsPayableItem && ObjectUtils.isNotNull((Object)(poItem = (apItem = (AccountsPayableItem)item).getPurchaseOrderItem()))) {
                if (poItem.getPurchasingCommodityCode() == null) {
                    return true;
                }
                callService = this.isCommodityCodeTaxable(poItem.getCommodityCode());
            }
        }
        return callService;
    }

    protected boolean isCommodityCodeTaxable(CommodityCode commodityCode) {
        if (ObjectUtils.isNotNull((Object)commodityCode)) {
            return commodityCode.isSalesTaxIndicator();
        }
        return true;
    }

    @Override
    public boolean isDeliveryStateTaxable(String deliveryState) {
        ParameterEvaluator parmEval = this.parameterEvaluatorService.getParameterEvaluator(KfsParameterConstants.PURCHASING_DOCUMENT.class, "TAXABLE_DELIVERY_STATES", deliveryState);
        return parmEval.evaluationSucceeds();
    }

    protected boolean doesAccountAllowCallToTaxService(String deliveryState, PurApItem item) {
        boolean callService = false;
        boolean deliveryStateTaxable = this.isDeliveryStateTaxable(deliveryState);
        for (PurApAccountingLine acctLine : item.getSourceAccountingLines()) {
            if (!this.isAccountingLineTaxable(acctLine, deliveryStateTaxable)) continue;
            callService = true;
            break;
        }
        return callService;
    }

    @Override
    public boolean isAccountingLineTaxable(PurApAccountingLine acctLine, boolean deliveryStateTaxable) {
        boolean isTaxable = false;
        String parameterSuffix = deliveryStateTaxable ? "FOR_TAXABLE_STATES" : "FOR_NON_TAXABLE_STATES";
        if (this.isAccountTaxable(parameterSuffix, acctLine) && this.isObjectCodeTaxable(parameterSuffix, acctLine)) {
            isTaxable = true;
        }
        return isTaxable;
    }

    protected boolean isAccountTaxable(String parameterSuffix, PurApAccountingLine acctLine) {
        boolean isAccountTaxable = false;
        String fundParam = "TAXABLE_FUND_GROUPS_" + parameterSuffix;
        String subFundParam = "TAXABLE_SUB_FUND_GROUPS_" + parameterSuffix;
        if (ObjectUtils.isNull((Object)acctLine.getAccount().getSubFundGroup())) {
            acctLine.refreshNonUpdateableReferences();
        }
        ParameterEvaluator fundParamEval = this.parameterEvaluatorService.getParameterEvaluator(KfsParameterConstants.PURCHASING_DOCUMENT.class, fundParam, acctLine.getAccount().getSubFundGroup().getFundGroupCode());
        ParameterEvaluator subFundParamEval = this.parameterEvaluatorService.getParameterEvaluator(KfsParameterConstants.PURCHASING_DOCUMENT.class, subFundParam, acctLine.getAccount().getSubFundGroupCode());
        if (this.isAllowedFound(fundParamEval) && (this.isAllowedFound(subFundParamEval) || this.isAllowedNotFound(subFundParamEval) || this.isDeniedNotFound(subFundParamEval)) || this.isAllowedNotFound(fundParamEval) && this.isAllowedFound(subFundParamEval) || this.isDeniedFound(fundParamEval) && this.isAllowedFound(subFundParamEval) || this.isDeniedNotFound(fundParamEval) && (this.isAllowedFound(subFundParamEval) || this.isAllowedNotFound(subFundParamEval) || this.isDeniedNotFound(subFundParamEval))) {
            isAccountTaxable = true;
        }
        return isAccountTaxable;
    }

    protected boolean isObjectCodeTaxable(String parameterSuffix, PurApAccountingLine acctLine) {
        boolean isObjectCodeTaxable = false;
        String levelParam = "TAXABLE_OBJECT_LEVELS_" + parameterSuffix;
        String consolidationParam = "TAXABLE_OBJECT_CONSOLIDATIONS_" + parameterSuffix;
        acctLine.getObjectCode().refreshReferenceObject("financialObjectLevel");
        ParameterEvaluator levelParamEval = this.parameterEvaluatorService.getParameterEvaluator(KfsParameterConstants.PURCHASING_DOCUMENT.class, levelParam, acctLine.getObjectCode().getFinancialObjectLevelCode());
        ParameterEvaluator consolidationParamEval = this.parameterEvaluatorService.getParameterEvaluator(KfsParameterConstants.PURCHASING_DOCUMENT.class, consolidationParam, acctLine.getObjectCode().getFinancialObjectLevel().getFinancialConsolidationObjectCode());
        if (this.isAllowedFound(levelParamEval) && (this.isAllowedFound(consolidationParamEval) || this.isAllowedNotFound(consolidationParamEval) || this.isDeniedNotFound(consolidationParamEval)) || this.isAllowedNotFound(levelParamEval) && this.isAllowedFound(consolidationParamEval) || this.isDeniedFound(levelParamEval) && this.isAllowedFound(consolidationParamEval) || this.isDeniedNotFound(levelParamEval) && (this.isAllowedFound(consolidationParamEval) || this.isAllowedNotFound(consolidationParamEval) || this.isDeniedNotFound(consolidationParamEval))) {
            isObjectCodeTaxable = true;
        }
        return isObjectCodeTaxable;
    }

    protected boolean isAllowedFound(ParameterEvaluator eval) {
        boolean exists = false;
        if (eval.evaluationSucceeds() && eval.constraintIsAllow()) {
            exists = true;
        }
        return exists;
    }

    protected boolean isAllowedNotFound(ParameterEvaluator eval) {
        boolean exists = false;
        if (!eval.evaluationSucceeds() && eval.constraintIsAllow()) {
            exists = true;
        }
        return exists;
    }

    protected boolean isDeniedFound(ParameterEvaluator eval) {
        boolean exists = false;
        if (!eval.evaluationSucceeds() && !eval.constraintIsAllow()) {
            exists = true;
        }
        return exists;
    }

    protected boolean isDeniedNotFound(ParameterEvaluator eval) {
        boolean exists = false;
        if (eval.evaluationSucceeds() && !eval.constraintIsAllow()) {
            exists = true;
        }
        return exists;
    }

    protected void calculateItemTax(boolean useTaxIndicator, String deliveryPostalCode, Date transactionTaxDate, PurApItem item, Class itemUseTaxClass, PurchasingAccountsPayableDocument purapDocument) {
        if (!useTaxIndicator) {
            if (!StringUtils.equals((CharSequence)item.getItemTypeCode(), (CharSequence)"DISC") && !StringUtils.equals((CharSequence)item.getItemTypeCode(), (CharSequence)"ORDS")) {
                KualiDecimal taxAmount = this.taxService.getTotalSalesTaxAmount(transactionTaxDate, deliveryPostalCode, item.getExtendedPrice());
                item.setItemTaxAmount(taxAmount);
            }
        } else {
            KualiDecimal extendedPrice = item.getExtendedPrice();
            if (StringUtils.equals((CharSequence)item.getItemTypeCode(), (CharSequence)"ORDS")) {
                extendedPrice = this.getFullDiscountTaxablePrice(extendedPrice, purapDocument);
            }
            List taxDetails = this.taxService.getUseTaxDetails(transactionTaxDate, deliveryPostalCode, extendedPrice);
            ArrayList<PurApItemUseTax> newUseTaxItems = new ArrayList<PurApItemUseTax>();
            if (taxDetails != null) {
                for (TaxDetail taxDetail : taxDetails) {
                    try {
                        PurApItemUseTax useTaxItem = (PurApItemUseTax)itemUseTaxClass.newInstance();
                        useTaxItem.setChartOfAccountsCode(taxDetail.getChartOfAccountsCode());
                        useTaxItem.setFinancialObjectCode(taxDetail.getFinancialObjectCode());
                        useTaxItem.setAccountNumber(taxDetail.getAccountNumber());
                        useTaxItem.setItemIdentifier(item.getItemIdentifier());
                        useTaxItem.setRateCode(taxDetail.getRateCode());
                        useTaxItem.setTaxAmount(taxDetail.getTaxAmount());
                        newUseTaxItems.add(useTaxItem);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            item.setUseTaxItems(newUseTaxItems);
        }
    }

    public KualiDecimal getFullDiscountTaxablePrice(KualiDecimal extendedPrice, PurchasingAccountsPayableDocument purapDocument) {
        KualiDecimal taxablePrice = KualiDecimal.ZERO;
        KualiDecimal taxableLineItemPrice = KualiDecimal.ZERO;
        KualiDecimal totalLineItemPrice = KualiDecimal.ZERO;
        boolean useTaxIndicator = purapDocument.isUseTaxIndicator();
        String deliveryState = this.getDeliveryState(purapDocument);
        for (PurApItem item : purapDocument.getItems()) {
            if (!item.getItemType().isLineItemIndicator() || !ObjectUtils.isNotNull((Object)item.getExtendedPrice())) continue;
            if (this.isTaxable(useTaxIndicator, deliveryState, item)) {
                taxableLineItemPrice = (KualiDecimal)taxableLineItemPrice.add((AbstractKualiDecimal)item.getExtendedPrice());
                totalLineItemPrice = (KualiDecimal)totalLineItemPrice.add((AbstractKualiDecimal)item.getExtendedPrice());
                continue;
            }
            totalLineItemPrice = (KualiDecimal)totalLineItemPrice.add((AbstractKualiDecimal)item.getExtendedPrice());
        }
        if (totalLineItemPrice.isNonZero() && ObjectUtils.isNotNull((Object)extendedPrice)) {
            taxablePrice = (KualiDecimal)((KualiDecimal)taxableLineItemPrice.divide((AbstractKualiDecimal)totalLineItemPrice)).multiply((AbstractKualiDecimal)extendedPrice);
        }
        return taxablePrice;
    }

    @Override
    public void prorateForTradeInAndFullOrderDiscount(PurchasingAccountsPayableDocument purDoc) {
        List<PurApAccountingLine> distributedAccounts;
        List<SourceAccountingLine> summaryAccounts;
        KualiDecimal totalAmount;
        if (purDoc instanceof VendorCreditMemoDocument) {
            throw new RuntimeException("This method not applicable for VCM documents");
        }
        PurApItem fullOrderDiscount = null;
        PurApItem tradeIn = null;
        for (PurApItem item : purDoc.getItems()) {
            if (item.getItemTypeCode().equals("ORDS")) {
                fullOrderDiscount = item;
                continue;
            }
            if (!item.getItemTypeCode().equals("TRDI")) continue;
            tradeIn = item;
        }
        if (fullOrderDiscount != null && fullOrderDiscount.getExtendedPrice() != null && fullOrderDiscount.getExtendedPrice().isNonZero()) {
            KNSGlobalVariables.getMessageList().add("Full order discount accounts cleared and regenerated", new String[0]);
            fullOrderDiscount.getSourceAccountingLines().clear();
            totalAmount = (KualiDecimal)purDoc.getTotalDollarAmountAboveLineItems().subtract((AbstractKualiDecimal)purDoc.getTotalTaxAmountAboveLineItems());
            KualiDecimal totalTaxAmount = purDoc.getTotalTaxAmountAboveLineItems();
            this.purapAccountingService.updateAccountAmounts(purDoc);
            boolean salesTaxInd = this.parameterService.getParameterValueAsBoolean(KfsParameterConstants.PURCHASING_DOCUMENT.class, "ENABLE_SALES_TAX_IND");
            boolean useTaxIndicator = purDoc.isUseTaxIndicator();
            if (salesTaxInd && ObjectUtils.isNull((Object)fullOrderDiscount.getItemTaxAmount()) && !useTaxIndicator) {
                KualiDecimal discountAmount = fullOrderDiscount.getExtendedPrice();
                KualiDecimal discountTaxAmount = (KualiDecimal)((KualiDecimal)discountAmount.divide((AbstractKualiDecimal)totalAmount)).multiply((AbstractKualiDecimal)totalTaxAmount);
                fullOrderDiscount.setItemTaxAmount(discountTaxAmount);
            }
            if ((summaryAccounts = this.purapAccountingService.generateSummary(PurApItemUtils.getAboveTheLineOnly(purDoc.getItems()))).size() == 0) {
                if (purDoc.shouldGiveErrorForEmptyAccountsProration()) {
                    GlobalVariables.getMessageMap().putError("document.item*,newPurchasingItemLine*,itemQuantity,document.grandTotal,accountDistributionnewSourceLine*,distributePurchasingCommodityCode,accountNumber*,chartOfAccountsCode*", "errors.summary.accounts.list.empty", new String[]{"full order discount"});
                }
            } else {
                distributedAccounts = this.purapAccountingService.generateAccountDistributionForProration(summaryAccounts, (KualiDecimal)totalAmount.add((AbstractKualiDecimal)totalTaxAmount), 2, fullOrderDiscount.getAccountingLineClass());
                for (PurApAccountingLine distributedAccount : distributedAccounts) {
                    BigDecimal percent = distributedAccount.getAccountLinePercent();
                    BigDecimal roundedPercent = new BigDecimal(Math.round(percent.doubleValue()));
                    distributedAccount.setAccountLinePercent(roundedPercent);
                }
                this.purapAccountingService.updateAccountAmountsWithTotal(distributedAccounts, totalAmount, fullOrderDiscount.getTotalAmount());
                fullOrderDiscount.setSourceAccountingLines(distributedAccounts);
            }
        } else if (fullOrderDiscount != null && (fullOrderDiscount.getExtendedPrice() == null || fullOrderDiscount.getExtendedPrice().isZero())) {
            fullOrderDiscount.getSourceAccountingLines().clear();
        }
        if (tradeIn != null && tradeIn.getExtendedPrice() != null && tradeIn.getExtendedPrice().isNonZero()) {
            tradeIn.getSourceAccountingLines().clear();
            totalAmount = purDoc.getTotalDollarAmountForTradeIn();
            KualiDecimal tradeInTotalAmount = tradeIn.getTotalAmount();
            this.purapAccountingService.updateAccountAmounts(purDoc);
            ArrayList<PurApItem> clonedTradeInItems = new ArrayList<PurApItem>();
            ArrayList objectSubTypesRequiringQty = new ArrayList(this.parameterService.getParameterValuesAsString(KfsParameterConstants.PURCHASING_DOCUMENT.class, "OBJECT_SUB_TYPES_REQUIRING_QUANTITY"));
            ArrayList purchasingObjectSubTypes = new ArrayList(this.parameterService.getParameterValuesAsString(KfsParameterConstants.CAPITAL_ASSETS_DOCUMENT.class, "PURCHASING_OBJECT_SUB_TYPES"));
            String tradeInCapitalObjectCode = this.parameterService.getParameterValueAsString("KFS-PURAP", "Document", "TRADE_IN_OBJECT_CODE_FOR_CAPITAL_ASSET");
            String tradeInCapitalLeaseObjCd = this.parameterService.getParameterValueAsString("KFS-PURAP", "Document", "TRADE_IN_OBJECT_CODE_FOR_CAPITAL_LEASE");
            for (PurApItem item : purDoc.getTradeInItems()) {
                PurApItem cloneItem = (PurApItem)((Object)ObjectUtils.deepCopy((Serializable)((Object)item)));
                List<PurApAccountingLine> sourceAccountingLines = cloneItem.getSourceAccountingLines();
                for (PurApAccountingLine accountingLine : sourceAccountingLines) {
                    if (objectSubTypesRequiringQty.contains(accountingLine.getObjectCode().getFinancialObjectSubTypeCode())) {
                        accountingLine.setFinancialObjectCode(tradeInCapitalObjectCode);
                        continue;
                    }
                    if (!purchasingObjectSubTypes.contains(accountingLine.getObjectCode().getFinancialObjectSubTypeCode())) continue;
                    accountingLine.setFinancialObjectCode(tradeInCapitalLeaseObjCd);
                }
                clonedTradeInItems.add(cloneItem);
            }
            summaryAccounts = this.purapAccountingService.generateSummary(clonedTradeInItems);
            if (summaryAccounts.size() == 0) {
                if (purDoc.shouldGiveErrorForEmptyAccountsProration()) {
                    GlobalVariables.getMessageMap().putError("document.item*,newPurchasingItemLine*,itemQuantity,document.grandTotal,accountDistributionnewSourceLine*,distributePurchasingCommodityCode,accountNumber*,chartOfAccountsCode*", "errors.summary.accounts.list.empty", new String[]{"trade in"});
                }
            } else {
                distributedAccounts = this.purapAccountingService.generateAccountDistributionForProration(summaryAccounts, totalAmount, 2, tradeIn.getAccountingLineClass());
                for (PurApAccountingLine distributedAccount : distributedAccounts) {
                    BigDecimal percent = distributedAccount.getAccountLinePercent();
                    BigDecimal roundedPercent = new BigDecimal(Math.round(percent.doubleValue()));
                    distributedAccount.setAccountLinePercent(roundedPercent);
                    this.resetAccountAmount(distributedAccount, tradeInTotalAmount);
                }
                tradeIn.setSourceAccountingLines(distributedAccounts);
            }
        }
    }

    private void resetAccountAmount(PurApAccountingLine distributedAccount, KualiDecimal tradeInTotalAmount) {
        BigDecimal pct = distributedAccount.getAccountLinePercent();
        BigDecimal amount = tradeInTotalAmount.bigDecimalValue().multiply(pct).divide(new BigDecimal(100));
        distributedAccount.setAmount(new KualiDecimal(amount));
    }

    @Override
    public void clearAllTaxes(PurchasingAccountsPayableDocument purapDoc) {
        if (purapDoc.getItems() != null) {
            for (int i = 0; i < purapDoc.getItems().size(); ++i) {
                PurApItem item = purapDoc.getItems().get(i);
                if (purapDoc.isUseTaxIndicator()) {
                    item.setUseTaxItems(new ArrayList<PurApItemUseTax>());
                    continue;
                }
                item.setItemTaxAmount(null);
            }
        }
    }

    @Override
    public boolean isItemTypeConflictWithTaxPolicy(PurchasingDocument purchasingDocument, PurApItem item) {
        boolean conflict = false;
        String deliveryState = this.getDeliveryState(purchasingDocument);
        if (item.getItemType().isLineItemIndicator()) {
            if (item.getItemType().isTaxableIndicator() && this.isTaxDisabledForVendor(purchasingDocument)) {
                conflict = true;
            }
            if (!item.getSourceAccountingLines().isEmpty() && !this.doesAccountAllowCallToTaxService(deliveryState, item)) {
                conflict = true;
            }
        }
        return conflict;
    }

    protected boolean isTaxDisabledForVendor(PurchasingDocument purapDocument) {
        return false;
    }

    public PurapAccountingService getPurapAccountingService() {
        return this.purapAccountingService;
    }

    public void setPurapAccountingService(PurapAccountingService purapAccountingService) {
        this.purapAccountingService = purapAccountingService;
    }

    protected ParameterEvaluatorService getParameterEvaluatorService() {
        return this.parameterEvaluatorService;
    }

    public void setParameterEvaluatorService(ParameterEvaluatorService parameterEvaluatorService) {
        this.parameterEvaluatorService = parameterEvaluatorService;
    }
}

