/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.MessageMap;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocument;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.document.AccountingDocument;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class PurchasingAccountsPayableFixErrorPathValidation
extends GenericValidation {
    private static final Logger LOG = LogManager.getLogger();
    private AccountingLine accountingLineForValidation;

    public boolean validate(AttributedDocumentEvent event) {
        this.fixErrorPath((AccountingDocument)event.getDocument(), this.accountingLineForValidation);
        return true;
    }

    private void fixErrorPath(AccountingDocument financialDocument, AccountingLine accountingLine) {
        List<PurApItem> items = ((PurchasingAccountsPayableDocument)financialDocument).getItems();
        if (accountingLine.isSourceAccountingLine()) {
            PurApAccountingLine targetAccountingLineToBeFound = (PurApAccountingLine)accountingLine;
            StringBuilder errorPath = new StringBuilder("document");
            boolean done = false;
            int itemLineIndex = 0;
            Iterator<PurApItem> iterItemEntries = items.iterator();
            while (!done && iterItemEntries.hasNext()) {
                PurApItem item = iterItemEntries.next();
                int accountingLineCounter = 0;
                Iterator<PurApAccountingLine> iterSourceAccountingLines = item.getSourceAccountingLines().iterator();
                while (!done && iterSourceAccountingLines.hasNext()) {
                    PurApAccountingLine sourceAccountingLine = iterSourceAccountingLines.next();
                    if (targetAccountingLineToBeFound.getSequenceNumber().equals(sourceAccountingLine.getSequenceNumber())) {
                        errorPath.append(".").append("item").append("[").append(itemLineIndex).append("].").append("sourceAccountingLines").append("[").append(accountingLineCounter).append("]");
                        done = true;
                    }
                    ++accountingLineCounter;
                }
                ++itemLineIndex;
            }
            if (!done) {
                LOG.warn("fixErrorPath failed to locate item accountingLine=" + accountingLine);
            }
            MessageMap errorMap = GlobalVariables.getMessageMap();
            errorMap.clearErrorPath();
            errorMap.addToErrorPath(errorPath.toString());
        }
    }

    public AccountingLine getAccountingLineForValidation() {
        return this.accountingLineForValidation;
    }

    public void setAccountingLineForValidation(AccountingLine accountingLineForValidation) {
        this.accountingLineForValidation = accountingLineForValidation;
    }
}

