/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.kew.api.document.DocumentStatus;
import org.kuali.kfs.kim.api.identity.Person;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.service.MyOrdersService;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;

public class MyOrdersServiceImpl
implements MyOrdersService {
    protected BusinessObjectService businessObjectService;
    protected static final List<String> DOCUMENT_STATUS_CODES = Arrays.asList(DocumentStatus.SAVED.getCode(), DocumentStatus.CANCELED.getCode(), DocumentStatus.DISAPPROVED.getCode(), DocumentStatus.ENROUTE.getCode(), DocumentStatus.EXCEPTION.getCode(), DocumentStatus.FINAL.getCode(), DocumentStatus.INITIATED.getCode(), DocumentStatus.RECALLED.getCode(), DocumentStatus.PROCESSED.getCode());

    @Override
    public List<Map<String, Object>> getLatestOrders(Person user, Integer count) {
        List<FinancialSystemDocumentHeader> latestRequisitions = this.findLatestRequisitionsForUser(user, count);
        if (latestRequisitions.isEmpty()) {
            return new ArrayList<Map<String, Object>>();
        }
        return latestRequisitions.stream().map(docHeader -> this.retrieveRequisition(docHeader.getDocumentNumber())).filter(req -> !ObjectUtils.isNull((Object)req)).map(this::convertDocumentInfoToMap).collect(Collectors.toList());
    }

    protected Map<String, Object> convertDocumentInfoToMap(RequisitionDocument req) {
        ConcurrentHashMap<String, Object> requisitionRepresentation = new ConcurrentHashMap<String, Object>();
        FinancialSystemDocumentHeader docHeader = (FinancialSystemDocumentHeader)req.getDocumentHeader();
        requisitionRepresentation.put("documentNumber", docHeader.getDocumentNumber());
        requisitionRepresentation.put("requisitionIdentifier", req.getPurapDocumentIdentifier());
        if (StringUtils.isNotBlank((CharSequence)req.getVendorName())) {
            requisitionRepresentation.put("vendorName", req.getVendorName());
        }
        requisitionRepresentation.put("documentDescription", docHeader.getDocumentDescription());
        requisitionRepresentation.put("workflowCreateDate", docHeader.getWorkflowCreateDate());
        requisitionRepresentation.put("workflowDocumentStatusCode", DocumentStatus.fromCode((String)docHeader.getWorkflowDocumentStatusCode()).getLabel());
        return requisitionRepresentation;
    }

    protected RequisitionDocument retrieveRequisition(String documentNumber) {
        ConcurrentHashMap<String, String> fieldValues = new ConcurrentHashMap<String, String>();
        fieldValues.put("documentNumber", documentNumber);
        Collection requisitionDocuments = this.getBusinessObjectService().findMatching(RequisitionDocument.class, fieldValues);
        RequisitionDocument req = null;
        Iterator iterator = requisitionDocuments.iterator();
        while (iterator.hasNext()) {
            RequisitionDocument requisitionDocument;
            req = requisitionDocument = (RequisitionDocument)iterator.next();
        }
        return req;
    }

    protected List<FinancialSystemDocumentHeader> findLatestRequisitionsForUser(Person user, Integer count) {
        ConcurrentHashMap<String, Object> fieldValues = new ConcurrentHashMap<String, Object>();
        fieldValues.put("workflowDocumentTypeName", "REQS");
        fieldValues.put("initiatorPrincipalId", user.getPrincipalId());
        fieldValues.put("workflowDocumentStatusCode", DOCUMENT_STATUS_CODES);
        Collection headers = this.getBusinessObjectService().findMatchingOrderBy(FinancialSystemDocumentHeader.class, fieldValues, "workflowCreateDate", false);
        ArrayList<FinancialSystemDocumentHeader> limitedHeaders = new ArrayList<FinancialSystemDocumentHeader>();
        int c = 0;
        for (FinancialSystemDocumentHeader header : headers) {
            if (c < count) {
                limitedHeaders.add(header);
            }
            ++c;
        }
        return limitedHeaders;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

