/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.service.impl;

import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coa.businessobject.SubObjectCode;
import org.kuali.kfs.coa.service.ObjectCodeService;
import org.kuali.kfs.coa.service.SubObjectCodeService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.service.impl.PurapAccountingLineRuleHelperServiceImpl;
import org.kuali.kfs.sys.businessobject.AccountingLine;

public class PurchasingAccountingLineRuleHelperServiceImpl
extends PurapAccountingLineRuleHelperServiceImpl {
    private ObjectCodeService objectCodeService;
    private SubObjectCodeService subObjectCodeService;

    @Override
    public boolean hasRequiredOverrides(AccountingLine line, String overrideCode) {
        boolean retVal = true;
        Account account = line.getAccount();
        if (!ObjectUtils.isNull((Object)account) && account.isExpired()) {
            GlobalVariables.getMessageMap().putError("accountNumber", "errors.item.accounting.expired", new String[]{account.getAccountNumber()});
            retVal = false;
        }
        return retVal;
    }

    public boolean isValidObjectCode(ObjectCode objectCode, String errorPropertyName) {
        String label = this.getObjectCodeLabel();
        if (ObjectUtils.isNull((Object)objectCode)) {
            GlobalVariables.getMessageMap().putError(errorPropertyName, "error.existence", new String[]{label});
            return false;
        }
        Integer universityFiscalYear = this.getDocument().getPostingYearNextOrCurrent();
        ObjectCode objectCodeForValidation = this.objectCodeService.getByPrimaryId(universityFiscalYear, objectCode.getChartOfAccountsCode(), objectCode.getFinancialObjectCode());
        if (objectCodeForValidation == null || !objectCodeForValidation.isFinancialObjectActiveCode()) {
            GlobalVariables.getMessageMap().putError(errorPropertyName, "error.inactive", new String[]{label});
            return false;
        }
        return true;
    }

    public boolean isValidSubObjectCode(SubObjectCode subObjectCode, String errorPropertyName) {
        String label = this.getSubObjectCodeLabel();
        if (ObjectUtils.isNull((Object)subObjectCode)) {
            GlobalVariables.getMessageMap().putError(errorPropertyName, "error.existence", new String[]{label});
            return false;
        }
        Integer universityFiscalYear = this.getDocument().getPostingYearNextOrCurrent();
        SubObjectCode subObjectCodeForValidation = this.subObjectCodeService.getByPrimaryId(universityFiscalYear, subObjectCode.getChartOfAccountsCode(), subObjectCode.getAccountNumber(), subObjectCode.getFinancialObjectCode(), subObjectCode.getFinancialSubObjectCode());
        if (!subObjectCodeForValidation.isActive()) {
            GlobalVariables.getMessageMap().putError(errorPropertyName, "error.inactive", new String[]{label});
            return false;
        }
        return true;
    }

    protected ObjectCodeService getObjectCodeService() {
        return this.objectCodeService;
    }

    public void setObjectCodeService(ObjectCodeService objectCodeService) {
        this.objectCodeService = objectCodeService;
    }

    protected SubObjectCodeService getSubObjectCodeService() {
        return this.subObjectCodeService;
    }

    public void setSubObjectCodeService(SubObjectCodeService subObjectCodeService) {
        this.subObjectCodeService = subObjectCodeService;
    }
}

