/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.authorization;

import java.util.HashSet;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.kew.api.WorkflowDocument;
import org.kuali.kfs.kew.api.document.DocumentStatus;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.authorization.PaymentRequestDocumentPresentationController;
import org.kuali.kfs.sys.businessobject.DocumentHeader;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@Execution(value=ExecutionMode.SAME_THREAD)
public class PaymentRequestDocumentPresentationControllerTest {
    PaymentRequestDocumentPresentationController cut;
    @Mock
    private PaymentRequestDocument preqMock;
    @Mock
    private DocumentHeader docHeaderMock;
    @Mock
    WorkflowDocument workflowDocMock;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.cut = new PaymentRequestDocumentPresentationController();
    }

    @Test
    public void addACHSignupInfoModeWhenPREQInFinalState() {
        this.createPREQMock(DocumentStatus.FINAL);
        HashSet editModes = new HashSet();
        this.cut.addACHSignUpInfoMode((Document)this.preqMock, editModes);
        Assert.assertFalse((boolean)editModes.contains("achAccountInfoDisplayed"));
    }

    @Test
    public void addACHSignupInfoModeWhenPREQInProcessedState() throws Exception {
        this.createPREQMock(DocumentStatus.PROCESSED);
        HashSet editModes = new HashSet();
        this.cut.addACHSignUpInfoMode((Document)this.preqMock, editModes);
        Assert.assertFalse((boolean)editModes.contains("achAccountInfoDisplayed"));
    }

    @Test
    public void addACHSignupInfoModeWhenPREQInDisapprovedState() throws Exception {
        this.createPREQMock(DocumentStatus.DISAPPROVED);
        HashSet editModes = new HashSet();
        this.cut.addACHSignUpInfoMode((Document)this.preqMock, editModes);
        Assert.assertFalse((boolean)editModes.contains("achAccountInfoDisplayed"));
    }

    @Test
    public void addACHSignupInfoModeWhenPREQInEnrouteState() throws Exception {
        this.createPREQMock(DocumentStatus.ENROUTE);
        HashSet editModes = new HashSet();
        this.cut.addACHSignUpInfoMode((Document)this.preqMock, editModes);
        Assert.assertTrue((boolean)editModes.contains("achAccountInfoDisplayed"));
    }

    private void createPREQMock(DocumentStatus status) {
        WorkflowDocument workflowDocument = this.workflowDocMock;
        Mockito.when((Object)this.workflowDocMock.getStatus()).thenReturn((Object)status);
        Mockito.when((Object)this.workflowDocMock.isEnroute()).thenReturn((Object)(status == DocumentStatus.ENROUTE ? 1 : 0));
        Mockito.when((Object)this.workflowDocMock.isDisapproved()).thenReturn((Object)(status == DocumentStatus.DISAPPROVED ? 1 : 0));
        Mockito.when((Object)this.workflowDocMock.isProcessed()).thenReturn((Object)(status == DocumentStatus.PROCESSED ? 1 : 0));
        Mockito.when((Object)this.workflowDocMock.isFinal()).thenReturn((Object)(status == DocumentStatus.FINAL ? 1 : 0));
        Mockito.when((Object)this.docHeaderMock.getWorkflowDocument()).thenReturn((Object)workflowDocument);
        Mockito.when((Object)this.preqMock.getDocumentHeader()).thenReturn((Object)this.docHeaderMock);
    }
}

