/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.service;

import java.util.HashSet;
import java.util.List;
import org.kuali.kfs.kew.api.WorkflowDocument;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.document.service.RequisitionService;
import org.kuali.kfs.module.purap.fixture.RequisitionDocumentFixture;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiIntegTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.AccountingDocument;
import org.kuali.kfs.sys.document.AccountingDocumentTestUtils;
import org.kuali.kfs.sys.document.workflow.WorkflowTestUtils;
import org.kuali.kfs.sys.fixture.UserNameFixture;

@ConfigureContext(session=UserNameFixture.parke)
public class RequisitionServiceIntegTest
extends KualiIntegTestBase {
    private static final String ACCOUNT_REVIEW = "Account";
    private DocumentService docService;
    private RequisitionService reqService;
    private DocumentService documentService;
    private BusinessObjectService businessObjectService;

    protected void setUp() throws Exception {
        super.setUp();
        if (null == this.reqService) {
            this.reqService = (RequisitionService)SpringContext.getBean(RequisitionService.class);
        }
        if (null == this.documentService) {
            this.documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        }
        if (null == this.businessObjectService) {
            this.businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        }
    }

    private RequisitionDocument routeReqToFinal(RequisitionDocument requistionDocument) throws Exception {
        String docid = requistionDocument.getDocumentNumber();
        AccountingDocumentTestUtils.routeDocument((AccountingDocument)requistionDocument, (DocumentService)((DocumentService)SpringContext.getBean(DocumentService.class)));
        WorkflowTestUtils.waitForNodeChange((WorkflowDocument)requistionDocument.getDocumentHeader().getWorkflowDocument(), (String)ACCOUNT_REVIEW);
        this.changeCurrentUser(UserNameFixture.sterner);
        requistionDocument = (RequisitionDocument)((DocumentService)SpringContext.getBean(DocumentService.class)).getByDocumentHeaderId(docid);
        ((DocumentService)SpringContext.getBean(DocumentService.class)).approveDocument((Document)requistionDocument, "Test approving as sterner", null);
        return requistionDocument;
    }

    public void testIsAutomaticPurchaseOrderAllowed_Valid() {
        RequisitionDocument requisitionDocument = RequisitionDocumentFixture.REQ_APO_VALID.createRequisitionDocument();
        RequisitionServiceIntegTest.assertTrue((boolean)this.reqService.isAutomaticPurchaseOrderAllowed(requisitionDocument));
    }

    public void testIsAutomaticPurchaseOrderAllowed_Alternative() {
        RequisitionDocument requisitionDocument = RequisitionDocumentFixture.REQ_ALTERNATE_APO.createRequisitionDocument();
        RequisitionServiceIntegTest.assertTrue((boolean)this.reqService.isAutomaticPurchaseOrderAllowed(requisitionDocument));
    }

    public void testGetDocumentsNumbersAwaitingContractManagerAssignment() throws Exception {
        HashSet<String> docIds = new HashSet<String>();
        RequisitionDocument req1 = this.routeReqToFinal(RequisitionDocumentFixture.REQ_NO_APO_VALID.createRequisitionDocument());
        RequisitionDocument req2 = this.routeReqToFinal(RequisitionDocumentFixture.REQ_TWO_ITEMS.createRequisitionDocument());
        RequisitionDocument req3 = RequisitionDocumentFixture.REQ_APO_VALID.createRequisitionDocument();
        req3.setApplicationDocumentStatus("Awaiting Contract Manager Assignment");
        this.documentService.saveDocument((Document)req3);
        List reqs = this.reqService.getRequisitionsAwaitingContractManagerAssignment();
        for (RequisitionDocument req : reqs) {
            docIds.add(req.getDocumentNumber());
        }
        RequisitionServiceIntegTest.assertTrue((boolean)docIds.contains(req1.getDocumentNumber()));
        RequisitionServiceIntegTest.assertTrue((!docIds.contains(req2.getDocumentNumber()) ? 1 : 0) != 0);
        RequisitionServiceIntegTest.assertTrue((!docIds.contains(req3.getDocumentNumber()) ? 1 : 0) != 0);
    }
}

