/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.service.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.kew.api.document.WorkflowDocumentService;
import org.kuali.kfs.kew.routeheader.DocumentStatusTransition;
import org.kuali.kfs.module.purap.document.AccountsPayableDocument;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.VendorCreditMemoDocument;
import org.kuali.kfs.module.purap.document.service.impl.AccountsPayableServiceImpl;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@Execution(value=ExecutionMode.SAME_THREAD)
public class AccountsPayableServiceImplTest {
    private static final String DOCUMENT_NUMBER1 = "123456";
    private static final String DOCUMENT_NUMBER2 = "654321";
    private AccountsPayableServiceImpl cut;
    @Mock
    private PaymentRequestDocument paymentRequestDocumentMock;
    @Mock
    private VendorCreditMemoDocument vendorCreditMemoDocumentMock;
    @Mock
    private WorkflowDocumentService workflowDocumentServiceMock;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.cut = new AccountsPayableServiceImpl();
        this.cut.setWorkflowDocumentService(this.workflowDocumentServiceMock);
        Mockito.when((Object)this.paymentRequestDocumentMock.getDocumentNumber()).thenReturn((Object)DOCUMENT_NUMBER1);
        Mockito.when((Object)this.vendorCreditMemoDocumentMock.getDocumentNumber()).thenReturn((Object)DOCUMENT_NUMBER2);
        List<DocumentStatusTransition> preqDocumentStatusTransitions = this.setupPreqDocumentStatusTransitions();
        ((WorkflowDocumentService)Mockito.doReturn(preqDocumentStatusTransitions).when((Object)this.workflowDocumentServiceMock)).getDocumentStatusTransitionHistory(DOCUMENT_NUMBER1);
        List<DocumentStatusTransition> cmDocumentStatusTransitions = this.setupCmDocumentStatusTransitions();
        ((WorkflowDocumentService)Mockito.doReturn(cmDocumentStatusTransitions).when((Object)this.workflowDocumentServiceMock)).getDocumentStatusTransitionHistory(DOCUMENT_NUMBER2);
    }

    private List<DocumentStatusTransition> setupPreqDocumentStatusTransitions() {
        ArrayList<DocumentStatusTransition> preqDocumentStatusTransitions = new ArrayList<DocumentStatusTransition>();
        preqDocumentStatusTransitions.add(this.setupDocumentStatusTransition(DOCUMENT_NUMBER1, "Department-Approved", "Cancelled", new Timestamp(3000L)));
        preqDocumentStatusTransitions.add(this.setupDocumentStatusTransition(DOCUMENT_NUMBER1, "In Process", "Department-Approved", new Timestamp(2000L)));
        preqDocumentStatusTransitions.add(this.setupDocumentStatusTransition(DOCUMENT_NUMBER1, "Initiated", "In Process", new Timestamp(1000L)));
        return preqDocumentStatusTransitions;
    }

    private List<DocumentStatusTransition> setupCmDocumentStatusTransitions() {
        ArrayList<DocumentStatusTransition> cmDocumentStatusTransitions = new ArrayList<DocumentStatusTransition>();
        cmDocumentStatusTransitions.add(this.setupDocumentStatusTransition(DOCUMENT_NUMBER2, "Complete", "Cancelled", new Timestamp(3000L)));
        cmDocumentStatusTransitions.add(this.setupDocumentStatusTransition(DOCUMENT_NUMBER2, "In Process", "Complete", new Timestamp(2000L)));
        cmDocumentStatusTransitions.add(this.setupDocumentStatusTransition(DOCUMENT_NUMBER2, "Initiated", "In Process", new Timestamp(1000L)));
        return cmDocumentStatusTransitions;
    }

    private DocumentStatusTransition setupDocumentStatusTransition(String documentNumber, String oldStatus, String newStatus, Timestamp timestamp) {
        DocumentStatusTransition documentStatusTransition = new DocumentStatusTransition(documentNumber, oldStatus, newStatus);
        documentStatusTransition.setStatusTransitionDate(timestamp);
        return documentStatusTransition;
    }

    @Test
    public void revertToPreviousAppDocStatus_PREQ() {
        this.cut.revertToPreviousAppDocStatus((AccountsPayableDocument)this.paymentRequestDocumentMock);
        ((PaymentRequestDocument)Mockito.verify((Object)this.paymentRequestDocumentMock)).updateAndSaveAppDocStatus("Department-Approved");
    }

    @Test
    public void revertToPreviousAppDocStatus_CM() {
        this.cut.revertToPreviousAppDocStatus((AccountsPayableDocument)this.vendorCreditMemoDocumentMock);
        ((VendorCreditMemoDocument)Mockito.verify((Object)this.vendorCreditMemoDocumentMock)).updateAndSaveAppDocStatus("Complete");
    }
}

