/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.pdf;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.kuali.kfs.core.api.config.property.ConfigurationService;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.module.purap.businessobject.ItemType;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderVendorQuote;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.pdf.PurchaseOrderQuotePdf;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiIntegTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.vnd.businessobject.ContractManager;

@ConfigureContext
public class PurchaseOrderQuotePdfIntegTest
extends KualiIntegTestBase {
    private PurchaseOrderVendorQuote poqv;
    private PurchaseOrderDocument po;
    private FileOutputStream fo;
    private ByteArrayOutputStream bao = new ByteArrayOutputStream();
    private PurchaseOrderQuotePdf poQuotePdf = new PurchaseOrderQuotePdf();

    protected void setUp() throws Exception {
        super.setUp();
        this.po = new PurchaseOrderDocument();
        this.po.setDeliveryCampusCode("BL");
        this.po.setPurapDocumentIdentifier(Integer.valueOf(1000));
        ContractManager contractManager = new ContractManager();
        contractManager.setContractManagerCode(Integer.valueOf(10));
        contractManager.setContractManagerName("Julia Child");
        contractManager.setContractManagerFaxNumber("800-111-1111");
        contractManager.setContractManagerPhoneNumber("800-222-2222");
        this.po.setContractManager(contractManager);
        this.po.setDeliveryCityName("Timbuktu");
        this.po.setDeliveryPostalCode("90210");
        this.po.setDeliveryStateCode("CA");
        this.po.setDeliveryCampusCode("BL");
        this.poqv = new PurchaseOrderVendorQuote();
        this.po.setPurchaseOrderQuoteDueDate(((DateTimeService)SpringContext.getBean(DateTimeService.class)).getCurrentSqlDate());
        this.poqv.setPurchaseOrder(this.po);
        this.poqv.setPurchaseOrderVendorQuoteIdentifier(Integer.valueOf(1000));
        this.poqv.setVendorName("Dusty's Cellar");
        this.poqv.setVendorHeaderGeneratedIdentifier(Integer.valueOf(1000));
        this.poqv.setVendorCityName("Okemos");
        this.poqv.setVendorCountryCode("US");
        this.poqv.setVendorLine1Address("1 Dobie Rd");
        this.poqv.setVendorFaxNumber("517-111-1FAX");
        this.poqv.setVendorPhoneNumber("1-800-DUSTY-CELL");
        this.poqv.setVendorPostalCode("48864");
        PurchaseOrderItem poi = new PurchaseOrderItem();
        ItemType it = new ItemType();
        it.setItemTypeCode("ITEM");
        it.setItemTypeDescription("ITEM");
        poi.setItemType(it);
        poi.setItemTypeCode(it.getItemTypeCode());
        poi.setItemDescription("Turtle Cheesecake");
        poi.setItemIdentifier(Integer.valueOf(1000));
        poi.setItemLineNumber(Integer.valueOf(1));
        poi.setItemQuantity(new KualiDecimal(2));
        poi.setItemUnitOfMeasureCode("piece");
        poi.setItemUnitPrice(new BigDecimal("5.50"));
        ArrayList<PurchaseOrderItem> itemList = new ArrayList<PurchaseOrderItem>();
        itemList.add(poi);
        this.po.setItems(itemList);
        this.fo = new FileOutputStream("POQuotePDF.pdf");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.fo.close();
        this.bao.close();
        this.poQuotePdf.deletePdf("", "POQuotePDF.pdf");
    }

    public void testGeneratePOQuotePDF() throws Exception {
        String environment = ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("environment");
        this.poQuotePdf.generatePOQuotePDF(this.po, this.poqv, "Bloomington", "BL", this.getLogoImageName(), this.bao, environment);
        this.bao.writeTo(this.fo);
    }

    private String getLogoImageName() {
        return "";
    }
}

