/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.service.impl.purapgeneralledgerserviceimpl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.purap.businessobject.ItemType;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderAccount;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.document.PurchaseOrderCloseDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.service.PurapAccountingService;
import org.kuali.kfs.module.purap.service.impl.PurapGeneralLedgerServiceImpl;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.kfs.sys.document.GeneralLedgerPendingEntrySource;
import org.kuali.kfs.sys.service.GeneralLedgerPendingEntryService;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@Execution(value=ExecutionMode.SAME_THREAD)
public class GenerateEntriesClosePurchaseOrderTest {
    private PurapGeneralLedgerServiceImpl cut;
    @Mock
    private PurapAccountingService purapAccountingSvcMock;
    @Mock
    private GeneralLedgerPendingEntryService glPendingEntrySvcMock;
    @Mock
    private BusinessObjectService boServiceMock;
    @Mock
    private PurchaseOrderCloseDocument poCloseMock;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.cut = new PurapGeneralLedgerServiceImpl();
        this.cut.setPurapAccountingService(this.purapAccountingSvcMock);
        this.cut.setGeneralLedgerPendingEntryService(this.glPendingEntrySvcMock);
        this.cut.setBusinessObjectService(this.boServiceMock);
    }

    private void setUpBaseExpectations(List<PurchaseOrderItem> purchaseOrderItems, List<PurApItem> activePurchaseOrderItems, List<SourceAccountingLine> accountingLines, List<GeneralLedgerPendingEntry> pendingEntries) {
        Mockito.when((Object)this.poCloseMock.getItems()).thenReturn(purchaseOrderItems);
        Mockito.when((Object)this.poCloseMock.getItemsActiveOnly()).thenReturn(activePurchaseOrderItems);
        Mockito.when((Object)this.purapAccountingSvcMock.generateSummaryWithNoZeroTotalsUsingAlternateAmount(activePurchaseOrderItems)).thenReturn(accountingLines);
        this.poCloseMock.setGlOnlySourceAccountingLines(accountingLines);
        ((PurchaseOrderCloseDocument)Mockito.verify((Object)this.poCloseMock)).setGlOnlySourceAccountingLines(ArgumentMatchers.anyList());
        Mockito.when((Object)this.poCloseMock.getGlOnlySourceAccountingLines()).thenReturn(accountingLines);
        Mockito.when((Object)this.glPendingEntrySvcMock.generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySource)this.poCloseMock)).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.boServiceMock.save(pendingEntries)).thenReturn(null);
    }

    protected PurchaseOrderItem buildBasePurchaseOrderItem() {
        PurchaseOrderItem purchaseOrderItem = new PurchaseOrderItem();
        purchaseOrderItem.setItemLineNumber(Integer.valueOf(1));
        purchaseOrderItem.setItemDescription("Stuff");
        purchaseOrderItem.setItemActiveIndicator(true);
        purchaseOrderItem.setDocumentNumber("1");
        purchaseOrderItem.setItemIdentifier(Integer.valueOf(1));
        purchaseOrderItem.setSourceAccountingLines(new ArrayList());
        return purchaseOrderItem;
    }

    protected PurchaseOrderItem buildQuantityPurchaseOrderItem(KualiDecimal itemQuantity, BigDecimal itemUnitPrice) {
        PurchaseOrderItem purchaseOrderItem = this.buildBasePurchaseOrderItem();
        purchaseOrderItem.setItemQuantity(itemQuantity);
        purchaseOrderItem.setItemUnitPrice(itemUnitPrice);
        ItemType itemType = new ItemType();
        itemType.setQuantityBasedGeneralLedgerIndicator(true);
        itemType.setItemTypeCode("ITEM");
        purchaseOrderItem.setItemType(itemType);
        return purchaseOrderItem;
    }

    protected PurchaseOrderItem buildNonQuantityPurchaseOrderItem(KualiDecimal invoicedAmount) {
        PurchaseOrderItem purchaseOrderItem = this.buildBasePurchaseOrderItem();
        purchaseOrderItem.setItemInvoicedTotalAmount(invoicedAmount);
        ItemType itemType = new ItemType();
        itemType.setQuantityBasedGeneralLedgerIndicator(false);
        itemType.setItemTypeCode("ITEM");
        purchaseOrderItem.setItemType(itemType);
        return purchaseOrderItem;
    }

    private PurchaseOrderAccount buildAccountingLine(BigDecimal accountingLinePercent, KualiDecimal amount) {
        PurchaseOrderAccount accountingLine = new PurchaseOrderAccount();
        accountingLine.setAccountLinePercent(accountingLinePercent);
        accountingLine.setAmount(amount);
        return accountingLine;
    }

    @Test
    public void purchaseOrderCloseWithNoItems() {
        ArrayList<PurchaseOrderItem> purchaseOrderItems = new ArrayList<PurchaseOrderItem>();
        ArrayList<PurApItem> activePurchaseOrderItems = new ArrayList<PurApItem>();
        ArrayList<SourceAccountingLine> accountingLines = new ArrayList<SourceAccountingLine>();
        ArrayList<GeneralLedgerPendingEntry> pendingEntries = new ArrayList<GeneralLedgerPendingEntry>();
        this.setUpBaseExpectations(purchaseOrderItems, activePurchaseOrderItems, accountingLines, pendingEntries);
        this.cut.generateEntriesClosePurchaseOrder((PurchaseOrderDocument)this.poCloseMock);
        Assert.assertEquals((String)"Purchase Order Close should have no general ledger pending entries", (long)0L, (long)pendingEntries.size());
    }

    @Test
    public void purchaseOrderCloseWithOneQuantityItemOneAccountingLine() {
        PurchaseOrderItem purchaseOrderItem = this.buildQuantityPurchaseOrderItem(new KualiDecimal(20), new BigDecimal(5.0));
        PurchaseOrderAccount accountingLine = this.buildAccountingLine(new BigDecimal(100.0), new KualiDecimal(100.0));
        ArrayList<PurchaseOrderItem> purchaseOrderItems = new ArrayList<PurchaseOrderItem>();
        ArrayList<PurApItem> activePurchaseOrderItems = new ArrayList<PurApItem>();
        ArrayList<SourceAccountingLine> accountingLines = new ArrayList<SourceAccountingLine>();
        ArrayList<GeneralLedgerPendingEntry> pendingEntries = new ArrayList<GeneralLedgerPendingEntry>();
        purchaseOrderItem.setItemOutstandingEncumberedQuantity(new KualiDecimal(1.0));
        purchaseOrderItem.setItemOutstandingEncumberedAmount(new KualiDecimal(100.0));
        purchaseOrderItem.getSourceAccountingLines().add(accountingLine);
        purchaseOrderItems.add(purchaseOrderItem);
        activePurchaseOrderItems.add((PurApItem)purchaseOrderItem);
        accountingLines.add((SourceAccountingLine)accountingLine);
        this.setUpBaseExpectations(purchaseOrderItems, activePurchaseOrderItems, accountingLines, pendingEntries);
        Mockito.when((Object)this.poCloseMock.getGeneralLedgerPendingEntries()).thenReturn(pendingEntries);
        this.cut.generateEntriesClosePurchaseOrder((PurchaseOrderDocument)this.poCloseMock);
        Assert.assertEquals((String)"Purchase Order Item should have outstanding encumbered quantity set to zero", (Object)KualiDecimal.ZERO, (Object)purchaseOrderItem.getItemOutstandingEncumberedQuantity());
        Assert.assertEquals((String)"Purchase Order Item should have outstanding encumbered amount set to zero", (Object)KualiDecimal.ZERO, (Object)purchaseOrderItem.getItemOutstandingEncumberedAmount());
        Assert.assertEquals((String)"GL Amount on accounting line should be 100.00", (Object)new KualiDecimal(100.0), (Object)accountingLine.getAlternateAmountForGLEntryCreation());
        Assert.assertEquals((String)"Outstanding encumbrance amount on accounting line should be zero'd out", (Object)KualiDecimal.ZERO, (Object)accountingLine.getItemAccountOutstandingEncumbranceAmount());
    }

    @Test
    public void purchaseOrderCloseWithOneQuantityItemTwoAccountingLines() {
        PurchaseOrderItem purchaseOrderItem = this.buildQuantityPurchaseOrderItem(new KualiDecimal(20), new BigDecimal(5));
        PurchaseOrderAccount accountingLine1 = this.buildAccountingLine(new BigDecimal(50.0), new KualiDecimal(50.0));
        PurchaseOrderAccount accountingLine2 = this.buildAccountingLine(new BigDecimal(50.0), new KualiDecimal(50.0));
        ArrayList<PurchaseOrderItem> purchaseOrderItems = new ArrayList<PurchaseOrderItem>();
        ArrayList<PurApItem> activePurchaseOrderItems = new ArrayList<PurApItem>();
        ArrayList<SourceAccountingLine> accountingLines = new ArrayList<SourceAccountingLine>();
        ArrayList<GeneralLedgerPendingEntry> pendingEntries = new ArrayList<GeneralLedgerPendingEntry>();
        purchaseOrderItem.setItemOutstandingEncumberedQuantity(new KualiDecimal(1.0));
        purchaseOrderItem.setItemOutstandingEncumberedAmount(new KualiDecimal(100.0));
        purchaseOrderItem.getSourceAccountingLines().add(accountingLine1);
        purchaseOrderItem.getSourceAccountingLines().add(accountingLine2);
        purchaseOrderItems.add(purchaseOrderItem);
        activePurchaseOrderItems.add((PurApItem)purchaseOrderItem);
        accountingLines.add((SourceAccountingLine)accountingLine1);
        accountingLines.add((SourceAccountingLine)accountingLine2);
        this.setUpBaseExpectations(purchaseOrderItems, activePurchaseOrderItems, accountingLines, pendingEntries);
        Mockito.when((Object)this.poCloseMock.getGeneralLedgerPendingEntries()).thenReturn(pendingEntries);
        this.cut.generateEntriesClosePurchaseOrder((PurchaseOrderDocument)this.poCloseMock);
        Assert.assertEquals((String)"Purchase Order Item should have outstanding encumbered quantity set to zero", (Object)KualiDecimal.ZERO, (Object)purchaseOrderItem.getItemOutstandingEncumberedQuantity());
        Assert.assertEquals((String)"Purchase Order Item should have outstanding encumbered amount set to zero", (Object)KualiDecimal.ZERO, (Object)purchaseOrderItem.getItemOutstandingEncumberedAmount());
        Assert.assertEquals((String)"GL Amount on accounting line should be 50", (Object)new KualiDecimal(50), (Object)accountingLine1.getAlternateAmountForGLEntryCreation());
        Assert.assertEquals((String)"Outstanding encumbrance amount on accounting line should be zero'd out", (Object)KualiDecimal.ZERO, (Object)accountingLine1.getItemAccountOutstandingEncumbranceAmount());
        Assert.assertEquals((String)"GL Amount on accounting line should be 50", (Object)new KualiDecimal(50), (Object)accountingLine2.getAlternateAmountForGLEntryCreation());
        Assert.assertEquals((String)"Outstanding encumbrance amount on accounting line should be zero'd out", (Object)KualiDecimal.ZERO, (Object)accountingLine2.getItemAccountOutstandingEncumbranceAmount());
    }

    @Test
    public void purchaseOrderCloseWithTwoItems() {
        PurchaseOrderItem purchaseOrderItem1 = this.buildQuantityPurchaseOrderItem(new KualiDecimal(20), new BigDecimal(5.0));
        PurchaseOrderAccount accountingLine1 = this.buildAccountingLine(new BigDecimal(100.0), new KualiDecimal(100.0));
        ArrayList<PurchaseOrderItem> purchaseOrderItems = new ArrayList<PurchaseOrderItem>();
        ArrayList<PurApItem> activePurchaseOrderItems = new ArrayList<PurApItem>();
        ArrayList<SourceAccountingLine> accountingLines = new ArrayList<SourceAccountingLine>();
        ArrayList<GeneralLedgerPendingEntry> pendingEntries = new ArrayList<GeneralLedgerPendingEntry>();
        purchaseOrderItem1.setItemOutstandingEncumberedQuantity(new KualiDecimal(1.0));
        purchaseOrderItem1.setItemOutstandingEncumberedAmount(new KualiDecimal(100.0));
        purchaseOrderItem1.getSourceAccountingLines().add(accountingLine1);
        purchaseOrderItems.add(purchaseOrderItem1);
        activePurchaseOrderItems.add((PurApItem)purchaseOrderItem1);
        accountingLines.add((SourceAccountingLine)accountingLine1);
        PurchaseOrderItem purchaseOrderItem2 = this.buildQuantityPurchaseOrderItem(new KualiDecimal(5), new BigDecimal(5));
        PurchaseOrderAccount accountingLine2 = this.buildAccountingLine(new BigDecimal(100), new KualiDecimal(25));
        purchaseOrderItem2.setItemOutstandingEncumberedQuantity(new KualiDecimal(1.0));
        purchaseOrderItem2.setItemOutstandingEncumberedAmount(new KualiDecimal(100.0));
        purchaseOrderItem2.getSourceAccountingLines().add(accountingLine2);
        purchaseOrderItems.add(purchaseOrderItem2);
        activePurchaseOrderItems.add((PurApItem)purchaseOrderItem2);
        accountingLines.add((SourceAccountingLine)accountingLine2);
        this.setUpBaseExpectations(purchaseOrderItems, activePurchaseOrderItems, accountingLines, pendingEntries);
        Mockito.when((Object)this.poCloseMock.getGeneralLedgerPendingEntries()).thenReturn(pendingEntries);
        this.cut.generateEntriesClosePurchaseOrder((PurchaseOrderDocument)this.poCloseMock);
        Assert.assertEquals((String)"Purchase Order Item 1 should have outstanding encumbered quantity set to zero", (Object)KualiDecimal.ZERO, (Object)purchaseOrderItem1.getItemOutstandingEncumberedQuantity());
        Assert.assertEquals((String)"Purchase Order Item 1 should have outstanding encumbered amount set to zero", (Object)KualiDecimal.ZERO, (Object)purchaseOrderItem1.getItemOutstandingEncumberedAmount());
        Assert.assertEquals((String)"GL Amount on accounting line 1 should be 100.00", (Object)new KualiDecimal(100.0), (Object)accountingLine1.getAlternateAmountForGLEntryCreation());
        Assert.assertEquals((String)"Outstanding encumbrance amount on accounting line 1 should be zero'd out", (Object)KualiDecimal.ZERO, (Object)accountingLine1.getItemAccountOutstandingEncumbranceAmount());
        Assert.assertEquals((String)"Purchase Order Item 2 should have outstanding encumbered quantity set to zero", (Object)KualiDecimal.ZERO, (Object)purchaseOrderItem2.getItemOutstandingEncumberedQuantity());
        Assert.assertEquals((String)"Purchase Order Item 2 should have outstanding encumbered amount set to zero", (Object)KualiDecimal.ZERO, (Object)purchaseOrderItem2.getItemOutstandingEncumberedAmount());
        Assert.assertEquals((String)"GL Amount on accounting line 2 should be 25.00", (Object)new KualiDecimal(100.0), (Object)accountingLine2.getAlternateAmountForGLEntryCreation());
        Assert.assertEquals((String)"Outstanding encumbrance amount on accounting line 2 should be zero'd out", (Object)KualiDecimal.ZERO, (Object)accountingLine2.getItemAccountOutstandingEncumbranceAmount());
    }

    @Test
    public void purchaseOrderCloseWithOneActiveOneInactiveItem() {
        PurchaseOrderItem purchaseOrderItem1 = this.buildQuantityPurchaseOrderItem(new KualiDecimal(20), new BigDecimal(5.0));
        PurchaseOrderAccount accountingLine1 = this.buildAccountingLine(new BigDecimal(100.0), new KualiDecimal(100.0));
        ArrayList<PurchaseOrderItem> purchaseOrderItems = new ArrayList<PurchaseOrderItem>();
        ArrayList<PurApItem> activePurchaseOrderItems = new ArrayList<PurApItem>();
        ArrayList<SourceAccountingLine> accountingLines = new ArrayList<SourceAccountingLine>();
        ArrayList<GeneralLedgerPendingEntry> pendingEntries = new ArrayList<GeneralLedgerPendingEntry>();
        purchaseOrderItem1.setItemOutstandingEncumberedQuantity(new KualiDecimal(1.0));
        purchaseOrderItem1.setItemOutstandingEncumberedAmount(new KualiDecimal(100.0));
        purchaseOrderItem1.getSourceAccountingLines().add(accountingLine1);
        purchaseOrderItems.add(purchaseOrderItem1);
        activePurchaseOrderItems.add((PurApItem)purchaseOrderItem1);
        accountingLines.add((SourceAccountingLine)accountingLine1);
        PurchaseOrderItem purchaseOrderItem2 = this.buildQuantityPurchaseOrderItem(new KualiDecimal(5), new BigDecimal(5));
        PurchaseOrderAccount accountingLine2 = this.buildAccountingLine(new BigDecimal(100), new KualiDecimal(25));
        purchaseOrderItem2.setItemOutstandingEncumberedQuantity(new KualiDecimal(1.0));
        purchaseOrderItem2.setItemOutstandingEncumberedAmount(new KualiDecimal(100.0));
        purchaseOrderItem2.getSourceAccountingLines().add(accountingLine2);
        purchaseOrderItems.add(purchaseOrderItem2);
        activePurchaseOrderItems.add((PurApItem)purchaseOrderItem2);
        accountingLines.add((SourceAccountingLine)accountingLine2);
        purchaseOrderItem2.setItemActiveIndicator(false);
        this.setUpBaseExpectations(purchaseOrderItems, activePurchaseOrderItems, accountingLines, pendingEntries);
        Mockito.when((Object)this.poCloseMock.getGeneralLedgerPendingEntries()).thenReturn(pendingEntries);
        this.cut.generateEntriesClosePurchaseOrder((PurchaseOrderDocument)this.poCloseMock);
        Assert.assertEquals((String)"Purchase Order Item 1 should have outstanding encumbered quantity set to zero", (Object)KualiDecimal.ZERO, (Object)purchaseOrderItem1.getItemOutstandingEncumberedQuantity());
        Assert.assertEquals((String)"Purchase Order Item 1 should have outstanding encumbered amount set to zero", (Object)KualiDecimal.ZERO, (Object)purchaseOrderItem1.getItemOutstandingEncumberedAmount());
        Assert.assertEquals((String)"GL Amount on accounting line 1 should be 100.00", (Object)new KualiDecimal(100.0), (Object)accountingLine1.getAlternateAmountForGLEntryCreation());
        Assert.assertEquals((String)"Outstanding encumbrance amount on accounting line 1 should be zero'd out", (Object)KualiDecimal.ZERO, (Object)accountingLine1.getItemAccountOutstandingEncumbranceAmount());
        Assert.assertEquals((String)"Purchase Order Item 2 should have outstanding encumbered quantity set to zero", (Object)KualiDecimal.ZERO, (Object)purchaseOrderItem2.getItemOutstandingEncumberedQuantity());
        Assert.assertEquals((String)"Purchase Order Item 2 should have outstanding encumbered amount set to zero", (Object)KualiDecimal.ZERO, (Object)purchaseOrderItem2.getItemOutstandingEncumberedAmount());
        Assert.assertEquals((String)"GL Amount on accounting line 2 should be zero", (Object)KualiDecimal.ZERO, (Object)accountingLine2.getAlternateAmountForGLEntryCreation());
        Assert.assertEquals((String)"Outstanding encumbrance amount on accounting line 2 should be zero'd out", (Object)KualiDecimal.ZERO, (Object)accountingLine2.getItemAccountOutstandingEncumbranceAmount());
    }

    @Test
    public void purchaseOrderCloseWithOneNonQuantityItemOneAccountingLine() {
        PurchaseOrderItem purchaseOrderItem = this.buildNonQuantityPurchaseOrderItem(new KualiDecimal(105.0));
        PurchaseOrderAccount accountingLine = this.buildAccountingLine(new BigDecimal(100.0), new KualiDecimal(105.0));
        ArrayList<PurchaseOrderItem> purchaseOrderItems = new ArrayList<PurchaseOrderItem>();
        ArrayList<PurApItem> activePurchaseOrderItems = new ArrayList<PurApItem>();
        ArrayList<SourceAccountingLine> accountingLines = new ArrayList<SourceAccountingLine>();
        ArrayList<GeneralLedgerPendingEntry> pendingEntries = new ArrayList<GeneralLedgerPendingEntry>();
        purchaseOrderItem.setItemOutstandingEncumberedAmount(new KualiDecimal(105.0));
        purchaseOrderItem.getSourceAccountingLines().add(accountingLine);
        purchaseOrderItems.add(purchaseOrderItem);
        activePurchaseOrderItems.add((PurApItem)purchaseOrderItem);
        accountingLines.add((SourceAccountingLine)accountingLine);
        this.setUpBaseExpectations(purchaseOrderItems, activePurchaseOrderItems, accountingLines, pendingEntries);
        Mockito.when((Object)this.poCloseMock.getGeneralLedgerPendingEntries()).thenReturn(pendingEntries);
        this.cut.generateEntriesClosePurchaseOrder((PurchaseOrderDocument)this.poCloseMock);
        Assert.assertNull((String)"Purchase Order Item should have outstanding encumbered quantity set to null", (Object)purchaseOrderItem.getItemOutstandingEncumberedQuantity());
        Assert.assertEquals((String)"Purchase Order Item should have outstanding encumbered amount set to zero", (Object)KualiDecimal.ZERO, (Object)purchaseOrderItem.getItemOutstandingEncumberedAmount());
        Assert.assertEquals((String)"GL Amount on accounting line should be 105.00", (Object)new KualiDecimal(105.0), (Object)accountingLine.getAlternateAmountForGLEntryCreation());
        Assert.assertEquals((String)"Outstanding encumbrance amount on accounting line should be zero'd out", (Object)KualiDecimal.ZERO, (Object)accountingLine.getItemAccountOutstandingEncumbranceAmount());
    }

    @Test
    public void purchaseOrderCloseWithOneNonQuantityItemTwoAccountingLines() {
        PurchaseOrderItem purchaseOrderItem = this.buildNonQuantityPurchaseOrderItem(new KualiDecimal(200.07));
        PurchaseOrderAccount accountingLine1 = this.buildAccountingLine(new BigDecimal(50.0), new KualiDecimal(100.03));
        PurchaseOrderAccount accountingLine2 = this.buildAccountingLine(new BigDecimal(50.0), new KualiDecimal(100.03));
        ArrayList<PurchaseOrderItem> purchaseOrderItems = new ArrayList<PurchaseOrderItem>();
        ArrayList<PurApItem> activePurchaseOrderItems = new ArrayList<PurApItem>();
        ArrayList<SourceAccountingLine> accountingLines = new ArrayList<SourceAccountingLine>();
        ArrayList<GeneralLedgerPendingEntry> pendingEntries = new ArrayList<GeneralLedgerPendingEntry>();
        purchaseOrderItem.setItemOutstandingEncumberedAmount(new KualiDecimal(200.07));
        purchaseOrderItem.getSourceAccountingLines().add(accountingLine1);
        purchaseOrderItem.getSourceAccountingLines().add(accountingLine2);
        purchaseOrderItems.add(purchaseOrderItem);
        activePurchaseOrderItems.add((PurApItem)purchaseOrderItem);
        accountingLines.add((SourceAccountingLine)accountingLine1);
        accountingLines.add((SourceAccountingLine)accountingLine2);
        this.setUpBaseExpectations(purchaseOrderItems, activePurchaseOrderItems, accountingLines, pendingEntries);
        Mockito.when((Object)this.poCloseMock.getGeneralLedgerPendingEntries()).thenReturn(pendingEntries);
        this.cut.generateEntriesClosePurchaseOrder((PurchaseOrderDocument)this.poCloseMock);
        Assert.assertNull((String)"Purchase Order Item should have outstanding encumbered quantity set to null", (Object)purchaseOrderItem.getItemOutstandingEncumberedQuantity());
        Assert.assertEquals((String)"Purchase Order Item should have outstanding encumbered amount set to zero", (Object)KualiDecimal.ZERO, (Object)purchaseOrderItem.getItemOutstandingEncumberedAmount());
        Assert.assertEquals((String)"GL Amount on accounting line should be 100.03", (Object)new KualiDecimal(100.04), (Object)accountingLine1.getAlternateAmountForGLEntryCreation());
        Assert.assertEquals((String)"Outstanding encumbrance amount on accounting line should be zero'd out", (Object)KualiDecimal.ZERO, (Object)accountingLine1.getItemAccountOutstandingEncumbranceAmount());
        Assert.assertEquals((String)"GL Amount on accounting line should be 100.04", (Object)new KualiDecimal(100.03), (Object)accountingLine2.getAlternateAmountForGLEntryCreation());
        Assert.assertEquals((String)"Outstanding encumbrance amount on accounting line should be zero'd out", (Object)KualiDecimal.ZERO, (Object)accountingLine2.getItemAccountOutstandingEncumbranceAmount());
    }
}

