/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.module.purap.PurapConstants;
import org.kuali.kfs.module.purap.batch.ElectronicInvoiceInputFileType;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoice;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceContact;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceDetailRequestHeader;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceDetailRequestSummary;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceItem;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceOrder;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoicePostalAddress;
import org.kuali.kfs.module.purap.util.ElectronicInvoiceUtils;
import org.kuali.kfs.module.purap.util.cxml.CxmlExtrinsic;
import org.kuali.kfs.module.purap.util.cxml.CxmlHeader;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.exception.ParseException;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.springframework.core.io.Resource;

public class ElectronicInvoiceParserTest {
    private static final String AMAZON_E_INVOICE_XML_FILE = ".." + File.separator + "fixture" + File.separator + "amazonInvoiceSample.xml";
    private static final String AMAZON_E_INVOICE_MALFORMED_XML_FILE = ".." + File.separator + "fixture" + File.separator + "amazonInvoiceMalformedSample.xml";
    private static final String E_INVOICE_XML_FILE = ".." + File.separator + "fixture" + File.separator + "electronicInvoiceSample.xml";
    private static final String SCHEMA_FILE = "org/kuali/kfs/module/purap/batch/electronicInvoice.xsd";
    private ElectronicInvoiceInputFileType cut;
    private ElectronicInvoice eInvoice;
    @Mock
    private ParameterService parameterSvcMock;
    @Mock
    private Resource schemaResourceMock;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setUp() throws IOException {
        MockitoAnnotations.initMocks((Object)this);
        this.cut = new ElectronicInvoiceInputFileType();
        this.cut.setSchemaLocation(SCHEMA_FILE);
        this.cut.setDigestorRulesFileName("org/kuali/kfs/module/purap/batch/electronicInvoiceDigesterRules.xml");
        Mockito.when((Object)this.parameterSvcMock.getParameterValueAsString("KFS-PURAP", "All", PurapConstants.NamedDateFormats.CXML_DATE_FORMAT)).thenReturn((Object)"0000-00-00");
        Mockito.when((Object)this.parameterSvcMock.getParameterValueAsString("KFS-PURAP", "All", PurapConstants.NamedDateFormats.KUALI_DATE_FORMAT)).thenReturn((Object)"00/00/0000");
        Mockito.when((Object)this.parameterSvcMock.getParameterValueAsString("KFS-PURAP", "All", PurapConstants.NamedDateFormats.CXML_SIMPLE_DATE_FORMAT)).thenReturn((Object)"yyyy-MM-dd");
        Mockito.when((Object)this.schemaResourceMock.getInputStream()).thenReturn((Object)this.getClass().getResourceAsStream("/org/kuali/kfs/module/purap/batch/electronicInvoice.xsd"), (Object[])new InputStream[]{this.getClass().getResourceAsStream("/org/kuali/kfs/module/purap/batch/electronicInvoice.xsd")});
    }

    @Test
    public void parse_eInvoiceXMLFile() throws IOException {
        BufferedInputStream fileStream = new BufferedInputStream(this.getClass().getResourceAsStream(E_INVOICE_XML_FILE));
        byte[] fileByteContent = IOUtils.toByteArray((InputStream)fileStream);
        try (MockedStatic springContextStaticMock = Mockito.mockStatic(SpringContext.class);){
            springContextStaticMock.when(() -> SpringContext.getBean(ParameterService.class)).thenReturn((Object)this.parameterSvcMock);
            springContextStaticMock.when(() -> SpringContext.getResource((String)SCHEMA_FILE)).thenReturn((Object)this.schemaResourceMock);
            this.eInvoice = (ElectronicInvoice)this.cut.parse(fileByteContent);
        }
        Assert.assertNotNull((Object)this.eInvoice);
        Assert.assertEquals((Object)"200807260401062080.964@eai002", (Object)this.eInvoice.getPayloadID());
        Assert.assertEquals((Object)"2008-07-26T04:01:06-08:00", (Object)this.eInvoice.getTimestamp());
        Assert.assertEquals((Object)"1.2.014", (Object)this.eInvoice.getVersion());
        Assert.assertEquals((Object)"en", (Object)this.eInvoice.getLocale());
        Assert.assertEquals((Object)"production", (Object)this.eInvoice.getDeploymentMode());
        CxmlHeader cxmlHeader = this.eInvoice.getCxmlHeader();
        Assert.assertNotNull((Object)cxmlHeader);
        Assert.assertEquals((Object)"DUNS", (Object)cxmlHeader.getFromDomain());
        Assert.assertEquals((Object)"121212", (Object)cxmlHeader.getFromIdentity());
        Assert.assertEquals((Object)"NetworkId", (Object)cxmlHeader.getToDomain());
        Assert.assertEquals((Object)"IUHIGHERM", (Object)cxmlHeader.getToIdentity());
        Assert.assertEquals((Object)"DUNS", (Object)cxmlHeader.getSenderDomain());
        Assert.assertEquals((Object)"121212", (Object)cxmlHeader.getSenderIdentity());
        Assert.assertEquals((Object)"fisherscipass", (Object)cxmlHeader.getSenderSharedSecret());
        Assert.assertEquals((Object)"IUPUI", (Object)cxmlHeader.getSenderUserAgent());
        ElectronicInvoiceDetailRequestHeader invoiceDetailRequestHeader = this.eInvoice.getInvoiceDetailRequestHeader();
        Assert.assertNotNull((Object)invoiceDetailRequestHeader);
        String invoiceDate = invoiceDetailRequestHeader.getInvoiceDateString();
        Assert.assertEquals((Object)"2008-07-25T00:00:00-08:00", (Object)invoiceDate);
        Date date = ElectronicInvoiceUtils.getDate((String)invoiceDate);
        Assert.assertNotNull((Object)date);
        Assert.assertEquals((Object)date.toString(), (Object)invoiceDetailRequestHeader.getInvoiceDate().toString());
        Assert.assertEquals((Object)"133", (Object)invoiceDetailRequestHeader.getInvoiceId());
        Assert.assertEquals((Object)"new", (Object)invoiceDetailRequestHeader.getOperation());
        Assert.assertEquals((Object)"standard", (Object)invoiceDetailRequestHeader.getPurpose());
        Assert.assertTrue((boolean)invoiceDetailRequestHeader.isInformationOnly());
        Assert.assertTrue((boolean)invoiceDetailRequestHeader.isHeaderInvoiceIndicator());
        Assert.assertTrue((boolean)invoiceDetailRequestHeader.isTaxInLine());
        Assert.assertTrue((boolean)invoiceDetailRequestHeader.isSpecialHandlingInLine());
        Assert.assertTrue((boolean)invoiceDetailRequestHeader.isShippingInLine());
        Assert.assertTrue((boolean)invoiceDetailRequestHeader.isDiscountInLine());
        ElectronicInvoiceContact billToContact = invoiceDetailRequestHeader.getCxmlContactByRoleID("billTo");
        Assert.assertNotNull((Object)billToContact);
        Assert.assertEquals((Object)"", (Object)billToContact.getAddressID());
        Assert.assertEquals((Object)"billTo", (Object)billToContact.getRole());
        Assert.assertEquals((long)1L, (long)billToContact.getPostalAddresses().size());
        Assert.assertEquals((Object)"ACCOUNTING DEPT", (Object)((ElectronicInvoicePostalAddress)billToContact.getPostalAddresses().get(0)).getLine1());
        Assert.assertEquals((Object)"620 UNION DR", (Object)((ElectronicInvoicePostalAddress)billToContact.getPostalAddresses().get(0)).getLine2());
        Assert.assertEquals((Object)"RM 443", (Object)((ElectronicInvoicePostalAddress)billToContact.getPostalAddresses().get(0)).getLine3());
        Assert.assertEquals((Object)"INDIANAPOLIS", (Object)((ElectronicInvoicePostalAddress)billToContact.getPostalAddresses().get(0)).getCityName());
        Assert.assertEquals((Object)"IN", (Object)((ElectronicInvoicePostalAddress)billToContact.getPostalAddresses().get(0)).getStateCode());
        Assert.assertEquals((Object)"United States", (Object)((ElectronicInvoicePostalAddress)billToContact.getPostalAddresses().get(0)).getCountryName());
        Assert.assertEquals((Object)"US", (Object)((ElectronicInvoicePostalAddress)billToContact.getPostalAddresses().get(0)).getCountryCode());
        ElectronicInvoiceContact remitToContact = invoiceDetailRequestHeader.getCxmlContactByRoleID("remitTo");
        Assert.assertNotNull((Object)remitToContact);
        Assert.assertEquals((Object)"004321519", (Object)remitToContact.getAddressID());
        Assert.assertEquals((Object)"remitTo", (Object)remitToContact.getRole());
        Assert.assertEquals((long)1L, (long)remitToContact.getPostalAddresses().size());
        ElectronicInvoicePostalAddress remitToAddress = (ElectronicInvoicePostalAddress)remitToContact.getPostalAddresses().get(0);
        Assert.assertEquals((Object)"13551 COLLECTIONS CTR DR", (Object)remitToAddress.getLine1());
        Assert.assertNull((Object)remitToAddress.getLine2());
        Assert.assertNull((Object)remitToAddress.getLine3());
        Assert.assertEquals((Object)"CHICAGO", (Object)remitToAddress.getCityName());
        Assert.assertEquals((Object)"IL", (Object)remitToAddress.getStateCode());
        Assert.assertEquals((Object)"United States", (Object)remitToAddress.getCountryName());
        Assert.assertEquals((Object)"US", (Object)remitToAddress.getCountryCode());
        Assert.assertEquals((Object)"2008-07-25T00:00:00-08:00", (Object)invoiceDetailRequestHeader.getShippingDateString());
        ElectronicInvoiceContact shipToContact = invoiceDetailRequestHeader.getCxmlContactByRoleID("shipTo");
        Assert.assertNotNull((Object)shipToContact);
        Assert.assertEquals((Object)"387520002", (Object)shipToContact.getAddressID());
        Assert.assertEquals((Object)"shipTo", (Object)shipToContact.getRole());
        Assert.assertEquals((long)1L, (long)shipToContact.getPostalAddresses().size());
        ElectronicInvoicePostalAddress shipToAddress = (ElectronicInvoicePostalAddress)shipToContact.getPostalAddresses().get(0);
        Assert.assertEquals((Object)"950 W WALNUT ST", (Object)shipToAddress.getLine1());
        Assert.assertEquals((Object)"ROOM #451", (Object)shipToAddress.getLine2());
        Assert.assertNull((Object)shipToAddress.getLine3());
        Assert.assertEquals((Object)"INDIANAPOLIS", (Object)shipToAddress.getCityName());
        Assert.assertEquals((Object)"IN", (Object)shipToAddress.getStateCode());
        Assert.assertEquals((Object)"United States", (Object)shipToAddress.getCountryName());
        Assert.assertEquals((Object)"US", (Object)shipToAddress.getCountryCode());
        Map emailAddresses = shipToContact.getEmailAddresses();
        Assert.assertEquals((long)2L, (long)emailAddresses.size());
        Assert.assertEquals((Object)"abc@efg.com", emailAddresses.get("test1"));
        Assert.assertEquals((Object)"efg@hij.com", emailAddresses.get("test2"));
        Map phoneNumbers = shipToContact.getPhoneNumbers();
        Assert.assertEquals((long)2L, (long)phoneNumbers.size());
        Assert.assertEquals((Object)"12099545333", phoneNumbers.get("testPhone"));
        Assert.assertEquals((Object)"12099545331", phoneNumbers.get("testFax"));
        String url = (String)shipToContact.getWebAddresses().get(0);
        Assert.assertEquals((Object)"www.abc.com", (Object)url);
        Assert.assertEquals((long)30L, (long)invoiceDetailRequestHeader.getPayInNumberOfDays());
        Assert.assertEquals((Object)"0", (Object)invoiceDetailRequestHeader.getPercentageRate());
        Assert.assertEquals((long)1L, (long)this.eInvoice.getInvoiceDetailOrders().size());
        ElectronicInvoiceOrder order = (ElectronicInvoiceOrder)this.eInvoice.getInvoiceDetailOrders().get(0);
        Assert.assertEquals((Object)"2008-07-25T00:00:00-08:00", (Object)order.getOrderReferenceOrderDateString());
        Assert.assertEquals((Object)"1085", (Object)order.getOrderReferenceOrderID());
        Assert.assertEquals((Object)"", (Object)order.getOrderReferenceDocumentRefPayloadID());
        Assert.assertEquals((long)1L, (long)order.getInvoiceItems().size());
        ElectronicInvoiceItem item = (ElectronicInvoiceItem)order.getInvoiceItems().get(0);
        Assert.assertEquals((Object)"1", (Object)item.getInvoiceLineNumber());
        Assert.assertEquals((Object)"10", (Object)item.getQuantity());
        Assert.assertEquals((Object)"BG", (Object)item.getUnitOfMeasure());
        Assert.assertEquals((Object)"11", (Object)item.getUnitPrice());
        Assert.assertEquals((Object)"1", (Object)item.getReferenceLineNumber());
        Assert.assertEquals((Object)"1212", (Object)item.getReferenceItemIDSupplierPartID());
        Assert.assertEquals((Object)"LABCOAT UNISEX LONG XL WHT", (Object)item.getReferenceDescription());
        Assert.assertEquals((double)110.0, (double)item.getInvoiceLineSubTotalAmountBigDecimal().doubleValue(), (double)0.0);
        Assert.assertEquals((double)2.0, (double)item.getInvoiceLineTaxAmountBigDecimal().doubleValue(), (double)0.0);
        Assert.assertEquals((Object)"Sales Tax", (Object)item.getTaxDescription());
        Assert.assertEquals((double)10.0, (double)item.getInvoiceLineShippingAmountBigDecimal().doubleValue(), (double)0.0);
        Assert.assertEquals((double)5.0, (double)item.getInvoiceLineSpecialHandlingAmountBigDecimal().doubleValue(), (double)0.0);
        ElectronicInvoiceDetailRequestSummary summary = this.eInvoice.getInvoiceDetailRequestSummary();
        Assert.assertNotNull((Object)summary);
        Assert.assertEquals((Object)"1.00", (Object)summary.getSubTotalAmount());
        Assert.assertEquals((Object)"2.00", (Object)summary.getTaxAmount());
        Assert.assertEquals((Object)"Total Tax", (Object)summary.getTaxDescription());
        Assert.assertEquals((Object)"3.00", (Object)summary.getSpecialHandlingAmount());
        Assert.assertEquals((Object)"4.00", (Object)summary.getShippingAmount());
        Assert.assertEquals((Object)"6.00", (Object)summary.getDiscountAmount());
        Assert.assertEquals((Object)"5.00", (Object)summary.getGrossAmount());
        Assert.assertEquals((Object)"7.00", (Object)summary.getNetAmount());
        Assert.assertEquals((Object)"8.00", (Object)summary.getDepositAmount());
        Assert.assertEquals((Object)"9.00", (Object)summary.getDueAmount());
    }

    @Test
    public void parse_amazonInvoiceXMLFile() throws IOException {
        BufferedInputStream fileStream = new BufferedInputStream(this.getClass().getResourceAsStream(AMAZON_E_INVOICE_XML_FILE));
        byte[] fileByteContent = IOUtils.toByteArray((InputStream)fileStream);
        try (MockedStatic springContextStaticMock = Mockito.mockStatic(SpringContext.class);){
            springContextStaticMock.when(() -> SpringContext.getBean(ParameterService.class)).thenReturn((Object)this.parameterSvcMock);
            springContextStaticMock.when(() -> SpringContext.getResource((String)SCHEMA_FILE)).thenReturn((Object)this.schemaResourceMock);
            this.eInvoice = (ElectronicInvoice)this.cut.parse(fileByteContent);
        }
        Assert.assertNotNull((Object)this.eInvoice);
        Assert.assertEquals((Object)"1528161523877.141.1289@amazon.com", (Object)this.eInvoice.getPayloadID());
        Assert.assertEquals((Object)"2018-06-05T01:18:43+0000", (Object)this.eInvoice.getTimestamp());
        Assert.assertEquals((Object)"1.2.030", (Object)this.eInvoice.getVersion());
        Assert.assertEquals((Object)"en-US", (Object)this.eInvoice.getLocale());
        Assert.assertEquals((Object)"production", (Object)this.eInvoice.getDeploymentMode());
        CxmlHeader cxmlHeader = this.eInvoice.getCxmlHeader();
        Assert.assertNotNull((Object)cxmlHeader);
        Assert.assertEquals((Object)"DUNS", (Object)cxmlHeader.getFromDomain());
        Assert.assertEquals((Object)"174495606", (Object)cxmlHeader.getFromIdentity());
        Assert.assertEquals((Object)"NetworkId", (Object)cxmlHeader.getToDomain());
        Assert.assertEquals((Object)"174495606", (Object)cxmlHeader.getToIdentity());
        Assert.assertEquals((Object)"NetworkId", (Object)cxmlHeader.getSenderDomain());
        Assert.assertEquals((Object)"Amazon", (Object)cxmlHeader.getSenderIdentity());
        Assert.assertEquals((Object)"Amazon LLC eProcurement Application", (Object)cxmlHeader.getSenderUserAgent());
        ElectronicInvoiceDetailRequestHeader invoiceDetailRequestHeader = this.eInvoice.getInvoiceDetailRequestHeader();
        Assert.assertNotNull((Object)invoiceDetailRequestHeader);
        String invoiceDate = invoiceDetailRequestHeader.getInvoiceDateString();
        Date date = ElectronicInvoiceUtils.getDate((String)invoiceDate);
        Assert.assertEquals((Object)"2018-06-05T00:53:26+0000", (Object)invoiceDate);
        Assert.assertNotNull((Object)date);
        Assert.assertEquals((Object)date.toString(), (Object)invoiceDetailRequestHeader.getInvoiceDate().toString());
        Assert.assertEquals((Object)"1FGM-CH6N-DCV1", (Object)invoiceDetailRequestHeader.getInvoiceId());
        Assert.assertEquals((Object)"new", (Object)invoiceDetailRequestHeader.getOperation());
        Assert.assertEquals((Object)"standard", (Object)invoiceDetailRequestHeader.getPurpose());
        Assert.assertFalse((boolean)invoiceDetailRequestHeader.isInformationOnly());
        Assert.assertFalse((boolean)invoiceDetailRequestHeader.isHeaderInvoiceIndicator());
        Assert.assertFalse((boolean)invoiceDetailRequestHeader.isTaxInLine());
        Assert.assertFalse((boolean)invoiceDetailRequestHeader.isSpecialHandlingInLine());
        Assert.assertFalse((boolean)invoiceDetailRequestHeader.isShippingInLine());
        Assert.assertFalse((boolean)invoiceDetailRequestHeader.isDiscountInLine());
        Assert.assertEquals((long)30L, (long)invoiceDetailRequestHeader.getPayInNumberOfDays());
        Assert.assertTrue((boolean)invoiceDetailRequestHeader.isAccountingInLine());
        List extrinsics = invoiceDetailRequestHeader.getExtrinsics();
        Assert.assertEquals((long)2L, (long)extrinsics.size());
        HashMap<String, String> expectedExtrinsicValues = new HashMap<String, String>();
        expectedExtrinsicValues.put("carrierName", "UPS");
        expectedExtrinsicValues.put("carrierTrackingNumber", "1Z2FW8240302944450");
        for (CxmlExtrinsic extrinsic : extrinsics) {
            Assert.assertEquals(expectedExtrinsicValues.get(extrinsic.getName()), (Object)extrinsic.getValue());
        }
        ElectronicInvoiceContact billToContact = invoiceDetailRequestHeader.getCxmlContactByRoleID("billTo");
        Assert.assertNull((Object)billToContact);
        ElectronicInvoiceContact remitToContact = invoiceDetailRequestHeader.getCxmlContactByRoleID("remitTo");
        Assert.assertNull((Object)remitToContact);
        Assert.assertEquals((long)1L, (long)this.eInvoice.getInvoiceDetailOrders().size());
        ElectronicInvoiceOrder order = (ElectronicInvoiceOrder)this.eInvoice.getInvoiceDetailOrders().get(0);
        Assert.assertEquals((Object)"2018-06-04T19:45:16+0000", (Object)order.getOrderReferenceOrderDateString());
        Assert.assertEquals((Object)"61820446", (Object)order.getOrderReferenceOrderID());
        Assert.assertEquals((Object)"2018-06-04-12-43-51.61820446:0:84.234388139244199091950851296116719871325@", (Object)order.getOrderReferenceDocumentRefPayloadID());
        Assert.assertEquals((Object)"111-9115002-3933056", (Object)order.getSupplierOrderInfoID());
        Assert.assertEquals((long)1L, (long)order.getInvoiceItems().size());
        ElectronicInvoiceItem item = (ElectronicInvoiceItem)order.getInvoiceItems().get(0);
        Assert.assertEquals((Object)"1", (Object)item.getInvoiceLineNumber());
        Assert.assertEquals((Object)"1", (Object)item.getQuantity());
        Assert.assertEquals((Object)"EA", (Object)item.getUnitOfMeasure());
        Assert.assertEquals((Object)"316.99", (Object)item.getUnitPrice());
        Assert.assertEquals((Object)"2", (Object)item.getReferenceLineNumber());
        Assert.assertEquals((Object)"B01NB0P9K5", (Object)item.getReferenceItemIDSupplierPartID());
        Assert.assertEquals((Object)"HP 410A Toner Cartridge Cyan, Yellow & Magenta", (Object)item.getReferenceDescription());
        Assert.assertEquals((double)316.99, (double)item.getInvoiceLineSubTotalAmountBigDecimal().doubleValue(), (double)0.0);
        Assert.assertEquals((double)28.53, (double)item.getInvoiceLineTaxAmountBigDecimal().doubleValue(), (double)0.0);
        Assert.assertEquals((Object)"Cost of tax, including shipping tax", (Object)item.getTaxDescription());
        Assert.assertEquals((double)0.0, (double)item.getInvoiceLineShippingAmountBigDecimal().doubleValue(), (double)0.0);
        Assert.assertEquals((double)0.0, (double)item.getInvoiceLineSpecialHandlingAmountBigDecimal().doubleValue(), (double)0.0);
        ElectronicInvoiceDetailRequestSummary summary = this.eInvoice.getInvoiceDetailRequestSummary();
        Assert.assertNotNull((Object)summary);
        Assert.assertEquals((Object)"316.99", (Object)summary.getSubTotalAmount());
        Assert.assertEquals((Object)"28.53", (Object)summary.getTaxAmount());
        Assert.assertEquals((Object)"Cost of tax, including shipping tax", (Object)summary.getTaxDescription());
        Assert.assertEquals((Object)"0.00", (Object)summary.getSpecialHandlingAmount());
        Assert.assertEquals((Object)"0.00", (Object)summary.getShippingAmount());
        Assert.assertEquals((Object)"0.00", (Object)summary.getDiscountAmount());
        Assert.assertNull((Object)summary.getGrossAmount());
        Assert.assertEquals((Object)"345.52", (Object)summary.getNetAmount());
        Assert.assertNull((Object)summary.getDepositAmount());
        Assert.assertEquals((Object)"345.52", (Object)summary.getDueAmount());
    }

    @Test
    public void parse_amazonInvoiceMalformedXMLFile() throws IOException {
        BufferedInputStream fileStream = new BufferedInputStream(this.getClass().getResourceAsStream(AMAZON_E_INVOICE_MALFORMED_XML_FILE));
        byte[] fileByteContent = IOUtils.toByteArray((InputStream)fileStream);
        this.expectedException.expect(ParseException.class);
        this.expectedException.expectMessage("error Parsing error was encountered on line 41, column 42: cvc-complex-type.2.4.d: Invalid content was found starting with element 'Request'. No child element is expected at this point.");
        try (MockedStatic springContextStaticMock = Mockito.mockStatic(SpringContext.class);){
            springContextStaticMock.when(() -> SpringContext.getResource((String)SCHEMA_FILE)).thenReturn((Object)this.schemaResourceMock);
            this.eInvoice = (ElectronicInvoice)this.cut.parse(fileByteContent);
        }
        Assert.assertNull((Object)this.eInvoice);
    }
}

