/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.fixture;

import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.fixture.PurApItemFixture;
import org.kuali.kfs.module.purap.fixture.PurchaseOrderAccountingLineFixture;
import org.kuali.kfs.vnd.businessobject.CommodityCode;
import org.kuali.kfs.vnd.fixture.CommodityCodeFixture;

public enum PurchaseOrderItemFixture {
    PO_QTY_UNRESTRICTED_ITEM_1(null, null, null, null, null, null, null, true, PurApItemFixture.BASIC_QTY_ITEM_1, new PurchaseOrderAccountingLineFixture[]{PurchaseOrderAccountingLineFixture.BASIC_PO_ACCOUNT_1}),
    PO_QTY_UNRESTRICTED_ITEM_2(null, null, null, null, null, null, null, true, PurApItemFixture.BASIC_QTY_ITEM_2, new PurchaseOrderAccountingLineFixture[]{PurchaseOrderAccountingLineFixture.BASIC_PO_ACCOUNT_1}),
    PO_VALID_FREIGHT_ITEM(null, null, null, null, null, null, null, true, PurApItemFixture.VALID_FREIGHT_ITEM, new PurchaseOrderAccountingLineFixture[]{PurchaseOrderAccountingLineFixture.BASIC_PO_ACCOUNT_1}),
    PO_VALID_SHIPPING_AND_HANDLING_ITEM(null, null, null, null, null, null, null, true, PurApItemFixture.VALID_SHIPPING_AND_HANDLING_ITEM, new PurchaseOrderAccountingLineFixture[]{PurchaseOrderAccountingLineFixture.BASIC_PO_ACCOUNT_1}),
    PO_WITH_MISC_CREDIT_ITEM(null, null, null, null, null, null, null, true, PurApItemFixture.VALID_MISC_CREDIT_ITEM, new PurchaseOrderAccountingLineFixture[]{PurchaseOrderAccountingLineFixture.BASIC_PO_ACCOUNT_1}),
    PO_WITH_NEGATIVE_FREIGHT_ITEM(null, null, null, null, null, null, null, true, PurApItemFixture.NEGATIVE_FREIGHT_ITEM, new PurchaseOrderAccountingLineFixture[]{PurchaseOrderAccountingLineFixture.BASIC_PO_ACCOUNT_1}),
    PO_WITH_NEGATIVE_SHIPPING_AND_HANDLING_ITEM(null, null, null, null, null, null, null, true, PurApItemFixture.NEGATIVE_SHIPPING_AND_HANDLING_ITEM, new PurchaseOrderAccountingLineFixture[]{PurchaseOrderAccountingLineFixture.BASIC_PO_ACCOUNT_1}),
    PO_WITH_ZERO_FREIGHT_ITEM(null, null, null, null, null, null, null, true, PurApItemFixture.ZERO_FREIGHT_ITEM, new PurchaseOrderAccountingLineFixture[]{PurchaseOrderAccountingLineFixture.BASIC_PO_ACCOUNT_1}),
    PO_WITH_ZERO_SHIPPING_AND_HANDLING_ITEM(null, null, null, null, null, null, null, true, PurApItemFixture.ZERO_SHIPPING_AND_HANDLING_ITEM, new PurchaseOrderAccountingLineFixture[]{PurchaseOrderAccountingLineFixture.BASIC_PO_ACCOUNT_1}),
    PO_WITH_MISC_ITEM_NO_DESC(null, null, null, null, null, null, null, true, PurApItemFixture.MISC_ITEM_NO_DESC, new PurchaseOrderAccountingLineFixture[]{PurchaseOrderAccountingLineFixture.BASIC_PO_ACCOUNT_1}),
    PO_QTY_APO_ITEM_1(null, null, null, null, null, null, null, true, PurApItemFixture.APO_QTY_ITEM_1, new PurchaseOrderAccountingLineFixture[]{PurchaseOrderAccountingLineFixture.PO_APO_ACCOUNT_1}),
    PO_ITEM_BASIC_ACTIVE_COMMODITY_CODE(null, null, null, null, null, null, null, true, PurApItemFixture.BASIC_QTY_ITEM_1, new PurchaseOrderAccountingLineFixture[]{PurchaseOrderAccountingLineFixture.BASIC_PO_ACCOUNT_1}, CommodityCodeFixture.COMMODITY_CODE_BASIC_ACTIVE),
    PO_ITEM_BASIC_INACTIVE_COMMODITY_CODE(null, null, null, null, null, null, null, true, PurApItemFixture.BASIC_QTY_ITEM_1, new PurchaseOrderAccountingLineFixture[]{PurchaseOrderAccountingLineFixture.BASIC_PO_ACCOUNT_1}, CommodityCodeFixture.COMMODITY_CODE_BASIC_INACTIVE),
    PO_ITEM_NON_EXISTENCE_COMMODITY_CODE(null, null, null, null, null, null, null, true, PurApItemFixture.BASIC_QTY_ITEM_1, new PurchaseOrderAccountingLineFixture[]{PurchaseOrderAccountingLineFixture.BASIC_PO_ACCOUNT_1}, CommodityCodeFixture.COMMODITY_CODE_NON_EXISTENCE),
    PO_ITEM_THRESHOLD_CHECK(null, null, null, null, null, null, null, true, PurApItemFixture.ITEM_FOR_THRESHOLD_CHECK, new PurchaseOrderAccountingLineFixture[]{PurchaseOrderAccountingLineFixture.BASIC_PO_ACCOUNT_1}, CommodityCodeFixture.COMMODITY_CODE_BASIC_ACTIVE),
    EINVOICE_PO_ITEM(null, null, null, null, null, null, null, true, PurApItemFixture.EINVOICE_ITEM, new PurchaseOrderAccountingLineFixture[]{PurchaseOrderAccountingLineFixture.BASIC_PO_ACCOUNT_1});

    private String documentNumber;
    private KualiDecimal itemInvoicedTotalQuantity;
    private KualiDecimal itemInvoicedTotalAmount;
    private KualiDecimal itemReceivedTotalQuantity;
    private KualiDecimal itemReturnedTotalQuantity;
    private KualiDecimal itemOutstandingEncumberedQuantity;
    private KualiDecimal itemOutstandingEncumberedAmount;
    private boolean itemActiveIndicator = true;
    private PurApItemFixture purApItemFixture;
    private PurchaseOrderAccountingLineFixture[] purchaseOrderAccountingLineFixtures;
    private CommodityCodeFixture commodityCodeFixture;

    private PurchaseOrderItemFixture(String documentNumber, KualiDecimal itemInvoicedTotalQuantity, KualiDecimal itemInvoicedTotalAmount, KualiDecimal itemReceivedTotalQuantity, KualiDecimal itemReturnedTotalQuantity, KualiDecimal itemOutstandingEncumberedQuantity, KualiDecimal itemOutstandingEncumberedAmount, boolean itemActiveIndicator, PurApItemFixture purApItemFixture, PurchaseOrderAccountingLineFixture[] purchaseOrderAccountingLineFixtures) {
        this.documentNumber = documentNumber;
        this.itemInvoicedTotalQuantity = itemInvoicedTotalQuantity;
        this.itemInvoicedTotalAmount = itemInvoicedTotalAmount;
        this.itemReceivedTotalQuantity = itemReceivedTotalQuantity;
        this.itemReturnedTotalQuantity = itemReturnedTotalQuantity;
        this.itemOutstandingEncumberedQuantity = itemOutstandingEncumberedQuantity;
        this.itemOutstandingEncumberedAmount = itemOutstandingEncumberedAmount;
        this.itemActiveIndicator = itemActiveIndicator;
        this.purApItemFixture = purApItemFixture;
        this.purchaseOrderAccountingLineFixtures = purchaseOrderAccountingLineFixtures;
    }

    private PurchaseOrderItemFixture(String documentNumber, KualiDecimal itemInvoicedTotalQuantity, KualiDecimal itemInvoicedTotalAmount, KualiDecimal itemReceivedTotalQuantity, KualiDecimal itemReturnedTotalQuantity, KualiDecimal itemOutstandingEncumberedQuantity, KualiDecimal itemOutstandingEncumberedAmount, boolean itemActiveIndicator, PurApItemFixture purApItemFixture, PurchaseOrderAccountingLineFixture[] purchaseOrderAccountingLineFixtures, CommodityCodeFixture commodityCodeFixture) {
        this.documentNumber = documentNumber;
        this.itemInvoicedTotalQuantity = itemInvoicedTotalQuantity;
        this.itemInvoicedTotalAmount = itemInvoicedTotalAmount;
        this.itemReceivedTotalQuantity = itemReceivedTotalQuantity;
        this.itemReturnedTotalQuantity = itemReturnedTotalQuantity;
        this.itemOutstandingEncumberedQuantity = itemOutstandingEncumberedQuantity;
        this.itemOutstandingEncumberedAmount = itemOutstandingEncumberedAmount;
        this.itemActiveIndicator = itemActiveIndicator;
        this.purApItemFixture = purApItemFixture;
        this.purchaseOrderAccountingLineFixtures = purchaseOrderAccountingLineFixtures;
        this.commodityCodeFixture = commodityCodeFixture;
    }

    public void addTo(PurchaseOrderDocument purchaseOrderDocument) {
        PurchaseOrderItem item = null;
        item = (PurchaseOrderItem)this.createPurchaseOrderItem(this.purApItemFixture);
        purchaseOrderDocument.addItem((PurApItem)item);
        for (PurchaseOrderAccountingLineFixture purchaseOrderAccountMultiFixture : this.purchaseOrderAccountingLineFixtures) {
            purchaseOrderAccountMultiFixture.addTo(item);
        }
    }

    public PurApItem createPurchaseOrderItem(PurApItemFixture purApItemFixture) {
        PurchaseOrderItem item = (PurchaseOrderItem)purApItemFixture.createPurApItem(PurchaseOrderItem.class);
        item.setDocumentNumber(this.documentNumber);
        item.setItemInvoicedTotalQuantity(this.itemInvoicedTotalQuantity);
        item.setItemInvoicedTotalAmount(this.itemInvoicedTotalAmount);
        item.setItemReceivedTotalQuantity(this.itemReceivedTotalQuantity);
        item.setItemOutstandingEncumberedQuantity(this.itemOutstandingEncumberedQuantity);
        item.setItemOutstandingEncumberedAmount(this.itemOutstandingEncumberedAmount);
        item.setItemActiveIndicator(this.itemActiveIndicator);
        if (this.commodityCodeFixture != null) {
            CommodityCode commodityCode = this.commodityCodeFixture.createCommodityCode();
            item.setCommodityCode(commodityCode);
            item.setPurchasingCommodityCode(commodityCode.getPurchasingCommodityCode());
        }
        return item;
    }
}

