/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.service.impl.purapgeneralledgerserviceimpl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderAccount;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.module.purap.service.PurapAccountingService;
import org.kuali.kfs.module.purap.service.impl.PurapGeneralLedgerServiceImpl;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.kfs.sys.document.GeneralLedgerPendingEntrySource;
import org.kuali.kfs.sys.service.GeneralLedgerPendingEntryService;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

@Execution(value=ExecutionMode.SAME_THREAD)
public class GenerateEntriesApproveAmendPurchaseOrderTest {
    private PurapGeneralLedgerServiceImpl cut;
    @Mock
    private PurchaseOrderDocument oldPoMock;
    @Mock
    private PurchaseOrderDocument newPoMock;
    @Mock
    private PurapAccountingService purapAccountingSvcMock;
    @Mock
    private GeneralLedgerPendingEntryService glPendingEntrySvcMock;
    @Mock
    private BusinessObjectService boServiceMock;
    @Mock
    private PurchaseOrderService purchaseOrderSvcMock;
    private List<PurApItem> newPoItems;
    private List<PurApItem> newPoActiveItems;
    private List<PurApItem> oldPoItems;
    private List<GeneralLedgerPendingEntry> glpes;
    private List<SourceAccountingLine> newSummaryAccountingLines;
    private List<SourceAccountingLine> oldSummaryAccountingLines;
    private List<SourceAccountingLine> diffSummaryAccountingLines;
    private List<Object> dynamicMocks;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.cut = new PurapGeneralLedgerServiceImpl();
        this.cut.setPurapAccountingService(this.purapAccountingSvcMock);
        this.cut.setGeneralLedgerPendingEntryService(this.glPendingEntrySvcMock);
        this.cut.setBusinessObjectService(this.boServiceMock);
        this.cut.setPurchaseOrderService(this.purchaseOrderSvcMock);
        this.newPoItems = new ArrayList<PurApItem>();
        this.newPoActiveItems = new ArrayList<PurApItem>();
        this.oldPoItems = new ArrayList<PurApItem>();
        this.glpes = new ArrayList<GeneralLedgerPendingEntry>();
        this.newSummaryAccountingLines = new ArrayList<SourceAccountingLine>();
        this.oldSummaryAccountingLines = new ArrayList<SourceAccountingLine>();
        this.diffSummaryAccountingLines = new ArrayList<SourceAccountingLine>();
        this.dynamicMocks = new ArrayList<Object>();
    }

    private void execute() {
        this.cut.generateEntriesApproveAmendPurchaseOrder(this.newPoMock);
        ((PurchaseOrderDocument)Mockito.verify((Object)this.oldPoMock)).getItemsActiveOnlySetupAlternateAmount();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.oldPoMock});
        ((PurchaseOrderDocument)Mockito.verify((Object)this.newPoMock)).getPurapDocumentIdentifier();
        ((PurchaseOrderDocument)Mockito.verify((Object)this.newPoMock)).getItems();
        ((PurchaseOrderDocument)Mockito.verify((Object)this.newPoMock)).getItemsActiveOnly();
        ((PurchaseOrderDocument)Mockito.verify((Object)this.newPoMock)).getGeneralLedgerPendingEntries();
        ((PurapAccountingService)Mockito.verify((Object)this.purapAccountingSvcMock, (VerificationMode)Mockito.atLeastOnce())).generateSummaryWithNoZeroTotalsUsingAlternateAmount(this.oldPoItems);
        ((PurapAccountingService)Mockito.verify((Object)this.purapAccountingSvcMock, (VerificationMode)Mockito.atLeastOnce())).generateSummaryWithNoZeroTotalsUsingAlternateAmount(this.newPoActiveItems);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.purapAccountingSvcMock});
        ((GeneralLedgerPendingEntryService)Mockito.verify((Object)this.glPendingEntrySvcMock)).generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySource)this.newPoMock);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.glPendingEntrySvcMock});
        ((BusinessObjectService)Mockito.verify((Object)this.boServiceMock)).save(this.glpes);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.boServiceMock});
        ((PurchaseOrderService)Mockito.verify((Object)this.purchaseOrderSvcMock)).getCurrentPurchaseOrder(Integer.valueOf(101));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.purchaseOrderSvcMock});
    }

    private void prepareNewPO() {
        Mockito.when((Object)this.newPoMock.getPurapDocumentIdentifier()).thenReturn((Object)101);
        Mockito.when((Object)this.newPoMock.getItems()).thenReturn(this.newPoItems);
        Mockito.when((Object)this.newPoMock.getItemsActiveOnly()).thenReturn(this.newPoActiveItems);
        Mockito.when((Object)this.newPoMock.getGeneralLedgerPendingEntries()).thenReturn(this.glpes);
    }

    private void prepareOldPO() {
        Mockito.when((Object)this.oldPoMock.getItemsActiveOnlySetupAlternateAmount()).thenReturn(this.oldPoItems);
    }

    private KualiDecimal doubleToKualiDecimal(Double amount) {
        if (amount == null) {
            return null;
        }
        return new KualiDecimal(amount.doubleValue());
    }

    private void prepareItem(Double quantity, Double invoicedQuantity, Double outstandingQuantity, Double unitPrice, Double invoicedAmount, Double taxAmount, Double outstandingAmount, List<PurApAccountingLine> accountingLines, boolean active) {
        PurchaseOrderItem item = (PurchaseOrderItem)Mockito.mock(PurchaseOrderItem.class);
        Mockito.when((Object)item.getItemQuantity()).thenReturn((Object)this.doubleToKualiDecimal(quantity));
        Mockito.when((Object)item.getItemInvoicedTotalQuantity()).thenReturn((Object)this.doubleToKualiDecimal(invoicedQuantity));
        Mockito.when((Object)item.getItemInvoicedTotalAmount()).thenReturn((Object)this.doubleToKualiDecimal(invoicedAmount));
        Mockito.when((Object)item.getSourceAccountingLines()).thenReturn(accountingLines);
        Mockito.when((Object)item.getItemOutstandingEncumberedQuantity()).thenReturn((Object)this.doubleToKualiDecimal(outstandingQuantity));
        Mockito.when((Object)item.getItemOutstandingEncumberedAmount()).thenReturn((Object)this.doubleToKualiDecimal(outstandingAmount));
        Mockito.when((Object)item.getItemUnitPrice()).thenReturn((Object)new BigDecimal(unitPrice));
        Mockito.when((Object)item.getItemTaxAmount()).thenReturn((Object)this.doubleToKualiDecimal(taxAmount));
        item.setItemInvoicedTotalQuantity(this.doubleToKualiDecimal(invoicedQuantity));
        item.setItemInvoicedTotalAmount(this.doubleToKualiDecimal(invoicedAmount));
        item.setItemOutstandingEncumberedQuantity(this.doubleToKualiDecimal(outstandingQuantity));
        item.setItemOutstandingEncumberedAmount(this.doubleToKualiDecimal(outstandingAmount));
        Mockito.when((Object)item.isItemActiveIndicator()).thenReturn((Object)active);
        if (active) {
            this.newPoActiveItems.add((PurApItem)item);
        }
        this.newPoItems.add((PurApItem)item);
        this.dynamicMocks.add(item);
    }

    private PurchaseOrderAccount createPoAccountingLine(double percent, double amount, double newOutstandingAmount) {
        PurchaseOrderAccount account = (PurchaseOrderAccount)Mockito.mock(PurchaseOrderAccount.class);
        Mockito.when((Object)account.getAccountLinePercent()).thenReturn((Object)new BigDecimal(percent));
        Mockito.when((Object)account.getAmount()).thenReturn((Object)this.doubleToKualiDecimal(amount));
        Mockito.when((Object)account.getItemAccountOutstandingEncumbranceAmount()).thenReturn((Object)this.doubleToKualiDecimal(newOutstandingAmount));
        account.setItemAccountOutstandingEncumbranceAmount(this.doubleToKualiDecimal(newOutstandingAmount));
        account.setAlternateAmountForGLEntryCreation(this.doubleToKualiDecimal(newOutstandingAmount));
        this.dynamicMocks.add(account);
        return account;
    }

    private void prepareSummaryAccountingLine(Double newAmount, Double oldAmount, Double diffAmount, String objectCode) {
        SourceAccountingLine account;
        if (newAmount != null) {
            account = new SourceAccountingLine();
            account.setFinancialObjectCode(objectCode);
            account.setAmount(this.doubleToKualiDecimal(newAmount));
            this.newSummaryAccountingLines.add(account);
        }
        if (oldAmount != null) {
            account = new SourceAccountingLine();
            account.setFinancialObjectCode(objectCode);
            account.setAmount(this.doubleToKualiDecimal(oldAmount));
            this.oldSummaryAccountingLines.add(account);
        }
        account = new SourceAccountingLine();
        account.setFinancialObjectCode(objectCode);
        account.setAmount(this.doubleToKualiDecimal(diffAmount));
        this.diffSummaryAccountingLines.add(account);
    }

    private void prepareItemsNoAccountingLines() {
        this.prepareItem(3.0, 1.0, 2.0, 5.0, 5.0, 0.5, 10.5, new ArrayList<PurApAccountingLine>(), true);
        this.prepareItem(3.0, 1.0, 0.0, 5.0, 5.0, 0.5, 0.0, new ArrayList<PurApAccountingLine>(), false);
        this.prepareItem(null, 0.0, null, 10.0, 3.0, 0.5, 7.0, new ArrayList<PurApAccountingLine>(), true);
    }

    private void prepareItemsWithAccountingLines() {
        ArrayList<Object> accountingLines = new ArrayList<PurApAccountingLine>();
        accountingLines.add(this.createPoAccountingLine(100.0, 15.0, 10.0));
        this.prepareItem(3.0, 1.0, 2.0, 5.0, 5.0, 0.0, 10.0, accountingLines, true);
        accountingLines = new ArrayList();
        accountingLines.add((PurApAccountingLine)this.createPoAccountingLine(50.0, 7.5, 5.0));
        accountingLines.add(this.createPoAccountingLine(50.0, 7.5, 5.0));
        this.prepareItem(3.0, 1.0, 2.0, 5.0, 5.0, 0.0, 10.0, accountingLines, true);
        accountingLines = new ArrayList();
        accountingLines.add((PurApAccountingLine)this.createPoAccountingLine(66.66, 6666.67, 6700.0));
        accountingLines.add(this.createPoAccountingLine(33.33, 3333.33, 3300.0));
        this.prepareItem(1.0, 0.0, 1.0, 10000.0, 0.0, 0.0, 10000.0, accountingLines, true);
    }

    private void prepareSummaryAccountingLines() {
        this.prepareSummaryAccountingLine(10.0, 7.0, 3.0, "Matching");
        this.prepareSummaryAccountingLine(10.0, null, 10.0, "NewOnly");
        this.prepareSummaryAccountingLine(null, 7.0, -7.0, "OldOnly");
    }

    private void baseExpectations() {
        this.prepareOldPO();
        this.prepareNewPO();
        Mockito.when((Object)this.purchaseOrderSvcMock.getCurrentPurchaseOrder(Integer.valueOf(101))).thenReturn((Object)this.oldPoMock);
        Mockito.when((Object)this.purapAccountingSvcMock.generateSummaryWithNoZeroTotalsUsingAlternateAmount(this.newPoActiveItems)).thenReturn(this.newSummaryAccountingLines);
        Mockito.when((Object)this.purapAccountingSvcMock.generateSummaryWithNoZeroTotalsUsingAlternateAmount(this.oldPoItems)).thenReturn(this.oldSummaryAccountingLines);
        Mockito.when((Object)this.glPendingEntrySvcMock.generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySource)this.newPoMock)).thenReturn((Object)true);
        Mockito.when((Object)this.boServiceMock.save(this.glpes)).thenReturn(null);
    }

    @Test
    public void baseCase() {
        this.baseExpectations();
        this.execute();
    }

    @Test
    public void poWithItems() {
        this.baseExpectations();
        this.prepareItemsNoAccountingLines();
        this.execute();
    }

    @Test
    public void poWithAccountingLines() {
        this.baseExpectations();
        this.prepareItemsWithAccountingLines();
        this.execute();
    }

    @Test
    public void poWithSummaryAccountingLines() {
        this.baseExpectations();
        this.prepareSummaryAccountingLines();
        this.execute();
    }
}

