/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.batch;

import java.math.BigDecimal;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.coreservice.api.parameter.EvaluationOperator;
import org.kuali.kfs.coreservice.impl.parameter.Parameter;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.PersistenceStructureService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.businessobject.RequisitionAccount;
import org.kuali.kfs.module.purap.businessobject.RequisitionItem;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.document.service.PurapService;
import org.kuali.kfs.module.purap.document.service.RequisitionService;
import org.kuali.kfs.sys.batch.AbstractStep;
import org.kuali.kfs.sys.batch.TestingStep;
import org.kuali.kfs.sys.businessobject.DocumentHeader;

public class PurapMassRequisitionStep
extends AbstractStep
implements TestingStep {
    private static final Logger LOG = LogManager.getLogger();
    private DocumentService documentService;
    private RequisitionService requisitionService;
    private PurapService purapService;
    private BusinessObjectService boService;
    private PersistenceStructureService psService;
    private final int NUM_DOCS_TO_CREATE = 25;
    private final String RUN_INDICATOR_PARAMETER_NAMESPACE_STEP = "PurapMassRequisitionStep";
    private final String RUN_INDICATOR_PARAMETER_VALUE = "N";
    private final String RUN_INDICATOR_PARAMETER_DESCRIPTION = "Tells the job framework whether to run this job or not; because the PurapMassRequisitionJob needs to only be run once after database initialization.";

    public boolean execute(String jobName, Date jobRunDate) throws InterruptedException {
        LOG.debug("Starting execution of PurapMassRequisitionStep");
        Parameter runIndicatorParameter = this.parameterService.getParameter(PurapMassRequisitionStep.class, "RUN_IND");
        if (runIndicatorParameter == null || "Y".equals(runIndicatorParameter.getValue())) {
            RequisitionDocument reqDoc;
            int i;
            this.setInitiatedRunParameter();
            for (i = 0; i < 25; ++i) {
                LOG.info("Setting user session for routing of quantity document.");
                GlobalVariables.setUserSession((UserSession)new UserSession("khuntley"));
                reqDoc = this.populateQuantityDocument();
                LOG.info("Blanket approving quantity requisition document.");
                this.documentService.blanketApproveDocument((Document)reqDoc, "auto-routing: Test Requisition Job.", null);
                Thread.sleep(5000L);
            }
            for (i = 0; i < 25; ++i) {
                LOG.info("Setting user session for routing of non-quantity document.");
                GlobalVariables.setUserSession((UserSession)new UserSession("khuntley"));
                reqDoc = this.populateNonQuantityDocument();
                LOG.info("Blanket approving non-quantity requisition document.");
                this.documentService.blanketApproveDocument((Document)reqDoc, "auto-routing: Test Requisition Job.", null);
                Thread.sleep(5000L);
            }
        }
        Thread.sleep(60000L);
        return true;
    }

    private RequisitionDocument populateQuantityDocument() {
        LOG.debug("Creating a new requisition.");
        RequisitionDocument reqDoc = null;
        reqDoc = (RequisitionDocument)this.documentService.getNewDocument(RequisitionDocument.class);
        LOG.info("Populating a new requisition.");
        reqDoc.getDocumentHeader().setExplanation("batch created quantity document");
        DocumentHeader documentHeader = reqDoc.getDocumentHeader();
        documentHeader.setDocumentDescription("batch created quantity document");
        reqDoc.setDocumentFundingSourceCode("INST");
        reqDoc.setRequisitionSourceCode("STAN");
        reqDoc.setPurchaseOrderTransmissionMethodCode("NOPR");
        reqDoc.setPurchaseOrderCostSourceCode("EST");
        reqDoc.setChartOfAccountsCode("KO");
        reqDoc.setOrganizationCode("SBSC");
        reqDoc.setDeliveryCampusCode("KO");
        reqDoc.setRequestorPersonName("WATSON,TERRENCE G");
        reqDoc.setRequestorPersonEmailAddress("tw@localhost.localhost");
        reqDoc.setRequestorPersonPhoneNumber("812-555-5555");
        reqDoc.setDeliveryBuildingCode("ADMN");
        reqDoc.setDeliveryBuildingName("Administration");
        reqDoc.setDeliveryBuildingRoomNumber("100");
        reqDoc.setDeliveryBuildingLine1Address("98 smart street");
        reqDoc.setDeliveryCityName("brainy");
        reqDoc.setDeliveryStateCode("CA");
        reqDoc.setDeliveryPostalCode("46202");
        reqDoc.setDeliveryCountryCode("US");
        reqDoc.setDeliveryToName("front desk");
        reqDoc.setBillingName("THE UNIVERSITY");
        reqDoc.setBillingLine1Address("ACCOUNTS PAYABLE");
        reqDoc.setBillingCityName("BUTTER NUT");
        reqDoc.setBillingStateCode("SC");
        reqDoc.setBillingPostalCode("47402");
        reqDoc.setBillingCountryCode("US");
        reqDoc.setBillingPhoneNumber("111-111-1111");
        reqDoc.setPurchaseOrderAutomaticIndicator(false);
        reqDoc.setApplicationDocumentStatus("In Process");
        reqDoc.setVendorHeaderGeneratedIdentifier(1002);
        reqDoc.setVendorDetailAssignedIdentifier(0);
        reqDoc.setVendorName("MK CORPORATION ACTIVE");
        reqDoc.setVendorLine1Address("3894 SOUTH ST");
        reqDoc.setVendorLine2Address("P.O. BOX 3455");
        reqDoc.setVendorCityName("SPRINGFIELD");
        reqDoc.setVendorStateCode("IL");
        reqDoc.setVendorPostalCode("33555");
        reqDoc.setVendorCountryCode("US");
        reqDoc.setUseTaxIndicator(false);
        RequisitionItem item1 = new RequisitionItem();
        item1.setItemLineNumber(1);
        item1.setItemUnitOfMeasureCode("PCS");
        item1.setItemCatalogNumber("P10M980");
        item1.setItemDescription("Copy Paper - 8 1/2 x 11, White, 92, 20lb");
        item1.setItemUnitPrice(new BigDecimal(30.2));
        item1.setItemTypeCode("ITEM");
        item1.setItemQuantity(new KualiDecimal(20));
        item1.setExtendedPrice(new KualiDecimal(604));
        item1.setItemAssignedToTradeInIndicator(false);
        RequisitionAccount account1 = new RequisitionAccount();
        account1.setPostingYear(2004);
        account1.setChartOfAccountsCode("BL");
        account1.setAccountNumber("1023200");
        account1.setFinancialObjectCode("4100");
        account1.setDebitCreditCode("D");
        account1.setAmount(new KualiDecimal(604));
        account1.setAccountLinePercent(new BigDecimal("100"));
        item1.getSourceAccountingLines().add(account1);
        reqDoc.getItems().add(item1);
        reqDoc.fixItemReferences();
        return reqDoc;
    }

    private RequisitionDocument populateNonQuantityDocument() {
        RequisitionDocument reqDoc = null;
        reqDoc = (RequisitionDocument)this.documentService.getNewDocument(RequisitionDocument.class);
        reqDoc.getDocumentHeader().setExplanation("batch created non-quantity document");
        DocumentHeader documentHeader = reqDoc.getDocumentHeader();
        documentHeader.setDocumentDescription("batch created non-quantity document");
        reqDoc.setDocumentFundingSourceCode("INST");
        reqDoc.setRequisitionSourceCode("STAN");
        reqDoc.setPurchaseOrderTransmissionMethodCode("NOPR");
        reqDoc.setPurchaseOrderCostSourceCode("EST");
        reqDoc.setChartOfAccountsCode("KO");
        reqDoc.setOrganizationCode("SBSC");
        reqDoc.setDeliveryCampusCode("KO");
        reqDoc.setDeliveryCountryCode("US");
        reqDoc.setRequestorPersonName("WATSON,TERRENCE G");
        reqDoc.setRequestorPersonEmailAddress("tw@localhost.localhost");
        reqDoc.setRequestorPersonPhoneNumber("812-555-5555");
        reqDoc.setDeliveryBuildingCode("ADMN");
        reqDoc.setDeliveryBuildingName("Administration");
        reqDoc.setDeliveryBuildingRoomNumber("100");
        reqDoc.setDeliveryBuildingLine1Address("98 smart street");
        reqDoc.setDeliveryCityName("brainy");
        reqDoc.setDeliveryStateCode("CA");
        reqDoc.setDeliveryPostalCode("46202");
        reqDoc.setDeliveryToName("front desk");
        reqDoc.setBillingName("THE UNIVERSITY");
        reqDoc.setBillingLine1Address("ACCOUNTS PAYABLE");
        reqDoc.setBillingCityName("BUTTER NUT");
        reqDoc.setBillingStateCode("SC");
        reqDoc.setBillingPostalCode("47402");
        reqDoc.setBillingCountryCode("US");
        reqDoc.setBillingPhoneNumber("111-111-1111");
        reqDoc.setPurchaseOrderAutomaticIndicator(false);
        reqDoc.setApplicationDocumentStatus("In Process");
        reqDoc.setVendorHeaderGeneratedIdentifier(1016);
        reqDoc.setVendorDetailAssignedIdentifier(0);
        reqDoc.setVendorName("PHYSIK INSTRUMENT L.P.");
        reqDoc.setVendorLine1Address("16 AUBURN ST");
        reqDoc.setVendorCityName("AUBURN");
        reqDoc.setVendorStateCode("MA");
        reqDoc.setVendorPostalCode("01501");
        reqDoc.setVendorCountryCode("US");
        reqDoc.setUseTaxIndicator(false);
        RequisitionItem item1 = new RequisitionItem();
        item1.setItemLineNumber(1);
        item1.setItemUnitOfMeasureCode("");
        item1.setItemCatalogNumber("");
        item1.setItemDescription("consulting");
        item1.setItemUnitPrice(new BigDecimal(5000));
        item1.setItemTypeCode("SRVC");
        item1.setItemQuantity(null);
        item1.setExtendedPrice(new KualiDecimal(5000));
        item1.setItemAssignedToTradeInIndicator(false);
        RequisitionAccount account1 = new RequisitionAccount();
        account1.setPostingYear(2004);
        account1.setChartOfAccountsCode("BL");
        account1.setAccountNumber("1023200");
        account1.setFinancialObjectCode("4078");
        account1.setDebitCreditCode("D");
        account1.setAmount(new KualiDecimal(5000));
        account1.setAccountLinePercent(new BigDecimal("100"));
        item1.getSourceAccountingLines().add(account1);
        reqDoc.getItems().add(item1);
        reqDoc.fixItemReferences();
        return reqDoc;
    }

    private void setInitiatedRunParameter() {
        Parameter runIndicatorParameter = this.parameterService.getParameter(PurapMassRequisitionStep.class, "RUN_IND");
        if (runIndicatorParameter == null) {
            Parameter newParameter = new Parameter();
            newParameter.setNamespaceCode("KFS-PURAP");
            newParameter.setComponentCode("PurapMassRequisitionStep");
            newParameter.setName("RUN_IND");
            newParameter.setParameterTypeCode("CONFG");
            newParameter.setDescription("Tells the job framework whether to run this job or not; because the PurapMassRequisitionJob needs to only be run once after database initialization.");
            newParameter.setEvaluationOperatorCode(EvaluationOperator.ALLOW.getCode());
            newParameter.setValue("N");
            this.parameterService.createParameter(newParameter);
        } else {
            runIndicatorParameter.setValue("N");
            this.parameterService.updateParameter(runIndicatorParameter);
        }
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public RequisitionService getRequisitionService() {
        return this.requisitionService;
    }

    public void setRequisitionService(RequisitionService requisitionService) {
        this.requisitionService = requisitionService;
    }

    public PurapService getPurapService() {
        return this.purapService;
    }

    public void setPurapService(PurapService purapService) {
        this.purapService = purapService;
    }

    public BusinessObjectService getBoService() {
        return this.boService;
    }

    public void setBoService(BusinessObjectService boService) {
        this.boService = boService;
    }

    public PersistenceStructureService getPsService() {
        return this.psService;
    }

    public void setPsService(PersistenceStructureService psService) {
        this.psService = psService;
    }
}

