/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.service.impl;

import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.kuali.kfs.core.api.config.property.ConfigurationService;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderVendorQuote;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.service.FaxService;
import org.kuali.kfs.module.purap.exception.FaxServerUnavailableError;
import org.kuali.kfs.module.purap.exception.FaxSubmissionError;
import org.kuali.kfs.module.purap.exception.PurError;
import org.kuali.kfs.module.purap.pdf.PurchaseOrderParameters;
import org.kuali.kfs.module.purap.pdf.PurchaseOrderPdf;
import org.kuali.kfs.module.purap.pdf.PurchaseOrderQuotePdf;
import org.kuali.kfs.module.purap.pdf.PurchaseOrderTransmitParameters;
import org.kuali.kfs.sys.businessobject.Country;
import org.kuali.kfs.sys.service.LocationService;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;
import org.kuali.kfs.vnd.document.service.VendorService;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class FaxServiceImpl
implements FaxService {
    private static final Logger LOG = LogManager.getLogger();
    protected ConfigurationService kualiConfigurationService;
    protected ParameterService parameterService;
    protected VendorService vendorService;
    protected BusinessObjectService businessObjectService;
    private LocationService locationService;
    private PurchaseOrderParameters purchaseOrderParameters;

    @Override
    public void faxPurchaseOrderPdf(PurchaseOrderDocument po, boolean isRetransmit) {
        LOG.debug("faxPurchaseOrderPdf(po,reTransmit) started");
        String pdfFileLocation = this.getPdfFileLocation();
        if (pdfFileLocation == null) {
            throw new RuntimeException("Application Setting PDF_DIRECTORY is missing.");
        }
        String imageTempLocation = this.kualiConfigurationService.getPropertyValueAsString("temp.directory") + "/";
        if (imageTempLocation == null) {
            throw new RuntimeException("Application Setting TEMP_DIRECTORY_KEY is missing.");
        }
        LOG.debug("faxPurchaseOrderPdf() ended");
        this.faxPurchaseOrderPdf(po, pdfFileLocation, imageTempLocation, isRetransmit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void faxPurchaseOrderPdf(PurchaseOrderDocument po, String pdfFileLocation, String imageTempLocation, boolean isRetransmit) {
        block25: {
            LOG.debug("faxPurchaseOrderPdf() started with locations");
            if (StringUtils.isNotBlank((CharSequence)po.getVendorCountryCode())) {
                Country vendorCountry = this.locationService.getCountry(po.getVendorCountryCode());
                if (vendorCountry != null) {
                    po.setVendorCountryCode(vendorCountry.getCode());
                } else {
                    po.setVendorCountryCode("NA");
                }
            } else {
                po.setVendorCountryCode("NA");
            }
            this.purchaseOrderParameters.setPurchaseOrderPdfAndFaxParameters(po);
            PurchaseOrderPdf poPdf = null;
            try {
                String environment = this.kualiConfigurationService.getPropertyValueAsString("environment");
                poPdf = new PurchaseOrderPdf();
                poPdf.savePdf(po, this.purchaseOrderParameters, isRetransmit, environment);
            }
            catch (PurError e) {
                GlobalVariables.getMessageMap().putError("errors", "error.blank", new String[0]);
                LOG.debug("faxPurchaseOrderPdf() ended");
            }
            catch (Throwable e) {
                Supplier[] supplierArray = new Supplier[2];
                supplierArray[0] = e::getMessage;
                supplierArray[1] = () -> e;
                LOG.error("faxPurchaseOrderPdf() Faxing Failed on PDF creation - Exception was {}", supplierArray);
                GlobalVariables.getMessageMap().putError("errors", "error.blank", new String[]{"Faxing Error.  Unable to save pdf file. Please Contact Purchasing"});
                LOG.debug("faxPurchaseOrderPdf() ended");
            }
            PurchaseOrderTransmitParameters transmitParameters = (PurchaseOrderTransmitParameters)this.purchaseOrderParameters;
            String[] files = new String[]{transmitParameters.getPdfFileName()};
            this.faxPDF(files, this.purchaseOrderParameters);
            try {
                if (poPdf != null) {
                    poPdf.deletePdf(pdfFileLocation, transmitParameters.getPdfFileName());
                }
                break block25;
            }
            catch (Throwable e) {
                Supplier[] supplierArray = new Supplier[2];
                supplierArray[0] = e::getMessage;
                supplierArray[1] = () -> e;
                LOG.error("faxPurchaseOrderPdf() Error deleting PDF - Exception was {}", supplierArray);
                GlobalVariables.getMessageMap().putError("errors", "error.blank", new String[]{"Your fax was sent successfully but an error occurred that is unrelated to faxing. Please report this problem to Purchasing"});
            }
            break block25;
            catch (FaxServerUnavailableError | FaxSubmissionError | PurError e) {
                GlobalVariables.getMessageMap().putError("errors", "error.blank", new String[0]);
                try {
                    if (poPdf != null) {
                        poPdf.deletePdf(pdfFileLocation, transmitParameters.getPdfFileName());
                    }
                }
                catch (Throwable e2) {
                    Supplier[] supplierArray = new Supplier[2];
                    supplierArray[0] = e2::getMessage;
                    supplierArray[1] = () -> e;
                    LOG.error("faxPurchaseOrderPdf() Error deleting PDF - Exception was {}", supplierArray);
                    GlobalVariables.getMessageMap().putError("errors", "error.blank", new String[]{"Your fax was sent successfully but an error occurred that is unrelated to faxing. Please report this problem to Purchasing"});
                }
            }
            catch (Throwable e2) {
                Supplier[] supplierArray = new Supplier[2];
                supplierArray[0] = e2::getMessage;
                supplierArray[1] = () -> e2;
                LOG.error("faxPurchaseOrderPdf() Faxing Failed Exception was {}", supplierArray);
                GlobalVariables.getMessageMap().putError("errors", "error.blank", new String[]{"Faxing Error.  Please Contact Purchasing"});
                {
                    catch (Throwable throwable) {
                        try {
                            if (poPdf != null) {
                                poPdf.deletePdf(pdfFileLocation, transmitParameters.getPdfFileName());
                            }
                        }
                        catch (Throwable e3) {
                            Supplier[] supplierArray2 = new Supplier[2];
                            supplierArray2[0] = e3::getMessage;
                            supplierArray2[1] = () -> e;
                            LOG.error("faxPurchaseOrderPdf() Error deleting PDF - Exception was {}", supplierArray2);
                            GlobalVariables.getMessageMap().putError("errors", "error.blank", new String[]{"Your fax was sent successfully but an error occurred that is unrelated to faxing. Please report this problem to Purchasing"});
                        }
                        throw throwable;
                    }
                }
                try {
                    if (poPdf != null) {
                        poPdf.deletePdf(pdfFileLocation, transmitParameters.getPdfFileName());
                    }
                }
                catch (Throwable e4) {
                    Supplier[] supplierArray3 = new Supplier[2];
                    supplierArray3[0] = e4::getMessage;
                    supplierArray3[1] = () -> e;
                    LOG.error("faxPurchaseOrderPdf() Error deleting PDF - Exception was {}", supplierArray3);
                    GlobalVariables.getMessageMap().putError("errors", "error.blank", new String[]{"Your fax was sent successfully but an error occurred that is unrelated to faxing. Please report this problem to Purchasing"});
                }
            }
        }
        LOG.debug("faxPurchaseOrderPdf() ended");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void faxPurchaseOrderQuotePdf(PurchaseOrderDocument po, PurchaseOrderVendorQuote povq) {
        block21: {
            LOG.debug("faxPurchaseOrderQuotePdf() started");
            this.purchaseOrderParameters.setPurchaseOrderPdfAndFaxParameters(po, povq);
            String environmentCode = this.kualiConfigurationService.getPropertyValueAsString("environment");
            PurchaseOrderQuotePdf poQuotePdf = new PurchaseOrderQuotePdf();
            try {
                if (StringUtils.isNotBlank((CharSequence)povq.getVendorCountryCode())) {
                    Country vendorCountry = this.locationService.getCountry(po.getVendorCountryCode());
                    if (vendorCountry != null) {
                        povq.setVendorCountryCode(vendorCountry.getCode());
                    } else {
                        povq.setVendorCountryCode("NA");
                    }
                } else {
                    povq.setVendorCountryCode("NA");
                }
                poQuotePdf.savePOQuotePDF(po, povq, this.purchaseOrderParameters, environmentCode);
            }
            catch (PurError e) {
                GlobalVariables.getMessageMap().putError("errors", "error.blank", new String[0]);
                LOG.debug("faxPurchaseOrderQuotePdf() ended");
            }
            catch (Throwable e) {
                Supplier[] supplierArray = new Supplier[2];
                supplierArray[0] = e::getMessage;
                supplierArray[1] = () -> e;
                LOG.error("faxPurchaseOrderQuotePdf() Faxing Failed on PDF creation - Exception was {}", supplierArray);
                Supplier[] supplierArray2 = new Supplier[2];
                supplierArray2[0] = e::getMessage;
                supplierArray2[1] = () -> e;
                LOG.error("faxPurchaseOrderQuotePdf() Faxing Failed on PDF creation - Exception was {}", supplierArray2);
                GlobalVariables.getMessageMap().putError("errors", "error.blank", new String[]{"Faxing Error.  Unable to save pdf file. Please Contact Purchasing"});
            }
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = po::getPurapDocumentIdentifier;
            supplierArray[1] = povq::getPurchaseOrderVendorQuoteIdentifier;
            LOG.debug("faxPurchaseOrderQuotePdf() Quote PDF saved successfully for PO {} and Quote ID {}", supplierArray);
            PurchaseOrderTransmitParameters transmitParameters = (PurchaseOrderTransmitParameters)this.purchaseOrderParameters;
            String pdfFileLocation = transmitParameters.getPdfFileLocation();
            String pdfFileName = transmitParameters.getPdfFileName();
            String[] files = new String[]{pdfFileName};
            this.faxPDF(files, transmitParameters);
            try {
                poQuotePdf.deletePdf(pdfFileLocation, pdfFileName);
            }
            catch (Throwable e) {
                Supplier[] supplierArray3 = new Supplier[3];
                supplierArray3[0] = () -> pdfFileName;
                supplierArray3[1] = e::getMessage;
                supplierArray3[2] = () -> e;
                LOG.error("faxPurchaseOrderQuotePdf() Error deleting Quote PDF{} - Exception was {}", supplierArray3);
                GlobalVariables.getMessageMap().putError("errors", "error.blank", new String[]{"Your fax was sent successfully but an error occurred that is unrelated to faxing. Please report this problem to Purchasing"});
            }
            break block21;
            catch (FaxSubmissionError e) {
                Supplier[] supplierArray4 = new Supplier[3];
                supplierArray4[0] = () -> pdfFileName;
                supplierArray4[1] = e::getMessage;
                supplierArray4[2] = () -> e;
                LOG.error("faxPurchaseOrderQuotePdf() Error faxing Quote PDF{} - Exception was {}", supplierArray4);
                GlobalVariables.getMessageMap().putError("errors", "error.blank", new String[0]);
                try {
                    poQuotePdf.deletePdf(pdfFileLocation, pdfFileName);
                }
                catch (Throwable e2) {
                    Supplier[] supplierArray5 = new Supplier[3];
                    supplierArray5[0] = () -> pdfFileName;
                    supplierArray5[1] = e2::getMessage;
                    supplierArray5[2] = () -> e;
                    LOG.error("faxPurchaseOrderQuotePdf() Error deleting Quote PDF{} - Exception was {}", supplierArray5);
                    GlobalVariables.getMessageMap().putError("errors", "error.blank", new String[]{"Your fax was sent successfully but an error occurred that is unrelated to faxing. Please report this problem to Purchasing"});
                }
            }
            catch (Throwable e2) {
                Supplier[] supplierArray6 = new Supplier[3];
                supplierArray6[0] = () -> pdfFileName;
                supplierArray6[1] = e2::getMessage;
                supplierArray6[2] = () -> e2;
                LOG.error("faxPurchaseOrderQuotePdf() Error faxing Quote PDF{} - Exception was {}", supplierArray6);
                GlobalVariables.getMessageMap().putError("errors", "error.blank", new String[]{"The document did not successfully transmit to the fax server. Report this to the Procurement Services Technology group, make note of the document you attempted to transmit and try again when the issue has been resolved"});
                {
                    catch (Throwable throwable) {
                        try {
                            poQuotePdf.deletePdf(pdfFileLocation, pdfFileName);
                        }
                        catch (Throwable e3) {
                            Supplier[] supplierArray7 = new Supplier[3];
                            supplierArray7[0] = () -> pdfFileName;
                            supplierArray7[1] = e3::getMessage;
                            supplierArray7[2] = () -> e;
                            LOG.error("faxPurchaseOrderQuotePdf() Error deleting Quote PDF{} - Exception was {}", supplierArray7);
                            GlobalVariables.getMessageMap().putError("errors", "error.blank", new String[]{"Your fax was sent successfully but an error occurred that is unrelated to faxing. Please report this problem to Purchasing"});
                        }
                        throw throwable;
                    }
                }
                try {
                    poQuotePdf.deletePdf(pdfFileLocation, pdfFileName);
                }
                catch (Throwable e4) {
                    Supplier[] supplierArray8 = new Supplier[3];
                    supplierArray8[0] = () -> pdfFileName;
                    supplierArray8[1] = e4::getMessage;
                    supplierArray8[2] = () -> e;
                    LOG.error("faxPurchaseOrderQuotePdf() Error deleting Quote PDF{} - Exception was {}", supplierArray8);
                    GlobalVariables.getMessageMap().putError("errors", "error.blank", new String[]{"Your fax was sent successfully but an error occurred that is unrelated to faxing. Please report this problem to Purchasing"});
                }
            }
        }
        LOG.debug("faxPurchaseOrderQuotePdf() ended");
    }

    protected void faxPDF(String[] files, PurchaseOrderParameters transmitParameters) {
        LOG.info("faxPDF() NEEDS TO BE IMPLEMENTED!");
        throw new RuntimeException("faxPDF() NEEDS TO BE IMPLEMENTED!");
    }

    public String getPdfFileLocation() {
        return this.parameterService.getParameterValueAsString(KfsParameterConstants.PURCHASING_DOCUMENT.class, "PDF_DIRECTORY");
    }

    public void setConfigurationService(ConfigurationService kualiConfigurationService) {
        this.kualiConfigurationService = kualiConfigurationService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setVendorService(VendorService vendorService) {
        this.vendorService = vendorService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setLocationService(LocationService locationService) {
        this.locationService = locationService;
    }

    public void setPurchaseOrderParameters(PurchaseOrderParameters purchaseOrderParameters) {
        this.purchaseOrderParameters = purchaseOrderParameters;
    }
}

