/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.sql.Date;
import java.util.Map;
import org.kuali.kfs.kew.api.WorkflowDocument;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.PersistenceService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.service.PurapService;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class PaymentRequestPayDateNotPastValidation
extends GenericValidation {
    private PurapService purapService;
    private PersistenceService persistenceService;
    private BusinessObjectService businessObjectService;

    public boolean validate(AttributedDocumentEvent event) {
        boolean valid = true;
        PaymentRequestDocument document = (PaymentRequestDocument)event.getDocument();
        GlobalVariables.getMessageMap().clearErrorPath();
        GlobalVariables.getMessageMap().addToErrorPath("document");
        Date paymentRequestPayDate = document.getPaymentRequestPayDate();
        if (ObjectUtils.isNotNull((Object)paymentRequestPayDate) && this.purapService.isDateInPast(paymentRequestPayDate)) {
            WorkflowDocument workflowDocument = document.getDocumentHeader().getWorkflowDocument();
            if (workflowDocument.isInitiated() || workflowDocument.isSaved()) {
                valid = false;
                GlobalVariables.getMessageMap().putError("paymentRequestPayDate", "errors.invalid.pay.date", new String[0]);
            } else {
                PaymentRequestDocument paymentRequestDocumentFromDatabase = this.retrievePaymentRequestDocumentFromDatabase(document);
                if (ObjectUtils.isNull((Object)paymentRequestDocumentFromDatabase)) {
                    throw new NullPointerException("Unable to find payment request document " + document.getDocumentNumber() + " from database");
                }
                Date paymentRequestPayDateFromDatabase = paymentRequestDocumentFromDatabase.getPaymentRequestPayDate();
                if (ObjectUtils.isNull((Object)paymentRequestPayDateFromDatabase) || !paymentRequestPayDateFromDatabase.equals(paymentRequestPayDate)) {
                    valid = false;
                    GlobalVariables.getMessageMap().putError("paymentRequestPayDate", "errors.invalid.pay.date", new String[0]);
                }
            }
        }
        GlobalVariables.getMessageMap().clearErrorPath();
        return valid;
    }

    protected PaymentRequestDocument retrievePaymentRequestDocumentFromDatabase(PaymentRequestDocument document) {
        Map primaryKeyValues = this.persistenceService.getPrimaryKeyFieldValues((Object)document);
        return (PaymentRequestDocument)this.businessObjectService.findByPrimaryKey(document.getClass(), primaryKeyValues);
    }

    public PurapService getPurapService() {
        return this.purapService;
    }

    public void setPurapService(PurapService purapService) {
        this.purapService = purapService;
    }

    public PersistenceService getPersistenceService() {
        return this.persistenceService;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

