/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.core.api.parameter.ParameterEvaluatorService;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.datadictionary.legacy.DataDictionaryService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.PurapConstants;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocument;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class PurchasingAccountsPayableBelowTheLineValuesValidation
extends GenericValidation {
    private DataDictionaryService dataDictionaryService;
    private ParameterService parameterService;
    private PurApItem itemForValidation;
    private ParameterEvaluatorService parameterEvaluatorService;

    public boolean validate(AttributedDocumentEvent event) {
        boolean valid = true;
        PurchasingAccountsPayableDocument purapDocument = (PurchasingAccountsPayableDocument)event.getDocument();
        String documentType = this.dataDictionaryService.getDocumentTypeNameByClass(purapDocument.getClass());
        try {
            if (ObjectUtils.isNotNull((Object)this.itemForValidation.getItemUnitPrice())) {
                if (new KualiDecimal(this.itemForValidation.getItemUnitPrice()).isZero()) {
                    this.parameterEvaluatorService = (ParameterEvaluatorService)SpringContext.getBean(ParameterEvaluatorService.class);
                    if (this.parameterService.parameterExists(Class.forName(PurapConstants.PURAP_DETAIL_TYPE_CODE_MAP.get(documentType)), "ITEM_TYPES_ALLOWING_ZERO").booleanValue() && !this.parameterEvaluatorService.getParameterEvaluator(Class.forName(PurapConstants.PURAP_DETAIL_TYPE_CODE_MAP.get(documentType)), "ITEM_TYPES_ALLOWING_ZERO", this.itemForValidation.getItemTypeCode()).evaluationSucceeds()) {
                        valid = false;
                        GlobalVariables.getMessageMap().putError("itemUnitPrice", "errors.item.belowTheLine", new String[]{this.itemForValidation.getItemType().getItemTypeDescription(), "zero"});
                    }
                } else if (new KualiDecimal(this.itemForValidation.getItemUnitPrice()).isPositive()) {
                    if (this.parameterService.parameterExists(Class.forName(PurapConstants.PURAP_DETAIL_TYPE_CODE_MAP.get(documentType)), "ITEM_TYPES_ALLOWING_POSITIVE").booleanValue() && !this.parameterEvaluatorService.getParameterEvaluator(Class.forName(PurapConstants.PURAP_DETAIL_TYPE_CODE_MAP.get(documentType)), "ITEM_TYPES_ALLOWING_POSITIVE", this.itemForValidation.getItemTypeCode()).evaluationSucceeds()) {
                        valid = false;
                        GlobalVariables.getMessageMap().putError("itemUnitPrice", "errors.item.belowTheLine", new String[]{this.itemForValidation.getItemType().getItemTypeDescription(), "positive"});
                    }
                } else if (new KualiDecimal(this.itemForValidation.getItemUnitPrice()).isNegative() && this.parameterService.parameterExists(Class.forName(PurapConstants.PURAP_DETAIL_TYPE_CODE_MAP.get(documentType)), "ITEM_TYPES_ALLOWING_NEGATIVE").booleanValue() && !this.parameterEvaluatorService.getParameterEvaluator(Class.forName(PurapConstants.PURAP_DETAIL_TYPE_CODE_MAP.get(documentType)), "ITEM_TYPES_ALLOWING_NEGATIVE", this.itemForValidation.getItemTypeCode()).evaluationSucceeds()) {
                    valid = false;
                    GlobalVariables.getMessageMap().putError("itemUnitPrice", "errors.item.belowTheLine", new String[]{this.itemForValidation.getItemType().getItemTypeDescription(), "negative"});
                }
            }
            if (ObjectUtils.isNotNull((Object)this.itemForValidation.getItemUnitPrice()) && new KualiDecimal(this.itemForValidation.getItemUnitPrice()).isNonZero() && StringUtils.isEmpty((CharSequence)this.itemForValidation.getItemDescription()) && this.parameterService.parameterExists(Class.forName(PurapConstants.PURAP_DETAIL_TYPE_CODE_MAP.get(documentType)), "ITEM_TYPES_REQUIRING_USER_ENTERED_DESCRIPTION").booleanValue() && this.parameterEvaluatorService.getParameterEvaluator(Class.forName(PurapConstants.PURAP_DETAIL_TYPE_CODE_MAP.get(documentType)), "ITEM_TYPES_REQUIRING_USER_ENTERED_DESCRIPTION", this.itemForValidation.getItemTypeCode()).evaluationSucceeds()) {
                valid = false;
                GlobalVariables.getMessageMap().putError("itemDescription", "errors.item.belowTheLine", new String[]{"The item description of " + this.itemForValidation.getItemType().getItemTypeDescription(), "empty"});
            }
            if (ObjectUtils.isNotNull((Object)this.itemForValidation.getTotalAmount()) && this.itemForValidation.getTotalAmount().isPositive() && this.parameterService.parameterExists(Class.forName(PurapConstants.PURAP_DETAIL_TYPE_CODE_MAP.get(documentType)), "ITEM_TYPES_ALLOWING_POSITIVE").booleanValue() && !this.parameterEvaluatorService.getParameterEvaluator(Class.forName(PurapConstants.PURAP_DETAIL_TYPE_CODE_MAP.get(documentType)), "ITEM_TYPES_ALLOWING_POSITIVE", this.itemForValidation.getItemTypeCode()).evaluationSucceeds()) {
                valid = false;
                GlobalVariables.getMessageMap().putError("totalAmount", "errors.item.belowTheLine", new String[]{this.itemForValidation.getItemType().getItemTypeDescription() + " Total Amount", "positive"});
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("The validateBelowTheLineValues of PurchasingAccountsPayableDocumentRuleBase was unable to resolve a document type class: " + PurapConstants.PURAP_DETAIL_TYPE_CODE_MAP.get(documentType), e);
        }
        return valid;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public PurApItem getItemForValidation() {
        return this.itemForValidation;
    }

    public void setItemForValidation(PurApItem itemForValidation) {
        this.itemForValidation = itemForValidation;
    }

    public void setParameterEvaluatorService(ParameterEvaluatorService parameterEvaluatorService) {
        this.parameterEvaluatorService = parameterEvaluatorService;
    }
}

