/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.kuali.kfs.core.web.format.FormatException;
import org.kuali.kfs.krad.bo.BusinessObject;
import org.kuali.kfs.krad.bo.ExternalizableBusinessObject;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.service.ModuleService;
import org.kuali.kfs.krad.service.PersistenceService;
import org.kuali.kfs.krad.util.ExternalizableBusinessObjectUtils;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.PurapConstants;
import org.kuali.kfs.sys.context.SpringContext;

public final class PurApObjectUtils {
    private static final Logger LOG = LogManager.getLogger();

    private PurApObjectUtils() {
    }

    public static void populateFromBaseClass(Class base, BusinessObject src, BusinessObject target, Map supplementalUncopyable) {
        Field[] fields;
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (Field field : fields = base.getDeclaredFields()) {
            if (!Modifier.isTransient(field.getModifiers())) {
                fieldNames.add(field.getName());
                continue;
            }
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = field::getName;
            LOG.debug("field {} is transient, skipping ", supplierArray);
        }
        int counter = 0;
        for (String fieldName : fieldNames) {
            if (!PurApObjectUtils.isProcessableField(base, fieldName, PurapConstants.KNOWN_UNCOPYABLE_FIELDS) || !PurApObjectUtils.isProcessableField(base, fieldName, supplementalUncopyable)) continue;
            PurApObjectUtils.attemptCopyOfFieldName(base.getName(), fieldName, src, target, supplementalUncopyable);
            ++counter;
        }
        int loggableCounter = counter;
        Supplier[] supplierArray = new Supplier[3];
        supplierArray[0] = () -> loggableCounter;
        supplierArray[1] = fieldNames::size;
        supplierArray[2] = () -> base;
        LOG.debug("Population complete for {} fields out of a total of {} potential fields in object with base class '{}'", supplierArray);
    }

    public static void populateFromBaseClass(Class base, BusinessObject src, BusinessObject target) {
        PurApObjectUtils.populateFromBaseClass(base, src, target, new HashMap());
    }

    protected static boolean isProcessableField(Class baseClass, String fieldName, Map excludedFieldNames) {
        if (excludedFieldNames.containsKey(fieldName)) {
            Class potentialClassName = (Class)excludedFieldNames.get(fieldName);
            return ObjectUtils.isNotNull((Object)potentialClassName) && !potentialClassName.equals(baseClass);
        }
        return true;
    }

    protected static void attemptCopyOfFieldName(String baseClassName, String fieldName, BusinessObject sourceObject, BusinessObject targetObject, Map supplementalUncopyable) {
        try {
            Object propertyValue = ObjectUtils.getPropertyValue((Object)sourceObject, (String)fieldName);
            if (ObjectUtils.isNotNull((Object)propertyValue) && Collection.class.isAssignableFrom(propertyValue.getClass())) {
                Supplier[] supplierArray = new Supplier[3];
                supplierArray[0] = () -> fieldName;
                supplierArray[1] = () -> baseClassName;
                supplierArray[2] = propertyValue::getClass;
                LOG.debug("attempting to copy collection field '{}' using base class '{}' and property value class '{}'", supplierArray);
                PurApObjectUtils.copyCollection(fieldName, targetObject, (Collection)propertyValue, supplementalUncopyable);
            } else {
                String propertyValueClass = ObjectUtils.isNotNull((Object)propertyValue) ? propertyValue.getClass().toString() : "(null)";
                LOG.debug("attempting to set field '{}' using base class '{}' and property value class '{}'", (Object)fieldName, (Object)baseClassName, (Object)propertyValueClass);
                ObjectUtils.setObjectProperty((Object)targetObject, (String)fieldName, (Object)propertyValue);
            }
        }
        catch (Exception e) {
            String exceptionClassname = e.getClass().getName();
            LOG.debug("couldn't set field '{}' using base class '{}' due to exception with class name '{}'", (Object)fieldName, (Object)baseClassName, (Object)exceptionClassname, (Object)e);
        }
    }

    protected static <T extends BusinessObject> void copyCollection(String fieldName, BusinessObject targetObject, Collection<T> sourceList, Map supplementalUncopyable) throws FormatException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        ArrayList<BusinessObject> listToSet;
        if (ObjectUtils.isNotNull(sourceList)) {
            ObjectUtils.materializeObjects(sourceList);
        }
        try {
            listToSet = (ArrayList<BusinessObject>)sourceList.getClass().newInstance();
        }
        catch (Exception e) {
            Supplier[] supplierArray = new Supplier[3];
            supplierArray[0] = sourceList::getClass;
            supplierArray[1] = () -> fieldName;
            supplierArray[2] = sourceList::getClass;
            LOG.debug("couldn't set class '{}' on collection...{} using {}", supplierArray);
            listToSet = new ArrayList<BusinessObject>();
        }
        for (BusinessObject sourceCollectionObject : sourceList) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = sourceCollectionObject::getClass;
            LOG.debug("attempting to copy collection member with class '{}'", supplierArray);
            BusinessObject targetCollectionObject = (BusinessObject)PurApObjectUtils.createNewObjectFromClass(sourceCollectionObject.getClass());
            PurApObjectUtils.populateFromBaseWithSuper(sourceCollectionObject, targetCollectionObject, supplementalUncopyable, new HashSet<Class>());
            Map pkMap = ((PersistenceService)SpringContext.getBean(PersistenceService.class)).getPrimaryKeyFieldValues((Object)targetCollectionObject);
            Set pkFields = pkMap.keySet();
            for (String field : pkFields) {
                ObjectUtils.setObjectProperty((Object)targetCollectionObject, (String)field, null);
            }
            listToSet.add(targetCollectionObject);
        }
        ObjectUtils.setObjectProperty((Object)targetObject, (String)fieldName, (Object)listToSet);
    }

    protected static Object createNewObjectFromClass(Class clazz) {
        if (clazz == null) {
            throw new RuntimeException("BO class was passed in as null");
        }
        try {
            if (clazz.getSuperclass().equals(ExternalizableBusinessObject.class)) {
                Class eboInterface = ExternalizableBusinessObjectUtils.determineExternalizableBusinessObjectSubInterface((Class)clazz);
                ModuleService moduleService = ((KualiModuleService)SpringContext.getBean(KualiModuleService.class)).getResponsibleModuleService(eboInterface);
                return moduleService.createNewObjectFromExternalizableClass(eboInterface);
            }
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Error occurred while trying to create a new instance for class " + clazz);
        }
    }

    public static void populateFromBaseWithSuper(BusinessObject sourceObject, BusinessObject targetObject, Map supplementalUncopyableFieldNames, Set<Class> classesToExclude) {
        ArrayList classesToCopy = new ArrayList();
        Class<?> sourceObjectClass = sourceObject.getClass();
        classesToCopy.add(sourceObjectClass);
        while (sourceObjectClass.getSuperclass() != null) {
            if (classesToExclude.contains(sourceObjectClass = sourceObjectClass.getSuperclass())) continue;
            classesToCopy.add(sourceObjectClass);
        }
        for (int i = classesToCopy.size() - 1; i >= 0; --i) {
            Class temp = (Class)classesToCopy.get(i);
            PurApObjectUtils.populateFromBaseClass(temp, sourceObject, targetObject, supplementalUncopyableFieldNames);
        }
    }

    public static BusinessObject retrieveObjectWithIdentitcalKey(Collection controlList, BusinessObject bo) {
        BusinessObject returnBo = null;
        for (Object control : controlList) {
            BusinessObject listBo = (BusinessObject)control;
            if (!PurApObjectUtils.equalByKeys(listBo, bo)) continue;
            returnBo = listBo;
        }
        return returnBo;
    }

    public static boolean equalByKeys(BusinessObject bo1, BusinessObject bo2) {
        if (bo1 == null && bo2 == null) {
            return true;
        }
        if (bo1 == null || bo2 == null) {
            return false;
        }
        if (!bo1.getClass().getName().equals(bo2.getClass().getName())) {
            return false;
        }
        Map bo1Keys = ((PersistenceService)SpringContext.getBean(PersistenceService.class)).getPrimaryKeyFieldValues((Object)bo1);
        Map bo2Keys = ((PersistenceService)SpringContext.getBean(PersistenceService.class)).getPrimaryKeyFieldValues((Object)bo2);
        for (Object key : bo1Keys.keySet()) {
            String keyName = (String)key;
            if (bo1Keys.get(keyName) != null && bo2Keys.get(keyName) != null) {
                if (bo1Keys.get(keyName).toString().equals(bo2Keys.get(keyName).toString())) continue;
                return false;
            }
            return false;
        }
        return true;
    }
}

