/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.dataaccess.impl;

import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.ReportQueryByCriteria;
import org.kuali.kfs.core.framework.persistence.ojb.dao.PlatformAwareDaoBaseOjb;
import org.kuali.kfs.module.purap.document.CorrectionReceivingDocument;
import org.kuali.kfs.module.purap.document.LineItemReceivingDocument;
import org.kuali.kfs.module.purap.document.dataaccess.ReceivingDao;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class ReceivingDaoOjb
extends PlatformAwareDaoBaseOjb
implements ReceivingDao {
    @Override
    public List<String> getDocumentNumbersByPurchaseOrderId(Integer id) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("purchaseOrderIdentifier", (Object)id);
        return this.getDocumentNumbersOfReceivingLineByCriteria(criteria, false);
    }

    @Override
    public List<String> getCorrectionReceivingDocumentNumbersByPurchaseOrderId(Integer id) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("lineItemReceivingDocument.purchaseOrderIdentifier", (Object)id);
        return this.getDocumentNumbersOfCorrectionReceivingByCriteria(criteria, false);
    }

    @Override
    public List<String> getCorrectionReceivingDocumentNumbersByReceivingLineNumber(String receivingDocumentNumber) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("lineItemReceivingDocumentNumber", (Object)receivingDocumentNumber);
        return this.getDocumentNumbersOfCorrectionReceivingByCriteria(criteria, false);
    }

    protected List<String> getDocumentNumbersOfReceivingLineByCriteria(Criteria criteria, boolean orderByAscending) {
        ReportQueryByCriteria rqbc = new ReportQueryByCriteria(LineItemReceivingDocument.class, criteria);
        if (orderByAscending) {
            rqbc.addOrderByAscending("documentNumber");
        } else {
            rqbc.addOrderByDescending("documentNumber");
        }
        List lineItemRecvDocs = (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)rqbc);
        ArrayList<String> returnList = new ArrayList<String>();
        for (LineItemReceivingDocument lineItemRecvDoc : lineItemRecvDocs) {
            returnList.add(lineItemRecvDoc.getDocumentNumber());
        }
        return returnList;
    }

    protected List<String> getDocumentNumbersOfCorrectionReceivingByCriteria(Criteria criteria, boolean orderByAscending) {
        ReportQueryByCriteria rqbc = new ReportQueryByCriteria(CorrectionReceivingDocument.class, criteria);
        if (orderByAscending) {
            rqbc.addOrderByAscending("documentNumber");
        } else {
            rqbc.addOrderByDescending("documentNumber");
        }
        List correctionRecvDocs = (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)rqbc);
        ArrayList<String> returnList = new ArrayList<String>();
        for (CorrectionReceivingDocument correctionRecvDoc : correctionRecvDocs) {
            returnList.add(correctionRecvDoc.getDocumentNumber());
        }
        return returnList;
    }

    @Override
    public List<String> duplicateBillOfLadingNumber(Integer poId, String billOfLadingNumber) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("purchaseOrderIdentifier", (Object)poId);
        criteria.addEqualTo("shipmentBillOfLadingNumber", (Object)billOfLadingNumber);
        return this.getDocumentNumbersOfReceivingLineByCriteria(criteria, false);
    }

    @Override
    public List<String> duplicatePackingSlipNumber(Integer poId, String packingSlipNumber) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("purchaseOrderIdentifier", (Object)poId);
        criteria.addEqualTo("shipmentPackingSlipNumber", (Object)packingSlipNumber);
        return this.getDocumentNumbersOfReceivingLineByCriteria(criteria, false);
    }

    @Override
    public List<String> duplicateVendorDate(Integer poId, Date vendorDate) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("purchaseOrderIdentifier", (Object)poId);
        criteria.addEqualTo("shipmentReceivedDate", (Object)vendorDate);
        return this.getDocumentNumbersOfReceivingLineByCriteria(criteria, false);
    }
}

