/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.datadictionary.legacy.BusinessObjectDictionaryService;
import org.kuali.kfs.integration.cam.CapitalAssetManagementModuleService;
import org.kuali.kfs.integration.purap.CapitalAssetLocation;
import org.kuali.kfs.integration.purap.CapitalAssetSystem;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.SequenceAccessorService;
import org.kuali.kfs.krad.service.impl.PersistenceServiceStructureImplBase;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchasingCapitalAssetItem;
import org.kuali.kfs.module.purap.document.PurchasingDocument;
import org.kuali.kfs.module.purap.document.service.PurchasingDocumentSpecificService;
import org.kuali.kfs.module.purap.document.service.PurchasingService;
import org.kuali.kfs.module.purap.service.PurapAccountingService;
import org.kuali.kfs.sys.businessobject.Room;
import org.kuali.kfs.sys.service.PostalCodeValidationService;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;
import org.kuali.kfs.vnd.businessobject.VendorDetail;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class PurchasingServiceImpl
extends PersistenceServiceStructureImplBase
implements PurchasingService {
    protected ParameterService parameterService;
    protected SequenceAccessorService sequenceAccessorService;
    protected PurapAccountingService purapAccountingService;
    protected CapitalAssetManagementModuleService capitalAssetManagementModuleService;
    protected PostalCodeValidationService postalCodeValidationService;
    private BusinessObjectService businessObjectService;
    private BusinessObjectDictionaryService businessObjectDictionaryService;

    @Override
    public void setupCapitalAssetItems(PurchasingDocument purDoc) {
        List<PurchasingCapitalAssetItem> camsItemsList = purDoc.getPurchasingCapitalAssetItems();
        ArrayList<PurchasingCapitalAssetItem> newCamsItemsList = new ArrayList<PurchasingCapitalAssetItem>();
        for (PurApItem purapItem : purDoc.getItems()) {
            if (purapItem.getItemType().isLineItemIndicator() || "TRDI".equals(purapItem.getItemTypeCode())) {
                PurchasingCapitalAssetItem camsItem;
                if (this.capitalAssetManagementModuleService.doesItemNeedCapitalAsset(purapItem.getItemTypeCode(), purapItem.getSourceAccountingLines())) {
                    camsItem = this.getItemIfAlreadyInCamsItemsList(purapItem, camsItemsList);
                    if (ObjectUtils.isNull((Object)camsItem) || purDoc.getCapitalAssetSystemTypeCode() != null && purDoc.getCapitalAssetSystemTypeCode().equals("IND") && ObjectUtils.isNull((Object)camsItem.getPurchasingCapitalAssetSystem())) {
                        PurchasingCapitalAssetItem newCamsItem = this.createCamsItem(purDoc, purapItem);
                        newCamsItemsList.add(newCamsItem);
                    } else {
                        camsItem.setPurchasingDocument(purDoc);
                        newCamsItemsList.add(camsItem);
                    }
                } else {
                    camsItem = this.getItemIfAlreadyInCamsItemsList(purapItem, camsItemsList);
                    if (camsItem != null && camsItem.isEmpty()) {
                        camsItemsList.remove(camsItem);
                    }
                }
            }
            purapItem.setPurapDocument(purDoc);
        }
        purDoc.setPurchasingCapitalAssetItems(newCamsItemsList);
        if (purDoc.getPurchasingCapitalAssetItems().isEmpty()) {
            purDoc.setCapitalAssetSystemStateCode(null);
            purDoc.setCapitalAssetSystemTypeCode(null);
        }
    }

    protected PurchasingCapitalAssetItem createCamsItem(PurchasingDocument purDoc, PurApItem purapItem) {
        PurchasingDocumentSpecificService purchasingDocumentSpecificService = purDoc.getDocumentSpecificService();
        if (purapItem.getItemIdentifier() == null) {
            ClassDescriptor cd = this.getClassDescriptor(purapItem.getClass());
            String sequenceName = cd.getFieldDescriptorByName("itemIdentifier").getSequenceName();
            Integer itemIdentifier = this.sequenceAccessorService.getNextAvailableSequenceNumber(sequenceName, PurApItem.class).intValue();
            purapItem.setItemIdentifier(itemIdentifier);
        }
        return purchasingDocumentSpecificService.createCamsItem(purDoc, purapItem);
    }

    protected PurchasingCapitalAssetItem getItemIfAlreadyInCamsItemsList(PurApItem item, List<PurchasingCapitalAssetItem> camsItemsList) {
        for (PurchasingCapitalAssetItem camsItem : camsItemsList) {
            if (camsItem.getItemIdentifier() == null || !camsItem.getItemIdentifier().equals(item.getItemIdentifier())) continue;
            return camsItem;
        }
        return null;
    }

    @Override
    public void deleteCapitalAssetItems(PurchasingDocument purDoc, Integer itemIdentifier) {
        int index = 0;
        for (PurchasingCapitalAssetItem camsItem : purDoc.getPurchasingCapitalAssetItems()) {
            if (camsItem.getItemIdentifier().equals(itemIdentifier)) break;
            ++index;
        }
        purDoc.getPurchasingCapitalAssetItems().remove(index);
    }

    @Override
    public void setupCapitalAssetSystem(PurchasingDocument purDoc) {
        CapitalAssetSystem resultSystem = purDoc.getDocumentSpecificService().createCapitalAssetSystem();
        if (purDoc.getCapitalAssetSystemTypeCode() != null && (purDoc.getCapitalAssetSystemTypeCode().equals("ONE") || purDoc.getCapitalAssetSystemTypeCode().equals("MUL")) && purDoc.getPurchasingCapitalAssetSystems().size() == 0) {
            purDoc.getPurchasingCapitalAssetSystems().add(resultSystem);
        }
    }

    @Override
    public boolean getDefaultUseTaxIndicatorValue(PurchasingDocument purDoc) {
        purDoc.refreshReferenceObject("vendorDetail");
        VendorDetail vendor = purDoc.getVendorDetail();
        if (vendor != null) {
            String billingStateCode;
            String vendorStateCode = vendor.getDefaultAddressStateCode();
            return !StringUtils.equals((CharSequence)vendorStateCode, (CharSequence)(billingStateCode = purDoc.getBillingStateCode())) && !vendor.isTaxableIndicator();
        }
        return true;
    }

    @Override
    public String getDefaultAssetTypeCodeNotThisFiscalYear() {
        return this.parameterService.getParameterValueAsString(KfsParameterConstants.CAPITAL_ASSETS_DOCUMENT.class, "PURCHASING_DEFAULT_ASSET_TYPE_WHEN_NOT_THIS_FISCAL_YEAR");
    }

    @Override
    public boolean checkCapitalAssetLocation(CapitalAssetLocation location) {
        if (ObjectUtils.isNotNull((Object)location) && (StringUtils.isEmpty((CharSequence)location.getCapitalAssetLine1Address()) || StringUtils.isEmpty((CharSequence)location.getCapitalAssetCityName()) || StringUtils.isEmpty((CharSequence)location.getCapitalAssetCountryCode()))) {
            String missingFields;
            if (StringUtils.isEmpty((CharSequence)location.getCapitalAssetLine1Address())) {
                missingFields = "Address";
                this.addErrorToCapitalAssetLocation("capitalAssetLine1Address", missingFields);
            }
            if (StringUtils.isEmpty((CharSequence)location.getCapitalAssetCityName())) {
                missingFields = "City";
                this.addErrorToCapitalAssetLocation("capitalAssetCityName", missingFields);
            }
            if (StringUtils.isEmpty((CharSequence)location.getCapitalAssetCountryCode())) {
                missingFields = "Country";
                this.addErrorToCapitalAssetLocation("capitalAssetCountryCode", missingFields);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean checkValidRoomNumber(CapitalAssetLocation location) {
        boolean valid = true;
        if (StringUtils.isNotBlank((CharSequence)location.getBuildingCode()) && StringUtils.isNotBlank((CharSequence)location.getBuildingRoomNumber())) {
            HashMap<String, String> objectKeys = new HashMap<String, String>();
            objectKeys.put("campusCode", location.getCampusCode());
            objectKeys.put("buildingCode", location.getBuildingCode());
            objectKeys.put("buildingRoomNumber", location.getBuildingRoomNumber());
            Room room = (Room)this.businessObjectService.findByPrimaryKey(Room.class, objectKeys);
            if (ObjectUtils.isNull((Object)room)) {
                GlobalVariables.getMessageMap().addToErrorPath("newPurchasingCapitalAssetLocationLine");
                GlobalVariables.getMessageMap().putError("buildingRoomNumber", "error.asset.location.invalid.room.code", new String[]{location.getBuildingCode(), location.getBuildingRoomNumber(), location.getCampusCode()});
                GlobalVariables.getMessageMap().removeFromErrorPath("newPurchasingCapitalAssetLocationLine");
                valid = false;
            } else if (!room.isActive()) {
                String label = this.businessObjectDictionaryService.getBusinessObjectEntry(Room.class.getName()).getAttributeDefinition("buildingRoomNumber").getLabel();
                GlobalVariables.getMessageMap().addToErrorPath("newPurchasingCapitalAssetLocationLine");
                GlobalVariables.getMessageMap().putError("buildingRoomNumber", "error.inactive", new String[]{label});
                GlobalVariables.getMessageMap().removeFromErrorPath("newPurchasingCapitalAssetLocationLine");
                valid = false;
            }
        } else if (StringUtils.isBlank((CharSequence)location.getBuildingCode()) && StringUtils.isNotBlank((CharSequence)location.getBuildingRoomNumber())) {
            HashMap<String, String> objectKeys = new HashMap<String, String>();
            objectKeys.put("campusCode", location.getCampusCode());
            objectKeys.put("buildingRoomNumber", location.getBuildingRoomNumber());
            Room room = (Room)this.businessObjectService.findByPrimaryKey(Room.class, objectKeys);
            if (ObjectUtils.isNull((Object)room)) {
                GlobalVariables.getMessageMap().addToErrorPath("newPurchasingCapitalAssetLocationLine");
                GlobalVariables.getMessageMap().putError("buildingRoomNumber", "error.asset.location.invalid.room.code.for.campus", new String[]{location.getBuildingRoomNumber(), location.getCampusCode()});
                GlobalVariables.getMessageMap().removeFromErrorPath("newPurchasingCapitalAssetLocationLine");
                valid = false;
            } else if (!room.isActive()) {
                String label = this.businessObjectDictionaryService.getBusinessObjectEntry(Room.class.getName()).getAttributeDefinition("buildingRoomNumber").getLabel();
                GlobalVariables.getMessageMap().addToErrorPath("newPurchasingCapitalAssetLocationLine");
                GlobalVariables.getMessageMap().putError("buildingRoomNumber", "error.inactive", new String[]{label});
                GlobalVariables.getMessageMap().removeFromErrorPath("newPurchasingCapitalAssetLocationLine");
                valid = false;
            }
        }
        return valid;
    }

    public void addErrorToCapitalAssetLocation(String path, String field) {
        GlobalVariables.getMessageMap().addToErrorPath("newPurchasingCapitalAssetLocationLine");
        GlobalVariables.getMessageMap().putError(path, "error.capitalAsset.incomplete.address", new String[]{field});
        GlobalVariables.getMessageMap().removeFromErrorPath("newPurchasingCapitalAssetLocationLine");
    }

    public void setBusinessObjectDictionaryService(BusinessObjectDictionaryService businessObjectDictionaryService) {
        this.businessObjectDictionaryService = businessObjectDictionaryService;
    }

    public void setPurapAccountingService(PurapAccountingService purapAccountingService) {
        this.purapAccountingService = purapAccountingService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setSequenceAccessorService(SequenceAccessorService sequenceAccessorService) {
        this.sequenceAccessorService = sequenceAccessorService;
    }

    public void setCapitalAssetManagementModuleService(CapitalAssetManagementModuleService capitalAssetManagementModuleService) {
        this.capitalAssetManagementModuleService = capitalAssetManagementModuleService;
    }

    public void setPostalCodeValidationService(PostalCodeValidationService postalCodeValidationService) {
        this.postalCodeValidationService = postalCodeValidationService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

