/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.web.struts;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.kuali.kfs.core.api.config.property.ConfigurationService;
import org.kuali.kfs.kew.api.WorkflowDocument;
import org.kuali.kfs.kns.document.authorization.DocumentAuthorizer;
import org.kuali.kfs.kns.service.DocumentHelperService;
import org.kuali.kfs.kns.web.ui.ExtraButton;
import org.kuali.kfs.kns.web.ui.HeaderField;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.service.PurapService;
import org.kuali.kfs.module.purap.document.web.struts.AccountsPayableFormBase;
import org.kuali.kfs.sys.context.SpringContext;

public class PaymentRequestForm
extends AccountsPayableFormBase {
    protected boolean calculatedTax;

    public PaymentRequestForm() {
        this.setNewPurchasingItemLine(this.setupNewPurchasingItemLine());
        this.setReadOnlyAccountDistributionMethod(true);
    }

    protected String getDefaultDocumentTypeName() {
        return "PREQ";
    }

    public boolean isCalculatedTax() {
        return this.calculatedTax;
    }

    public void setCalculatedTax(boolean calculatedTax) {
        this.calculatedTax = calculatedTax;
    }

    public PaymentRequestDocument getPaymentRequestDocument() {
        return (PaymentRequestDocument)this.getDocument();
    }

    public void setPaymentRequestDocument(PaymentRequestDocument purchaseOrderDocument) {
        this.setDocument((Document)purchaseOrderDocument);
    }

    public void populateHeaderFields(WorkflowDocument workflowDocument) {
        super.populateHeaderFields(workflowDocument);
        if (ObjectUtils.isNotNull((Object)this.getPaymentRequestDocument().getPurapDocumentIdentifier())) {
            this.getDocInfo().add(new HeaderField("DataDictionary.PaymentRequestDocument.attributes.purapDocumentIdentifier", ((PaymentRequestDocument)this.getDocument()).getPurapDocumentIdentifier().toString()));
        } else {
            this.getDocInfo().add(new HeaderField("DataDictionary.PaymentRequestDocument.attributes.purapDocumentIdentifier", "Not Available"));
        }
        String applicationDocumentStatus = "Not Available";
        if (ObjectUtils.isNotNull((Object)this.getPaymentRequestDocument().getApplicationDocumentStatus())) {
            applicationDocumentStatus = workflowDocument.getApplicationDocumentStatus();
        }
        this.getDocInfo().add(new HeaderField("DataDictionary.PaymentRequestDocument.attributes.applicationDocumentStatus", applicationDocumentStatus));
    }

    @Override
    public PurApItem setupNewPurchasingItemLine() {
        return new PurchaseOrderItem();
    }

    public List<ExtraButton> getExtraButtons() {
        this.extraButtons.clear();
        PaymentRequestDocument paymentRequestDocument = this.getPaymentRequestDocument();
        ConfigurationService configurationService = (ConfigurationService)SpringContext.getBean(ConfigurationService.class);
        String externalImageURL = configurationService.getPropertyValueAsString("externalizable.images.url");
        String appExternalImageURL = configurationService.getPropertyValueAsString("externalizable.images.url");
        if (this.canContinue()) {
            this.addExtraButton("methodToCall.continuePREQ", externalImageURL + "buttonsmall_continue.gif", "Continue");
            this.addExtraButton("methodToCall.clearInitFields", externalImageURL + "buttonsmall_clear.gif", "Clear");
        } else {
            if (this.getEditingMode().containsKey("requestPaymentRequestHold")) {
                this.addExtraButton("methodToCall.addHoldOnPayment", appExternalImageURL + "buttonsmall_hold.gif", "Hold");
            }
            if (this.getEditingMode().containsKey("paymentRequestHoldCancelRemoval") && paymentRequestDocument.isHoldIndicator()) {
                this.addExtraButton("methodToCall.removeHoldFromPayment", appExternalImageURL + "buttonsmall_removehold.gif", "Remove Hold");
            }
            if (this.getEditingMode().containsKey("requestPaymentRequestCancel")) {
                this.addExtraButton("methodToCall.requestCancelOnPayment", appExternalImageURL + "buttonsmall_requestcancel.gif", "Request Cancel");
            }
            if (this.getEditingMode().containsKey("paymentRequestHoldCancelRemoval") && paymentRequestDocument.isPaymentRequestedCancelIndicator()) {
                this.addExtraButton("methodToCall.removeCancelRequestFromPayment", appExternalImageURL + "buttonsmall_remreqcanc.gif", "Remove Request Cancel");
            }
            if (this.canCalculate()) {
                this.addExtraButton("methodToCall.calculate", appExternalImageURL + "buttonsmall_calculate.gif", "Calculate");
            }
            if (this.getEditingMode().containsKey("processorCancel") || this.getEditingMode().containsKey("managerCancel")) {
                if ("Closed".equals(paymentRequestDocument.getPurchaseOrderDocument().getApplicationDocumentStatus())) {
                    if (!paymentRequestDocument.getPurchaseOrderDocument().isPendingActionIndicator()) {
                        this.addExtraButton("methodToCall.reopenPo", appExternalImageURL + "buttonsmall_openorder.gif", "Open Order");
                    }
                } else if (!paymentRequestDocument.getDocumentHeader().getWorkflowDocument().isDisapproved()) {
                    this.addExtraButton("methodToCall.cancel", externalImageURL + "buttonsmall_cancel.gif", "Cancel");
                }
            }
        }
        return this.extraButtons;
    }

    public boolean canContinue() {
        boolean can = "Initiated".equals(this.getPaymentRequestDocument().getApplicationDocumentStatus());
        if (can) {
            DocumentAuthorizer documentAuthorizer = ((DocumentHelperService)SpringContext.getBean(DocumentHelperService.class)).getDocumentAuthorizer((Document)this.getPaymentRequestDocument());
            can = documentAuthorizer.canInitiate("PREQ", GlobalVariables.getUserSession().getPerson());
        }
        return can;
    }

    public boolean canCalculate() {
        boolean can = !((PurapService)SpringContext.getBean(PurapService.class)).isFullDocumentEntryCompleted(this.getPaymentRequestDocument());
        can = can && this.documentActions.containsKey("canEdit");
        can = can || this.editingMode.containsKey("taxAreaEditable");
        return can;
    }

    public boolean shouldMethodToCallParameterBeUsed(String methodToCallParameterName, String methodToCallParameterValue, HttpServletRequest request) {
        if ("methodToCall".equals(methodToCallParameterName) && "changeUseTaxIndicator".equals(methodToCallParameterValue)) {
            return true;
        }
        return super.shouldMethodToCallParameterBeUsed(methodToCallParameterName, methodToCallParameterValue, request);
    }
}

