/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.businessobject;

import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.krad.bo.BusinessObject;
import org.kuali.kfs.module.purap.PurapConstants;
import org.kuali.kfs.module.purap.businessobject.PaymentRequestItem;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLineBase;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderAccount;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.businessobject.AccountingLineBase;
import org.kuali.kfs.sys.util.ObjectPopulationUtils;

public class PaymentRequestAccount
extends PurApAccountingLineBase {
    private KualiDecimal disencumberedAmount = KualiDecimal.ZERO;

    public PaymentRequestAccount() {
        this.setAmount(null);
        this.setAccountLinePercent(null);
        this.setSequenceNumber(0);
    }

    public PaymentRequestAccount(PaymentRequestItem item, PurchaseOrderAccount poa) {
        ObjectPopulationUtils.populateFromBaseClass(AccountingLineBase.class, (BusinessObject)poa, (BusinessObject)this, PurapConstants.KNOWN_UNCOPYABLE_FIELDS);
        this.setSequenceNumber(poa.getSequenceNumber());
        this.setAccountLinePercent(poa.getAccountLinePercent());
        this.setItemIdentifier(item.getItemIdentifier());
        this.setPaymentRequestItem(item);
    }

    public KualiDecimal getDisencumberedAmount() {
        return this.disencumberedAmount;
    }

    public void setDisencumberedAmount(KualiDecimal disencumberedAmount) {
        this.disencumberedAmount = disencumberedAmount;
    }

    public PaymentRequestItem getPaymentRequestItem() {
        return (PaymentRequestItem)super.getPurapItem();
    }

    public void setPaymentRequestItem(PaymentRequestItem paymentRequestItem) {
        super.setPurapItem(paymentRequestItem);
    }

    @Override
    public void copyFrom(AccountingLine other) {
        super.copyFrom(other);
        if (other instanceof PaymentRequestAccount) {
            PaymentRequestAccount preqOther = (PaymentRequestAccount)other;
            this.setDisencumberedAmount(preqOther.getDisencumberedAmount());
        }
    }
}

