/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.businessobject;

import java.math.BigDecimal;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.businessobject.PurApItemBase;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.businessobject.PurchasingCapitalAssetItem;
import org.kuali.kfs.module.purap.businessobject.PurchasingItem;
import org.kuali.kfs.module.purap.document.PurchasingDocument;
import org.kuali.kfs.sys.businessobject.UnitOfMeasure;
import org.kuali.kfs.vnd.businessobject.CommodityCode;

public abstract class PurchasingItemBase
extends PurApItemBase
implements PurchasingItem {
    private String purchasingCommodityCode;
    private CommodityCode commodityCode;
    private UnitOfMeasure itemUnitOfMeasure;

    @Override
    public boolean isConsideredEntered() {
        PurchaseOrderItem poi;
        if (this instanceof PurchaseOrderItem && !(poi = (PurchaseOrderItem)this).isItemActiveIndicator()) {
            return false;
        }
        if (this.getItemType().isAdditionalChargeIndicator()) {
            return ObjectUtils.isNotNull((Object)this.getItemUnitPrice()) || StringUtils.isNotBlank((CharSequence)this.getItemDescription()) || !this.getSourceAccountingLines().isEmpty();
        }
        return true;
    }

    public boolean isEmpty() {
        return !StringUtils.isNotEmpty((CharSequence)this.getItemUnitOfMeasureCode()) && !StringUtils.isNotEmpty((CharSequence)this.getItemCatalogNumber()) && !StringUtils.isNotEmpty((CharSequence)this.getItemDescription()) && !StringUtils.isNotEmpty((CharSequence)this.getItemAuxiliaryPartIdentifier()) && !ObjectUtils.isNotNull((Object)this.getItemQuantity()) && (!ObjectUtils.isNotNull((Object)this.getItemUnitPrice()) || this.getItemUnitPrice().compareTo(BigDecimal.ZERO) == 0) && this.isAccountListEmpty();
    }

    public boolean isItemDetailEmpty() {
        boolean empty = ObjectUtils.isNull((Object)this.getItemQuantity()) || StringUtils.isEmpty((CharSequence)this.getItemQuantity().toString());
        empty &= StringUtils.isEmpty((CharSequence)this.getItemUnitOfMeasureCode());
        empty &= StringUtils.isEmpty((CharSequence)this.getItemCatalogNumber());
        empty &= StringUtils.isEmpty((CharSequence)this.getItemDescription());
        return empty &= ObjectUtils.isNull((Object)this.getItemUnitPrice()) || this.getItemUnitPrice().compareTo(BigDecimal.ZERO) == 0;
    }

    public CommodityCode getCommodityCode() {
        if (ObjectUtils.isNull((Object)this.commodityCode) || !StringUtils.equalsIgnoreCase((CharSequence)this.commodityCode.getPurchasingCommodityCode(), (CharSequence)this.getPurchasingCommodityCode())) {
            this.refreshReferenceObject("commodityCode");
        }
        return this.commodityCode;
    }

    public void setCommodityCode(CommodityCode commodityCode) {
        this.commodityCode = commodityCode;
    }

    public String getPurchasingCommodityCode() {
        return this.purchasingCommodityCode;
    }

    public void setPurchasingCommodityCode(String purchasingCommodityCode) {
        this.purchasingCommodityCode = StringUtils.isNotBlank((CharSequence)purchasingCommodityCode) ? purchasingCommodityCode.toUpperCase(Locale.US) : purchasingCommodityCode;
    }

    @Override
    public PurchasingCapitalAssetItem getPurchasingCapitalAssetItem() {
        PurchasingDocument pd = (PurchasingDocument)this.getPurapDocument();
        if (this.getItemIdentifier() != null) {
            return pd.getPurchasingCapitalAssetItem(this.getItemIdentifier());
        }
        return null;
    }

    public UnitOfMeasure getItemUnitOfMeasure() {
        if (ObjectUtils.isNull((Object)this.itemUnitOfMeasure) || !StringUtils.equalsIgnoreCase((CharSequence)this.itemUnitOfMeasure.getItemUnitOfMeasureCode(), (CharSequence)this.getItemUnitOfMeasureCode())) {
            this.refreshReferenceObject("itemUnitOfMeasure");
        }
        return this.itemUnitOfMeasure;
    }

    public void setItemUnitOfMeasure(UnitOfMeasure itemUnitOfMeasure) {
        this.itemUnitOfMeasure = itemUnitOfMeasure;
    }

    public boolean isNewItemForAmendment() {
        return false;
    }
}

