/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.authorization;

import java.util.HashMap;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.kim.impl.identity.Person;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.businessobject.RequisitionItem;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.document.authorization.PurchasingAccountsPayableTransactionalDocumentAuthorizerBase;
import org.kuali.kfs.sys.KFSConstants;

public class RequisitionDocumentAuthorizer
extends PurchasingAccountsPayableTransactionalDocumentAuthorizerBase {
    private static final Logger LOG = LogManager.getLogger();

    public Set<String> getEditModes(Document document, Person user, Set<String> editModes) {
        LOG.debug("getEditModes() started");
        editModes = super.getEditModes(document, user, editModes);
        RequisitionDocument requisitionDocument = (RequisitionDocument)document;
        HashMap<String, String> permissionDetails = new HashMap<String, String>();
        permissionDetails.put("documentTypeName", "REQS");
        permissionDetails.put("routeNodeName", "Commodity");
        permissionDetails.put("propertyName", "items.sourceAccountingLines.financialObjectCode");
        if (requisitionDocument.isDocumentStoppedInRouteNode("Commodity")) {
            boolean removeCapitalAssetEdit = true;
            for (RequisitionItem purApItem : requisitionDocument.getItems()) {
                if (!ObjectUtils.isNotNull((Object)purApItem)) continue;
                HashMap<String, String> roleQualifiers = new HashMap<String, String>();
                String purchasingCommodityCode = purApItem.getPurchasingCommodityCode();
                if (!StringUtils.isNotBlank((CharSequence)purchasingCommodityCode)) continue;
                roleQualifiers.put("purchasingCommodityCode", purchasingCommodityCode);
                if (!this.isAuthorizedByTemplate(document, KFSConstants.PermissionTemplate.MODIFY_ACCOUNTING_LINES.namespace, KFSConstants.PermissionTemplate.MODIFY_ACCOUNTING_LINES.name, user.getPrincipalId(), permissionDetails, roleQualifiers)) continue;
                removeCapitalAssetEdit = false;
                break;
            }
            if (removeCapitalAssetEdit) {
                editModes.remove("allowCapitalAssetEdit");
            }
        }
        return editModes;
    }
}

