/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.dataaccess.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.ReportQueryByCriteria;
import org.kuali.kfs.core.framework.persistence.ojb.dao.PlatformAwareDaoBaseOjb;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.document.dataaccess.RequisitionDao;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class RequisitionDaoOjb
extends PlatformAwareDaoBaseOjb
implements RequisitionDao {
    private static final Logger LOG = LogManager.getLogger();

    @Override
    public String getDocumentNumberForRequisitionId(Integer id) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("purapDocumentIdentifier", (Object)id);
        ReportQueryByCriteria rqbc = new ReportQueryByCriteria(RequisitionDocument.class, criteria);
        rqbc.addOrderByAscending("documentNumber");
        List reqs = (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)rqbc);
        if (reqs.isEmpty()) {
            return null;
        }
        if (reqs.size() > 1) {
            String errorMsg = "Expected single document number for given criteria but multiple (at least 2) were returned";
            LOG.error(errorMsg);
            throw new RuntimeException();
        }
        RequisitionDocument req = (RequisitionDocument)reqs.get(0);
        return req.getDocumentNumber();
    }

    @Override
    public List<String> getDocumentNumbersAwaitingContractManagerAssignment() {
        return this.getDocumentNumbersOfRequisitionsByCriteria(this.getDocumentsAwaitingContractManagerAssignmentCriteria(), false);
    }

    @Override
    public List<RequisitionDocument> getDocumentsAwaitingContractManagerAssignment() {
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)new QueryByCriteria(RequisitionDocument.class, this.getDocumentsAwaitingContractManagerAssignmentCriteria()));
    }

    protected Criteria getDocumentsAwaitingContractManagerAssignmentCriteria() {
        Criteria criteria = new Criteria();
        criteria.addIn("documentHeader.workflowDocumentStatusCode", Arrays.asList("F", "P"));
        criteria.addEqualTo("documentHeader.applicationDocumentStatus", (Object)"Awaiting Contract Manager Assignment");
        return criteria;
    }

    protected List<String> getDocumentNumbersOfRequisitionsByCriteria(Criteria criteria, boolean orderByAscending) {
        LOG.debug("getDocumentNumberOfRequisitionsByCriteria() started");
        ReportQueryByCriteria rqbc = new ReportQueryByCriteria(RequisitionDocument.class, criteria);
        if (orderByAscending) {
            rqbc.addOrderByAscending("documentNumber");
        } else {
            rqbc.addOrderByDescending("documentNumber");
        }
        ArrayList<String> returnList = new ArrayList<String>();
        List reqDocs = (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)rqbc);
        for (RequisitionDocument reqDoc : reqDocs) {
            returnList.add(reqDoc.getDocumentNumber());
        }
        return returnList;
    }
}

