/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.service.impl;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.kim.impl.identity.Person;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.PersistenceService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.PurapConstants;
import org.kuali.kfs.module.purap.businessobject.B2BInformation;
import org.kuali.kfs.module.purap.businessobject.B2BShoppingCartItem;
import org.kuali.kfs.module.purap.businessobject.BillingAddress;
import org.kuali.kfs.module.purap.businessobject.DefaultPrincipalAddress;
import org.kuali.kfs.module.purap.businessobject.RequisitionItem;
import org.kuali.kfs.module.purap.dataaccess.B2BDao;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.document.service.B2BShoppingService;
import org.kuali.kfs.module.purap.document.service.PurapService;
import org.kuali.kfs.module.purap.document.service.PurchasingService;
import org.kuali.kfs.module.purap.exception.B2BShoppingException;
import org.kuali.kfs.module.purap.util.PurApDateFormatUtils;
import org.kuali.kfs.module.purap.util.cxml.B2BParserHelper;
import org.kuali.kfs.module.purap.util.cxml.B2BShoppingCart;
import org.kuali.kfs.module.purap.util.cxml.PunchOutSetupResponse;
import org.kuali.kfs.sys.businessobject.ChartOrgHolder;
import org.kuali.kfs.sys.service.FinancialSystemUserService;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;
import org.kuali.kfs.vnd.businessobject.CommodityCode;
import org.kuali.kfs.vnd.businessobject.VendorAddress;
import org.kuali.kfs.vnd.businessobject.VendorCommodityCode;
import org.kuali.kfs.vnd.businessobject.VendorContract;
import org.kuali.kfs.vnd.businessobject.VendorDetail;
import org.kuali.kfs.vnd.document.service.VendorService;
import org.kuali.kfs.vnd.service.PhoneNumberService;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class B2BShoppingServiceImpl
implements B2BShoppingService {
    private static final Logger LOG = LogManager.getLogger();
    private B2BDao b2bDao;
    private BusinessObjectService businessObjectService;
    private DocumentService documentService;
    private ParameterService parameterService;
    private PersistenceService persistenceService;
    private PhoneNumberService phoneNumberService;
    private PurchasingService purchasingService;
    private PurapService purapService;
    private VendorService vendorService;
    private DateTimeService dateTimeService;
    private FinancialSystemUserService financialSystemUserService;
    private String b2bEnvironment;
    private String b2bPunchoutURL;
    private String b2bPunchbackURL;
    private String b2bUserAgent;
    private String b2bShoppingIdentity;
    private String b2bShoppingPassword;

    protected B2BInformation getB2bShoppingConfigurationInformation() {
        B2BInformation b2b = new B2BInformation();
        b2b.setPunchoutURL(this.b2bPunchoutURL);
        b2b.setPunchbackURL(this.b2bPunchbackURL);
        b2b.setEnvironment(this.b2bEnvironment);
        b2b.setUserAgent(this.b2bUserAgent);
        b2b.setIdentity(this.b2bShoppingIdentity);
        b2b.setPassword(this.b2bShoppingPassword);
        return b2b;
    }

    @Override
    public String getPunchOutUrl(Person user) {
        B2BInformation b2b = this.getB2bShoppingConfigurationInformation();
        String response = this.b2bDao.sendPunchOutRequest(this.getPunchOutSetupRequestMessage(user, b2b), b2b.getPunchoutURL());
        PunchOutSetupResponse posr = B2BParserHelper.getInstance().parsePunchOutSetupResponse(response);
        return posr.getPunchOutUrl();
    }

    @Override
    public String getPunchOutSetupRequestMessage(Person user, B2BInformation b2bInformation) {
        StringBuffer cxml = new StringBuffer();
        Date currentDate = this.dateTimeService.getCurrentDate();
        SimpleDateFormat dateFormat = PurApDateFormatUtils.getSimpleDateFormat(PurapConstants.NamedDateFormats.CXML_SIMPLE_DATE_FORMAT);
        SimpleDateFormat timeFormat = PurApDateFormatUtils.getSimpleDateFormat(PurapConstants.NamedDateFormats.CXML_SIMPLE_TIME_FORMAT);
        cxml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n").append("<!DOCTYPE cXML SYSTEM \"cXML.dtd\">\n").append("<cXML payloadID=\"irrelevant\" xml:lang=\"en-US\" timestamp=\"").append(dateFormat.format(currentDate)).append("T").append(timeFormat.format(currentDate)).append("-05:00").append("\">\n");
        cxml.append("  <Header>\n").append("    <From>\n").append("      <Credential domain=\"NetworkId\">\n").append("        <Identity>").append(b2bInformation.getIdentity()).append("</Identity>\n").append("      </Credential>\n").append("    </From>\n").append("    <To>\n").append("      <Credential domain=\"DUNS\">\n").append("        <Identity>").append(b2bInformation.getIdentity()).append("</Identity>\n").append("      </Credential>\n").append("      <Credential domain=\"internalsupplierid\">\n").append("        <Identity>1016</Identity>\n").append("      </Credential>\n").append("    </To>\n").append("    <Sender>\n").append("      <Credential domain=\"TOPSNetworkUserId\">\n").append("        <Identity>").append(user.getPrincipalName().toUpperCase(Locale.US)).append("</Identity>\n").append("        <SharedSecret>").append(b2bInformation.getPassword()).append("</SharedSecret>\n").append("      </Credential>\n").append("      <UserAgent>").append(b2bInformation.getUserAgent()).append("</UserAgent>\n").append("    </Sender>\n").append("  </Header>\n").append("  <Request deploymentMode=\"").append(b2bInformation.getEnvironment()).append("\">\n").append("    <PunchOutSetupRequest operation=\"create\">\n").append("      <BuyerCookie>").append(user.getPrincipalName().toUpperCase(Locale.US)).append("</BuyerCookie>\n").append("      <Extrinsic name=\"UniqueName\">").append(user.getPrincipalName().toUpperCase(Locale.US)).append("</Extrinsic>\n").append("      <Extrinsic name=\"Department\">IU").append(user.getCampusCode()).append(user.getPrimaryDepartmentCode()).append("</Extrinsic>\n").append("      <Extrinsic name=\"Campus\">").append(user.getCampusCode()).append("</Extrinsic>\n").append("      <BrowserFormPost>\n").append("        <URL>").append(b2bInformation.getPunchbackURL()).append("</URL>\n").append("      </BrowserFormPost>\n").append("      <Contact role=\"endUser\">\n").append("        <Name xml:lang=\"en\">").append(user.getName()).append("</Name>\n").append("      </Contact>\n").append("      <SupplierSetup>\n").append("        <URL>").append(b2bInformation.getPunchoutURL()).append("</URL>\n").append("      </SupplierSetup>\n").append("    </PunchOutSetupRequest>\n").append("  </Request>\n").append("</cXML>\n");
        return cxml.toString();
    }

    @Override
    public List createRequisitionsFromCxml(B2BShoppingCart message, Person user) {
        LOG.debug("createRequisitionsFromCxml() started");
        ArrayList<RequisitionDocument> requisitions = new ArrayList<RequisitionDocument>();
        List<B2BShoppingCartItem> items = message.getItems();
        List vendors = this.getAllVendors(items);
        for (Object aVendor : vendors) {
            ChartOrgHolder purapChartOrg;
            VendorDetail vendor = (VendorDetail)aVendor;
            RequisitionDocument req = (RequisitionDocument)this.documentService.getNewDocument("REQS");
            req.setupAccountDistributionMethod();
            VendorContract contract = this.vendorService.getVendorB2BContract(vendor, user.getCampusCode());
            if (ObjectUtils.isNotNull((Object)contract)) {
                req.setVendorContractGeneratedIdentifier(contract.getVendorContractGeneratedIdentifier());
                if (ObjectUtils.isNotNull((Object)contract.getPurchaseOrderCostSourceCode())) {
                    req.setPurchaseOrderCostSourceCode(contract.getPurchaseOrderCostSourceCode());
                } else {
                    req.setPurchaseOrderCostSourceCode("EST");
                }
            } else {
                Supplier[] supplierArray = new Supplier[2];
                supplierArray[0] = () -> ((VendorDetail)vendor).getVendorName();
                supplierArray[1] = () -> ((VendorDetail)vendor).getVendorNumber();
                LOG.error("createRequisitionsFromCxml() Contract is missing for vendor {} ({})", supplierArray);
                throw new B2BShoppingException("The vendor whose shopping cart you are attempting to return does not have an active contract for your organization.");
            }
            List itemsForVendor = this.getAllVendorItems(items, vendor);
            req.setDeliveryCampusCode(user.getCampusCode());
            req.setDeliveryToName(user.getName());
            req.setDeliveryToEmailAddress(user.getEmailAddressUnmasked());
            req.setDeliveryToPhoneNumber(this.phoneNumberService.formatNumberIfPossible(user.getPhoneNumber()));
            DefaultPrincipalAddress defaultPrincipalAddress = new DefaultPrincipalAddress(user.getPrincipalId());
            Map addressKeys = this.persistenceService.getPrimaryKeyFieldValues((Object)defaultPrincipalAddress);
            defaultPrincipalAddress = (DefaultPrincipalAddress)this.businessObjectService.findByPrimaryKey(DefaultPrincipalAddress.class, addressKeys);
            if (ObjectUtils.isNotNull((Object)((Object)defaultPrincipalAddress)) && ObjectUtils.isNotNull((Object)defaultPrincipalAddress.getBuilding())) {
                if (defaultPrincipalAddress.getBuilding().isActive()) {
                    req.setDeliveryCampusCode(defaultPrincipalAddress.getCampusCode());
                    req.templateBuildingToDeliveryAddress(defaultPrincipalAddress.getBuilding());
                    req.setDeliveryBuildingRoomNumber(defaultPrincipalAddress.getBuildingRoomNumber());
                } else {
                    this.businessObjectService.delete((PersistableBusinessObject)defaultPrincipalAddress);
                }
            }
            if (ObjectUtils.isNotNull((Object)(purapChartOrg = this.financialSystemUserService.getPrimaryOrganization(user, "KFS-PURAP")))) {
                req.setChartOfAccountsCode(purapChartOrg.getChartOfAccountsCode());
                req.setOrganizationCode(purapChartOrg.getOrganizationCode());
            }
            req.setRequestorPersonName(user.getName());
            req.setRequestorPersonEmailAddress(user.getEmailAddress());
            req.setRequestorPersonPhoneNumber(this.phoneNumberService.formatNumberIfPossible(user.getPhoneNumber()));
            req.setUseTaxIndicator(this.purchasingService.getDefaultUseTaxIndicatorValue(req));
            req.setVendorHeaderGeneratedIdentifier(vendor.getVendorHeaderGeneratedIdentifier());
            req.setVendorDetailAssignedIdentifier(vendor.getVendorDetailAssignedIdentifier());
            req.setVendorName(vendor.getVendorName());
            req.setVendorRestrictedIndicator(vendor.getVendorRestrictedIndicator());
            req.setItems(itemsForVendor);
            req.setDocumentFundingSourceCode(this.parameterService.getParameterValueAsString(RequisitionDocument.class, "FUNDING_SOURCE"));
            req.setRequisitionSourceCode("B2B");
            req.updateAndSaveAppDocStatus("In Process");
            req.setPurchaseOrderTransmissionMethodCode("ELEC");
            req.setOrganizationAutomaticPurchaseOrderLimit(this.purapService.getApoLimit(req.getVendorContractGeneratedIdentifier(), req.getChartOfAccountsCode(), req.getOrganizationCode()));
            req.setExternalOrganizationB2bSupplierIdentifier(this.getSupplierIdFromFirstItem(itemsForVendor));
            VendorAddress vendorAddress = this.vendorService.getVendorDefaultAddress(vendor.getVendorHeaderGeneratedIdentifier(), vendor.getVendorDetailAssignedIdentifier(), "PO", user.getCampusCode());
            if (ObjectUtils.isNotNull((Object)vendorAddress)) {
                req.templateVendorAddress(vendorAddress);
            }
            BillingAddress billingAddress = new BillingAddress();
            billingAddress.setBillingCampusCode(req.getDeliveryCampusCode());
            Map keys = this.persistenceService.getPrimaryKeyFieldValues((Object)billingAddress);
            billingAddress = (BillingAddress)this.businessObjectService.findByPrimaryKey(BillingAddress.class, keys);
            req.templateBillingAddress(billingAddress);
            req.loadReceivingAddress();
            req.fixItemReferences();
            this.purapService.saveDocumentNoValidation((Document)req);
            requisitions.add(req);
        }
        return requisitions;
    }

    private boolean isDunsNumberEnabled() {
        return this.parameterService.getParameterValueAsBoolean(KfsParameterConstants.PURCHASING_DOCUMENT.class, "ENABLE_B2B_BY_VENDOR_DUNS_NUMBER_IND");
    }

    protected List getAllVendors(List items) {
        LOG.debug("getAllVendors() started");
        HashSet<String> vendorIdentifiers = new HashSet<String>();
        for (Object anItem : items) {
            B2BShoppingCartItem b2BShoppingCartItem = (B2BShoppingCartItem)anItem;
            vendorIdentifiers.add(this.getVendorNumber(b2BShoppingCartItem));
        }
        ArrayList<VendorDetail> vendors = new ArrayList<VendorDetail>();
        for (Object e : vendorIdentifiers) {
            String vendorIdentifier = (String)e;
            VendorDetail vd = this.isDunsNumberEnabled() ? this.vendorService.getVendorByDunsNumber(vendorIdentifier) : this.vendorService.getVendorDetail(vendorIdentifier);
            if (ObjectUtils.isNotNull((Object)vd)) {
                vendors.add(vd);
                continue;
            }
            LOG.error("getAllVendors() Invalid vendor number or DUNS from shopping cart: {}", (Object)vendorIdentifier);
            throw new B2BShoppingException("Invalid vendor number or DUNS from shopping cart: " + vendorIdentifier);
        }
        return vendors;
    }

    protected List getAllVendorItems(List items, VendorDetail vendorDetail) {
        LOG.debug("getAllVendorItems() started");
        String vendorNumberOrDUNS = this.isDunsNumberEnabled() ? vendorDetail.getVendorDunsNumber() : vendorDetail.getVendorNumber();
        ArrayList<Object> scItems = new ArrayList<Object>();
        for (Object anItem : items) {
            B2BShoppingCartItem item = (B2BShoppingCartItem)anItem;
            if (!StringUtils.equals((CharSequence)vendorNumberOrDUNS, (CharSequence)this.getVendorNumber(item))) continue;
            scItems.add(item);
        }
        List vcc = vendorDetail.getVendorCommodities();
        String defaultCommodityCode = null;
        for (VendorCommodityCode commodity : vcc) {
            if (!commodity.isCommodityDefaultIndicator()) continue;
            defaultCommodityCode = commodity.getPurchasingCommodityCode();
        }
        int itemLine = 1;
        ArrayList<RequisitionItem> vendorItems = new ArrayList<RequisitionItem>();
        for (Object e : scItems) {
            B2BShoppingCartItem item = (B2BShoppingCartItem)e;
            RequisitionItem reqItem = this.createRequisitionItem(item, itemLine, defaultCommodityCode);
            ++itemLine;
            vendorItems.add(reqItem);
        }
        return vendorItems;
    }

    protected RequisitionItem createRequisitionItem(B2BShoppingCartItem item, Integer itemLine, String defaultCommodityCode) {
        RequisitionItem reqItem = new RequisitionItem();
        reqItem.setItemTypeCode("ITEM");
        reqItem.setItemLineNumber(itemLine);
        reqItem.setItemUnitPrice(new BigDecimal(item.getUnitPrice()));
        reqItem.setItemQuantity(new KualiDecimal(item.getQuantity()));
        reqItem.setItemCatalogNumber(item.getSupplierPartId());
        reqItem.setItemAuxiliaryPartIdentifier(item.getSupplierPartAuxiliaryId());
        reqItem.setItemDescription(item.getDescription());
        reqItem.setItemUnitOfMeasureCode(item.getUnitOfMeasure());
        reqItem.setExternalOrganizationB2bProductTypeName(item.getExtrinsic("Product Source"));
        reqItem.setExternalOrganizationB2bProductReferenceNumber(item.getExtrinsic("SystemProductID"));
        reqItem.setItemRestrictedIndicator(false);
        boolean commCodeParam = this.parameterService.getParameterValueAsBoolean(RequisitionDocument.class, "ENABLE_DEFAULT_VENDOR_COMMODITY_CODE_IND");
        if (commCodeParam) {
            String commodityCode;
            String classification = this.parameterService.getParameterValueAsString(RequisitionDocument.class, "B2B_CLASSIFICATION_FOR_COMMODITY_CODE");
            if (StringUtils.isBlank((CharSequence)classification)) {
                classification = "UNSPSC";
            }
            if (this.verifyCommodityCode(commodityCode = item.getClassification(classification))) {
                reqItem.setPurchasingCommodityCode(commodityCode);
            } else {
                reqItem.setPurchasingCommodityCode(defaultCommodityCode);
            }
        }
        reqItem.setHoldSupplierId(item.getSupplier("SystemSupplierID"));
        return reqItem;
    }

    private boolean verifyCommodityCode(String commodityCode) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("purchasingCommodityCode", commodityCode);
        CommodityCode commodity = (CommodityCode)this.businessObjectService.findByPrimaryKey(CommodityCode.class, fieldValues);
        if (ObjectUtils.isNotNull((Object)commodity)) {
            return true;
        }
        LOG.warn("Could not retrieve CommodityCode: {}! Instead using default commodity code for vendor", (Object)commodityCode);
        return false;
    }

    protected String getSupplierIdFromFirstItem(List reqItems) {
        if (ObjectUtils.isNotNull((Object)reqItems) && !reqItems.isEmpty()) {
            return ((RequisitionItem)reqItems.get(0)).getHoldSupplierId();
        }
        return "";
    }

    protected String getVendorNumber(B2BShoppingCartItem item) {
        String vendorNumber = this.isDunsNumberEnabled() ? item.getSupplier("DUNS") : item.getExtrinsic("ExternalSupplierId");
        if (StringUtils.isBlank((CharSequence)vendorNumber)) {
            throw new B2BShoppingException("The vendor whose shopping cart you are attempting to return does not have an active contract for your organization.");
        }
        return vendorNumber;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setVendorService(VendorService vendorService) {
        this.vendorService = vendorService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setB2bDao(B2BDao b2bDao) {
        this.b2bDao = b2bDao;
    }

    public void setPhoneNumberService(PhoneNumberService phoneNumberService) {
        this.phoneNumberService = phoneNumberService;
    }

    public void setPurapService(PurapService purapService) {
        this.purapService = purapService;
    }

    public void setPurchasingService(PurchasingService purchasingService) {
        this.purchasingService = purchasingService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    protected DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public void setFinancialSystemUserService(FinancialSystemUserService financialSystemUserService) {
        this.financialSystemUserService = financialSystemUserService;
    }

    public void setB2bEnvironment(String environment) {
        this.b2bEnvironment = environment;
    }

    public void setB2bPunchoutURL(String punchoutURL) {
        this.b2bPunchoutURL = punchoutURL;
    }

    public void setB2bPunchbackURL(String punchbackURL) {
        this.b2bPunchbackURL = punchbackURL;
    }

    public void setB2bUserAgent(String userAgent) {
        this.b2bUserAgent = userAgent;
    }

    public void setB2bShoppingIdentity(String b2bShoppingIdentity) {
        this.b2bShoppingIdentity = b2bShoppingIdentity;
    }

    public void setB2bShoppingPassword(String password) {
        this.b2bShoppingPassword = password;
    }
}

