/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.service.impl;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.kuali.kfs.core.api.config.property.ConfigurationService;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.kew.api.WorkflowDocument;
import org.kuali.kfs.kew.api.document.WorkflowDocumentService;
import org.kuali.kfs.krad.bo.AdHocRoutePerson;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.NoteService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.businessobject.CorrectionReceivingItem;
import org.kuali.kfs.module.purap.businessobject.ItemType;
import org.kuali.kfs.module.purap.businessobject.LineItemReceivingItem;
import org.kuali.kfs.module.purap.businessobject.LineItemReceivingView;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.businessobject.ReceivingItem;
import org.kuali.kfs.module.purap.document.CorrectionReceivingDocument;
import org.kuali.kfs.module.purap.document.LineItemReceivingDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderAmendmentDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.ReceivingDocument;
import org.kuali.kfs.module.purap.document.dataaccess.ReceivingDao;
import org.kuali.kfs.module.purap.document.service.LogicContainer;
import org.kuali.kfs.module.purap.document.service.PurapService;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.module.purap.document.service.ReceivingService;
import org.kuali.kfs.module.purap.document.validation.event.AttributedContinuePurapEvent;
import org.kuali.kfs.sys.document.service.FinancialSystemDocumentService;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class ReceivingServiceImpl
implements ReceivingService {
    private static final Logger LOG = LogManager.getLogger();
    protected PurchaseOrderService purchaseOrderService;
    protected ReceivingDao receivingDao;
    protected DocumentService documentService;
    protected WorkflowDocumentService workflowDocumentService;
    protected ConfigurationService configurationService;
    protected PurapService purapService;
    protected NoteService noteService;
    protected FinancialSystemDocumentService financialSystemDocumentService;
    private ParameterService parameterService;

    @Override
    public void populateReceivingLineFromPurchaseOrder(LineItemReceivingDocument rlDoc) {
        PurchaseOrderDocument poDoc;
        if (rlDoc == null) {
            rlDoc = new LineItemReceivingDocument();
        }
        if ((poDoc = this.purchaseOrderService.getCurrentPurchaseOrder(rlDoc.getPurchaseOrderIdentifier())) != null) {
            rlDoc.populateReceivingLineFromPurchaseOrder(poDoc);
        }
    }

    @Override
    public void populateCorrectionReceivingFromReceivingLine(CorrectionReceivingDocument rcDoc) {
        LineItemReceivingDocument rlDoc;
        if (rcDoc == null) {
            rcDoc = new CorrectionReceivingDocument();
        }
        if ((rlDoc = rcDoc.getLineItemReceivingDocument()) != null) {
            rcDoc.populateCorrectionReceivingFromReceivingLine(rlDoc);
        }
    }

    @Override
    public void populateAndSaveLineItemReceivingDocument(LineItemReceivingDocument rlDoc) {
        this.documentService.saveDocument((Document)rlDoc, AttributedContinuePurapEvent.class);
    }

    @Override
    public void populateCorrectionReceivingDocument(CorrectionReceivingDocument rcDoc) {
        this.populateCorrectionReceivingFromReceivingLine(rcDoc);
    }

    @Override
    public boolean canCreateLineItemReceivingDocument(Integer poId, String receivingDocumentNumber) throws RuntimeException {
        PurchaseOrderDocument po = this.purchaseOrderService.getCurrentPurchaseOrder(poId);
        return this.canCreateLineItemReceivingDocument(po, receivingDocumentNumber);
    }

    @Override
    public boolean canCreateLineItemReceivingDocument(PurchaseOrderDocument po) throws RuntimeException {
        return this.canCreateLineItemReceivingDocument(po, null);
    }

    protected boolean canCreateLineItemReceivingDocument(PurchaseOrderDocument po, String receivingDocumentNumber) {
        boolean canCreate = false;
        if (this.isPurchaseOrderValidForLineItemReceivingDocumentCreation(po) && !this.isLineItemReceivingDocumentInProcessForPurchaseOrder(po.getPurapDocumentIdentifier(), receivingDocumentNumber) && !this.isCorrectionReceivingDocumentInProcessForPurchaseOrder(po.getPurapDocumentIdentifier(), null)) {
            canCreate = true;
        }
        return canCreate;
    }

    @Override
    public boolean isPurchaseOrderActiveForLineItemReceivingDocumentCreation(Integer poId) {
        PurchaseOrderDocument po = this.purchaseOrderService.getCurrentPurchaseOrder(poId);
        return this.isPurchaseOrderValidForLineItemReceivingDocumentCreation(po);
    }

    protected boolean isPurchaseOrderValidForLineItemReceivingDocumentCreation(PurchaseOrderDocument po) {
        return po != null && ObjectUtils.isNotNull((Object)po.getPurapDocumentIdentifier()) && po.isPurchaseOrderCurrentIndicator() && ("Open".equals(po.getApplicationDocumentStatus()) || "Closed".equals(po.getApplicationDocumentStatus()) || "Payment Hold".equals(po.getApplicationDocumentStatus()));
    }

    @Override
    public boolean canCreateCorrectionReceivingDocument(LineItemReceivingDocument rl) throws RuntimeException {
        return this.canCreateCorrectionReceivingDocument(rl, null);
    }

    @Override
    public boolean canCreateCorrectionReceivingDocument(LineItemReceivingDocument rl, String receivingCorrectionDocNumber) throws RuntimeException {
        boolean canCreate = false;
        WorkflowDocument workflowDocument = this.workflowDocumentService.loadWorkflowDocument(rl.getDocumentNumber(), GlobalVariables.getUserSession().getPerson());
        if (workflowDocument.isFinal() && !this.isCorrectionReceivingDocumentInProcessForReceivingLine(rl.getDocumentNumber(), receivingCorrectionDocNumber)) {
            canCreate = true;
        }
        return canCreate;
    }

    protected boolean isLineItemReceivingDocumentInProcessForPurchaseOrder(Integer poId, String receivingDocumentNumber) throws RuntimeException {
        return !this.getLineItemReceivingDocumentNumbersInProcessForPurchaseOrder(poId, receivingDocumentNumber).isEmpty();
    }

    @Override
    public List<String> getLineItemReceivingDocumentNumbersInProcessForPurchaseOrder(Integer poId, String receivingDocumentNumber) {
        ArrayList<String> inProcessDocNumbers = new ArrayList<String>();
        List<String> docNumbers = this.receivingDao.getDocumentNumbersByPurchaseOrderId(poId);
        for (String docNumber : docNumbers) {
            WorkflowDocument workflowDocument = this.workflowDocumentService.loadWorkflowDocument(docNumber, GlobalVariables.getUserSession().getPerson());
            if (workflowDocument.isCanceled() || workflowDocument.isException() || workflowDocument.isFinal() || docNumber.equals(receivingDocumentNumber)) continue;
            inProcessDocNumbers.add(docNumber);
        }
        return inProcessDocNumbers;
    }

    protected boolean isCorrectionReceivingDocumentInProcessForPurchaseOrder(Integer poId, String receivingDocumentNumber) throws RuntimeException {
        return !this.getCorrectionReceivingDocumentNumbersInProcessForPurchaseOrder(poId, receivingDocumentNumber).isEmpty();
    }

    @Override
    public List<String> getCorrectionReceivingDocumentNumbersInProcessForPurchaseOrder(Integer poId, String receivingDocumentNumber) {
        ArrayList<String> inProcessDocNumbers = new ArrayList<String>();
        List<String> docNumbers = this.receivingDao.getCorrectionReceivingDocumentNumbersByPurchaseOrderId(poId);
        for (String docNumber : docNumbers) {
            WorkflowDocument workflowDocument = this.workflowDocumentService.loadWorkflowDocument(docNumber, GlobalVariables.getUserSession().getPerson());
            if (workflowDocument.isCanceled() || workflowDocument.isException() || workflowDocument.isFinal() || docNumber.equals(receivingDocumentNumber)) continue;
            inProcessDocNumbers.add(docNumber);
        }
        return inProcessDocNumbers;
    }

    protected boolean isCorrectionReceivingDocumentInProcessForReceivingLine(String receivingDocumentNumber, String receivingCorrectionDocNumber) throws RuntimeException {
        boolean isInProcess = false;
        List<String> docNumbers = this.receivingDao.getCorrectionReceivingDocumentNumbersByReceivingLineNumber(receivingDocumentNumber);
        for (String docNumber : docNumbers) {
            WorkflowDocument workflowDocument = this.workflowDocumentService.loadWorkflowDocument(docNumber, GlobalVariables.getUserSession().getPerson());
            if (workflowDocument.isCanceled() || workflowDocument.isException() || workflowDocument.isFinal() || docNumber.equals(receivingCorrectionDocNumber)) continue;
            isInProcess = true;
            break;
        }
        return isInProcess;
    }

    @Override
    public HashMap<String, String> receivingLineDuplicateMessages(LineItemReceivingDocument rlDoc) {
        List<String> docNumbers;
        HashMap<String, String> msgs = new HashMap<String, String>();
        Integer poId = rlDoc.getPurchaseOrderIdentifier();
        StringBuffer currentMessage = new StringBuffer();
        if (rlDoc.getShipmentReceivedDate() != null && this.hasDuplicateEntry(docNumbers = this.receivingDao.duplicateVendorDate(poId, rlDoc.getShipmentReceivedDate()))) {
            this.appendDuplicateMessage(currentMessage, "message.duplicate.receivngLine.vendorDate", rlDoc.getPurchaseOrderIdentifier());
        }
        if (StringUtils.isNotEmpty((CharSequence)rlDoc.getShipmentPackingSlipNumber()) && this.hasDuplicateEntry(docNumbers = this.receivingDao.duplicatePackingSlipNumber(poId, rlDoc.getShipmentPackingSlipNumber()))) {
            this.appendDuplicateMessage(currentMessage, "message.duplicate.receivingLine.packingSlipNumber", rlDoc.getPurchaseOrderIdentifier());
        }
        if (StringUtils.isNotEmpty((CharSequence)rlDoc.getShipmentBillOfLadingNumber()) && this.hasDuplicateEntry(docNumbers = this.receivingDao.duplicateBillOfLadingNumber(poId, rlDoc.getShipmentBillOfLadingNumber()))) {
            this.appendDuplicateMessage(currentMessage, "message.duplicate.receivingLine.billOfLadingNumber", rlDoc.getPurchaseOrderIdentifier());
        }
        if (currentMessage.length() > 0) {
            this.appendDuplicateMessage(currentMessage, "message.duplicate.receivingLine.suffix", rlDoc.getPurchaseOrderIdentifier());
            msgs.put("DuplicateReceivingLine", currentMessage.toString());
        }
        return msgs;
    }

    protected boolean hasDuplicateEntry(List<String> docNumbers) {
        boolean isDuplicate = false;
        for (String docNumber : docNumbers) {
            WorkflowDocument workflowDocument = this.workflowDocumentService.loadWorkflowDocument(docNumber, GlobalVariables.getUserSession().getPerson());
            if (!workflowDocument.isFinal()) continue;
            isDuplicate = true;
            break;
        }
        return isDuplicate;
    }

    protected void appendDuplicateMessage(StringBuffer currentMessage, String duplicateMessageKey, Integer poId) {
        if (currentMessage.length() == 0) {
            String messageText = this.configurationService.getPropertyValueAsString("message.duplicate.receivingLine.prefix");
            String prefix = MessageFormat.format(messageText, poId.toString());
            currentMessage.append(prefix);
        }
        currentMessage.append(this.configurationService.getPropertyValueAsString(duplicateMessageKey));
    }

    @Override
    public void completeCorrectionReceivingDocument(ReceivingDocument correctionDocument) {
        LineItemReceivingDocument receivingDoc = ((CorrectionReceivingDocument)correctionDocument).getLineItemReceivingDocument();
        for (CorrectionReceivingItem correctionItem : correctionDocument.getItems()) {
            LineItemReceivingItem recItem;
            if (StringUtils.equalsIgnoreCase((CharSequence)correctionItem.getItemType().getItemTypeCode(), (CharSequence)"UNOR") || !ObjectUtils.isNotNull((Object)(recItem = this.getItemByLineNumber(receivingDoc, correctionItem.getItemLineNumber())))) continue;
            recItem.setItemReceivedTotalQuantity(correctionItem.getItemReceivedTotalQuantity());
            recItem.setItemReturnedTotalQuantity(correctionItem.getItemReturnedTotalQuantity());
            recItem.setItemDamagedTotalQuantity(correctionItem.getItemDamagedTotalQuantity());
        }
    }

    public LineItemReceivingItem getItemByLineNumber(ReceivingDocument receivingDoc, int lineNumber) {
        List lineItemReceivingItems = receivingDoc.getItems();
        return lineItemReceivingItems.stream().filter(item -> item.getItemLineNumber() != null && item.getItemLineNumber() == lineNumber).findFirst().orElse(null);
    }

    @Override
    public void completeReceivingDocument(ReceivingDocument receivingDocument) {
        PurchaseOrderDocument poDoc = null;
        if (receivingDocument instanceof LineItemReceivingDocument) {
            this.purapService.deleteUnenteredItems(receivingDocument);
            poDoc = receivingDocument.getPurchaseOrderDocument();
        } else if (receivingDocument instanceof CorrectionReceivingDocument) {
            CorrectionReceivingDocument correctionDocument = (CorrectionReceivingDocument)receivingDocument;
            poDoc = this.purchaseOrderService.getCurrentPurchaseOrder(correctionDocument.getLineItemReceivingDocument().getPurchaseOrderIdentifier());
        }
        this.updateReceivingTotalsOnPurchaseOrder(receivingDocument, poDoc);
        this.purapService.saveDocumentNoValidation((Document)poDoc);
        this.sendFyiForItems(receivingDocument);
        this.spawnPoAmendmentForUnorderedItems(receivingDocument, poDoc);
        this.purapService.saveDocumentNoValidation((Document)receivingDocument);
    }

    @Override
    public void createNoteForReturnedAndDamagedItems(ReceivingDocument recDoc) {
        for (ReceivingItem item : recDoc.getItems()) {
            Object noteString;
            if (StringUtils.equalsIgnoreCase((CharSequence)item.getItemType().getItemTypeCode(), (CharSequence)"UNOR")) continue;
            if (item.getItemReturnedTotalQuantity() != null && item.getItemReturnedTotalQuantity().isGreaterThan((AbstractKualiDecimal)KualiDecimal.ZERO)) {
                try {
                    noteString = this.configurationService.getPropertyValueAsString("message.receiving.lineitem.return");
                    noteString = item.getItemReturnedTotalQuantity().intValue() + " " + (String)noteString + " " + item.getItemLineNumber();
                    this.addNoteToReceivingDocument(recDoc, (String)noteString);
                }
                catch (Exception e) {
                    String errorMsg = "Note Service Exception caught: " + e.getLocalizedMessage();
                    throw new RuntimeException(errorMsg, e);
                }
            }
            if (item.getItemDamagedTotalQuantity() == null || !item.getItemDamagedTotalQuantity().isGreaterThan((AbstractKualiDecimal)KualiDecimal.ZERO)) continue;
            try {
                noteString = this.configurationService.getPropertyValueAsString("message.receiving.lineitem.damage");
                noteString = item.getItemDamagedTotalQuantity().intValue() + " " + (String)noteString + " " + item.getItemLineNumber();
                this.addNoteToReceivingDocument(recDoc, (String)noteString);
            }
            catch (Exception e) {
                String errorMsg = "Note Service Exception caught: " + e.getLocalizedMessage();
                throw new RuntimeException(errorMsg, e);
            }
        }
    }

    protected void updateReceivingTotalsOnPurchaseOrder(ReceivingDocument receivingDocument, PurchaseOrderDocument poDoc) {
        for (ReceivingItem receivingItem : receivingDocument.getItems()) {
            KualiDecimal receivingItemTotalDamaged;
            KualiDecimal receivingItemTotalDamagedOriginal;
            KualiDecimal receivingItemReturned;
            PurchaseOrderItem poItem;
            ItemType itemType = receivingItem.getItemType();
            if (StringUtils.equalsIgnoreCase((CharSequence)itemType.getItemTypeCode(), (CharSequence)"UNOR") || !ObjectUtils.isNotNull((Object)(poItem = (PurchaseOrderItem)poDoc.getItemByLineNumber(receivingItem.getItemLineNumber())))) continue;
            KualiDecimal poItemReceivedTotal = poItem.getItemReceivedTotalQuantity();
            KualiDecimal receivingItemReceivedOriginal = receivingItem.getItemOriginalReceivedTotalQuantity();
            if (ObjectUtils.isNull((Object)receivingItemReceivedOriginal)) {
                receivingItemReceivedOriginal = KualiDecimal.ZERO;
            }
            KualiDecimal receivingItemReceived = receivingItem.getItemReceivedTotalQuantity();
            KualiDecimal receivingItemTotalReceivedAdjusted = (KualiDecimal)receivingItemReceived.subtract((AbstractKualiDecimal)receivingItemReceivedOriginal);
            if (ObjectUtils.isNull((Object)poItemReceivedTotal)) {
                poItemReceivedTotal = KualiDecimal.ZERO;
            }
            KualiDecimal poItemReceivedTotalAdjusted = (KualiDecimal)poItemReceivedTotal.add((AbstractKualiDecimal)receivingItemTotalReceivedAdjusted);
            KualiDecimal receivingItemReturnedOriginal = receivingItem.getItemOriginalReturnedTotalQuantity();
            if (ObjectUtils.isNull((Object)receivingItemReturnedOriginal)) {
                receivingItemReturnedOriginal = KualiDecimal.ZERO;
            }
            if (ObjectUtils.isNull((Object)(receivingItemReturned = receivingItem.getItemReturnedTotalQuantity()))) {
                receivingItemReturned = KualiDecimal.ZERO;
            }
            KualiDecimal receivingItemTotalReturnedAdjusted = (KualiDecimal)receivingItemReturned.subtract((AbstractKualiDecimal)receivingItemReturnedOriginal);
            poItemReceivedTotalAdjusted = (KualiDecimal)poItemReceivedTotalAdjusted.subtract((AbstractKualiDecimal)receivingItemTotalReturnedAdjusted);
            poItem.setItemReceivedTotalQuantity(poItemReceivedTotalAdjusted);
            KualiDecimal poTotalDamaged = poItem.getItemDamagedTotalQuantity();
            if (ObjectUtils.isNull((Object)poTotalDamaged)) {
                poTotalDamaged = KualiDecimal.ZERO;
            }
            if (ObjectUtils.isNull((Object)(receivingItemTotalDamagedOriginal = receivingItem.getItemOriginalDamagedTotalQuantity()))) {
                receivingItemTotalDamagedOriginal = KualiDecimal.ZERO;
            }
            if (ObjectUtils.isNull((Object)(receivingItemTotalDamaged = receivingItem.getItemDamagedTotalQuantity()))) {
                receivingItemTotalDamaged = KualiDecimal.ZERO;
            }
            KualiDecimal receivingItemTotalDamagedAdjusted = (KualiDecimal)receivingItemTotalDamaged.subtract((AbstractKualiDecimal)receivingItemTotalDamagedOriginal);
            poItem.setItemDamagedTotalQuantity((KualiDecimal)poTotalDamaged.add((AbstractKualiDecimal)receivingItemTotalDamagedAdjusted));
        }
    }

    protected void spawnPoAmendmentForUnorderedItems(ReceivingDocument receivingDocument, PurchaseOrderDocument po) {
        if (receivingDocument instanceof LineItemReceivingDocument) {
            LineItemReceivingDocument rlDoc = (LineItemReceivingDocument)receivingDocument;
            if (this.hasNewUnorderedItem((LineItemReceivingDocument)receivingDocument)) {
                String newSessionUserId = "kfs";
                LogicContainer logicToRun = objects -> {
                    LineItemReceivingDocument rlDoc1 = (LineItemReceivingDocument)objects[0];
                    String poDocNumber = (String)objects[1];
                    PurchaseOrderAmendmentDocument amendmentPo = (PurchaseOrderAmendmentDocument)this.purchaseOrderService.createAndSavePotentialChangeDocument(poDocNumber, "POA", "Pending Amendment");
                    this.addUnorderedItemsToAmendment(amendmentPo, rlDoc1);
                    this.documentService.routeDocument((Document)amendmentPo, null, null);
                    String note = "Purchase Order Amendment " + amendmentPo.getPurapDocumentIdentifier() + " (document id " + amendmentPo.getDocumentNumber() + ") created for new unordered line items due to Receiving (document id " + rlDoc1.getDocumentNumber() + ")";
                    Note noteObj = this.documentService.createNoteFromDocument((Document)amendmentPo, note);
                    amendmentPo.addNote(noteObj);
                    this.noteService.save(noteObj);
                    return null;
                };
                this.purapService.performLogicWithFakedUserSession(newSessionUserId, logicToRun, rlDoc, po.getDocumentNumber());
            }
        }
    }

    @Override
    public boolean hasNewUnorderedItem(LineItemReceivingDocument rlDoc) {
        boolean itemAdded = false;
        for (LineItemReceivingItem rlItem : rlDoc.getItems()) {
            if (!"UNOR".equals(rlItem.getItemTypeCode()) || !StringUtils.isNotEmpty((CharSequence)rlItem.getItemReasonAddedCode())) continue;
            itemAdded = true;
            break;
        }
        return itemAdded;
    }

    protected void addUnorderedItemsToAmendment(PurchaseOrderAmendmentDocument amendment, LineItemReceivingDocument rlDoc) {
        for (LineItemReceivingItem rlItem : rlDoc.getItems()) {
            if (!"UNOR".equals(rlItem.getItemTypeCode()) || !StringUtils.isNotEmpty((CharSequence)rlItem.getItemReasonAddedCode())) continue;
            PurchaseOrderItem poi = this.createPoItemFromReceivingLine(rlItem);
            poi.setDocumentNumber(amendment.getDocumentNumber());
            if (this.purchaseOrderService.isCommodityCodeRequiredOnPurchaseOrder() && StringUtils.isEmpty((CharSequence)poi.getPurchasingCommodityCode())) {
                String defaultCommodityCode = this.parameterService.getParameterValueAsString(PurchaseOrderAmendmentDocument.class, "UNORDERED_ITEM_DEFAULT_COMMODITY_CODE");
                poi.setPurchasingCommodityCode(defaultCommodityCode);
            }
            poi.refreshNonUpdateableReferences();
            amendment.addItem(poi);
        }
    }

    protected PurchaseOrderItem createPoItemFromReceivingLine(LineItemReceivingItem rlItem) {
        PurchaseOrderItem poi = new PurchaseOrderItem();
        poi.setItemActiveIndicator(true);
        poi.setItemTypeCode(rlItem.getItemTypeCode());
        poi.setItemLineNumber(rlItem.getItemLineNumber());
        poi.setItemCatalogNumber(rlItem.getItemCatalogNumber());
        poi.setItemDescription(rlItem.getItemDescription());
        if (rlItem.getItemReturnedTotalQuantity() == null) {
            poi.setItemQuantity(rlItem.getItemReceivedTotalQuantity());
        } else {
            poi.setItemQuantity((KualiDecimal)rlItem.getItemReceivedTotalQuantity().subtract((AbstractKualiDecimal)rlItem.getItemReturnedTotalQuantity()));
        }
        poi.setItemUnitOfMeasureCode(rlItem.getItemUnitOfMeasureCode());
        poi.setItemUnitPrice(new BigDecimal(0));
        poi.setItemDamagedTotalQuantity(rlItem.getItemDamagedTotalQuantity());
        poi.setItemReceivedTotalQuantity(rlItem.getItemReceivedTotalQuantity());
        return poi;
    }

    protected List<AdHocRoutePerson> createFyiFiscalOfficerList(ReceivingDocument recDoc) {
        PurchaseOrderDocument po = recDoc.getPurchaseOrderDocument();
        ArrayList<AdHocRoutePerson> adHocRoutePersons = new ArrayList<AdHocRoutePerson>();
        HashMap<String, String> fiscalOfficers = new HashMap<String, String>();
        for (ReceivingItem recItem : recDoc.getItems()) {
            PurchaseOrderItem poItem;
            if (!ObjectUtils.isNotNull((Object)recItem.getItemLineNumber()) || !(poItem = (PurchaseOrderItem)po.getItemByLineNumber(recItem.getItemLineNumber())).getItemQuantity().isLessThan((AbstractKualiDecimal)poItem.getItemReceivedTotalQuantity()) && !recItem.getItemDamagedTotalQuantity().isGreaterThan((AbstractKualiDecimal)KualiDecimal.ZERO)) continue;
            for (PurApAccountingLine account : poItem.getSourceAccountingLines()) {
                if (fiscalOfficers.containsKey(account.getAccount().getAccountFiscalOfficerUser().getPrincipalName())) continue;
                fiscalOfficers.put(account.getAccount().getAccountFiscalOfficerUser().getPrincipalName(), account.getAccount().getAccountFiscalOfficerUser().getPrincipalName());
                AdHocRoutePerson adHocRoutePerson = new AdHocRoutePerson();
                adHocRoutePerson.setId(account.getAccount().getAccountFiscalOfficerUser().getPrincipalName());
                adHocRoutePerson.setActionRequested("F");
                adHocRoutePersons.add(adHocRoutePerson);
            }
        }
        return adHocRoutePersons;
    }

    protected void sendFyiForItems(ReceivingDocument recDoc) {
        List<AdHocRoutePerson> fyiList = this.createFyiFiscalOfficerList(recDoc);
        String annotation = "Notification of Item exceeded Quantity or Damaged(document id " + recDoc.getDocumentNumber() + ")";
        String responsibilityNote = "Please Review";
        for (AdHocRoutePerson adHocPerson : fyiList) {
            recDoc.appSpecificRouteDocumentToUser(recDoc.getDocumentHeader().getWorkflowDocument(), adHocPerson.getPerson().getPrincipalId(), annotation, responsibilityNote);
        }
    }

    @Override
    public void addNoteToReceivingDocument(ReceivingDocument receivingDocument, String note) throws Exception {
        Note noteObj = this.documentService.createNoteFromDocument((Document)receivingDocument, note);
        receivingDocument.addNote(noteObj);
        this.noteService.save(noteObj);
    }

    @Override
    public String getReceivingDeliveryCampusCode(PurchaseOrderDocument po) {
        String deliveryCampusCode = "";
        String latestDocumentNumber = "";
        List<LineItemReceivingView> rViews = null;
        DateTime latestCreateDate = null;
        if (ObjectUtils.isNotNull((Object)po.getRelatedViews())) {
            rViews = po.getRelatedViews().getRelatedLineItemReceivingViews();
        }
        if (ObjectUtils.isNotNull(rViews) && !rViews.isEmpty()) {
            for (LineItemReceivingView rView : rViews) {
                WorkflowDocument workflowDocument = this.workflowDocumentService.loadWorkflowDocument(rView.getDocumentNumber(), GlobalVariables.getUserSession().getPerson());
                if (!ObjectUtils.isNull(latestCreateDate) && !latestCreateDate.isBefore((ReadableInstant)workflowDocument.getDateCreated())) continue;
                latestCreateDate = workflowDocument.getDateCreated();
                latestDocumentNumber = workflowDocument.getDocumentId();
            }
            if (ObjectUtils.isNotNull(latestCreateDate)) {
                LineItemReceivingDocument rlDoc = (LineItemReceivingDocument)this.documentService.getByDocumentHeaderId(latestDocumentNumber);
                deliveryCampusCode = rlDoc.getDeliveryCampusCode();
            }
        }
        return deliveryCampusCode;
    }

    @Override
    public void approveReceivingDocsForPOAmendment() {
        List<LineItemReceivingDocument> docs = this.getDocumentsAwaitingPurchaseOrderOpenStatus();
        if (docs != null) {
            for (LineItemReceivingDocument receivingDoc : docs) {
                Set currentNodes = receivingDoc.getDocumentHeader().getWorkflowDocument().getCurrentNodeNames();
                if (!CollectionUtils.isNotEmpty((Collection)currentNodes) || !currentNodes.contains("OutstandingTransactions")) continue;
                this.approveReceivingDoc(receivingDoc);
            }
        }
    }

    protected void approveReceivingDoc(LineItemReceivingDocument receivingDoc) {
        PurchaseOrderDocument poDoc = receivingDoc.getPurchaseOrderDocument();
        if (this.purchaseOrderService.isPurchaseOrderOpenForProcessing(poDoc)) {
            this.documentService.approveDocument((Document)receivingDoc, "Approved by the batch job", null);
        }
    }

    @Deprecated
    protected List<String> getDocumentsNumbersAwaitingPurchaseOrderOpenStatus() {
        ArrayList<String> receivingDocumentNumbers = new ArrayList<String>();
        List<LineItemReceivingDocument> receivingDocuments = this.getDocumentsAwaitingPurchaseOrderOpenStatus();
        for (LineItemReceivingDocument document : receivingDocuments) {
            receivingDocumentNumbers.add(document.getDocumentNumber());
        }
        return receivingDocumentNumbers;
    }

    protected List<LineItemReceivingDocument> getDocumentsAwaitingPurchaseOrderOpenStatus() {
        return (List)this.financialSystemDocumentService.findByApplicationDocumentStatus(LineItemReceivingDocument.class, "Awaiting Purchase Order Open Status");
    }

    public void setPurchaseOrderService(PurchaseOrderService purchaseOrderService) {
        this.purchaseOrderService = purchaseOrderService;
    }

    public void setReceivingDao(ReceivingDao receivingDao) {
        this.receivingDao = receivingDao;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setWorkflowDocumentService(WorkflowDocumentService workflowDocumentService) {
        this.workflowDocumentService = workflowDocumentService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public void setPurapService(PurapService purapService) {
        this.purapService = purapService;
    }

    public void setNoteService(NoteService noteService) {
        this.noteService = noteService;
    }

    public void setFinancialSystemDocumentService(FinancialSystemDocumentService financialSystemDocumentService) {
        this.financialSystemDocumentService = financialSystemDocumentService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

