/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.core.api.config.property.ConfigurationService;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.module.purap.document.AccountsPayableDocument;
import org.kuali.kfs.module.purap.document.service.PurapService;
import org.kuali.kfs.module.purap.document.validation.impl.PurapDocumentPreRulesBase;
import org.kuali.kfs.sys.context.SpringContext;

public abstract class AccountsPayableDocumentPreRulesBase
extends PurapDocumentPreRulesBase {
    @Override
    public boolean doPrompts(Document document) {
        boolean preRulesOK = true;
        AccountsPayableDocument accountsPayableDocument = (AccountsPayableDocument)document;
        if (!((PurapService)SpringContext.getBean(PurapService.class)).isFullDocumentEntryCompleted(accountsPayableDocument)) {
            preRulesOK = this.confirmInvoiceNoMatchOverride(accountsPayableDocument);
        } else if (((PurapService)SpringContext.getBean(PurapService.class)).isFullDocumentEntryCompleted(accountsPayableDocument)) {
            accountsPayableDocument.setUnmatchedOverride(true);
        }
        return preRulesOK;
    }

    protected boolean confirmInvoiceNoMatchOverride(AccountsPayableDocument accountsPayableDocument) {
        if (this.validateInvoiceTotalsAreMismatched(accountsPayableDocument)) {
            String questionText = this.createInvoiceNoMatchQuestionText(accountsPayableDocument);
            boolean confirmOverride = super.askOrAnalyzeYesNoQuestion("OverrideInvoiceNoMatch", questionText);
            if (confirmOverride && StringUtils.isBlank((CharSequence)this.event.getQuestionContext())) {
                this.event.setQuestionContext("OverrideInvoiceNoMatch");
                accountsPayableDocument.setUnmatchedOverride(true);
            }
            if (!confirmOverride) {
                this.event.setActionForwardName("basic");
                return false;
            }
        }
        return true;
    }

    public String createInvoiceNoMatchQuestionText(AccountsPayableDocument accountsPayableDocument) {
        String questionText = ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("ap.question.confirm.invoice.mismatch");
        questionText = StringUtils.replace((String)questionText, (String)"{0}", (String)this.getDocumentName());
        return questionText;
    }

    protected boolean validateInvoiceTotalsAreMismatched(AccountsPayableDocument accountsPayableDocument) {
        boolean mismatched = false;
        String[] excludeArray = new String[]{"DISC"};
        if (accountsPayableDocument.getTotalDollarAmountAllItems(excludeArray).compareTo((AbstractKualiDecimal)accountsPayableDocument.getInitialAmount()) != 0 && !accountsPayableDocument.isUnmatchedOverride()) {
            mismatched = true;
        }
        return mismatched;
    }

    public String getDocumentName() {
        return "";
    }
}

