/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.util.cxml;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.kuali.kfs.module.purap.businessobject.B2BShoppingCartItem;
import org.kuali.kfs.module.purap.util.cxml.B2BShoppingCartBase;
import org.kuali.kfs.module.purap.util.cxml.CxmlHeader;
import org.kuali.kfs.module.purap.util.cxml.ItemIn;
import org.kuali.kfs.module.purap.util.cxml.Message;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"cxmlHeader", "message"})
@XmlRootElement(name="cXML", namespace="http://www.kuali.org/kfs/purap/b2bPunchOutOrder")
public class B2BShoppingCart
extends B2BShoppingCartBase {
    @XmlElement(name="Message", namespace="http://www.kuali.org/kfs/purap/b2bPunchOutOrder", required=true)
    private Message message = new Message();
    @XmlElement(name="Header", namespace="http://www.kuali.org/kfs/purap/b2bPunchOutOrder", required=true)
    private CxmlHeader cxmlHeader = new CxmlHeader();
    @XmlTransient
    private List<B2BShoppingCartItem> itemsList;

    public void addShoppingCartItem(B2BShoppingCartItem item) {
        if (this.itemsList == null) {
            this.itemsList = new ArrayList<B2BShoppingCartItem>();
        }
        this.itemsList.add(item);
    }

    public List<B2BShoppingCartItem> getItems() {
        if (CollectionUtils.isEmpty(this.itemsList) && this.message.getPunchOutOrderMessage() != null && CollectionUtils.isNotEmpty(this.message.getPunchOutOrderMessage().getItemInList())) {
            return this.message.getPunchOutOrderMessage().getItemInList().stream().map(ItemIn::toB2BShoppingCartItem).collect(Collectors.toList());
        }
        return this.itemsList;
    }

    @Override
    public boolean isSuccess() {
        return "200".equals(this.message.getStatus().getCode());
    }

    public CxmlHeader getCxmlHeader() {
        return this.cxmlHeader;
    }

    public void setCxmlHeader(CxmlHeader cxmlHeader) {
        this.cxmlHeader = cxmlHeader;
    }

    public String getBuyerCookieText() {
        return this.message.getPunchOutOrderMessage().getBuyerCookie();
    }

    public void setBuyerCookieText(String buyerCookieText) {
        this.message.getPunchOutOrderMessage().setBuyerCookie(buyerCookieText);
    }

    public String getTotal() {
        return this.message.getPunchOutOrderMessage().getPunchOutOrderMessageHeader().getTotal().getMoney().getValue().toString();
    }

    public void setTotal(String totalAmount) {
        this.message.getPunchOutOrderMessage().getPunchOutOrderMessageHeader().getTotal().getMoney().setValue(new BigDecimal(totalAmount));
    }

    public Message getMessage() {
        return this.message;
    }

    public void setMessage(Message message) {
        this.message = message;
    }

    public String getMessageStatusCode() {
        return this.message.getStatus().getCode();
    }

    public void setMessageStatusCode(String messageStatusCode) {
        this.message.getStatus().setCode(messageStatusCode);
    }

    public String getMessageStatusText() {
        return this.message.getStatus().getText();
    }

    public void setMessageStatusText(String messageStatusText) {
        this.message.getStatus().setText(messageStatusText);
    }

    public String toString() {
        ToStringBuilder toString = new ToStringBuilder((Object)this);
        toString.append("messageStatusCode", (Object)this.getMessageStatusCode());
        toString.append("messageStatusText", (Object)this.getMessageStatusText());
        toString.append("statusCode", (Object)this.getStatusCode());
        toString.append("statusText", (Object)this.getStatusText());
        toString.append("buyerCookieText", (Object)this.getBuyerCookieText());
        toString.append("totalAmount", (Object)this.getTotal());
        toString.append("CXMLHeader", (Object)this.cxmlHeader);
        toString.append("Items", this.itemsList);
        return toString.toString();
    }
}

