/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.service.impl;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.integration.purap.PurchasingAccountsPayableModuleService;
import org.kuali.kfs.integration.purap.PurchasingAccountsPayableSensitiveData;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.NoteService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.businessobject.PaymentRequestView;
import org.kuali.kfs.module.purap.businessobject.SensitiveData;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.document.VendorCreditMemoDocument;
import org.kuali.kfs.module.purap.document.service.CreditMemoService;
import org.kuali.kfs.module.purap.document.service.PaymentRequestService;
import org.kuali.kfs.module.purap.document.service.PurapService;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.module.purap.util.PurApRelatedViews;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.exception.WorkflowException;

public class PurchasingAccountsPayableModuleServiceImpl
implements PurchasingAccountsPayableModuleService {
    private static Logger LOG = Logger.getLogger(PurchasingAccountsPayableModuleServiceImpl.class);
    protected PurchaseOrderService purchaseOrderService;
    protected PurapService purapService;
    protected DocumentService documentService;
    protected BusinessObjectService businessObjectService;

    public void addAssignedAssetNumbers(Integer purchaseOrderNumber, String principalId, String noteText) {
        PurchaseOrderDocument document = this.purchaseOrderService.getCurrentPurchaseOrder(purchaseOrderNumber);
        try {
            Note assetNote = ((DocumentService)SpringContext.getBean(DocumentService.class)).createNoteFromDocument((Document)document, noteText);
            assetNote.setAuthorUniversalIdentifier(principalId);
            document.addNote(assetNote);
            ((NoteService)SpringContext.getBean(NoteService.class)).save(assetNote);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getPurchaseOrderInquiryUrl(Integer purchaseOrderNumber) {
        PurchaseOrderDocument po = this.purchaseOrderService.getCurrentPurchaseOrder(purchaseOrderNumber);
        if (ObjectUtils.isNotNull((Object)po)) {
            return "purapPurchaseOrder.do?methodToCall=docHandler&docId=" + po.getDocumentNumber() + "&command=displayDocSearchView";
        }
        return "";
    }

    public List<PurchasingAccountsPayableSensitiveData> getAllSensitiveDatas() {
        ArrayList<PurchasingAccountsPayableSensitiveData> sensitiveDatas = new ArrayList<PurchasingAccountsPayableSensitiveData>();
        Collection sensitiveDatasAsObjects = ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findAll(SensitiveData.class);
        for (Object rm : sensitiveDatasAsObjects) {
            sensitiveDatas.add((PurchasingAccountsPayableSensitiveData)rm);
        }
        return sensitiveDatas;
    }

    public PurchasingAccountsPayableSensitiveData getSensitiveDataByCode(String sensitiveDataCode) {
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        primaryKeys.put("sensitiveDataCode", sensitiveDataCode);
        return (PurchasingAccountsPayableSensitiveData)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findByPrimaryKey(SensitiveData.class, primaryKeys);
    }

    public boolean isPurchasingBatchDocument(String documentTypeCode) {
        return "PREQ".equals(documentTypeCode) || "CM".equals(documentTypeCode);
    }

    public void handlePurchasingBatchCancels(String documentNumber, String documentTypeCode, boolean primaryCancel, boolean disbursedPayment) {
        LOG.info((Object)("Begin handlePurchasingBatchCancels(documentNumber=" + documentNumber + ", documentTypeCode=" + documentTypeCode + ", primaryCancel=" + primaryCancel + ", disbursedPayment=" + disbursedPayment));
        ParameterService parameterService = (ParameterService)SpringContext.getBean(ParameterService.class);
        PaymentRequestService paymentRequestService = (PaymentRequestService)SpringContext.getBean(PaymentRequestService.class);
        CreditMemoService creditMemoService = (CreditMemoService)SpringContext.getBean(CreditMemoService.class);
        String preqCancelNote = parameterService.getParameterValueAsString(PaymentRequestDocument.class, "CANCEL_NOTE");
        String preqResetNote = parameterService.getParameterValueAsString(PaymentRequestDocument.class, "RESET_NOTE");
        String cmCancelNote = parameterService.getParameterValueAsString(VendorCreditMemoDocument.class, "CANCEL_NOTE");
        String cmResetNote = parameterService.getParameterValueAsString(VendorCreditMemoDocument.class, "RESET_NOTE");
        if ("PREQ".equals(documentTypeCode)) {
            PaymentRequestDocument pr = paymentRequestService.getPaymentRequestByDocumentNumber(documentNumber);
            if (pr != null) {
                if (disbursedPayment || primaryCancel) {
                    paymentRequestService.cancelExtractedPaymentRequest(pr, preqCancelNote);
                } else {
                    paymentRequestService.resetExtractedPaymentRequest(pr, preqResetNote);
                }
            } else {
                LOG.error((Object)("processPdpCancels() DOES NOT EXIST, CANNOT PROCESS - Payment Request with doc type of " + documentTypeCode + " with id " + documentNumber));
            }
        } else if ("CM".equals(documentTypeCode)) {
            VendorCreditMemoDocument cm = creditMemoService.getCreditMemoByDocumentNumber(documentNumber);
            if (cm != null) {
                if (disbursedPayment || primaryCancel) {
                    creditMemoService.cancelExtractedCreditMemo(cm, cmCancelNote);
                } else {
                    creditMemoService.resetExtractedCreditMemo(cm, cmResetNote);
                }
            } else {
                LOG.error((Object)("processPdpCancels() DOES NOT EXIST, CANNOT PROCESS - Credit Memo with doc type of " + documentTypeCode + " with id " + documentNumber));
            }
        }
    }

    public void handlePurchasingBatchPaids(String documentNumber, String documentTypeCode, Date processDate) {
        ParameterService parameterService = (ParameterService)SpringContext.getBean(ParameterService.class);
        PaymentRequestService paymentRequestService = (PaymentRequestService)SpringContext.getBean(PaymentRequestService.class);
        CreditMemoService creditMemoService = (CreditMemoService)SpringContext.getBean(CreditMemoService.class);
        if ("PREQ".equals(documentTypeCode)) {
            PaymentRequestDocument pr = paymentRequestService.getPaymentRequestByDocumentNumber(documentNumber);
            if (pr != null) {
                paymentRequestService.markPaid(pr, processDate);
            } else {
                LOG.error((Object)("processPdpPaids() DOES NOT EXIST, CANNOT MARK - Payment Request with doc type of " + documentTypeCode + " with id " + documentNumber));
            }
        } else if ("CM".equals(documentTypeCode)) {
            VendorCreditMemoDocument cm = creditMemoService.getCreditMemoByDocumentNumber(documentNumber);
            if (cm != null) {
                creditMemoService.markPaid(cm, processDate);
            } else {
                LOG.error((Object)("processPdpPaids() DOES NOT EXIST, CANNOT PROCESS - Credit Memo with doc type of " + documentTypeCode + " with id " + documentNumber));
            }
        }
    }

    public KualiDecimal getTotalPaidAmountToRequisitions(List<String> documentNumbers) {
        KualiDecimal totalPaidAmountToRequests = KualiDecimal.ZERO;
        HashMap<String, List<String>> fieldValues = new HashMap<String, List<String>>();
        fieldValues.put("documentNumber", documentNumbers);
        Collection reqses = this.businessObjectService.findMatching(RequisitionDocument.class, fieldValues);
        for (RequisitionDocument reqs : reqses) {
            try {
                PurApRelatedViews relatedviews = reqs.getRelatedViews();
                if (relatedviews == null || relatedviews.getRelatedPaymentRequestViews() == null || relatedviews.getRelatedPaymentRequestViews().size() <= 0) continue;
                List<PaymentRequestView> preqViews = relatedviews.getRelatedPaymentRequestViews();
                for (PaymentRequestView preqView : preqViews) {
                    PaymentRequestDocument preqDocument = (PaymentRequestDocument)this.documentService.getByDocumentHeaderId(preqView.getDocumentNumber());
                    if (!preqDocument.getDocumentHeader().getWorkflowDocument().isFinal()) continue;
                    totalPaidAmountToRequests = (KualiDecimal)totalPaidAmountToRequests.add((AbstractKualiDecimal)preqDocument.getVendorInvoiceAmount());
                }
            }
            catch (WorkflowException we) {
                throw new RuntimeException("Could not retrieve document to determine totals paid on Requisitions", we);
            }
        }
        return totalPaidAmountToRequests;
    }

    public String getB2BUrlString() {
        return "&channelUrl=b2b.do?methodToCall=shopCatalogs";
    }

    public void setPurchaseOrderService(PurchaseOrderService purchaseOrderService) {
        this.purchaseOrderService = purchaseOrderService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setPurapService(PurapService purapService) {
        this.purapService = purapService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

