/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.service.DataDictionaryService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.validation.impl.PurchasingAccountsPayableAccountingLineAccessibleValidation;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.AccountingDocument;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;

public class PaymentRequestNonZeroAccountingLineAmountValidation
extends PurchasingAccountsPayableAccountingLineAccessibleValidation {
    private PurApItem itemForValidation;
    private ParameterService parameterService;

    public boolean validate(AttributedDocumentEvent event) {
        boolean valid = true;
        String status = ((PaymentRequestDocument)event.getDocument()).getApplicationDocumentStatus();
        AccountingDocument accountingDocument = (AccountingDocument)event.getDocument();
        this.setAccountingDocumentForValidation(accountingDocument);
        this.setDataDictionaryService((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class));
        if (StringUtils.equals((String)"Awaiting Fiscal Officer Approval", (String)status)) {
            Set currentNodes = accountingDocument.getDocumentHeader().getWorkflowDocument().getCurrentNodeNames();
            for (PurApAccountingLine acct : this.itemForValidation.getSourceAccountingLines()) {
                this.setAccountingLineForValidation(acct);
                boolean lineIsAccessible = this.lookupAccountingLineAuthorizer().hasEditPermissionOnAccountingLine(accountingDocument, (AccountingLine)acct, this.getAccountingLineCollectionProperty(), GlobalVariables.getUserSession().getPerson(), true, currentNodes);
                if (!lineIsAccessible) continue;
                if (ObjectUtils.isNull((Object)acct.getAmount())) {
                    GlobalVariables.getMessageMap().putError("document.item*,newPurchasingItemLine*,itemQuantity,document.grandTotal,accountDistributionnewSourceLine*,distributePurchasingCommodityCode,accountNumber*,chartOfAccountsCode*", "errors.item.accounting.amount.invalid", new String[]{this.itemForValidation.getItemIdentifierString()});
                    valid &= false;
                    continue;
                }
                if (!acct.getAmount().isZero() || this.canApproveAccountingLinesWithZeroAmount()) continue;
                GlobalVariables.getMessageMap().putError("document.item*,newPurchasingItemLine*,itemQuantity,document.grandTotal,accountDistributionnewSourceLine*,distributePurchasingCommodityCode,accountNumber*,chartOfAccountsCode*", "errors.item.accounting.amount.invalid", new String[]{this.itemForValidation.getItemIdentifierString()});
                valid &= false;
            }
        }
        return valid;
    }

    public boolean canApproveAccountingLinesWithZeroAmount() {
        boolean canApproveLine = false;
        String approveZeroAmountLine = ((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsString(KfsParameterConstants.PURCHASING_DOCUMENT.class, "APPROVE_ACCOUNTING_LINES_WITH_ZERO_DOLLAR_AMOUNT_IND");
        if ("Y".equalsIgnoreCase(approveZeroAmountLine)) {
            return true;
        }
        return canApproveLine;
    }

    public PurApItem getItemForValidation() {
        return this.itemForValidation;
    }

    public void setItemForValidation(PurApItem itemForValidation) {
        this.itemForValidation = itemForValidation;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

