/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.util.Collection;
import java.util.HashMap;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.maintenance.rules.MaintenanceDocumentRuleBase;
import org.kuali.kfs.kns.rule.AddCollectionLineRule;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderQuoteList;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderQuoteListVendor;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.vnd.VendorUtils;
import org.kuali.kfs.vnd.businessobject.VendorDetail;

public class PurchaseOrderQuoteListRule
extends MaintenanceDocumentRuleBase
implements AddCollectionLineRule {
    protected boolean processCustomApproveDocumentBusinessRules(MaintenanceDocument document) {
        LOG.info((Object)"processCustomApproveDocumentBusinessRules called");
        this.setupConvenienceObjects();
        boolean success = this.validateVendor();
        return success && super.processCustomApproveDocumentBusinessRules(document);
    }

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        LOG.info((Object)"processCustomRouteDocumentBusinessRules called");
        this.setupConvenienceObjects();
        boolean success = this.validateVendor();
        return success && super.processCustomRouteDocumentBusinessRules(document);
    }

    protected boolean processCustomSaveDocumentBusinessRules(MaintenanceDocument document) {
        LOG.info((Object)"processCustomSaveDocumentBusinessRules called");
        this.setupConvenienceObjects();
        boolean success = this.validateVendor();
        return success && super.processCustomSaveDocumentBusinessRules(document);
    }

    protected boolean validateVendor() {
        LOG.info((Object)"validateVendor called");
        boolean success = true;
        PurchaseOrderQuoteList newBo = (PurchaseOrderQuoteList)((Object)super.getNewBo());
        if (newBo.getQuoteListVendors() == null || newBo.getQuoteListVendors().size() == 0) {
            success = false;
            this.putFieldError("add.quoteListVendors.vendorDetail.vendorNumber", "error.purchaseOrder.quoteList.no.vendor");
        }
        return success;
    }

    public boolean processAddCollectionLineBusinessRules(MaintenanceDocument document, String collectionName, PersistableBusinessObject line) {
        PurchaseOrderQuoteListVendor vendor = (PurchaseOrderQuoteListVendor)line;
        HashMap<String, Integer> fieldValues = new HashMap<String, Integer>();
        String vendorNumber = vendor.getVendorDetail().getVendorNumber();
        Integer headerId = VendorUtils.getVendorHeaderId((String)vendorNumber);
        Integer detailId = VendorUtils.getVendorDetailId((String)vendorNumber);
        fieldValues.put("vendorHeaderGeneratedIdentifier", headerId);
        fieldValues.put("vendorDetailAssignedIdentifier", detailId);
        Collection result = ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findMatching(VendorDetail.class, fieldValues);
        if (result == null || result.size() == 0) {
            this.putFieldError("add.quoteListVendors.vendorDetail.vendorNumber", "error.purchaseOrder.quoteList.nonExistence.vendor");
            return false;
        }
        VendorDetail resultVendor = (VendorDetail)result.iterator().next();
        vendor.setVendorHeaderGeneratedIdentifier(resultVendor.getVendorHeaderGeneratedIdentifier());
        vendor.setVendorDetailAssignedIdentifier(resultVendor.getVendorDetailAssignedIdentifier());
        return super.processAddCollectionLineBusinessRules(document, collectionName, line);
    }
}

