/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.web.struts;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kfs.kns.service.DocumentHelperService;
import org.kuali.kfs.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.service.KualiRuleService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.businessobject.PaymentRequestItem;
import org.kuali.kfs.module.purap.document.AccountsPayableDocument;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.purap.document.service.PaymentRequestService;
import org.kuali.kfs.module.purap.document.service.PurapService;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.module.purap.document.validation.event.AttributedCalculateAccountsPayableEvent;
import org.kuali.kfs.module.purap.document.validation.event.AttributedContinuePurapEvent;
import org.kuali.kfs.module.purap.document.validation.event.AttributedPreCalculateAccountsPayableEvent;
import org.kuali.kfs.module.purap.document.web.struts.AccountsPayableActionBase;
import org.kuali.kfs.module.purap.document.web.struts.PaymentRequestForm;
import org.kuali.kfs.module.purap.document.web.struts.PurchasingAccountsPayableFormBase;
import org.kuali.kfs.module.purap.service.PurapAccountingService;
import org.kuali.kfs.module.purap.util.PurQuestionCallback;
import org.kuali.kfs.pdp.PdpConstants;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.PayeeACHService;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.kfs.vnd.businessobject.VendorDetail;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.bo.BusinessObject;

public class PaymentRequestAction
extends AccountsPayableActionBase {
    static Logger LOG = Logger.getLogger(PaymentRequestAction.class);

    protected void createDocument(KualiDocumentFormBase kualiDocumentFormBase) throws WorkflowException {
        super.createDocument(kualiDocumentFormBase);
        ((PaymentRequestDocument)kualiDocumentFormBase.getDocument()).initiateDocument();
    }

    @Override
    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PaymentRequestForm preqForm = (PaymentRequestForm)form;
        PaymentRequestDocument document = (PaymentRequestDocument)preqForm.getDocument();
        return super.refresh(mapping, form, request, response);
    }

    public ActionForward continuePREQ(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug((Object)"continuePREQ() method");
        PaymentRequestForm preqForm = (PaymentRequestForm)form;
        PaymentRequestDocument paymentRequestDocument = (PaymentRequestDocument)preqForm.getDocument();
        boolean poNotNull = true;
        boolean rulePassed = ((KualiRuleService)SpringContext.getBean(KualiRuleService.class)).applyRules((KualiDocumentEvent)new AttributedContinuePurapEvent((Document)paymentRequestDocument));
        if (!rulePassed) {
            return mapping.findForward("basic");
        }
        GlobalVariables.getMessageMap().clearErrorPath();
        GlobalVariables.getMessageMap().addToErrorPath("document");
        if (ObjectUtils.isNull((Object)paymentRequestDocument.getPurchaseOrderIdentifier())) {
            GlobalVariables.getMessageMap().putError("purchaseOrderIdentifier", "error.required", new String[]{"Purchase Order Identifier"});
            poNotNull = false;
        }
        if (ObjectUtils.isNull((Object)paymentRequestDocument.getInvoiceDate())) {
            GlobalVariables.getMessageMap().putError("invoiceDate", "error.required", new String[]{"Invoice Date"});
            poNotNull = false;
        }
        if (ObjectUtils.isNull((Object)paymentRequestDocument.getInvoiceNumber())) {
            GlobalVariables.getMessageMap().putError("invoiceNumber", "error.required", new String[]{"Invoice Number"});
            poNotNull = false;
        }
        paymentRequestDocument.setInvoiceNumber(paymentRequestDocument.getInvoiceNumber().toUpperCase());
        if (ObjectUtils.isNull((Object)paymentRequestDocument.getVendorInvoiceAmount())) {
            GlobalVariables.getMessageMap().putError("vendorInvoiceAmount", "error.required", new String[]{"Vendor Invoice Amount"});
            poNotNull = false;
        }
        if (!poNotNull) {
            return mapping.findForward("basic");
        }
        PurchaseOrderDocument po = ((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).getCurrentPurchaseOrder(paymentRequestDocument.getPurchaseOrderIdentifier());
        if (ObjectUtils.isNotNull((Object)po)) {
            paymentRequestDocument.setAccountsPayablePurchasingDocumentLinkIdentifier(po.getAccountsPayablePurchasingDocumentLinkIdentifier());
            if (!((DocumentHelperService)SpringContext.getBean(DocumentHelperService.class)).getDocumentAuthorizer((Document)paymentRequestDocument).isAuthorizedByTemplate((BusinessObject)paymentRequestDocument, "KR-NS", "Open Document", GlobalVariables.getUserSession().getPrincipalId())) {
                throw this.buildAuthorizationException("initiate document", (Document)paymentRequestDocument);
            }
        }
        if (!((PaymentRequestService)SpringContext.getBean(PaymentRequestService.class)).isPurchaseOrderValidForPaymentRequestDocumentCreation(paymentRequestDocument, po)) {
            return mapping.findForward("basic");
        }
        ActionForward forward = this.performDuplicatePaymentRequestAndEncumberFiscalYearCheck(mapping, form, request, response, paymentRequestDocument);
        if (forward != null) {
            return forward;
        }
        ((PaymentRequestService)SpringContext.getBean(PaymentRequestService.class)).populateAndSavePaymentRequest(paymentRequestDocument);
        preqForm.setCalculated(false);
        preqForm.setCalculatedTax(false);
        ((PurapService)SpringContext.getBean(PurapService.class)).sortBelowTheLine(paymentRequestDocument);
        preqForm.updateItemCounts();
        return mapping.findForward("basic");
    }

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward dest = super.execute(mapping, form, request, response);
        PaymentRequestForm preqForm = (PaymentRequestForm)form;
        if (ObjectUtils.isNull((Object)((Object)preqForm))) {
            return dest;
        }
        PaymentRequestDocument preqDoc = (PaymentRequestDocument)preqForm.getDocument();
        if (ObjectUtils.isNull((Object)preqDoc)) {
            return dest;
        }
        this.updateAchSignupStatusFlagForPayee(preqDoc);
        return dest;
    }

    private void updateAchSignupStatusFlagForPayee(PaymentRequestDocument preqDoc) {
        VendorDetail vendorDetail = preqDoc.getVendorDetail();
        if (ObjectUtils.isNull((Object)vendorDetail)) {
            return;
        }
        boolean signedupForACH = false;
        String payeeTypeCode = PdpConstants.PayeeIdTypeCodes.VENDOR_ID;
        String payeeIdNumber = vendorDetail.getVendorNumber();
        signedupForACH = ((PayeeACHService)SpringContext.getBean(PayeeACHService.class)).isPayeeSignedUpForACH(payeeTypeCode, payeeIdNumber);
        preqDoc.setAchSignUpStatusFlag(signedupForACH);
    }

    public ActionForward clearInitFields(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug((Object)"clearInitValues() method");
        PaymentRequestForm preqForm = (PaymentRequestForm)form;
        PaymentRequestDocument paymentRequestDocument = (PaymentRequestDocument)preqForm.getDocument();
        paymentRequestDocument.clearInitFields();
        return super.refresh(mapping, form, request, response);
    }

    protected ActionForward performDuplicatePaymentRequestAndEncumberFiscalYearCheck(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, PaymentRequestDocument paymentRequestDocument) throws Exception {
        ActionForward forward = null;
        String question = request.getParameter("questionIndex");
        if (question == null) {
            if (this.isEncumberNextFiscalYear(paymentRequestDocument)) {
                String questionText = ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("warning.encumber.nextFY");
                return this.performQuestionWithoutInput(mapping, form, request, response, "Encumber Next Fiscal Year Question", questionText, "cf.confirmationQuestion", "route", "");
            }
            HashMap<String, String> duplicateMessages = ((PaymentRequestService)SpringContext.getBean(PaymentRequestService.class)).paymentRequestDuplicateMessages(paymentRequestDocument);
            if (!duplicateMessages.isEmpty()) {
                return this.performQuestionWithoutInput(mapping, form, request, response, "PREQDuplicateInvoice", duplicateMessages.get("PREQDuplicateInvoice"), "cf.confirmationQuestion", "route", "");
            }
        } else {
            String buttonClicked = request.getParameter("buttonClicked");
            if ("Encumber Next Fiscal Year Question".equals(question) && "0".equals(buttonClicked)) {
                HashMap<String, String> duplicateMessages = ((PaymentRequestService)SpringContext.getBean(PaymentRequestService.class)).paymentRequestDuplicateMessages(paymentRequestDocument);
                if (!duplicateMessages.isEmpty()) {
                    return this.performQuestionWithoutInput(mapping, form, request, response, "PREQDuplicateInvoice", duplicateMessages.get("PREQDuplicateInvoice"), "cf.confirmationQuestion", "route", "");
                }
            } else if (("Encumber Next Fiscal Year Question".equals(question) || "PREQDuplicateInvoice".equals(question)) && "1".equals(buttonClicked)) {
                paymentRequestDocument.updateAndSaveAppDocStatus("Initiated");
                forward = mapping.findForward("basic");
            }
        }
        return forward;
    }

    protected boolean isEncumberNextFiscalYear(PaymentRequestDocument paymentRequestDocument) {
        Integer fiscalYear = ((UniversityDateService)SpringContext.getBean(UniversityDateService.class)).getCurrentFiscalYear();
        return paymentRequestDocument.getPurchaseOrderDocument().getPostingYear() > fiscalYear;
    }

    public ActionForward addHoldOnPayment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String operation = "Hold ";
        PurQuestionCallback callback = new PurQuestionCallback(){

            @Override
            public AccountsPayableDocument doPostQuestion(AccountsPayableDocument document, String noteText) throws Exception {
                document = ((PaymentRequestService)SpringContext.getBean(PaymentRequestService.class)).addHoldOnPaymentRequest((PaymentRequestDocument)document, noteText);
                return document;
            }
        };
        return this.askQuestionWithInput(mapping, form, request, response, "HoldPREQ", "Note entered while placing Payment Request on hold : ", operation, "paymentRequest.message.hold.text", callback);
    }

    public ActionForward removeHoldFromPayment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String operation = "Remove ";
        PurQuestionCallback callback = new PurQuestionCallback(){

            @Override
            public AccountsPayableDocument doPostQuestion(AccountsPayableDocument document, String noteText) throws Exception {
                document = ((PaymentRequestService)SpringContext.getBean(PaymentRequestService.class)).removeHoldOnPaymentRequest((PaymentRequestDocument)document, noteText);
                return document;
            }
        };
        return this.askQuestionWithInput(mapping, form, request, response, "RemoveHoldPREQ", "Note entered while removing a hold on Payment Request : ", operation, "paymentRequest.message.remove.hold.text", callback);
    }

    public ActionForward requestCancelOnPayment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String operation = "Cancel ";
        PurQuestionCallback callback = new PurQuestionCallback(){

            @Override
            public AccountsPayableDocument doPostQuestion(AccountsPayableDocument document, String noteText) throws Exception {
                ((PaymentRequestService)SpringContext.getBean(PaymentRequestService.class)).requestCancelOnPaymentRequest((PaymentRequestDocument)document, noteText);
                return document;
            }
        };
        return this.askQuestionWithInput(mapping, form, request, response, "CancelPREQ", "Note entered while requesting cancel on Payment Request : ", operation, "paymentRequest.message.cancel.text", callback);
    }

    public ActionForward removeCancelRequestFromPayment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String operation = "Cancel ";
        PurQuestionCallback callback = new PurQuestionCallback(){

            @Override
            public AccountsPayableDocument doPostQuestion(AccountsPayableDocument document, String noteText) throws Exception {
                ((PaymentRequestService)SpringContext.getBean(PaymentRequestService.class)).removeRequestCancelOnPaymentRequest((PaymentRequestDocument)document, noteText);
                return document;
            }
        };
        return this.askQuestionWithInput(mapping, form, request, response, "RemoveCancelPREQ", "Note entered while removing a request cancel on Payment Request : ", operation, "paymentRequest.message.remove.cancel.text", callback);
    }

    @Override
    protected void customCalculate(PurchasingAccountsPayableDocument apDoc) {
        PaymentRequestDocument preqDoc = (PaymentRequestDocument)apDoc;
        preqDoc.updateExtendedPriceOnItems();
        if (StringUtils.equals((String)preqDoc.getApplicationDocumentStatus(), (String)"Awaiting Tax Approval")) {
            ((PaymentRequestService)SpringContext.getBean(PaymentRequestService.class)).calculateTaxArea(preqDoc);
            return;
        }
        ((PaymentRequestService)SpringContext.getBean(PaymentRequestService.class)).calculatePaymentRequest(preqDoc, true);
        ((KualiRuleService)SpringContext.getBean(KualiRuleService.class)).applyRules((KualiDocumentEvent)new AttributedCalculateAccountsPayableEvent((Document)preqDoc));
    }

    @Override
    public String getActionName() {
        return "PaymentRequest";
    }

    public ActionForward useAlternateVendor(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PaymentRequestForm preqForm = (PaymentRequestForm)form;
        PaymentRequestDocument document = (PaymentRequestDocument)preqForm.getDocument();
        ((PaymentRequestService)SpringContext.getBean(PaymentRequestService.class)).changeVendor(document, document.getAlternateVendorHeaderGeneratedIdentifier(), document.getAlternateVendorDetailAssignedIdentifier());
        return mapping.findForward("basic");
    }

    public ActionForward useOriginalVendor(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PaymentRequestForm preqForm = (PaymentRequestForm)form;
        PaymentRequestDocument document = (PaymentRequestDocument)preqForm.getDocument();
        ((PaymentRequestService)SpringContext.getBean(PaymentRequestService.class)).changeVendor(document, document.getOriginalVendorHeaderGeneratedIdentifier(), document.getOriginalVendorDetailAssignedIdentifier());
        return mapping.findForward("basic");
    }

    @Override
    public ActionForward route(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PaymentRequestDocument preq = ((PaymentRequestForm)form).getPaymentRequestDocument();
        ((PurapService)SpringContext.getBean(PurapService.class)).prorateForTradeInAndFullOrderDiscount(preq);
        ((PurapAccountingService)SpringContext.getBean(PurapAccountingService.class)).updateAccountAmounts(preq);
        if (preq.isClosePurchaseOrderIndicator()) {
            PurchaseOrderDocument po = preq.getPurchaseOrderDocument();
            if (po.canClosePOForTradeIn()) {
                return super.route(mapping, form, request, response);
            }
            return mapping.findForward("basic");
        }
        return super.route(mapping, form, request, response);
    }

    public ActionForward approve(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PaymentRequestDocument preq = ((PaymentRequestForm)form).getPaymentRequestDocument();
        ((PurapService)SpringContext.getBean(PurapService.class)).prorateForTradeInAndFullOrderDiscount(preq);
        if (this.requiresCalculateTax((PaymentRequestForm)form)) {
            GlobalVariables.getMessageMap().putError("document.document*,document.explanation*,document.reversal*,document.selected*,document.header*", "errors.save.calculationRequired", new String[0]);
            return mapping.findForward("basic");
        }
        if (((KualiRuleService)SpringContext.getBean(KualiRuleService.class)).applyRules((KualiDocumentEvent)new AttributedPreCalculateAccountsPayableEvent((Document)preq))) {
            this.customCalculate(preq);
            ((PurapAccountingService)SpringContext.getBean(PurapAccountingService.class)).updateAccountAmounts(preq);
            return super.approve(mapping, form, request, response);
        }
        return mapping.findForward("basic");
    }

    protected boolean requiresCalculateTax(PaymentRequestForm preqForm) {
        PaymentRequestDocument preq = (PaymentRequestDocument)preqForm.getDocument();
        boolean requiresCalculateTax = StringUtils.equals((String)preq.getApplicationDocumentStatus(), (String)"Awaiting Tax Approval") && !preqForm.isCalculatedTax();
        return requiresCalculateTax;
    }

    public ActionForward changeUseTaxIndicator(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PurchasingAccountsPayableDocument document = (PurchasingAccountsPayableDocument)((PurchasingAccountsPayableFormBase)form).getDocument();
        ((PurapService)SpringContext.getBean(PurapService.class)).updateUseTaxIndicator(document, !document.isUseTaxIndicator());
        ((PurapService)SpringContext.getBean(PurapService.class)).calculateTax(document);
        return mapping.findForward("basic");
    }

    public ActionForward clearTaxInfo(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PaymentRequestForm prForm = (PaymentRequestForm)form;
        PaymentRequestDocument document = (PaymentRequestDocument)prForm.getDocument();
        PaymentRequestService taxService = (PaymentRequestService)SpringContext.getBean(PaymentRequestService.class);
        taxService.clearTax(document);
        return mapping.findForward("basic");
    }

    @Override
    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PaymentRequestForm preqForm = (PaymentRequestForm)form;
        PaymentRequestDocument preqDocument = (PaymentRequestDocument)preqForm.getDocument();
        ActionForward forward = mapping.findForward("basic");
        if (preqDocument.getPurchaseOrderDocument().isPendingActionIndicator()) {
            GlobalVariables.getMessageMap().putError("document.documentNumber", "error.paymentRequest.cannot.be.cancelled", new String[0]);
        } else {
            forward = super.cancel(mapping, form, request, response);
        }
        return forward;
    }

    public ActionForward clearQty(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PaymentRequestForm preqForm = (PaymentRequestForm)form;
        PaymentRequestDocument preqDocument = (PaymentRequestDocument)preqForm.getDocument();
        for (PaymentRequestItem item : preqDocument.getItems()) {
            if (!item.getItemType().isQuantityBasedGeneralLedgerIndicator()) continue;
            item.setItemQuantity(null);
        }
        return mapping.findForward("basic");
    }

    public ActionForward loadQty(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PaymentRequestForm preqForm = (PaymentRequestForm)form;
        PaymentRequestDocument preqDocument = (PaymentRequestDocument)preqForm.getDocument();
        for (PaymentRequestItem item : preqDocument.getItems()) {
            if (!item.getItemType().isQuantityBasedGeneralLedgerIndicator() || item.getPoOutstandingQuantity() == null || !item.getPoOutstandingQuantity().isGreaterThan((AbstractKualiDecimal)KualiDecimal.ZERO)) continue;
            item.setItemQuantity(item.getPoOutstandingQuantity());
        }
        return mapping.findForward("basic");
    }
}

