/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.web.struts;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kfs.kns.web.struts.action.KualiAction;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.document.service.B2BShoppingService;
import org.kuali.kfs.module.purap.exception.B2BConnectionException;
import org.kuali.kfs.module.purap.exception.B2BShoppingException;
import org.kuali.kfs.module.purap.util.cxml.B2BParserHelper;
import org.kuali.kfs.module.purap.util.cxml.B2BShoppingCart;
import org.kuali.kfs.module.purap.web.struts.B2BForm;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.config.property.ConfigurationService;

public class B2BAction
extends KualiAction {
    private static Logger LOG = Logger.getLogger(B2BAction.class);

    public ActionForward shopCatalogs(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        B2BForm b2bForm = (B2BForm)form;
        String url = ((B2BShoppingService)SpringContext.getBean(B2BShoppingService.class)).getPunchOutUrl(GlobalVariables.getUserSession().getPerson());
        if (ObjectUtils.isNull((Object)url)) {
            throw new B2BConnectionException("Unable to connect to remote site for punchout.");
        }
        b2bForm.setShopUrl(url);
        return mapping.findForward("basic");
    }

    public ActionForward returnFromShopping(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        List requisitions;
        String cXml = request.getParameter("cxml-urlencoded");
        LOG.info((Object)("executeLogic() cXML returned in PunchoutOrderMessage:\n" + cXml));
        B2BShoppingCart cart = B2BParserHelper.getInstance().parseShoppingCartXML(cXml);
        if (cart.isSuccess()) {
            requisitions = ((B2BShoppingService)SpringContext.getBean(B2BShoppingService.class)).createRequisitionsFromCxml(cart, GlobalVariables.getUserSession().getPerson());
            if (requisitions.size() > 1) {
                request.getSession().setAttribute("multipleB2BRequisitions", (Object)"true");
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("executeLogic() Retrieving shopping cart from cxml was unsuccessful. Error message:" + cart.getStatusText()));
            }
            throw new B2BShoppingException("Retrieving shopping cart from cxml was unsuccessful. Error message:" + cart.getStatusText());
        }
        request.setAttribute("forward", (Object)((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString("b2b.punch.back.action.forwarding.url"));
        request.getSession().setAttribute("docId", (Object)((RequisitionDocument)requisitions.get(0)).getDocumentNumber());
        return mapping.findForward("removeframe");
    }
}

